VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ComboBoxEx"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

Private ImgList As New CImageList

Private Type ComboEx
Info As String
InfoPath As String
End Type

Private Const WM_CTLCOLOREDIT = &H133
Private Const WM_SETFONT = &H30

Private NewComboFont As Long
Private cmbLeft As Integer
Private cmbTop As Integer
Private cmbFontBold As Boolean
Private cmbFontItalic As Boolean
Private cmbFontName As String
Private cmbFontHeight As Integer
Private cmbCustomize As Boolean
Private cmbFontUnderlined As Boolean

 
Private Const SYSTEM_FONT& = 13
Private LF As LOGFONT
Public Enum cbIconState
  cbNormal = 0
  cbDisabled = 1
End Enum
Private ComboInfo() As ComboEx


Private Type FONTSTRUC
    lStructSize As Long
    hWnd As Long
    hdc As Long
    lpLogFont As Long
    iPointSize As Long
    flags As Long
    rgbColors As Long
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
    hInstance As Long
    lpszStyle As String
    nFontType As Integer
    MISSING_ALIGNMENT As Integer
    nSizeMin As Long
    nSizeMax As Long
End Type

Private Type LOGFONT
    lfHeight As Long
    lfWidth As Long
    lfEscapement As Long
    lfOrientation As Long
    lfWeight As Long
    lfItalic As Byte
    lfUnderline As Byte
    lfStrikeOut As Byte
    lfCharSet As Byte
    lfOutPrecision As Byte
    lfClipPrecision As Byte
    lfQuality As Byte
    lfPitchAndFamily As Byte
    lffacename As String * 32
   'lfFaceName(LF_FACESIZE) As Byte
End Type

'Get Drive Information
Private Declare Function GetVolumeInformation Lib "kernel32" Alias "GetVolumeInformationA" (ByVal lpRootPathName As String, ByVal lpVolumeNameBuffer As String, ByVal nVolumeNameSize As Long, lpVolumeSerialNumber As Long, lpMaximumComponentLength As Long, lpFileSystemFlags As Long, ByVal lpFileSystemNameBuffer As String, ByVal nFileSystemNameSize As Long) As Long
Private Declare Function GetLogicalDrives Lib "kernel32" () As Long
Private Declare Function GetLogicalDriveStrings Lib "kernel32" Alias "GetLogicalDriveStringsA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function GetDriveType Lib "kernel32" Alias "GetDriveTypeA" (ByVal nDrive As String) As Long
Private Declare Function WNetGetConnection Lib "mpr.dll" Alias "WNetGetConnectionA" (ByVal lpszLocalName As String, ByVal lpszRemoteName As String, cbRemoteName As Long) As Long
Private Const DRIVE_REMOVABLE = 2
Private Const DRIVE_FIXED = 3
Private Const DRIVE_REMOTE = 4
Private Const DRIVE_CDROM = 5
Private Const DRIVE_RAMDISK = 6

Private Const GMEM_MOVEABLE = &H2
Private Const GMEM_ZEROINIT = &H40
Private Const GHND = (GMEM_MOVEABLE Or GMEM_ZEROINIT)
Private Declare Function ReleaseDC Lib "user32" (ByVal hWnd As Long, ByVal hdc As Long) As Long
Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function GlobalLock Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function GlobalUnlock Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
Private Declare Function GetDC Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function SetBkColor Lib "gdi32" (ByVal hdc As Long, ByVal crColor As Long) As Long
Private Declare Function SetTextColor Lib "gdi32" (ByVal hdc As Long, ByVal crColor As Long) As Long
Private Declare Function GetClientRect Lib "user32" (ByVal hWnd As Long, lpRect As RECT) As Long
Private Declare Function SendMessageByString& Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String)
Private Declare Function SetParent Lib "user32" (ByVal hWndChild As Long, ByVal hWndNewParent As Long) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Any) As Long
Private Declare Function SendMessageByLong Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lParam As Long) As Long
Private Declare Function ExtractIconEx Lib "shell32.dll" Alias "ExtractIconExA" (ByVal lpszFile As String, ByVal nIconIndex As Long, phiconLarge As Long, phiconSmall As Long, ByVal nIcons As Long) As Long
Private Declare Function ShowWindow Lib "user32" (ByVal hWnd As Long, ByVal nCmdShow As Long) As Long
Private Declare Function GetWindowsDirectory Lib "kernel32" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function GetSystemDirectory Lib "kernel32" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function MoveWindow Lib "user32" (ByVal hWnd As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long
Private Declare Function IsWindowVisible Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function CreateWindowEX Lib "user32" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Declare Function SetWindowPos Lib "user32" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal X As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long
Private Declare Function DestroyWindow Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function CreateFontIndirect Lib "gdi32" Alias "CreateFontIndirectA" (lpLogFont As LOGFONT) As Long
Private Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
Private Declare Function SetBkMode Lib "gdi32" (ByVal hdc As Long, ByVal nBkMode As Long) As Long
Private Declare Function GetTextFace Lib "gdi32" Alias "GetTextFaceA" (ByVal hdc As Long, ByVal nCount As Long, ByVal lpFacename As String) As Long
Private Declare Function GetTextMetrics Lib "gdi32" Alias "GetTextMetricsA" (ByVal hdc As Long, lpMetrics As TEXTMETRIC) As Long
Private Declare Function SetWindowText Lib "user32" Alias "SetWindowTextA" (ByVal hWnd As Long, ByVal lpString As String) As Long
Private Declare Function UpdateWindow Lib "user32" (ByVal hWnd As Long) As Long
Private Declare Function GetStockObject Lib "gdi32" (ByVal nIndex As Long) As Long
Private Declare Function GetWindowRect Lib "user32" (ByVal hWnd As Long, lpRect As RECT) As Long
Private Declare Function InitCommonControlsEx Lib "comctl32.dll" (iccex As tagInitCommonControlsEx) As Boolean
Private Declare Function SendStringMessage Lib "user32" Alias "SendMessageA" (ByVal hWnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long
Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hWnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
 
Private Type TEXTMETRIC
        tmHeight As Long
        tmAscent As Long
        tmDescent As Long
        tmInternalLeading As Long
        tmExternalLeading As Long
        tmAveCharWidth As Long
        tmMaxCharWidth As Long
        tmWeight As Long
        tmOverhang As Long
        tmDigitizedAspectX As Long
        tmDigitizedAspectY As Long
        tmFirstChar As Byte
        tmLastChar As Byte
        tmDefaultChar As Byte
        tmBreakChar As Byte
        tmItalic As Byte
        tmUnderlined As Byte
        tmStruckOut As Byte
        tmPitchAndFamily As Byte
        tmCharSet As Byte
End Type

 
Private Type RECT
        Left As Long
        Top As Long
        Right As Long
        Bottom As Long
End Type

Private Type tagInitCommonControlsEx
    lngSize As Long
    lngICC As Long
End Type

Private Const CF_BITMAP = 2
Private Const SWP_NOACTIVATE = &H10
Private ObjParent As Object
 
Private Const CB_SETCURSEL = &H14E
Private Const CB_GETCOUNT = &H146
Private Const CB_GETCURSEL = &H147
Private Const CB_GETEDITSEL = &H140
Private Const CB_GETLBTEXT = &H148
Private Const CB_GETLBTEXTLEN = &H149
Private Const CB_SELECTSTRING = &H14D
Private Const CB_FINDSTRING = &H14C
Private Const CB_FINDSTRINGEXACT = &H158
Private Const CB_SETDROPPEDWIDTH = &H160
Private Const CB_SETITEMHEIGHT = &H153
Private Const CB_RESETCONTENT = &H14B
 

Private cbItems As COMBOBOXEXITEMW

Const WS_VISIBLE = &H10000000
Const WS_CHILD = &H40000000
 
Private Const WM_USER = &H400
Private Const GWL_HWNDPARENT = (-8)
Private Const GWL_STYLE = (-16)
 
Private ComboExhWnd As Long

Const HWND_TOPMOST = -1
Const SW_HIDE = 0
Const SW_SHOWNORMAL = 1
 
Const SWP_NOSIZE = &H1
Const SWP_NOMOVE = &H2
Const SWP_NOREDRAW = &H8
Const SWP_SHOWWINDOW = &H40

Private Const ICC_USEREX_CLASSES = &H200

Private Const WC_COMBOBOXEXW = "ComboBoxEx32"
Private Const WC_COMBOBOXEXA = "ComboBoxEx32"
 
#If UNICODE Then
Private Const WC_COMBOBOXEX = WC_COMBOBOXEXW
#Else
Private Const WC_COMBOBOXEX = WC_COMBOBOXEXA
#End If

Private Const CBS_DROPDOWN = &H2&
Private Const CBS_DROPDOWNLIST = &H3&
Private Const CBS_HASSTRINGS = &H200&
Private Const CBS_DISABLENOSCROLL = &H800&
Private Const CBS_NOINTEGRALHEIGHT = &H400&
Private Const CBS_OWNERDRAWFIXED = &H10&
Private Const CBS_OWNERDRAWVARIABLE = &H20&
Private Const CBS_SIMPLE = &H1&
Private Const CBS_SORT = &H100&
Private Const CB_SETEDITSEL = &H142
 
Private Const CBEIF_TEXT = &H1
Private Const CBEIF_IMAGE = &H2
Private Const CBEIF_SELECTEDIMAGE = &H4
Private Const CBEIF_OVERLAY = &H8
Private Const CBEIF_INDENT = &H10
Private Const CBEIF_LPARAM = &H20
Private Const CBEIF_DI_SETITEM = &H10000000
Private Const H_MAX As Long = &HFFFF + 1
Private Const CBEN_FIRST = (H_MAX - 800&)
Private Const CBEN_LAST = (H_MAX - 830&)
Private Const CBEN_GETDISPINFO = (CBEN_FIRST - 0)
Private Const CBEN_INSERTITEM = (CBEN_FIRST - 1)
Private Const CBEN_DELETEITEM = (CBEN_FIRST - 2)
Private Const CBEN_BEGINEDIT = (CBEN_FIRST - 4)
Private Const CBEN_ENDEDITA = (CBEN_FIRST - 5)
Private Const CBEN_ENDEDITW = (CBEN_FIRST - 6)
Private Const CBN_EDITCHANGE = 5
Private Const CBN_EDITUPDATE = 6
Private Const CBN_SELCHANGE = 1
Private Const CB_DELETESTRING = &H144
Private Const CBEM_INSERTITEMA = (WM_USER + 1)
Private Const CBEM_SETIMAGELIST = (WM_USER + 2)
Private Const CBEM_GETIMAGELIST = (WM_USER + 3)
Private Const CBEM_GETITEMA = (WM_USER + 4)
Private Const CBEM_SETITEMA = (WM_USER + 5)
Private Const CBEM_DELETEITEM = CB_DELETESTRING
Private Const CBEM_GETCOMBOCONTROL = (WM_USER + 6)
Private Const CBEM_GETEDITCONTROL = (WM_USER + 7)
Private Const CBEM_SETEXSTYLE = (WM_USER + 8)
Private Const CBEM_GETEXSTYLE = (WM_USER + 9)
Private Const CBEM_HASEDITCHANGED = (WM_USER + 10)
Private Const CBEM_INSERTITEMW = (WM_USER + 11)
Private Const CBEM_SETITEMW = (WM_USER + 12)
Private Const CBEM_GETITEMW = (WM_USER + 13)

Private Type COMBOBOXEXITEMW
    mask As Long
    iItem As Long
    pszText As String
    cchTextMax  As Long
    iImage As Long
    iSelectedImage As Long
    iOverlay As Long
    iIndent As Long
    lParam As Long
End Type


#If UNICODE Then
Private Const CBEM_INSERTITEM = CBEM_INSERTITEMW
Private Const CBEM_SETITEM = CBEM_SETITEMW
Private Const CBEM_GETITEM = CBEM_GETITEMW
#Else
Private Const CBEM_INSERTITEM = CBEM_INSERTITEMA
Private Const CBEM_SETITEM = CBEM_SETITEMA
Private Const CBEM_GETITEM = CBEM_GETITEMA
#End If

Private Const CBES_EX_NOEDITIMAGE = &H1
Private Const CBES_EX_NOEDITIMAGEINDENT = &H2
Private Const CBES_EX_PATHWORDBREAKPROC = &H4

Public Function AddIcon(hIcon As Variant)
AddIcon = ImgList.AddIcon(hIcon)
End Function

Public Sub Clear()
  Dim ComboCount As Integer, Total
  Total = ListCount
 
  For ComboCount = 0 To Total - 2
  Call SendMessage(ComboExhWnd, CBEM_DELETEITEM, 0, 0)
  Next

  cbItems.mask = 0&
  cbItems.pszText = ""
  cbItems.cchTextMax = 0
  cbItems.iIndent = 0
  cbItems.iImage = -1
  cbItems.iSelectedImage = -1
  cbItems.iItem = -1
  cbItems.iOverlay = -1
  
  ReDim ComboInfo(0)
   
    
  Call SendMessage(ComboExhWnd, CBEM_INSERTITEM, -1, cbItems)
  Call SendMessage(ComboExhWnd, CBEM_DELETEITEM, 0, 0)
  
  SetIndex 0
End Sub

Public Sub RemoveItem(ByVal Item As Integer)
Call SendMessage(ComboExhWnd, CBEM_DELETEITEM, Item, 0)
SetIndex 0

End Sub
Public Sub Destroy()
ImgList.Destroy
Call DestroyWindow(ComboExhWnd)
End Sub

Public Sub GetAllDrives()
Dim LastItem As Integer
Dim Drv As String, lResult As Long, DrvLetter As String
 
 Additems "Desktop", 0, 0, 0, , 34
 Additems "My Computer", 1, 1, 1, GetWinDir & "\Explorer.exe", 0

LastItem = 2

Drv = String$(128, 0)

lResult = GetLogicalDriveStrings(1024, Drv)

   Do While Left$(Drv, 1) <> Chr$(0)

        DrvLetter = UCase$(Left$(Drv, 3))
        Drv = Mid$(Drv, 5)

        DrvType = GetDriveType(DrvLetter)

        Select Case DrvType
            Case DRIVE_REMOVABLE
                 If DrvLetter = "A:\" Then
                 Additems "3  Floppy" & " (" & Left(DrvLetter, 2) & ")", LastItem, LastItem, 2, DrvLetter
                 ElseIf DrvLetter = "B:\" Then
                 Additems "5  Floppy" & " (" & Left(DrvLetter, 2) & ")", LastItem, LastItem, 2, DrvLetter
                 Else
                 Additems GetVolName(DrvLetter) & " (" & Left(DrvLetter, 2) & ")", LastItem, LastItem, 2, DrvLetter
                 End If

                 LastItem = LastItem + 1
            Case DRIVE_FIXED
                 Additems GetVolName(DrvLetter) & " (" & Left(DrvLetter, 2) & ")", LastItem, LastItem, 2, DrvLetter
                 LastItem = LastItem + 1
            Case DRIVE_REMOTE
                 sBuffer = String$(255, 0)
                 lResult = WNetGetConnection(Left$(DrvLetter, 2), sBuffer, Len(sBuffer))
                 If lResult = 0 Then
                 Additems GetVolName(DrvLetter) & " (" & Left(DrvLetter, 2) & ")", LastItem, LastItem, 2, DrvLetter
                 LastItem = LastItem + 1
                 End If
            Case DRIVE_CDROM
                 Additems GetVolName(DrvLetter) & " (" & Left(DrvLetter, 2) & ")", LastItem, LastItem, 2, DrvLetter
                 LastItem = LastItem + 1
            Case DRIVE_RAMDISK
                 Additems GetVolName(DrvLetter) & " (" & Left(DrvLetter, 2) & ")", LastItem, LastItem, 2, DrvLetter
                 LastItem = LastItem + 1
        End Select

    Loop

 Dim MyFile, MyPath, MyName As String

MyPath = GetWinDir & "\Desktop\"
MyName = Dir(MyPath, vbDirectory)

Do While MyName <> ""

   If MyName <> "." And MyName <> ".." Then


If (GetAttr(MyPath & MyName) And vbDirectory) = vbDirectory Then
           Additems MyName, LastItem, LastItem, 0, MyPath & MyName
           LastItem = LastItem + 1
        End If
    End If
    MyName = Dir
Loop
   
    SetIndex 0
End Sub
Public Function GetComboHwnd() As Long
GetComboHwnd = ComboExhWnd
End Function

Public Function GetComboIcon(Pic As Object, Optional IconDrawState As cbIconState)
On Error Resume Next
Dim CurSel As Integer
'Gets the Current Icon Displayed in the Edit portion of the ComboBox
CurSel = SendMessage(ComboExhWnd, CB_GETCURSEL, 0, 0)
ImgList.GetIcon CurSel, Pic, IconDrawState
End Function

Public Function GetDropDownHwnd() As Long
GetDropDownHwnd = SendMessage(ComboExhWnd, CBEM_GETCOMBOCONTROL, 0, 0)
End Function
 
Public Function GetEditString() As String
Dim EditHwnd As Long
Dim ComboString As String * 255, lResult As Long
'Gets the Text in the Edit portion of the ComboBox
EditHwnd = SendMessage(ComboExhWnd, CBEM_GETEDITCONTROL, 0, 0)
lResult = GetWindowText(EditHwnd, ComboString, Len(ComboString))
GetEditString = Left(ComboString, lResult)
 
End Function
Public Function ListCount() As Integer
ListCount = SendMessage(GetComboHwnd, CB_GETCOUNT, 0, 0)
End Function

Public Sub SetEditString(EditString As String)
Dim EditHwnd As Long
Dim lResult As Long
'Sets the Text in the Edit portion of the ComboBox
'Only if it's editable
EditHwnd = SendMessage(ComboExhWnd, CBEM_GETEDITCONTROL, 0, 0)
lResult = SetWindowText(EditHwnd, ByVal EditString)
Call UpdateWindow(EditHwnd)

End Sub
Public Sub ResizeCombo(NewWidth As Integer)
Exit Sub

Dim ComboRect As RECT, FormRect As RECT
 
Call GetWindowRect(ComboExhWnd, ComboRect)
 
Call MoveWindow(ComboExhWnd, CLng(cmbLeft), CLng(cmbTop), CLng(NewWidth / Screen.TwipsPerPixelX), CLng(ComboRect.Bottom - ComboRect.Top), True)
End Sub

Public Sub SetDropWidth(NewWidth As Integer)
Call SendMessage(GetDropDownHwnd, CB_SETDROPPEDWIDTH, NewWidth * Screen.TwipsPerPixelX, 0&)

End Sub

Public Sub SetIndex(Index As Integer)
Dim CurSel As Long
 
CurSel = SendMessage(ComboExhWnd, CB_SETCURSEL, Index, 0)

End Sub
Public Sub SetItemHeight(ItemHeight As Integer)
 
'Set the New Item Height of drop down
Call SendMessageByLong(GetDropDownHwnd, CB_SETITEMHEIGHT, 0, ByVal (ItemHeight And &HFFFF))
 
'Update the Window
Call UpdateWindow(GetDropDownHwnd)

End Sub

Private Sub Class_Initialize()
Dim iccex As tagInitCommonControlsEx
    With iccex
        .lngSize = LenB(iccex)
        .lngICC = ICC_USEREX_CLASSES
    End With
    Call InitCommonControlsEx(iccex)
 
   ComboExhWnd = 0
End Sub
 
Public Function Create( _
 Optional Left As Variant, _
 Optional Top As Variant, _
 Optional Width As Variant, _
 Optional Height As Variant, _
   Optional ImageListHwnd As Long, Optional IconSize As Integer = 16, Optional Editable As Boolean) _
  As Boolean
  
'if we didn't pass a previously created imagelist then create one
If ImageListHwnd = 0 Then
With ImgList
If IconSize = 16 Then .Create Size16
If IconSize = 32 Then .Create Size32
End With
ImageListHwnd = ImgList.ImgListHwnd
End If
 
 'Create the ComboBoxEx Control
 'CBS_DROPDOWNLIST - Not Editable
 'CBS_DROPDOWN
 If Editable = True Then
  ComboExhWnd = CreateWindowEX(0, WC_COMBOBOXEX, "", _
          WS_CHILD Or WS_VISIBLE Or WS_BORDER Or CBS_DROPDOWN, _
          Left, Top, Width, Height, _
          Parent.hWnd, 0&, App.hInstance, 0&)
 Else
   ComboExhWnd = CreateWindowEX(0, WC_COMBOBOXEX, "", _
          WS_CHILD Or WS_VISIBLE Or WS_BORDER Or CBS_DROPDOWNLIST, _
          Left, Top, Width, Height, _
          Parent.hWnd, 0&, App.hInstance, 0&)
 End If
 ReDim ComboInfo(0)
 'Set the parent to receive the messages
 Call SetParent(ComboExhWnd, Parent.hWnd)
 
 'Set the Imagelist for the ComboBox
 Call SendMessage(ComboExhWnd, CBEM_SETIMAGELIST, 0, ByVal ImageListHwnd)
  
 Call MoveWindow(ComboExhWnd, CLng(Left), CLng(Top), CLng(Width), CLng(Height), True)
  
 If cmbCustomize = True Then SetComboFont
 
 Call ShowWindow(ComboExhWnd, SW_SHOWNORMAL)
 
 cmbLeft = CInt(Left)
 cmbTop = CInt(Top)
 
End Function
Public Property Get Parent() As Object
    Set Parent = ObjParent
End Property

Public Property Set Parent(frm As Object)
    Set ObjParent = frm
End Property
Public Sub Additems(StringToAdd As String, Index As Integer, ImgIndex As Integer, InDent As Integer, _
Optional FileName As String, Optional IconInFile As Integer = -1)
 
   
  If Len(FileName) > 0 Then
  Call ImgList.AddFileIcon(FileName, IconInFile)
  Else
  Call ImgList.AddFileIcon(GetSysDir & "\Shell32.dll", IconInFile)
  End If
    
  cbItems.mask = CBEIF_TEXT Or CBEIF_INDENT Or CBEIF_IMAGE Or CBEIF_LPARAM Or CBEIF_SELECTEDIMAGE Or CBEIF_OVERLAY
  cbItems.pszText = StringToAdd
  cbItems.cchTextMax = Len(StringToAdd)
  cbItems.iIndent = InDent
  cbItems.iImage = ImgIndex
  cbItems.iSelectedImage = ImgIndex
  cbItems.iItem = Index
  cbItems.iOverlay = ImgIndex
  'cbItems.lParam
  
  'Redim our array to hold info
  If Index > UBound(ComboInfo) Then
  ReDim Preserve ComboInfo(UBound(ComboInfo) + 1)
  End If
    
  ComboInfo(Index).Info = StringToAdd
  ComboInfo(Index).InfoPath = FileName
     
  Call SendMessage(ComboExhWnd, CBEM_INSERTITEM, Index, cbItems)
 
End Sub
Public Function GetWinDir()
 Dim sBuffer As String
 Dim lResult As Long
 sBuffer = String$(255, 0)
 lResult = GetWindowsDirectory(sBuffer, Len(sBuffer))
 GetWinDir = Left(sBuffer, lResult)
End Function
Public Function GetSysDir()
Dim sBuffer As String
Dim lResult As Long
sBuffer = String$(255, 0)
lResult = GetSystemDirectory(sBuffer, Len(sBuffer))
GetSysDir = Left(sBuffer, lResult)
End Function
 
Public Function GetText() As String
On Error Resume Next
Dim CurSel As Integer

CurSel = SendMessage(ComboExhWnd, CB_GETCURSEL, 0, 0)

GetText = ComboInfo(CurSel).Info
 
End Function

Private Sub Class_Terminate()
On Error Resume Next
If ComboExhWnd <> 0 Then
ImgList.Destroy
Call DestroyWindow(ComboExhWnd)
End If
Dim dl As Long
If NewComboFont <> 0 Then
dl = DeleteObject(NewComboFont)
End If
End Sub
Public Function GetString(id As Integer) As String
GetString = ComboInfo(id).Info
End Function
Public Function GetPath() As String
On Error Resume Next
 Dim CurSel As Integer
 Dim X As Long
 Dim k
'Returns the File used to extract the Icon or can be used to Return whatever type
'Info you want
CurSel = SendMessage(ComboExhWnd, CB_GETCURSEL, 0, 0)
 
GetPath = ComboInfo(CurSel).InfoPath


End Function
 
Public Function GetVolName(Drive As String) As String
Dim VolumName As String, lResult As Long, xNull As Integer
'Returns the Volume Name of a drive
    VolumName = String$(256, 0)
    
    lResult = GetVolumeInformation(Drive, VolumName, 255, 0&, _
         0&, 0&, 0&, 255)
     
    xNull = InStr(1, CStr(VolumName), Chr$(0))
     
   GetVolName = Left(VolumName, xNull - 1)
End Function
Public Sub SetComboFont()
 
    Dim cbDC As Long
 
    cbDC = GetDC(GetDropDownHwnd)
  
    Dim CurrentComboFont As Long
    
    Dim dl As Long
 
    Dim mFlags As Long
     
    CurrentComboFont = SelectObject(cbDC, GetStockObject(SYSTEM_FONT))
     
    dl = SetBkMode(cbDC, TRANSPARENT)
    
    LF.lffacename = cmbFontName & Chr$(0)
    LF.lfHeight = cmbFontHeight
    LF.lfUnderline = cmbFontUnderlined
    LF.lfItalic = cmbFontItalic
    
    If cmbFontBold = True Then
    LF.lfWeight = 600
    Else
    LF.lfWeight = 300
    End If
  
    NewComboFont = CreateFontIndirect(LF)
    dl = SelectObject(cbDC, NewComboFont)
      
    'Set the New Font to drop down
    Call SendMessage(GetDropDownHwnd, WM_SETFONT, NewComboFont, 1)
    
    Dim EditHwnd As Long
    EditHwnd = SendMessage(ComboExhWnd, CBEM_GETEDITCONTROL, 0, 0)
    
    'Set the New Font to the Edit window
    Call SendMessage(EditHwnd, WM_SETFONT, NewComboFont, 1)
       
    NewComboFont = SelectObject(cbDC, CurrentComboFont)
    'Restore original font
    dl = SelectObject(cbDC, CurrentComboFont)
    
    'NewComboFont is deleted in terminate Event
     
End Sub
Public Sub RunFile(FileToRun As String)

    On Error Resume Next
    
    Dim LinkCheck As String, RetVal As Long

    LinkCheck = Trim(Right(FileToRun, 3))
    
    If LinkCheck = "lnk" Then 'It's a shortcut
        RetVal = ShellExecute(ObjParent.hWnd, "", FileToRun, "", "", 1)
    Else ' its a executable or document
        RetVal = ShellExecute(ObjParent.hWnd, "Open", FileToRun, "", "", 1)
    End If
End Sub

Public Property Let FontBold(ByVal vNewValue As Boolean)
cmbFontBold = vNewValue
cmbCustomize = True
End Property
Public Property Let FontItalic(ByVal vNewValue As Boolean)
cmbFontItalic = vNewValue
cmbCustomize = True
End Property
Public Property Let FontName(ByVal vNewValue As String)
cmbFontName = vNewValue
cmbCustomize = True
End Property
Public Property Let FontHeight(ByVal vNewValue As Integer)
cmbFontHeight = vNewValue
cmbCustomize = True
End Property
Public Property Let FontUnderlined(ByVal vNewValue As Boolean)
cmbFontUnderlined = vNewValue
cmbCustomize = True
End Property
 
