Attribute VB_Name = "Module1"
Option Explicit
#If Win32 Then
    Type Coord      ' This is the type structure for the x and y
       X As Long    ' coordinates for the polygonal region.
       Y As Long
    End Type
    Declare Function CreatePolygonRgn Lib "gdi32" (lpPoints As Any, ByVal nCount As Long, ByVal nPolyFillMode As Long) As Long
    Declare Function Polygon Lib "gdi32" (ByVal hdc As Long, lpPoints As Any, ByVal nCount As Long) As Long
    Declare Function FillRgn Lib "gdi32" (ByVal hdc As Long, ByVal hRgn As Long, ByVal hBrush As Long) As Long
    Declare Function GetStockObject Lib "gdi32" (ByVal nIndex As Long) As Long
    Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Long) As Long
    Declare Function DeleteObject Lib "gdi32" (ByVal hndobj As Long) As Long
#Else
    
    Type Coord       ' This is the type structure for the x and y
       X As Integer  ' coordinates for the polygonal region.
       Y As Integer
    End Type
    
    Declare Function CreatePolygonRgn Lib "GDI" (lpPoints As Any, ByVal nCount As Integer, ByVal nPolyFillMode As Integer) As Integer
    Declare Function Polygon Lib "GDI" (ByVal hdc As Integer, lpPoints As Any, ByVal nCount As Integer) As Integer
    Declare Function FillRgn Lib "GDI" (ByVal hdc As Integer, ByVal hRgn As Integer, ByVal hBrush As Integer) As Integer
    Declare Function GetStockObject Lib "GDI" (ByVal nIndex As Integer) As Integer
    Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
    Declare Function DeleteObject Lib "GDI" (ByVal hndobj As Integer) As Integer
#End If
#If Win32 Then
    Declare Function FloodFill Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal crColor As Long) As Long
#Else
    Declare Function FloodFill Lib "GDI" (ByVal hdc As Integer, ByVal X As Integer, ByVal Y As Integer, ByVal crColor As Long) As Integer
#End If

Global Const ALTERNATE = 1 ' ALTERNATE and WINDING are
Global Const WINDING = 2   ' constants for FillMode.
Global Const BLACKBRUSH = 4 ' Constant for brush type.


   'Extends VB's shape palette. Draws a multi-pointed star.

Public Sub PolyStarGDI(objDraw As Object, lLeft As Long, lTop As Long, lWidth As Long, lHeight As Long, iPoints As Integer, iFill As Integer, lColor As Long)
Dim foo As Integer, foobar As Integer
Dim checkit As Integer, x1 As Long, y1 As Long, interval As Integer
Dim hBrush As Integer, hRgn As Integer
Dim HoldColor As Long
Dim Even As Integer, AdjPoints As Integer, EvenLevels As Integer, EvenLoop As Integer
Dim twipsX As Integer, twipsY As Integer
twipsX = Screen.TwipsPerPixelX
twipsY = Screen.TwipsPerPixelY

'can't do fewer than five pointed star...
If iPoints < 5 Then iPoints = 5
ReDim poly(1 To iPoints) As Coord

'set colors
HoldColor = objDraw.ForeColor
objDraw.ForeColor = lColor

'if odd number of points, can draw star in one pass,
If iPoints Mod 2 = 1 Then
    interval = iPoints \ 2
    AdjPoints = iPoints
    Even = False
'if even, must reduce until an odd interval is found
Else
    AdjPoints = iPoints \ 2
    EvenLevels = 1
    interval = AdjPoints \ 2
    Do Until AdjPoints Mod 2 = 1 Or AdjPoints = 4
        AdjPoints = AdjPoints \ 2
        EvenLevels = EvenLevels + 1
        interval = AdjPoints \ 2
    Loop
    If AdjPoints = 4 Then interval = 1
    Even = True
End If

'draw the odd loop
ReDim poly(1 To AdjPoints) As Coord
foo = 0
For foobar = 1 To AdjPoints
    DegreesToXY lLeft + lWidth / 2, lTop + lHeight / 2, foo * (360 / AdjPoints), lWidth / 2, lHeight / 2, x1, y1
    poly(foobar).X = x1 / twipsX
    poly(foobar).Y = y1 / twipsY
    foo = foo + interval
    If foo > AdjPoints Then foo = foo - AdjPoints
Next foobar
checkit = Polygon(objDraw.hdc, poly(1), AdjPoints)

'fill winding polygon using region fill
If iFill Then
    hRgn = CreatePolygonRgn(poly(1), AdjPoints, WINDING)
    hBrush = CreateSolidBrush(objDraw.ForeColor)
    If hRgn Then foo = FillRgn(objDraw.hdc, hRgn, hBrush)
    foo = DeleteObject(hRgn)
End If

'draw loops for even cycles
For EvenLoop = 1 To 2 ^ (EvenLevels) - 1
    foo = 0
    For foobar = 1 To AdjPoints
        DegreesToXY lLeft + lWidth / 2, lTop + lHeight / 2, (foo + EvenLoop * (1 / (2 ^ (EvenLevels)))) * (360 / AdjPoints), lWidth / 2, lHeight / 2, x1, y1
        poly(foobar).X = x1 / twipsX
        poly(foobar).Y = y1 / twipsY
        foo = foo + interval
        If foo > AdjPoints Then foo = foo - AdjPoints
    Next foobar
    checkit = Polygon(objDraw.hdc, poly(1), AdjPoints)
    'fill winding polygon using region fill
    If iFill Then
        hRgn = CreatePolygonRgn(poly(1), AdjPoints, WINDING)
        hBrush = CreateSolidBrush(objDraw.ForeColor)
        If hRgn Then foo = FillRgn(objDraw.hdc, hRgn, hBrush)
        foo = DeleteObject(hRgn)
    End If
Next EvenLoop
objDraw.ForeColor = HoldColor
End Sub

'Extends VB's shape palette. Draws multisided polygons. This sub assumes that the scalemode is twips.
Public Sub ShapePolygon(DrawObj As Object, left As Long, top As Long, width As Long, height As Long, sides As Integer, fill As Integer, FillColor As Long)
Dim foo As Integer, checkit As Integer
Dim x1 As Long, y1 As Long, x2 As Long, y2 As Long, holdstyle As Integer, HoldColor As Long
Dim twipsX As Integer, twipsY As Integer
ReDim poly(1 To sides) As Coord
twipsX = Screen.TwipsPerPixelX
twipsY = Screen.TwipsPerPixelY

'set the points for the polygon boundaries
For foo = 0 To sides - 1
    DegreesToXY left + width / 2, top + height / 2, foo * (360 / sides), width / 2, height / 2, x1, y1
    poly(foo + 1).X = x1 \ twipsX
    poly(foo + 1).Y = y1 \ twipsY
Next foo

'draw the polygon edges using the Polygon GDI call
checkit = Polygon(DrawObj.hdc, poly(1), sides)

'fill the polygon if desired, using floodfill
If fill Then
    holdstyle = DrawObj.FillStyle
    DrawObj.FillStyle = 0
    HoldColor = DrawObj.FillColor
    DrawObj.FillColor = FillColor
    foo = FloodFill(DrawObj.hdc, (left + width / 2) \ Screen.TwipsPerPixelX, (top + height / 2) \ Screen.TwipsPerPixelX, DrawObj.ForeColor)
    DrawObj.FillStyle = holdstyle
    DrawObj.FillColor = HoldColor
End If
End Sub

'Converts degrees on a circle to x, y coordinates.
Public Sub DegreesToXY(CenterX As Long, CenterY As Long, degree As Double, radiusX As Long, radiusY As Long, X As Long, Y As Long)
Dim convert As Double

    convert = 3.141593 / 180
    X = CenterX - (Sin(-degree * convert) * radiusX)
    Y = CenterY - (Sin((90 + (degree)) * convert) * radiusY)

End Sub


