Attribute VB_Name = "Module2"
Option Explicit

Type bitmap
      bmType As Integer
      bmWidth As Integer
      bmHeight As Integer
      bmWidthBytes As Integer

      bmPlanes As String * 1
      bmBitsPixel As String * 1
      bmBits As Long
End Type
   
   Declare Function BitBlt Lib "GDI" (ByVal srchDC As Integer, ByVal srcX As Integer, ByVal srcY As Integer, ByVal srcW As Integer, ByVal srcH As Integer, ByVal desthDC As Integer, ByVal destx As Integer, ByVal desty As Integer, ByVal op As Long) As Integer
   Declare Function SetBkColor Lib "GDI" (ByVal hDC As Integer, ByVal cColor As Long) As Long
   Declare Function CreateCompatibleDC Lib "GDI" (ByVal hDC As Integer) As Integer
   Declare Function DeleteDC Lib "GDI" (ByVal hDC As Integer) As Integer
   Declare Function CreateBitmap Lib "GDI" (ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal cbPlanes As Integer, ByVal cbBits As Integer, lpvBits As Any) As Integer
   Declare Function CreateCompatibleBitmap Lib "GDI" (ByVal hDC As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Integer
   Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
   Declare Function TRANSP_DeleteObject Lib "GDI" Alias "DeleteObject" (ByVal hObject As Integer) As Integer
   Declare Function GDIGetObject Lib "GDI" Alias "GetObject" (ByVal hObject As Integer, ByVal nCount As Integer, bmp As Any) As Integer
   
   Const SRCCOPY = &HCC0020
   Const SRCAND = &H8800C6
   Const SRCPAINT = &HEE0086
   Const NOTSRCCOPY = &H330008

   
      Const PIXEL = 3
      Dim destScale As Integer
      
      Dim srcDC As Integer  'source bitmap (color)
      Dim saveDC As Integer 'backup copy of source bitmap
      Dim maskDC As Integer 'mask bitmap (monochrome)
      Dim invDC As Integer  'inverse of mask bitmap (monochrome)
      Dim resultDC As Integer
      
      Dim bmp As bitmap 'description of the source bitmap
      
      Dim hResultBmp As Integer 'Bitmap combination of source & background
      Dim hSaveBmp As Integer 'Bitmap stores backup copy of source bitmap
      Dim hMaskBmp As Integer 'Bitmap stores mask (monochrome)
      Dim hInvBmp As Integer  'Bitmap holds inverse of mask (monochrome)
      Dim hPrevBmp As Integer 'Bitmap holds previous bitmap selected in DC
      
      Dim hSrcPrevBmp As Integer
      Dim hSavePrevBmp As Integer
      Dim hDestPrevBmp As Integer
      Dim hMaskPrevBmp As Integer
      Dim hInvPrevBmp As Integer
      
      Dim OrigColor As Long
      Dim Success As Integer


    Global Const maxxstep = 10
    Global Const maxystep = 10

Sub TRANSP_DoBlitt(Dest As Control, buff As Control, ByVal destx As Integer, ByVal desty As Integer, sourcex As Integer, sourcey As Integer, width As Integer, height As Integer)
    Success = BitBlt(resultDC, 0, 0, width + (maxxstep * 2), height + (maxystep * 2), buff.hDC, destx - maxxstep, desty - maxystep, SRCCOPY)
    Success = BitBlt(resultDC, maxxstep, maxystep, width, height, maskDC, sourcex, sourcey, SRCAND)
    Success = BitBlt(resultDC, maxxstep, maxystep, width, height, srcDC, sourcex, sourcey, SRCPAINT)
    Success = BitBlt(Dest.hDC, destx - maxxstep, desty - maxystep, width + (maxxstep * 2), height + (maxystep * 2), resultDC, 0, 0, SRCCOPY)
End Sub

Sub TRANSP_FreeMaske(Dest As Control)
    Success = BitBlt(srcDC, 0, 0, bmp.bmWidth, bmp.bmHeight, saveDC, 0, 0, SRCCOPY) 'Restore backup of bitmap.

    hPrevBmp = SelectObject(srcDC, hSrcPrevBmp) 'Select orig object
    hPrevBmp = SelectObject(saveDC, hSavePrevBmp) 'Select orig object
    hPrevBmp = SelectObject(resultDC, hDestPrevBmp) 'Select orig object
    hPrevBmp = SelectObject(maskDC, hMaskPrevBmp) 'Select orig object
    hPrevBmp = SelectObject(invDC, hInvPrevBmp) 'Select orig object
    'hPrevBmp = SelectObject(BuffDC, hBuffPrevBmp) 'Select orig object
    
    Success = TRANSP_DeleteObject(hSaveBmp)
    Success = TRANSP_DeleteObject(hMaskBmp)
    Success = TRANSP_DeleteObject(hInvBmp)
    Success = TRANSP_DeleteObject(hResultBmp)
    'Success = DeleteObject(hBuffBmp)
    
    Success = DeleteDC(srcDC)
    Success = DeleteDC(saveDC)
    'Success = DeleteDC(BuffDC)
    Success = DeleteDC(invDC)
    Success = DeleteDC(maskDC)
    Success = DeleteDC(resultDC)
    
    Dest.ScaleMode = destScale
End Sub

Sub TRANSP_MakeMaske(Dest As Control, src As Control, ByVal TransColor As Long)
    Debug.Print "Color: "; Hex(TransColor)
    destScale = Dest.ScaleMode
    'Dest.ScaleMode = 1
    
    Success = GDIGetObject(src.Picture, Len(bmp), bmp)
    
    srcDC = CreateCompatibleDC(Dest.hDC)
    saveDC = CreateCompatibleDC(Dest.hDC)
    maskDC = CreateCompatibleDC(Dest.hDC)
    invDC = CreateCompatibleDC(Dest.hDC)
    resultDC = CreateCompatibleDC(Dest.hDC)
    
    hMaskBmp = CreateBitmap(bmp.bmWidth, bmp.bmHeight, 1, 1, ByVal 0&)
    hInvBmp = CreateBitmap(bmp.bmWidth, bmp.bmHeight, 1, 1, ByVal 0&)
    hResultBmp = CreateCompatibleBitmap(Dest.hDC, bmp.bmWidth + (2 * maxxstep) + 10, bmp.bmHeight + (2 * maxystep) + 10)
    hSaveBmp = CreateCompatibleBitmap(Dest.hDC, bmp.bmWidth, bmp.bmHeight)
    
    hSrcPrevBmp = SelectObject(srcDC, src.Picture)
    hSavePrevBmp = SelectObject(saveDC, hSaveBmp)
    hMaskPrevBmp = SelectObject(maskDC, hMaskBmp)
    hInvPrevBmp = SelectObject(invDC, hInvBmp)
    hDestPrevBmp = SelectObject(resultDC, hResultBmp)
    
    Success = BitBlt(saveDC, 0, 0, bmp.bmWidth, bmp.bmHeight, srcDC, 0, 0, SRCCOPY) 'Make backup of source bitmap to restore later

    'Create mask: set background color of source to transparent color.
    OrigColor = SetBkColor(srcDC, TransColor)
    Success = BitBlt(maskDC, 0, 0, bmp.bmWidth, bmp.bmHeight, srcDC, 0, 0, SRCCOPY)
    TransColor = SetBkColor(srcDC, OrigColor)
    'Create inverse of mask to AND w/ source & combine w/ background.
    Success = BitBlt(invDC, 0, 0, bmp.bmWidth, bmp.bmHeight, maskDC, 0, 0, NOTSRCCOPY)
    'Copy background bitmap to result & create final transparent bitmap
    'AND inverse mask w/ source bitmap to turn off bits associated
    'with transparent area of source bitmap by making it black.
    Success = BitBlt(srcDC, 0, 0, bmp.bmWidth, bmp.bmHeight, invDC, 0, 0, SRCAND)
End Sub

