VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4005
   ClientLeft      =   3180
   ClientTop       =   3450
   ClientWidth     =   4650
   Height          =   4410
   Left            =   3120
   LinkTopic       =   "Form1"
   ScaleHeight     =   267
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   310
   Top             =   3105
   Width           =   4770
   Begin VB.PictureBox Picture1 
      Height          =   1335
      Left            =   1680
      ScaleHeight     =   85
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   77
      TabIndex        =   0
      Top             =   960
      Width           =   1215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Private Const BI_RGB = 0&
Private Const CBM_INIT = &H4
Private Const DIB_RGB_COLORS = 0
Private Const SRCCOPY = &HCC0020

Private Type BITMAPINFOHEADER
    biSize As Long
    biWidth As Long
    biHeight As Long
    biPlanes As Integer
    biBitCount As Integer
    biCompression As Long
    biSizeImage As Long
    biXPelsPerMeter As Long
    biYPelsPerMeter As Long
    biClrUsed As Long
    biClrImportant As Long
End Type
Private Type RGBQUAD
    rgbBlue As Byte
    rgbGreen As Byte
    rgbRed As Byte
    rgbReserved As Byte
End Type
Private Type BITMAPINFO_256
    bmiHeader As BITMAPINFOHEADER
    bmiColors(0 To 255) As RGBQUAD
End Type

Private Declare Function CreateCompatibleDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function CreateDIBitmap Lib "gdi32" (ByVal hdc As Long, lpInfoHeader As BITMAPINFOHEADER, ByVal dwUsage As Long, lpInitBits As Any, lpInitInfo As BITMAPINFO_256, ByVal wUsage As Long) As Long
Private Declare Function DeleteDC Lib "gdi32" (ByVal hdc As Long) As Long
Private Declare Function GetDC Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function SelectObject Lib "gdi32" (ByVal hdc As Long, ByVal hObject As Long) As Long
Private Declare Function StretchBlt Lib "gdi32" (ByVal hdc As Long, ByVal X As Long, ByVal Y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hSrcDC As Long, ByVal xSrc As Long, ByVal ySrc As Long, ByVal nSrcWidth As Long, ByVal nSrcHeight As Long, ByVal dwRop As Long) As Long

Dim Pixels() As Byte          ' Pixel data.
Dim bm_info As BITMAPINFO_256 ' DIB bitmap info.
Dim hDIB As Long              ' Bitmap handle.
Dim wid As Integer            ' Size of the bitmap.
Dim hgt As Integer

' Create the DIB.
Private Sub CreateDIB()
Dim screen_hdc As Long

    With bm_info.bmiHeader
        .biSize = Len(bm_info.bmiHeader)
        .biWidth = wid          ' Width in pixels.
        .biHeight = hgt         ' Height in pixels.
        .biPlanes = 1           ' 1 color plane.
        .biBitCount = 8         ' 8 bits per pixel.
        .biCompression = BI_RGB ' No compression.
        .biSizeImage = 0        ' Unneeded with no compression.
        .biXPelsPerMeter = 0    ' Unneeded.
        .biYPelsPerMeter = 0    ' Unneeded.
        .biClrUsed = 256        ' # colors in color table that are used by the image. 0 means all.
        .biClrImportant = 256   ' # important colors. 0 means all.
    End With
    
    ' Get the screen's device context.
    screen_hdc = GetDC(0)
    
    ' Create the DIB.
    hDIB = CreateDIBitmap(screen_hdc, _
        bm_info.bmiHeader, CBM_INIT, Pixels(0, 0), _
        bm_info, DIB_RGB_COLORS)
End Sub

' Draw the DIB onto the form.
Private Sub DrawDIB()
Dim compat_dc As Long

    ' Create a compatible device context.
    compat_dc = CreateCompatibleDC(hdc)
    
    ' Select the DIB into the compatible DC.
    SelectObject compat_dc, hDIB
        
    ' Copy the compatible DC's image onto the form.
    StretchBlt Picture1.hdc, 0, 0, _
        Picture1.ScaleWidth, Picture1.ScaleHeight, _
        compat_dc, 0, 0, wid, hgt, _
        SRCCOPY

    ' Destroy the compatible DC.
    DeleteDC compat_dc
End Sub

' Initialize 256 shades of gray.
Private Sub SetColorTable()
Dim i As Integer

    For i = 0 To 255
        bm_info.bmiColors(i).rgbRed = 0
        bm_info.bmiColors(i).rgbGreen = 0
        bm_info.bmiColors(i).rgbBlue = i
        bm_info.bmiColors(i).rgbReserved = 0
    Next i
End Sub
' Create a drawing.
Private Sub SetPixels()
Dim X As Integer
Dim Y As Integer

    wid = 100
    hgt = 256
    ReDim Pixels(0 To wid - 1, 0 To hgt - 1)
    For Y = 0 To hgt - 1
        For X = 0 To wid - 1
            If Y Mod 20 = 19 Or X Mod 20 = 19 Then
                Pixels(X, Y) = Y
            Else
                Pixels(X, Y) = 255 - Y
            End If
        Next X
    Next Y
End Sub


Private Sub Form_Load()
    SetColorTable
    SetPixels
    CreateDIB
End Sub

Private Sub Form_Resize()
    Picture1.Move 0, 0, ScaleWidth, ScaleHeight
    Picture1.Refresh
End Sub


Private Sub Picture1_Paint()
    DrawDIB
End Sub


