Attribute VB_Name = "GetScreen"

Option Explicit
Option Base 0
 
Public Type GUID
   Data1 As Long
   Data2 As Integer
   Data3 As Integer
   Data4(7) As Byte
End Type

Public Type PicBmp
   Size As Long
   Type As Long
   hBmp As Long
   hPal As Long
   Reserved As Long
End Type

Public Declare Function GetDesktopWindow Lib _
   "user32" () As Long
 
Public Declare Function CreateCompatibleDC Lib _
   "gdi32" _
   (ByVal hdc As Long) As Long

Public Declare Function CreateCompatibleBitmap Lib _
   "gdi32" _
   (ByVal hdc As Long, ByVal nWidth As Long, _
    ByVal nHeight As Long) As Long

Public Declare Function SelectObject Lib "gdi32" _
   (ByVal hdc As Long, ByVal hObject As Long) As Long

Public Declare Function BitBlt Lib "gdi32" _
   (ByVal hDCDest As Long, ByVal XDest As Long, _
    ByVal YDest As Long, ByVal nWidth As Long, _
    ByVal nHeight As Long, ByVal hDCSrc As Long, _
    ByVal XSrc As Long, ByVal YSrc As Long, _
    ByVal dwRop As Long) As Long

Public Declare Function DeleteDC Lib "gdi32" _
   (ByVal hdc As Long) As Long

Public Declare Function GetWindowDC Lib "user32" _
   (ByVal hWnd As Long) As Long

Public Declare Function ReleaseDC Lib "user32" _
   (ByVal hWnd As Long, ByVal hdc As Long) As Long

Public Declare Function OleCreatePictureIndirect Lib _
   "olepro32.dll" _
   (PicDesc As PicBmp, RefIID As GUID, _
    ByVal fPictureOwnsHandle As Long, _
    IPic As IPicture) As Long


Public Function GetOLEScreenSnapshot() As Picture

    Dim hWndSrc As Long
    Dim hDCSrc As Long
    Dim hDCMemory As Long
    Dim hBmp As Long
    Dim hBmpPrev As Long
    Dim WidthSrc As Long
    Dim HeightSrc As Long
    
    Dim r As Long
    
    Dim Pic As PicBmp
    Dim IPic As IPicture
    Dim IID_IDispatch As GUID
   
  'CaptureWindow
   WidthSrc = Screen.Width \ Screen.TwipsPerPixelX
   HeightSrc = Screen.Height \ Screen.TwipsPerPixelY
   
  'Get a handle to the desktop window and get the proper device context
   hWndSrc = GetDesktopWindow()
   hDCSrc = GetWindowDC(hWndSrc)
   
  'Create a memory device context for the copy process
   hDCMemory = CreateCompatibleDC(hDCSrc)
   
  'Create a bitmap and place it in the memory DC
   hBmp = CreateCompatibleBitmap(hDCSrc, WidthSrc, HeightSrc)
   hBmpPrev = SelectObject(hDCMemory, hBmp)
    
  'Copy the on-screen image into the memory DC
   r = BitBlt(hDCMemory, 0, 0, WidthSrc, HeightSrc, _
              hDCSrc, 0, 0, vbSrcCopy)
   
  'Remove the new copy of the the on-screen image
   hBmp = SelectObject(hDCMemory, hBmpPrev)
   
  'Release the device context resources back to the system
   r = DeleteDC(hDCMemory)
   r = ReleaseDC(hWndSrc, hDCSrc)
   
  'Fill in OLE IDispatch Interface ID
   With IID_IDispatch
      .Data1 = &H20400
      .Data4(0) = &HC0
      .Data4(7) = &H46
    End With
   
 'Fill Pic with necessary parts
  With Pic
      .Size = Len(Pic)         'Length of structure
      .Type = vbPicTypeBitmap  'Type of Picture (bitmap)
      .hBmp = hBmp             'Handle to bitmap
      .hPal = 0&               'Handle to palette (may be null)
    End With
   
  'Create OLE Picture object
   r = OleCreatePictureIndirect(Pic, IID_IDispatch, 1, IPic)
   
  'Return the new Picture object
   Set GetOLEScreenSnapshot = IPic

End Function

