VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "Floating Toolbar Demo"
   ClientHeight    =   2535
   ClientLeft      =   1125
   ClientTop       =   3345
   ClientWidth     =   3165
   ForeColor       =   &H80000008&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   2535
   ScaleWidth      =   3165
   Begin VB.PictureBox Picture1 
      BackColor       =   &H80000005&
      Height          =   1935
      Left            =   120
      ScaleHeight     =   1875
      ScaleWidth      =   2115
      TabIndex        =   0
      Top             =   120
      Width           =   2175
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuViewToolbar 
         Caption         =   "&Toolbar"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'FloatTbr - Floating toolbar demo for Visual Basic 5
'Copyright (c) 1994-97 SoftCircuits Programming (R)
'Redistributed by Permission.
'
'This program demonstrates how to create a floating toolbar in Visual
'Basic. The primary requirements for the toolbar was that it sits "on
'top" of the main window without necessarily sitting on top of windows in
'other applications. To customize the toolbar, change the imgButtons
'bitmap and the the IMAGE_COLS and IMAGE_ROWS constants at the top of
'FloatTbr.frm.
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
'
'Thanks also to Karl Peterson for his helpful suggestions.
Option Explicit

Private Sub Form_Load()
    'Size window to consume most of available screen
    Width = Screen.Width * 0.9
    Height = Screen.Height * 0.9
    'Center
    Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
    'Set initial toolbar position
    g_xToolbarPos = 1000: g_yToolbarPos = 2000
    'Display toolbar
    Call mnuViewToolbar_Click
End Sub

Private Sub Picture1_Click()
    'This code, as written, can only access the current
    'tool when the toolbar is visible. Depending on your
    'specific needs, you may want to modify the way the
    'current tool number is stored.
    If g_bToolbarVisible Then
        'Show what tool was selected
        MsgBox "Got tool #" & CStr(frmToolbar.Tool)
        'Reset default tool
        frmToolbar.Tool = 0
    End If
End Sub

Private Sub Form_Resize()
    Picture1.Move 0, 0, ScaleWidth, ScaleHeight
End Sub

Private Sub Form_Unload(Cancel As Integer)
    'Unload floating toolbar if it's loaded
    'IMPORTANT: Failure to do this may cause GPF
    If g_bToolbarVisible Then
        frmToolbar.UnloadToolbar
    End If
End Sub

Private Sub mnuFileExit_Click()
    'Unload this form to exit (Unload
    'event unloads toolbar form)
    Unload Me
End Sub

Private Sub mnuView_Click()
    'Indicate if floating toolbar is visible before opening menu
    If g_bToolbarVisible Then
        mnuViewToolbar.Checked = True
    Else
        mnuViewToolbar.Checked = False
    End If
End Sub

Private Sub mnuViewToolbar_Click()
    'Toggle floating toolbar visible state
    If Not g_bToolbarVisible Then
        frmToolbar.LoadToolbar Me
    Else
        frmToolbar.UnloadToolbar
    End If
End Sub

