VERSION 5.00
Begin VB.Form frmToolbar 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Tools"
   ClientHeight    =   2535
   ClientLeft      =   1155
   ClientTop       =   1770
   ClientWidth     =   6300
   ForeColor       =   &H00000000&
   KeyPreview      =   -1  'True
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   2535
   ScaleWidth      =   6300
   ShowInTaskbar   =   0   'False
   Begin VB.Image imgButtons 
      Height          =   750
      Left            =   120
      Picture         =   "FloatTbr.frx":0000
      Top             =   120
      Visible         =   0   'False
      Width           =   5625
   End
End
Attribute VB_Name = "frmToolbar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'FloatTbr - Floating toolbar demo for Visual Basic 5
'Copyright (c) 1994-97 SoftCircuits Programming (R)
'Redistributed by Permission.
'
'This program demonstrates how to create a floating toolbar in Visual
'Basic. The primary requirements for the toolbar was that it sits "on
'top" of the main window without necessarily sitting on top of windows in
'other applications. To customize the toolbar, change the imgButtons
'bitmap and the the IMAGE_COLS and IMAGE_ROWS constants at the top of
'FloatTbr.frm.
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
'
'Thanks also to Karl Peterson for his helpful suggestions.
Option Explicit

'Set values for imgButtons bitmap
Private Const IMAGE_COLS = 15
Private Const IMAGE_ROWS = 2
Private Const STATE_UNSELECTED = 0
Private Const STATE_SELECTED = 1

Private m_ImageWidth As Long
Private m_ImageHeight As Long
Private m_xSpacer As Long
Private m_ySpacer As Long

'Indicates which tool is currently selected
Private m_nCurrTool As Integer
'Tracks parent form
Private m_frmParent As Form

'Windows API declarations
Private Declare Function SetWindowWord Lib "user32" (ByVal hwnd As Long, ByVal nIndex As Long, ByVal wNewWord As Long) As Long
Private Const SWW_HPARENT = -8

'Public method to load toolbar
Public Sub LoadToolbar(frm As Form)
    'Save reference to parent form
    Set m_frmParent = frm
    'Display toolbar
    Show
    'Make toolbar a child window of the main window so that
    'it always remains on top of the main window, but not
    'other windows
    Call SetWindowWord(hwnd, SWW_HPARENT, m_frmParent.hwnd)
End Sub

'Public method to unload toolbar
Public Sub UnloadToolbar()
    'Note: Unload event performs clean up
    Unload Me
End Sub

'Public property to get selected tool
Public Property Get Tool() As Integer
    Tool = m_nCurrTool
End Property

'Public property to set selected tool
Public Property Let Tool(nTool As Integer)
    SetCurrentTool nTool
End Property

Private Sub Form_Load()
    Dim nWidth As Long, nHeight As Long

    'Cache image cell size for speed
    m_ImageWidth = imgButtons.Width \ IMAGE_COLS
    m_ImageHeight = imgButtons.Height \ IMAGE_ROWS
    'Create spacer around toolbar buttons
    m_xSpacer = (3 * Screen.TwipsPerPixelX)
    m_ySpacer = (3 * Screen.TwipsPerPixelY)
    'Size form to fit buttons
    nWidth = (m_ImageWidth * 2) + (m_xSpacer * 2)
    nHeight = (m_ImageWidth * ((IMAGE_COLS + 1) \ 2)) + (m_ySpacer * 2)
    Width = nWidth + (Width - ScaleWidth)
    Height = nHeight + (Height - ScaleHeight)
    'Position toolbar at remembered location
    Left = g_xToolbarPos: Top = g_yToolbarPos
    'Indicate toolbar is visible
    g_bToolbarVisible = True
    'Indicate which tool is selected
    Call SetCurrentTool(0)
End Sub

Private Sub Form_Unload(Cancel As Integer)
    'Save toolbar position
    g_xToolbarPos = Left: g_yToolbarPos = Top
    'Indicate toolbar is no longer visible
    g_bToolbarVisible = False
    'Ensure focus goes back to parent form
    m_frmParent.SetFocus
End Sub

Private Sub Form_MouseDown(button As Integer, Shift As Integer, X As Single, Y As Single)
    Dim nTool As Integer

    If button = vbLeftButton Then
        'Adjust for border around buttons
        X = X - m_xSpacer
        Y = Y - m_ySpacer
        'Prevent false hits
        If X >= 0 And X < (m_ImageWidth * 2) And _
            Y >= 0 And Y < (m_ImageHeight * ((IMAGE_COLS + 1) \ 2)) Then
            nTool = ((Y \ m_ImageHeight) * 2) + (X \ m_ImageWidth)
            'Set new toolnumber if valid
            If nTool < IMAGE_COLS Then
                SetCurrentTool nTool
            End If
        End If
    End If
End Sub

Private Sub SetCurrentTool(nNewTool As Integer)
    If nNewTool <> m_nCurrTool Then
        'Unselect old tool
        PaintTool m_nCurrTool, STATE_UNSELECTED
        'Set new tool number
        m_nCurrTool = nNewTool
        'Select new tool
        PaintTool m_nCurrTool, STATE_SELECTED
    End If
End Sub

Private Sub Form_Paint()
    Dim i As Integer, nState As Integer

    For i = 0 To (IMAGE_COLS - 1)
        If i = m_nCurrTool Then
            nState = STATE_SELECTED
        Else
            nState = STATE_UNSELECTED
        End If
        PaintTool i, nState
    Next i
End Sub

Private Sub PaintTool(nTool As Integer, nState As Integer)
    'Paint specified cell to form
    PaintPicture imgButtons, _
        m_xSpacer + ((nTool Mod 2) * m_ImageWidth), _
        m_ySpacer + ((nTool \ 2) * m_ImageHeight), _
        m_ImageWidth, m_ImageHeight, _
        nTool * m_ImageWidth, nState * m_ImageHeight, _
        m_ImageWidth, m_ImageHeight
End Sub
