VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3990
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4710
   LinkTopic       =   "Form1"
   ScaleHeight     =   3990
   ScaleWidth      =   4710
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdDraw 
      Caption         =   "Draw"
      Height          =   495
      Left            =   1680
      TabIndex        =   1
      Top             =   0
      Width           =   1215
   End
   Begin VB.PictureBox picCanvas 
      AutoRedraw      =   -1  'True
      Height          =   3375
      Left            =   0
      ScaleHeight     =   3315
      ScaleWidth      =   4635
      TabIndex        =   0
      Top             =   600
      Width           =   4695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Drawing As Boolean
Private DrawingStarted As Boolean

Private NumPoints As Integer
Private PointsX() As Single
Private PointsY() As Single

Private CurX As Single
Private CurY As Single

Private Sub cmdDraw_Click()
    Drawing = True
    picCanvas.MousePointer = vbCrosshair
    picCanvas.Cls
    NumPoints = 0
End Sub
Private Sub picCanvas_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    ' If we are not in drawing mode, ignore this.
    If Not Drawing Then Exit Sub

    ' Erase the last invert mode line if there is one.
    If NumPoints > 0 Then
        picCanvas.Line (PointsX(NumPoints), PointsY(NumPoints))-(CurX, CurY)
    End If

    ' See which mouse button this is.
    If Button <> vbLeftButton Then
        ' This is not the left button. End drawing.
        Drawing = False
        DrawingStarted = False
        picCanvas.MousePointer = vbDefault
        picCanvas.DrawMode = vbCopyPen

        ' If we have at least 3 points, connect the
        ' first and last.
        If NumPoints > 2 Then
            picCanvas.Line (PointsX(1), PointsY(1))-(PointsX(NumPoints), PointsY(NumPoints))
        End If

        ' This is where you might take extra action.
        Beep
    Else
        ' This is the left button.
        ' See if we have started drawing yet.
        If DrawingStarted Then
            ' We have already started.
            ' Draw the new permanent line.
            picCanvas.DrawMode = vbCopyPen
            picCanvas.Line (PointsX(NumPoints), PointsY(NumPoints))-(X, Y)
            picCanvas.DrawMode = vbInvert
        Else
            ' We have not started yet. Start now.
            DrawingStarted = True

            ' Prepare to draw in invert mode.
            picCanvas.DrawMode = vbInvert

            ' Update the current point.
            CurX = X
            CurY = Y

            ' Draw the new invert mode line.
            picCanvas.Line (CurX, CurY)-(CurX, CurY)
        End If

        ' Save this point.
        NumPoints = NumPoints + 1
        ReDim Preserve PointsX(1 To NumPoints)
        ReDim Preserve PointsY(1 To NumPoints)
        PointsX(NumPoints) = X
        PointsY(NumPoints) = Y
    End If
End Sub
Private Sub picCanvas_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    ' If we have not started drawing, ignore this.
    If Not DrawingStarted Then Exit Sub

    ' Erase the last invert mode line.
    picCanvas.Line (PointsX(NumPoints), PointsY(NumPoints))-(CurX, CurY)

    ' Update the current point.
    CurX = X
    CurY = Y

    ' Draw the new invert mode line.
    picCanvas.Line (PointsX(NumPoints), PointsY(NumPoints))-(CurX, CurY)
End Sub
