VERSION 5.00
Begin VB.Form frmDragDropFiles 
   AutoRedraw      =   -1  'True
   Caption         =   "DragDrop Files Demo"
   ClientHeight    =   3480
   ClientLeft      =   1575
   ClientTop       =   1530
   ClientWidth     =   3120
   LinkTopic       =   "Form1"
   ScaleHeight     =   232
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   208
   Begin VB.CheckBox Check1 
      Caption         =   "Use OLE DragDrop"
      Height          =   195
      Left            =   210
      TabIndex        =   2
      Top             =   3090
      Width           =   2175
   End
   Begin VB.PictureBox Picture1 
      AutoRedraw      =   -1  'True
      Height          =   2130
      Left            =   180
      ScaleHeight     =   2070
      ScaleWidth      =   2715
      TabIndex        =   0
      Top             =   750
      Width           =   2775
   End
   Begin VB.Label Label1 
      Caption         =   "Open Windows Explorer and drag any valid picture file onto the picturebox."
      Height          =   495
      Left            =   240
      TabIndex        =   1
      Top             =   135
      Width           =   2715
   End
End
Attribute VB_Name = "frmDragDropFiles"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
 Option Explicit
  ' A demo project of DragDrop file routines.  This demo shows the difference
  ' between using a subclassed dragdrop routine and an OLE dragdrop routine.
  ' written by Bryan Stafford of New Vision Software
  ' this demo is released into the public domain "as is" without
  ' warranty or guaranty of any kind.  In other words, use at
  ' your own risk.
  
  Private Const GWL_WNDPROC As Long = (-4&)
    
  ' API call to alter the class data for this window
  Private Declare Function SetWindowLong& Lib "user32" Alias "SetWindowLongA" (ByVal hWnd&, _
                                                              ByVal nIndex&, ByVal dwNewLong&)

Private Sub Form_Load()
  
  ' register picture1 as a window that accepts dragdrop files
  DragAcceptFiles Picture1.hWnd, 1&

  ' take control of message processing by installing our message handling
  ' routine into the chain of message routines for picture1
  procOld = SetWindowLong(Picture1.hWnd, GWL_WNDPROC, AddressOf WindowProc)
                            
End Sub

Private Sub Form_Unload(Cancel As Integer)

  ' give message processing control back to VB
  ' if you don't do this you WILL crash!!!
  Call SetWindowLong(Picture1.hWnd, GWL_WNDPROC, procOld)
  
End Sub

Public Sub DropFiles(ByVal hDrop&)

  Dim sFileName$, nCharsCopied&
  
  ' make some space for the file name
  sFileName = String$(MAX_PATH, vbNullChar)
  ' pass the file handle (hDrop), the index of the file if more than 1 was passed (we
  ' still use index zero since we only care about the first file in the list), the variable
  ' that will accept the file name and the amount of space that that variable is dimentioned for.
  nCharsCopied = DragQueryFile(hDrop, 0&, sFileName, MAX_PATH)

  ' clean up after ourselves bu closing the file handle
  DragFinish hDrop
  
  ' if there were chars copied, get the file name and try to load it into the picturbox
  If nCharsCopied Then
    sFileName = Left$(sFileName, nCharsCopied)
  
    ' incase it's not a valid picture display the error message
    On Error GoTo invalidPicture
    
    Picture1.Picture = LoadPicture(sFileName)
  End If
  
  Exit Sub
  
invalidPicture:

  ' display the invalid file format message
  DisplayPicture1Message
  
End Sub

Private Sub Picture1_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)

  ' check the format of the data that is being dropped
  If Data.GetFormat(vbCFFiles) = True Then
  
    Dim sFileName$
    
    ' grab the first file name in the collection of file names
    sFileName = Data.Files(1)
  
    ' incase it's not a valid picture display the error message
    On Error GoTo invalidPicture
    
    ' try to load a picture
    Picture1.Picture = LoadPicture(sFileName)
  End If
  
  Exit Sub
  
invalidPicture:

  ' display the invalid file format message
  DisplayPicture1Message
  
End Sub
                                                              
Private Sub Check1_Click()
  ' toggle between OLE dragdrop or Subclassed dragdrop mode.
  Picture1.OLEDropMode = Check1
End Sub

Private Sub DisplayPicture1Message()

  ' clear any picture out of the control
  Picture1.Picture = LoadPicture()
  
  Const Msg As String = "Invalid Picture Format!"
  
  ' print the error message on the picturebox
  Picture1.CurrentX = (Picture1.ScaleWidth \ 2) - (Picture1.TextWidth(Msg) \ 2)
  Picture1.CurrentY = (Picture1.ScaleHeight \ 2) - (Picture1.TextHeight(Msg) \ 2)
  Picture1.Print Msg

End Sub

Private Sub Picture1_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)
  
  ' check the data to see if it is what we will allow.  if not so "no drop"
  If Data.GetFormat(vbCFFiles) Then
    Effect = vbDropEffectCopy And Effect
  Else
    Effect = vbDropEffectNone
  End If

End Sub
