VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   6135
   ClientLeft      =   2835
   ClientTop       =   1230
   ClientWidth     =   3330
   Height          =   6540
   Left            =   2775
   LinkTopic       =   "Form1"
   ScaleHeight     =   409
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   222
   Top             =   885
   Width           =   3450
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Click and drag the mouse. The program beeps if you drag across the line shown."
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   3135
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim X1 As Single
Dim Y1 As Single
Dim X2 As Single
Dim Y2 As Single

Dim A1 As Single
Dim B1 As Single
Dim A2 As Single
Dim B2 As Single

Private Function DistToSegment(ByVal px As Single, ByVal py As Single, ByVal X1 As Single, ByVal Y1 As Single, ByVal X2 As Single, ByVal Y2 As Single) As Single
Dim dx As Single
Dim dy As Single
Dim t As Single

    dx = X2 - X1
    dy = Y2 - Y1
    If dx = 0 And dy = 0 Then
        ' It's a point not a line segment.
        dx = px - X1
        dy = py - Y1
        DistToSegment = Sqr(dx * dx + dy * dy)
        Exit Function
    End If

    t = (dx * (px - X1) + dy * (py - Y1)) / (dx * dx + dy * dy)
    If t < 0 Then
        dx = px - X1
        dy = py - Y1
    ElseIf t > 1 Then
        dx = px - X2
        dy = py - Y2
    Else
        X2 = X1 + t * dx
        Y2 = Y1 + t * dy
        dx = px - X2
        dy = py - Y2
    End If
    DistToSegment = Sqr(dx * dx + dy * dy)
End Function

Private Function SegmentsIntersect(ByVal X1 As Single, ByVal Y1 As Single, ByVal X2 As Single, ByVal Y2 As Single, ByVal A1 As Single, ByVal B1 As Single, ByVal A2 As Single, ByVal B2 As Single) As Boolean
Dim dx As Single
Dim dy As Single
Dim da As Single
Dim db As Single
Dim t As Single
Dim s As Single

    dx = X2 - X1
    dy = Y2 - Y1
    da = A2 - A1
    db = B2 - B1
    If (da * dy - db * dx) = 0 Then
        ' The segments are parallel.
        SegmentsIntersect = False
        Exit Function
    End If
    
    s = (dx * (B1 - Y1) + dy * (X1 - A1)) / (da * dy - db * dx)
    t = (da * (Y1 - B1) + db * (A1 - X1)) / (db * dx - da * dy)
    SegmentsIntersect = (s >= 0# And s <= 1# And _
                         t >= 0# And t <= 1#)
    
    ' If it exists, the point of intersection is:
    ' (x1 + t * dx, y1 + t * dy)
End Function

Private Sub Form_Load()
    X1 = 10
    Y1 = 50
    X2 = 200
    Y2 = 300
End Sub


Private Sub Form_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)
    Refresh
    A1 = X
    B1 = Y
End Sub


Private Sub Form_MouseUp(Button As Integer, Shift As Integer, X As Single, Y As Single)
    A2 = X
    B2 = Y
    Line (A1, B1)-(A2, B2)
    If SegmentsIntersect(X1, Y1, X2, Y2, A1, B1, A2, B2) Then Beep
End Sub

Private Sub Form_Paint()
    Line (X1, Y1)-(X2, Y2)
End Sub


