Attribute VB_Name = "CSTM_BTN"
'---------------------------------------------------------------------------
' Custom Buttons Demo, Copyright (c) 1994 SoftCircuits Programming
' Redistributed by permission.
'
' This program may be distributed freely on the condition that it is
' distributed in full, and unmodified, and that no fee is charged for such
' distribution with the exception of reasonable media and shipping charges.
' Any or all portions of the source code may be incorporated into your own
' programs, and those programs may be distributed without payment of
' royalties on the condition that such programs differ substantially from
' this demonstration program.
'
' This program demonstrates how to create a number of non-rectangular
' buttons. The basic steps include creating bitmaps of the buttons for
' each postion, or state, that the button supports. The program then
' creates a Windows region used to perform a hit test on the button to
' determine if the mouse falls within it. Windows supports rectangular,
' elliptical and rounded rectangular (not used here) regions. Windows also
' support customized regions that you specify by giving a list of points
' that define the region.
'
' This program was distributed by:
'
'   SoftCircuits Programming
'   P.O. Box 16262
'   Irvine, CA 92713
'   CompuServe: 72134,263
'
' SoftCircuits welcomes your comments or questions.
'---------------------------------------------------------------------------
Option Explicit

'Maximum number of regions per button
Global Const MAX_RGNS = 3

'Maximum number of Pts per region
Global Const MAX_RGNPTS = 20

'Button region types
Global Const RGN_TYPERECT = 1
Global Const RGN_TYPECIRC = 2
Global Const RGN_TYPEPOLY = 3

'CreatePolygonRgn arguments
Global Const ALTERNATE = 1
Global Const WINDING = 2


'Windows rectangle structure
#If Win16 Then
    Type RECT
        Left As Integer
        Top As Integer
        Right As Integer
        Bottom As Integer
    End Type
    'Windows point structure
    Type POINTAPI
        x As Integer
        y As Integer
    End Type

#Else
    Type RECT
            Left As Long
            Top As Long
            Right As Long
            Bottom As Long
    End Type
        'Windows point structure
    Type POINTAPI
        x As Long
        y As Long
    End Type

#End If

'Our structure for each region within a button
#If Win16 Then
    Type RGNINFO
        bitmapIdx As Integer    'Index of bitmap w/region selected
        relBmpIdx As Integer    'Index of bitmap after relase
        rgnType As Integer      'Region type
        numPts As Integer       'Number of points in region
        rgnPts(MAX_RGNPTS) As POINTAPI
    End Type
    
    'Our structure for each button
    Type BTNINFO
        name As String          'Name of button style
        bitmapIdx As Integer    'Index of bitmap-up image
        numRgns As Integer      'Number of regions within button
        rgns(MAX_RGNS) As RGNINFO
    End Type
#Else
    Type RGNINFO
        bitmapIdx As Long    'Index of bitmap w/region selected
        relBmpIdx As Long    'Index of bitmap after relase
        rgnType As Long      'Region type
        numPts As Long       'Number of points in region
        rgnPts(MAX_RGNPTS) As POINTAPI
    End Type
    
    'Our structure for each button
    Type BTNINFO
        name As String          'Name of button style
        bitmapIdx As Long    'Index of bitmap-up image
        numRgns As Long      'Number of regions within button
        rgns(MAX_RGNS) As RGNINFO
    End Type
#End If

'Array of buttons
Global buttons(6) As BTNINFO

#If Win16 Then
    'Indicated the current button
    Global curBtn As Integer
#Else
    Global curBtn As Long
#End If

'Declare Windows API function

#If Win16 Then
    Declare Function CreatePolygonRgn Lib "GDI" (lpPoints As POINTAPI, ByVal nCount As Integer, ByVal nPolyFillMode As Integer) As Integer
    Declare Function CreateRectRgnIndirect Lib "GDI" (lpRect As RECT) As Integer
    Declare Function CreateEllipticRgnIndirect Lib "GDI" (lpRect As RECT) As Integer
    Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
    Declare Function PtInRegion Lib "GDI" (ByVal hRgn As Integer, ByVal x As Integer, ByVal y As Integer) As Integer
#Else
    Declare Function CreatePolygonRgn Lib "gdi32" (lpPoint As POINTAPI, ByVal nCount As Long, ByVal nPolyFillMode As Long) As Long
    Declare Function CreateRectRgnIndirect Lib "gdi32" (lpRect As RECT) As Long
    Declare Function CreateEllipticRgnIndirect Lib "gdi32" (lpRect As RECT) As Long
    Declare Function DeleteObject Lib "gdi32" (ByVal hObject As Long) As Long
    Declare Function PtInRegion Lib "gdi32" (ByVal hRgn As Long, ByVal x As Long, ByVal y As Long) As Long
#End If
