VERSION 4.00
Begin VB.Form frmControls 
   Caption         =   "Resizing Controls"
   ClientHeight    =   5655
   ClientLeft      =   1110
   ClientTop       =   1650
   ClientWidth     =   6690
   Height          =   6060
   Left            =   1050
   LinkTopic       =   "Form1"
   ScaleHeight     =   5655
   ScaleWidth      =   6690
   Top             =   1305
   Width           =   6810
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   5280
      TabIndex        =   16
      Top             =   5160
      Width           =   1215
   End
   Begin VB.CommandButton cmdShow 
      Caption         =   "Skeletons"
      Height          =   375
      Index           =   2
      Left            =   2880
      TabIndex        =   15
      Top             =   5160
      Width           =   1215
   End
   Begin VB.CommandButton cmdShow 
      Caption         =   "Family"
      Height          =   375
      Index           =   1
      Left            =   1560
      TabIndex        =   14
      Top             =   5160
      Width           =   1215
   End
   Begin VB.CommandButton cmdShow 
      Caption         =   "Education"
      Height          =   375
      Index           =   0
      Left            =   240
      TabIndex        =   13
      Top             =   5160
      Width           =   1215
   End
   Begin VB.TextBox txtNotes 
      Height          =   2775
      Left            =   240
      MultiLine       =   -1  'True
      TabIndex        =   12
      Top             =   2160
      Width           =   6255
   End
   Begin VB.TextBox txtZip 
      Height          =   285
      Left            =   5640
      TabIndex        =   10
      Top             =   1320
      Width           =   855
   End
   Begin VB.TextBox txtState 
      Height          =   285
      Left            =   3600
      TabIndex        =   9
      Top             =   1320
      Width           =   1455
   End
   Begin VB.TextBox txtCity 
      Height          =   285
      Left            =   1080
      TabIndex        =   8
      Top             =   1320
      Width           =   1695
   End
   Begin VB.TextBox txtAddress2 
      Height          =   285
      Left            =   1080
      TabIndex        =   7
      Top             =   960
      Width           =   5415
   End
   Begin VB.TextBox txtAddress1 
      Height          =   285
      Left            =   1080
      TabIndex        =   6
      Top             =   600
      Width           =   5415
   End
   Begin VB.TextBox txtName 
      Height          =   285
      Left            =   1080
      TabIndex        =   5
      Top             =   240
      Width           =   5415
   End
   Begin VB.Line Line2 
      X1              =   0
      X2              =   6720
      Y1              =   5040
      Y2              =   5040
   End
   Begin VB.Label lblNotes 
      Caption         =   "Notes:"
      Height          =   255
      Left            =   225
      TabIndex        =   11
      Top             =   1875
      Width           =   735
   End
   Begin VB.Line Line1 
      X1              =   0
      X2              =   6720
      Y1              =   1800
      Y2              =   1800
   End
   Begin VB.Label lblZip 
      Alignment       =   1  'Right Justify
      Caption         =   "Zip:"
      Height          =   255
      Left            =   5160
      TabIndex        =   4
      Top             =   1320
      Width           =   375
   End
   Begin VB.Label lblState 
      Alignment       =   1  'Right Justify
      Caption         =   "State:"
      Height          =   255
      Left            =   2880
      TabIndex        =   3
      Top             =   1320
      Width           =   615
   End
   Begin VB.Label lblCity 
      Alignment       =   1  'Right Justify
      Caption         =   "City:"
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   1320
      Width           =   735
   End
   Begin VB.Label lblAddress 
      Alignment       =   1  'Right Justify
      Caption         =   "Address:"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   600
      Width           =   735
   End
   Begin VB.Label lblName 
      Alignment       =   1  'Right Justify
      Caption         =   "Name:"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   735
   End
End
Attribute VB_Name = "frmControls"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

Dim iOldX As Integer        'Last width
Dim iOldY As Integer        'Last height
Dim miLine2Y As Integer     'Location of bottom line
                            'relative to bottom of form.

Dim iStartHeight As Integer 'Starting width
Dim iStartWidth As Integer  'Starting height
Dim iStartFont As Single

Private Sub cmdClose_Click()
   Unload Me
End Sub

Private Sub Form_Load()

   'Record the current size
   iOldX = Me.Width
   iOldY = Me.Height
   
   'Save the position of Line2 relative to the
   'bottom of the form.
   miLine2Y = Me.ScaleHeight - Line2.Y1
   
   'Save the original height and font size
   'for font resizing.
   iStartHeight = Me.Height
   iStartWidth = Me.Width
   iStartFont = txtName.FontSize
   
   txtName.Text = "Don Kiely"
   txtAddress1.Text = "1190 West Airport"
   txtCity.Text = "Barrow"
   txtState.Text = "Alaska"
   txtZip.Text = "99709"
   txtNotes.Text = "Designing to the least common denominator " _
      & "means sizing your forms at design time so that they do not " _
      & "exceed the screen size in the smallest resolution it is " _
      & "likely to run in. These days 640x480 is a reasonable " _
      & "minimum resolution to use for the design unless you know of " _
      & "specific instances that call for a smaller resolution. Id " _
      & "be surprised to find anyone running Windows in less than " _
      & "640x480, but life still does surprise me at times. I know " _
      & "of no one running my applications in less than this resolution."
   
End Sub

Private Sub Form_Resize()
Static bInResize As Boolean
Dim iNewX As Integer
Dim iNewY As Integer
Dim iLine1 As Integer
Dim iLine2 As Integer
Dim fX As Single
Dim fY As Single
Dim iSpacing As Integer
Dim iTemp As Integer    'Intermediate calculation variable
Dim fTemp As Single     'Intermediate calculation variable
Dim i As Integer        'Loop variable

   'Check if this event is the result of resizing
   'the form within the Resize event. If it is, exit
   'the Sub.
   If bInResize Then
      Exit Sub
   End If
   
   bInResize = True
   
   'If we get below 80% of original height, don't resize.
   'Do individually in case only one changed.
   If Me.ScaleHeight / iStartHeight < 0.9 Then
      Me.Height = iStartHeight * 0.9
   End If
   If Me.ScaleWidth / iStartWidth < 0.9 Then
      Me.Width = iStartWidth * 0.9
   End If
   
   'Get the values of iNewX and iNewY so we don't have
   'to keep accessing the properties.
   iNewX = Me.ScaleWidth
   iNewY = Me.ScaleHeight
   
   'If the form hasn't changed size, don't
   'need to do anything (such as when first
   'loaded).
   If iNewX = iOldX And iNewY = iOldY Then
      bInResize = False
      Exit Sub
   End If
   
   fX = iNewX / iOldX
   fY = iNewY / iOldY
   
   'Start by resizing the sections
   Line1.X2 = Me.Width
   Line1.Y1 = Line1.Y1 * fY
   Line1.Y2 = Line1.Y1
   
   Line2.X2 = Me.Width
   Line2.Y1 = Me.ScaleHeight - miLine2Y
   Line2.Y2 = Line2.Y1
   
   '***** Section 1: Name and Address *****
   'Resize horizontally and move as needed
   iSpacing = fX * (txtName.Left - lblName.Width - lblName.Left)
   lblName.Width = lblName.Width * fX
   txtName.Width = txtName.Width * fX
   txtName.Left = lblName.Left + lblName.Width + iSpacing
   
   'Use txtName as a "template."
   lblAddress.Width = lblName.Width
   txtAddress1.Width = txtName.Width
   txtAddress1.Left = txtName.Left
   
   txtAddress2.Width = txtName.Width
   txtAddress2.Left = txtName.Left
   
   lblCity.Width = lblName.Width
   txtCity.Width = txtCity.Width * fX
   txtCity.Left = lblCity.Left + lblCity.Width + iSpacing
   iTemp = txtCity.Left + txtCity.Width + iSpacing
   
   lblState.Width = lblState.Width * fX
   lblState.Left = iTemp
   iTemp = iTemp + lblState.Width + iSpacing
   
   txtState.Width = txtState.Width * fX
   txtState.Left = iTemp
   iTemp = iTemp + txtState.Width + iSpacing
   
   lblZip.Width = lblZip.Width * fX
   lblZip.Left = iTemp
   iTemp = iTemp + lblZip.Width + iSpacing
   
   txtZip.Width = txtZip.Width * fX
   txtZip.Left = iTemp
   
   'Resize vertically
   iTemp = txtName.Height * fY
   txtName.Height = iTemp
   lblName.Height = iTemp
   lblAddress.Height = iTemp
   txtAddress1.Height = iTemp
   txtAddress2.Height = iTemp
   lblCity.Height = iTemp
   txtCity.Height = iTemp
   lblState.Height = iTemp
   txtState.Height = iTemp
   lblZip.Height = iTemp
   txtZip.Height = iTemp
   
   'Adjust vertical position
   iSpacing = (Line1.Y1 - (4 * txtName.Height)) / 5
   iTemp = iSpacing
   lblName.Top = iTemp
   txtName.Top = iTemp
   iTemp = iTemp + txtName.Height + iSpacing
   lblAddress.Top = iTemp
   txtAddress1.Top = iTemp
   iTemp = iTemp + txtAddress1.Height + iSpacing
   txtAddress2.Top = iTemp
   iTemp = iTemp + txtAddress2.Height + iSpacing
   lblCity.Top = iTemp
   txtCity.Top = iTemp
   lblState.Top = iTemp
   txtState.Top = iTemp
   lblZip.Top = iTemp
   txtZip.Top = iTemp
   
   '***** Section 2: Notes *****
   lblNotes.Width = lblName.Width
   iTemp = lblNotes.Height / 4
   lblNotes.Top = Line1.Y1 + iTemp
   txtNotes.Top = lblNotes.Top + lblNotes.Height + iTemp
   txtNotes.Height = Line2.Y1 - txtNotes.Top - (2 * iTemp)
   txtNotes.Width = iNewX - (2 * txtNotes.Left)
   
   '***** Section 3: Buttons *****
   'Move the Close button horizontally
   iTemp = txtNotes.Width + txtNotes.Left
   cmdClose.Left = iTemp - cmdClose.Width

   'Vertical
   iSpacing = (iNewY - Line2.Y1 - cmdShow(0).Height) \ 2
   cmdShow(0).Top = Line2.Y1 + iSpacing
   For i = 1 To 2
      cmdShow(i).Top = cmdShow(0).Top
   Next
   cmdClose.Top = cmdShow(0).Top
   
   'Save the "new" old settings
   iOldX = iNewX
   iOldY = iNewY
   
   bInResize = False
End Sub

Private Sub ResizeFonts()
Dim i As Integer

   For i = 0 To Controls.Count - 1
      If Not (TypeOf Controls(i) Is Line) Then
         Controls(i).FontSize = iStartFont * (Me.ScaleHeight / iStartHeight)
      End If
   Next i
End Sub
