Attribute VB_Name = "mWin32"
'' Win32 Constants
Private Const CS_BYTEALIGNCLIENT = &H1000
Private Const CS_BYTEALIGNWINDOW = &H2000
Private Const CS_CLASSDC = &H40
Private Const CS_DBLCLKS = &H8
Private Const CS_HREDRAW = &H2
Private Const CS_INSERTCHAR = &H2000
Private Const CS_KEYCVTWINDOW = &H4
Private Const CS_NOCLOSE = &H200
Private Const CS_NOKEYCVT = &H100
Private Const CS_NOMOVECARET = &H4000
Private Const CS_OWNDC = &H20
Private Const CS_PARENTDC = &H80
Private Const CS_PUBLICCLASS = &H4000
Private Const CS_SAVEBITS = &H800
Private Const CS_VREDRAW = &H1

Private Const WS_BORDER = &H800000
Private Const WS_CAPTION = &HC00000
Private Const WS_CHILD = &H40000000
Private Const WS_CLIPCHILDREN = &H2000000
Private Const WS_CLIPSIBLINGS = &H4000000
Private Const WS_DISABLED = &H8000000
Private Const WS_DLGFRAME = &H400000
Private Const WS_GROUP = &H20000
Private Const WS_HSCROLL = &H100000
Private Const WS_MAXIMIZE = &H1000000
Private Const WS_MAXIMIZEBOX = &H10000
Private Const WS_MINIMIZE = &H20000000
Private Const WS_MINIMIZEBOX = &H20000
Private Const WS_OVERLAPPED = &H0&
Private Const WS_POPUP = &H80000000
Private Const WS_SYSMENU = &H80000
Private Const WS_TABSTOP = &H10000
Private Const WS_THICKFRAME = &H40000
Private Const WS_VISIBLE = &H10000000
Private Const WS_VSCROLL = &H200000
Private Const WS_CHILDWINDOW = (WS_CHILD)
Private Const WS_ICONIC = WS_MINIMIZE
Private Const WS_SIZEBOX = WS_THICKFRAME
Private Const WS_POPUPWINDOW = (WS_POPUP Or WS_BORDER Or WS_SYSMENU)
Private Const WS_TILED = WS_OVERLAPPED
Private Const WS_OVERLAPPEDWINDOW = (WS_OVERLAPPED Or WS_CAPTION Or WS_SYSMENU Or WS_THICKFRAME Or WS_MINIMIZEBOX Or WS_MAXIMIZEBOX)
Private Const WS_TILEDWINDOW = WS_OVERLAPPEDWINDOW

Private Const WS_EX_ACCEPTFILES = &H10&
Private Const WS_EX_DLGMODALFRAME = &H1&
Private Const WS_EX_NOPARENTNOTIFY = &H4&
Private Const WS_EX_TOPMOST = &H8&
Private Const WS_EX_TRANSPARENT = &H20&

Private Const WM_ACTIVATE = &H6
Private Const WM_CLOSE = &H10
Private Const WM_CREATE = &H1
Private Const WM_DESTROY = &H2
Private Const WM_ENABLE = &HA
Private Const WM_LBUTTONDBLCLK = &H203
Private Const WM_LBUTTONDOWN = &H201
Private Const WM_LBUTTONUP = &H202
Private Const WM_MBUTTONDBLCLK = &H209
Private Const WM_MBUTTONDOWN = &H207
Private Const WM_MBUTTONUP = &H208
Private Const WM_MOUSEACTIVATE = &H21
Private Const WM_MOUSEFIRST = &H200
Private Const WM_MOUSELAST = &H209
Private Const WM_MOUSEMOVE = &H200
Private Const WM_MOVE = &H3
Private Const WM_NULL = &H0
Private Const WM_PAINT = &HF
Private Const WM_RBUTTONDBLCLK = &H206
Private Const WM_RBUTTONDOWN = &H204
Private Const WM_RBUTTONUP = &H205
Private Const WM_SHOWWINDOW = &H18
Private Const WM_SIZE = &H5
Private Const WM_QUIT = &H12

'' Win32 Structs
Private Type WNDCLASS
    style As Long
    lpfnWndProc As Long
    cbClsextra As Long
    cbWndExtra2 As Long
    hInstance As Long
    hIcon As Long
    hCursor As Long
    hbrBackground As Long
    lpszMenuName As String
    lpszClassName As String
End Type

Private Type POINTAPI
        x As Long
        y As Long
End Type

Private Type MSG
    hwnd As Long
    message As Long
    wParam As Long
    lParam As Long
    time As Long
    pt As POINTAPI
End Type

Private Type CREATESTRUCT
        lpCreateParams As Long
        hInstance As Long
        hMenu As Long
        hWndParent As Long
        cy As Long
        cx As Long
        y As Long
        x As Long
        style As Long
        lpszName As String
        lpszClass As String
        ExStyle As Long
End Type

'' Win32 APi Declarations
Private Declare Function CreateWindowEx Lib "user32" Alias "CreateWindowExA" (ByVal dwExStyle As Long, ByVal lpClassName As String, ByVal lpWindowName As String, ByVal dwStyle As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal hWndParent As Long, ByVal hMenu As Long, ByVal hInstance As Long, lpParam As Any) As Long
Private Declare Function DefWindowProc Lib "user32" Alias "DefWindowProcA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function RegisterClass Lib "user32" Alias "RegisterClassA" (Class As WNDCLASS) As Long
Private Declare Function CreateSolidBrush Lib "gdi32" (ByVal crColor As Long) As Long
Private Declare Function GetMessage Lib "user32" Alias "GetMessageA" (lpMsg As MSG, ByVal hwnd As Long, ByVal wMsgFilterMin As Long, ByVal wMsgFilterMax As Long) As Long
Private Declare Function TranslateMessage Lib "user32" (lpMsg As MSG) As Long
Private Declare Function DispatchMessage Lib "user32" Alias "DispatchMessageA" (lpMsg As MSG) As Long
Private Declare Function UnregisterClass Lib "user32" Alias "UnregisterClassA" (ByVal lpClassName As String, ByVal hInstance As Long) As Long
Private Declare Function DestroyWindow Lib "user32" (ByVal hwnd As Long) As Long
''
Sub Main()

  '' Execution Starts Here,
  Dim strClassName As String, strWindowName As String
    strClassName = InputBox("Enter lpClassName as String", "lpClassName as String")
    strWindowName = InputBox("Enter lpWindowName as String", "lpWindowName as String")
    
  If (strClassName <> "") And (strWindowName <> "") Then
    
    Dim lFlags As Long, lClass As Long, lCSB As Long, lhInst As Long
      lFlags = CS_DBLCLKS Or CS_OWNDC Or CS_VREDRAW Or CS_HREDRAW
      lCSB = VBCreateSolidBrush(0)
      lhInst = App.hInstance
        lClass = RegWndClass(lFlags, lCSB, lhInst, strClassName)
    
    Debug.Print "Window Class " & strClassName & " registered, ATOM = " & lClass & " "
    
    Dim lhWnd As Long, lExFlags As Long, x As Long, y As Long, xW As Long, yH As Long, CS As CREATESTRUCT
      lExFlags = WS_EX_TOPMOST
      lFlags = WS_OVERLAPPEDWINDOW Or WS_VISIBLE
      xW = (Screen.Width / Screen.TwipsPerPixelX) / 4
      yH = (Screen.Height / Screen.TwipsPerPixelY) / 4
      x = ((Screen.Width / Screen.TwipsPerPixelX) - xW) / 2
      y = ((Screen.Height / Screen.TwipsPerPixelY) - yH) / 2
        lhWnd = VBCreateWindow(lExFlags, strClassName, strWindowName, lFlags, x, y, xW, yH, 0, 0, lhInst, CS)
      
      ''MSG Loop
      Dim lMsg As MSG, bQuit As Boolean
        bQuit = False
        While (GetMessage(lMsg, lhWnd, 0, 0))
          TranslateMessage lMsg
          DispatchMessage lMsg
          DoEvents
          If lMsg.message = WM_NULL Then GoTo mlQuit
        Wend
mlQuit:
    MsgBox "Exiting MsgLoop"
    If lhWnd <> 0 Then
      Dim lKillWnd As Long
      lKillWnd = VBDestroyWindow(lhWnd)
      If lKillWnd Then
        Debug.Print "Window " & strWindowName & " destroyed."
      Else
        Debug.Print "Window " & strWindowName & " destroy, FAILED."
      End If
    End If
    MsgBox "Window Destroyed"
    If lClass <> 0 Then
      Dim lKillClass As Long
        lKillClass = VBUnRegisterClass(strClassName, lhInst)
        If lKillClass Then
          Debug.Print "Window Class " & strClassName & " un-registered."
        Else
          Debug.Print "Window Class " & strClassName & " un-register, FAILED."
        End If
    End If
    MsgBox "Class Unregistered"
  End If
  MsgBox "Exiting"
End Sub
''
Private Function VBCreateSolidBrush(WhichColor As Long) As Long

  Dim lReturn As Long
    
    lReturn = CreateSolidBrush(WhichColor)
  
  VBCreateSolidBrush = lReturn

End Function
''
Private Function RegWndClass(dwStyleFlags As Long, hBrush As Long, hInst As Long, lpClassName As String) As Long
  
  Dim lReturn As Long, WC As WNDCLASS
      
    With WC
      .style = dwStyleFlags
      .hbrBackground = hBrush
      .hInstance = hInst
      .lpfnWndProc = GetValueLNG(AddressOf WndProc)
      .lpszClassName = lpClassName
    End With
  
  lReturn = RegisterClass(WC)
  
  RegWndClass = lReturn

End Function
''
Private Function VBCreateWindow(dwExStyleFlags As Long, lpClassName As String, lpWindowName As String, dwStyleFlags As Long, xPos As Long, yPos As Long, xWidth As Long, yHeight As Long, hWndParent As Long, hMenu As Long, hInst As Long, lpParam As CREATESTRUCT) As Long

  Dim lReturn As Long
    
    lReturn = CreateWindowEx(dwExStyleFlags, lpClassName, lpWindowName, dwStyleFlags, xPos, yPos, xWidth, yHeight, hWndParent, hMenu, hInst, lpParam)
  
  VBCreateWindow = lReturn

End Function
''
Private Function VBUnRegisterClass(ByVal lpClassName As String, ByVal hInst As Long) As Long
  
  Dim lReturn As Long
  
    lReturn = UnregisterClass(lpClassName, hInst)
  
  VBUnRegisterClass = lReturn
  
End Function
''
Private Function VBDestroyWindow(ByVal hwnd As Long) As Long
  
  Dim lReturn As Long
    
    lReturn = DestroyWindow(hwnd)
  
  VBDestroyWindow = lReturn
  
End Function
''
Public Function WndProc(ByVal hwnd As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long

  WndProc = DefWindowProc(hwnd, uMsg, wParam, lParam)

End Function
''
Public Function GetValueLNG(ByVal x As Long) As Long

  GetValueLNG = x

End Function
''
