Attribute VB_Name = "modSplitFile"
Option Explicit
Type FileSection
    Bytes() As Byte
    FileLen As Long
End Type
Type SectionedFile
    Files() As FileSection
    NumberOfFiles As Long
End Type
Type FileInfo
    OrigProjSize As Long
    OrigFileName As String
    FileSectionPath As String
    FileCount As Integer
    FileStartNum As Long
End Type
Type CommReturn
    FileName As String
    Extention As String
    FilePath As String
    Successful As Boolean
End Type
Public Function Save_Load_File(ShowSave As Boolean, ComDlgCnt As CommonDialog, Filter As String, Flags As Long, DialogTitle As String, Optional FilterIndex As Long, Optional DefaultFileName As String = "", Optional InitDir As String) As CommReturn
    On Error Resume Next
    ComDlgCnt.CancelError = True
    ComDlgCnt.FileName = DefaultFileName
    ComDlgCnt.Filter = Filter
    ComDlgCnt.Flags = Flags
    ComDlgCnt.FilterIndex = FilterIndex
    ComDlgCnt.DialogTitle = DialogTitle
    ComDlgCnt.InitDir = InitDir
    If ShowSave Then
        ComDlgCnt.ShowSave
        If Err = cdlCancel Then Exit Function
    Else
        ComDlgCnt.ShowOpen
        If Err = cdlCancel Then Exit Function
    End If
    Save_Load_File.Successful = True
    Save_Load_File.FileName = ReturnFileName(ComDlgCnt.FileName)
    Save_Load_File.Extention = ReturnExtention(ComDlgCnt.FileName, False)
    Save_Load_File.FilePath = FilePath(ComDlgCnt.FileName)
End Function
Public Function ReturnExtention(FileName As String, ReturnFileName As Boolean, Optional SplitVar As String = ".") As String
    If Not ReturnFileName Then
        Dim m_lngLoop As Long, SelectedLetters As String
        For m_lngLoop = 1 To Len(FileName)
            SelectedLetters = Mid(Right(FileName, m_lngLoop), 1, Len(SplitVar))
            If SelectedLetters = SplitVar Then
                ReturnExtention = Right(FileName, m_lngLoop - 1)
                Exit Function
            End If
        Next
    Else
        For m_lngLoop = 1 To Len(FileName)
            SelectedLetters = Mid(Right(FileName, m_lngLoop), 1, Len(SplitVar))
            If SelectedLetters = SplitVar Then
                ReturnExtention = Left(FileName, Len(FileName) - m_lngLoop)
                Exit Function
            End If
        Next
    End If
End Function
Sub SplitDirName(DirName As String, Lines() As String)
'SplitDirName
'Created By Allen
    If DirName = "" Then Exit Sub
    Dim Text As String, CurNum As Long, TotalNum As Long, CurPos As Long
    Text = DirName
    CurNum = 1
    CurPos = 1
    TotalNum = GetCount(Text, "\")
    ReDim Lines(1 To TotalNum)
    Do Until CurNum = TotalNum + 1
        Lines(CurNum) = Mid(Text, 1, InStr(CurPos, Text, "\") - 1)
        Text = Mid(Text, Len(Lines(CurNum)) + 2)
        CurNum = CurNum + 1
    Loop
End Sub
Public Function GetCount(Text As String, Search As String)
    Dim CCnt As Long, m_lngLoop As Long
    For m_lngLoop = 1 To Len(Text)
        If Mid(Text, m_lngLoop, Len(Search)) = Search Then
            CCnt = CCnt + 1
        End If
    Next
    GetCount = CCnt
End Function

Public Function FilePath(FileName As String) As String
    Dim XText As String, DFileName As String, m_lngLoop As Long, DLines() As String
    XText = FileName
    If Not Right(XText, 1) = "\" Then XText = XText & "\"
    SplitDirName CStr(XText), DLines()
    For m_lngLoop = 1 To UBound(DLines) - 1
        DFileName = DFileName & DLines(m_lngLoop) & "\"
    Next
    FilePath = DFileName
End Function
Public Function SplitFile(SplitFileName As String, _
BeginningNumber As Long, ReturnErrorDes As String, Optional Split As Long = _
1439865, Optional OutTemplateName As String) As Boolean
    Dim SaveName As String
    SplitFile = True 'Assume Success
    On Error GoTo CleanUp
    Dim CurrentFile As SectionedFile, m_lngNumFil As Long, m_lngLoop As Long, FilesLen As Long
    FilesLen = FileLen(SplitFileName)
    If FilesLen <= Split + 1 Then
    SplitFile = False 'If the File _
    Name is Smaller than the Split Ratio then _
    The Function Doesnt Need Called So it Fails.
    ReturnErrorDes = "File Is Too Small"
    Exit Function
    End If
    Open SplitFileName For Binary As #1 'm_lngLoop Use #1 as _
    Default Because m_lngLoop Normally Only Open one _
    File At a Time. If needed it can be changed.
        If (FilesLen \ Split) >= _
        FilesLen / Split Or (FilesLen \ Split) _
        = FilesLen / Split Then
            m_lngNumFil = (FilesLen _
            \ Split)  ' If VB heightened(or if they _
            were equal) the length of the file _
            divided by the total Split ratio then _
            nothing needs To Do anything.
        ElseIf (FilesLen \ Split) <= _
        FilesLen / Split Then
            m_lngNumFil = (FilesLen \ _
            Split) + 1 ' If VB Lowered The _
            Length Of the File Divided by the Total _
            Split Ratio then it Will Need To Correct _
            it.
        End If
        ReDim CurrentFile.Files(1 To m_lngNumFil)
        For m_lngLoop = 1 To m_lngNumFil - 1
            ReDim CurrentFile.Files(m_lngLoop) _
                .Bytes(1 To Split) 'Re-Define(Re _
                Dimention) the Number Of Bytes Per _
                File
            CurrentFile.Files(m_lngLoop) _
                .FileLen = UBound(CurrentFile.Files _
                (m_lngLoop).Bytes) 'Just For Reference
        Next
        For m_lngLoop = 1 To m_lngNumFil
            Get #1, , CurrentFile.Files(m_lngLoop) _
            .Bytes
        Next
        ReDim CurrentFile.Files(m_lngNumFil) _
            .Bytes(1 To FilesLen - ((m_lngNumFil _
            - 1) * Split)) 'ReDefine the Number of _
            bytes for the last file since in many cases _
            it will not be at the Split ratio.
        CurrentFile.NumberOfFiles = m_lngNumFil
        Get #1, , CurrentFile.Files(m_lngNumFil) _
            .Bytes
        CurrentFile.Files(m_lngNumFil) _
            .FileLen = UBound(CurrentFile.Files _
            (m_lngNumFil).Bytes)
    Close #1 'Close File(1)
    For m_lngLoop = 1 To CurrentFile.NumberOfFiles _
    'Save What We Have Done Into Seperate Files
        SaveName = FilePath(OutTemplateName) & ReturnFileName(SplitFileName) & "." & Format(BeginningNumber - 1 + m_lngLoop, _
        "00#")
        Open SaveName For Binary As #1
            Put #1, 1, CurrentFile.Files(m_lngLoop)
        Close #1
    Next
    Dim FileInfoFile As FileInfo
    FileInfoFile.FileCount = m_lngNumFil
    FileInfoFile.OrigFileName = SplitFileName
    FileInfoFile.FileSectionPath = FilePath(SaveName)
    FileInfoFile.OrigProjSize = FileLen(SplitFileName)
    FileInfoFile.FileStartNum = BeginningNumber
    If OutTemplateName = "" Then
    SaveName = SplitFileName & ".tpl"
    Else
    SaveName = OutTemplateName
    End If
    On Error Resume Next
    Open SaveName For Binary As #1
        If Err <> 0 Then ReturnErrorDes = Err.Description _
            : SplitFile = False: Exit Function
        Put #1, , FileInfoFile
    Close #1
    Exit Function
CleanUp:
    ReturnErrorDes = Err.Description
    SplitFile = False
End Function

Public Function ReassembleFile(TemplateFileName As String, _
    Optional UseOldFilename As Boolean = True, Optional _
    OutPutName = "C:\Filname.Extention") As Boolean
    Dim FileInfo As FileInfo, OutName As String, File As _
    SectionedFile, m_lngLoop As Long, OpenName
    ReassembleFile = True 'Assume Success
    If Len(TemplateFileName) = 0 Then ReassembleFile = False: Exit Function
    Open TemplateFileName For Binary As #1
        Get #1, , FileInfo 'Get Information on the _
        Previously Saved File(s)
    Close #1
    If UseOldFilename Then
        OutName = FileInfo.OrigFileName
    Else
        OutName = OutPutName
    End If
    ReDim File.Files(1 To FileInfo.FileCount)
    For m_lngLoop = 1 To FileInfo.FileCount
        OpenName = FileInfo.FileSectionPath & ReturnExtention(FileInfo.OrigFileName, False, "\") & "." & _
        Format((FileInfo.FileStartNum - 1 + _
        m_lngLoop), "00#")
        Open OpenName For Binary As #1
            Get #1, 1, File.Files(m_lngLoop)
        Close #1
    Next
    Open OutName For Binary As #1
        For m_lngLoop = 1 To FileInfo.FileCount
            Put #1, , File.Files(m_lngLoop).Bytes
        Next
    Close #1
End Function

Public Function ReturnFileName(Text As String)
    Dim XText As String, DLines() As String
    XText = Text
    If Not Right(XText, 1) = "\" Then XText = XText & "\"
    SplitDirName CStr(XText), DLines()
    ReturnFileName = DLines(UBound(DLines))
End Function
