Attribute VB_Name = "modDrawing"
Option Explicit
Public Sub DrawBox(Object As Object, ByVal Left As _
    Single, ByVal Top As Single, ByVal Width As Single, _
    ByVal Height As Single, Down As Boolean, Optional _
    Filled As Boolean = True, Optional FillColor As _
    Long = vb3DFace)

    On Error Resume Next
    Dim m_clr1 As OLE_COLOR
    Dim m_clr2 As OLE_COLOR
    Dim m_clr3 As OLE_COLOR
    Dim m_clr4 As OLE_COLOR
    Dim CX As Single
    Dim CY As Single
    Dim PX As Long, PY As Long
    CX = Object.CurrentX
    CY = Object.CurrentY
    PX = Screen.TwipsPerPixelX
    PY = Screen.TwipsPerPixelY
    If Not Down Then
        m_clr1 = vb3DFace
        m_clr2 = vb3DDKShadow
        m_clr3 = vb3DHighlight
        m_clr4 = vb3DShadow
    Else
        m_clr1 = vb3DDKShadow
        m_clr2 = vb3DFace
        m_clr3 = vb3DShadow
        m_clr4 = vb3DHighlight
    End If
    If Filled Then
        Object.Line (Left, Top)-(Left + Width - PX, Top + Height - PY), FillColor, BF
    End If
    Object.Line (Left, Top)-(Left + Width - PX, Top), m_clr1
    Object.Line (Left, (Top + Height) - PY)-(Left + Width, (Top + Height) - PY), m_clr2
    Object.Line (Left, Top + Height - PY)-(Left, Top), m_clr1
    Object.Line (Left + Width - PX, Top)-(Left + Width - PX, (Top + Height) - PY), m_clr2
    Object.Line (Left + PX, Top + PY)-(Left + Width - (PX * 2), Top + PY), m_clr3
    Object.Line (Left + PX, (Top + Height) - (PY * 2))-(Left + Width - (PX), (Top + Height) - (PY * 2)), m_clr4
    Object.Line (Left + PX, Top + Height - (PY * 2))-(Left + PX, Top + PY), m_clr3
    Object.Line (Left + Width - (PX * 2), Top + PY)-(Left + Width - (PX * 2), (Top + Height) - (PY * 2)), m_clr4
    Object.CurrentX = CX
    Object.CurrentY = CY
End Sub
Public Sub DrawFocusRect(Object As Object, Left As _
    Single, Top As Single, Width As Single, Height _
    As Single, Color As Long)
    
    Dim m_lngLoop As Long
    For m_lngLoop = 1 To Width \ 30 + 1
        Object.PSet (Left + m_lngLoop * 30 - 30, Top), Color
        If Not m_lngLoop = 1 Then
            Object.PSet (Left + m_lngLoop * 30 - 30, Top + Height), Color
        End If
    Next
    For m_lngLoop = 1 To (Height \ 30) + 1
        Object.PSet (Left, Top + m_lngLoop * 30 - 30), Color
        If Not m_lngLoop = 1 Then
            Object.PSet (Left + Width, Top + m_lngLoop * 30 - 30), Color
        End If
    Next
End Sub
Public Sub Draw3DCircle(Object As Object, ByVal X As Single, ByVal Y As Single, ByVal Radius As Integer, Optional ByVal BackColor As Long = vbButtonFace, Optional ByVal Filled As Boolean = -1, Optional Down As Boolean)
Radius = Radius \ 15
Radius = Radius * 15
If Not Down Then
Draw2ColorCirc Object, vbButtonFace, vb3DShadow, X, Y, Radius, BackColor, Filled
Draw2ColorCirc Object, vb3DHighlight, vb3DDKShadow, X, Y, Radius - 15, BackColor, Filled
Else
Draw2ColorCirc Object, vb3DShadow, vbButtonFace, X, Y, Radius, BackColor, Filled
Draw2ColorCirc Object, vb3DDKShadow, vb3DHighlight, X, Y, Radius - 15, BackColor, Filled
End If
End Sub
Private Sub Draw2ColorCirc(Object As Object, ByVal Color1 As Long, ByVal Color2 As Long, ByVal X As Single, ByVal Y As Single, ByVal Radius As Integer, Optional ByVal BackColor As Long = vbButtonFace, Optional ByVal Filled As Boolean = -1)
Dim m_intDrawSty As Integer
If Filled Then
m_intDrawSty = Object.DrawStyle
Object.DrawStyle = vbSolid
Object.FillColor = BackColor
Object.Line ((X - Radius + (Radius / 2)) - 15, (Y - Radius + (Radius / 2)) - 15)-((X - Radius + Radius * 1.5) + 15, (Y - Radius + Radius * 1.5) + 15), BackColor, BF
Object.Circle (X, Y), Radius - 15, BackColor
Object.DrawStyle = m_intDrawSty
End If
Object.Circle (X, Y), Radius, Color1, 1, 4
Object.Circle (X, Y), Radius, Color2, 4, 6.25
Object.Circle (X, Y), Radius, Color2, 0, 1
End Sub
Public Sub DrawCross(Object As Object, X, Y, Color As Long)
Dim mDrawWidth%
mDrawWidth% = Object.DrawWidth
Object.DrawWidth = 2
Object.Line (X + 120, Y)-(X + 120, Y + 90), Color
Object.Line (X + 120, Y + 150)-(X + 120, Y + 240), Color
Object.Line (X, Y + 120)-(X + 90, Y + 120), Color
Object.Line (X + 150, Y + 120)-(X + 240, Y + 120), Color
Object.DrawWidth = mDrawWidth%
End Sub

