VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "ButtonMngr"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Public Event ButtonClick(Button As ComboPack.Button)
Public Event ButtonPress(Button As ComboPack.Button)
Public Event ButtonRelease(Button As ComboPack.Button)
Public Event ButtonGetFocus(Button As ComboPack.Button)
Public Event ButtonLostFocus(Button As ComboPack.Button)
Private m_ButtonColl As Collection
Public LastFocus As Integer
Private Sub Class_Initialize()
LastFocus = 1
    Set m_ButtonColl = New Collection
End Sub

Private Sub Class_Terminate()
    Set m_ButtonColl = Nothing
End Sub

Public Function AddButton(ButtonName As String, Caption As String, Left As Single, Top As Single, Width As Single, Height As Single, BackColor As OLE_COLOR, Container As Object, Optional Picture As StdPicture)
    Dim nclsBtn As ComboPack.Button
    Set nclsBtn = New ComboPack.Button
    nclsBtn.Enabled = True
    Set nclsBtn.Parent = Container
    Set nclsBtn.ButtonParentObj = Me
    nclsBtn.Name = ButtonName
    nclsBtn.Left = Left
    nclsBtn.Top = Top
    nclsBtn.Width = Width
    nclsBtn.Height = Height
    Set nclsBtn.Picture = Picture
    nclsBtn.BackColor = BackColor
    nclsBtn.Caption = Caption
    m_ButtonColl.Add nclsBtn
    Set AddButton = nclsBtn
    Set nclsBtn = Nothing
End Function

Public Sub MouseUp(Button As Integer, X As Single, Y As Single)
    Dim cBtn As ComboPack.Button, m_lngLoop As Long
    For m_lngLoop = 1 To m_ButtonColl.Count
        Set cBtn = m_ButtonColl(m_lngLoop)
        cBtn.MouseUp Button, X, Y
    Next
End Sub

Public Sub MouseDown(Button As Integer, X As Single, Y As Single)
    Dim cBtn As ComboPack.Button, m_lngLoop As Long
    For m_lngLoop = 1 To m_ButtonColl.Count
        Set cBtn = m_ButtonColl(m_lngLoop)
        cBtn.MouseDown Button, X, Y
    Next
End Sub

Public Sub MouseMove(Button As Integer, X As Single, Y As Single)
    Dim cBtn As ComboPack.Button, m_lngLoop As Long
    For m_lngLoop = 1 To m_ButtonColl.Count
        Set cBtn = m_ButtonColl(m_lngLoop)
        cBtn.MouseMove Button, X, Y
    Next
End Sub

Public Sub RaiseBtnEvent(Button As ComboPack.Button, EventType As Integer)
    Dim jbutton As ComboPack.Button, Index As Long
    Select Case EventType
        Case const_lngPress
            For Each jbutton In m_ButtonColl
                Index = Index + 1
                If jbutton.Name = Button.Name Then
                    LastFocus = Index
                End If
                If jbutton.HasFocus Then jbutton.HasFocus = False
            Next
            If Not Button.HasFocus Then Button.HasFocus = True
            RaiseEvent ButtonPress(Button)
        Case const_lngUnPress
            RaiseEvent ButtonRelease(Button)
        Case const_lngClick
            RaiseEvent ButtonClick(Button)
        Case const_lngGotFocus
            RaiseEvent ButtonGetFocus(Button)
        Case const_lngLostFocus
            RaiseEvent ButtonLostFocus(Button)
    End Select
End Sub

Public Property Get Buttons(Index As Long) As ComboPack.Button
On Error Resume Next
Set Buttons = m_ButtonColl(Index)
End Property

Public Property Get NewEnum() As IUnknown
Attribute NewEnum.VB_UserMemId = -4
Attribute NewEnum.VB_MemberFlags = "40"
    Set NewEnum = m_ButtonColl.[_NewEnum]
End Property


Public Sub KeyDown(KeyCode As Integer)
    If LastFocus = 0 Then _
        Exit Sub
    If KeyCode = vbKeyTab Then
    If Not Buttons(CLng(LastFocus)).HasFocus Then _
        Buttons(CLng(LastFocus)).HasFocus = True _
        : Exit Sub
    Buttons(CLng(LastFocus)).HasFocus = False
    If LastFocus = m_ButtonColl.Count Then _
        LastFocus = 0
    If Buttons(CLng(LastFocus + 1)).Enabled Then
        On Error Resume Next
        On Error GoTo 0
        LastFocus = LastFocus + 1
        Buttons(CLng(LastFocus)).HasFocus = True
    Else
        LastFocus = LastFocus + 1
        KeyDown (KeyCode)
    End If
    End If
End Sub

Public Property Get Count() As Long
Count = m_ButtonColl.Count
End Property
