VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "Button"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Private rFont As StdFont
Private rEnabled As Boolean
Private IClicked As Boolean 'Informs the mouse events _
that the MouseDown procedure was called by this button
'Private Declarations
Private LastState As String 'Stores the Last Drawn _
State of the button. Makes Drawing faster because, _
If it has been down before why draw it down again?
Private rHasFocus As Boolean
Private rCaption As String 'Memory version of the Caption.

'Public Declarations
Public PressKey As en_ButtonKeys
Public ImageIndex As Long
Public BackColor As OLE_COLOR 'BackColor Property
Public ForeColor As OLE_COLOR
Public Left As Single 'Left Property
Public Height As Single 'Height Property
Public Parent As Object 'Parent of the 'Button'
Public Picture As StdPicture
Public Top As Single 'Top Property
Public Width As Single 'Width Property
Public Name As String 'Basic ID
Public ButtonParentObj As ComboPack.ButtonMngr 'If it belongs _
to a Button Manager Class then it will need a _
reference.

'Events
Public Event Click() 'Click Event
Public Event Press() 'Press Down Event
Public Event UnPress() 'Release Event
Public Event GetFocus() 'When the Button is given _
"focus"
Public Event LostFocus() 'The Opposite of GetFocus

'Constant Declarations
Const const_strDn As String = "Pressed"
Const const_strUp As String = "Un-Pressed"
Private Function InScope(X As Single, Y As Single)
'Checks the X and Y of the event that calls it, _
VERY Simple Function
InScope = ((X - Left) > 0 And (X - Left) < Width) And ((Y - Top) > 0 And (Y - Top) < Height)
End Function
Private Sub MouseProc(Button As Integer, X As Single, Y As Single)
If Not CBool(Button - 1) Then
If InScope(X, Y) And IClicked Then
If LastState = const_strDn Then Exit Sub
LastState = const_strDn
Redraw
On Error Resume Next
ButtonParentObj.RaiseBtnEvent Me, const_lngPress
On Error GoTo 0
RaiseEvent Press
Exit Sub
Else
If LastState = const_strUp Then Exit Sub
LastState = const_strUp
Redraw
RaiseEvent UnPress
Exit Sub
End If
End If
End Sub

Public Sub MouseUp(Button As Integer, X As Single, Y As Single)
If Not Enabled Then Exit Sub
If InScope(X, Y) And Button = 1 And IClicked Then
LastState = const_strUp
Redraw
DoEvents
On Error Resume Next
ButtonParentObj.RaiseBtnEvent Me, const_lngUnPress
ButtonParentObj.RaiseBtnEvent Me, const_lngClick
On Error GoTo 0
RaiseEvent UnPress
RaiseEvent Click
End If
IClicked = False
End Sub

Public Sub MouseDown(Button As Integer, X As Single, Y As Single)
If Not Enabled Then Exit Sub
If Button = 1 Then
If InScope(X, Y) Then
IClicked = True
End If
End If
MouseProc Button, X, Y
End Sub

Public Sub MouseMove(Button As Integer, X As Single, Y As Single)
If Not Enabled Then Exit Sub
MouseProc Button, X, Y
End Sub

Public Sub Redraw()
Dim bFont As StdFont
Dim m_lngFClr As OLE_COLOR
Dim m_intDWid As Integer
On Error Resume Next
m_intDWid = Parent.DrawWidth
Parent.DrawWidth = 1
Left = (Left \ 15) * 15
Top = (Top \ 15) * 15
Width = (Width \ 15) * 15
Height = (Height \ 15) * 15
Parent.Line (Left, Top)-(Left + Width - 15, Top + Height - 15), BackColor, BF
DrawImage
m_lngFClr = Parent.ForeColor
If Not Enabled Then
Parent.ForeColor = vbGrayText
Else
Parent.ForeColor = ForeColor
End If
Set bFont = Parent.Font
Set Parent.Font = Font
Parent.CurrentX = Left + (Width / 2 - Parent.TextWidth(Caption) / 2) + -(CInt(CBool(LastState = const_strDn)) * (Screen.TwipsPerPixelX * 2))
Parent.CurrentY = Top + (Height / 2 - Parent.TextHeight(Caption) / 2) + -(CInt(CBool(LastState = const_strDn)) * (Screen.TwipsPerPixelY * 2))
Parent.Print Caption
Set Parent.Font = bFont
Parent.ForeColor = m_lngFClr
If HasFocus Then
DrawBox Parent, Left + 15, Top + 15, Width - 30, Height - 30, CBool(LastState = const_strDn), False, BackColor
Parent.Line (Left, Top)-(Left + Width - 15, Top + Height - 15), vbBlack, B
If Len(Caption) <> 0 Then
DrawFocusRect Parent, Left + 75, Top + 75, Width - 150, Height - 150, 0
End If
Else
DrawBox Parent, Left, Top, Width, Height, CBool(LastState = const_strDn), False, BackColor
End If
Parent.DrawWidth = m_intDWid
DoEvents
End Sub

Public Property Get Caption() As String
Caption = rCaption
End Property

Public Property Let Caption(ByVal vCaption As String)
rCaption = vCaption
Redraw
End Property

Public Property Get HasFocus() As Boolean
HasFocus = rHasFocus
End Property

Public Property Let HasFocus(ByVal vHasFocus As Boolean)
If rHasFocus = vHasFocus Then Exit Property
rHasFocus = vHasFocus
If rHasFocus Then
On Error Resume Next
ButtonParentObj.RaiseBtnEvent Me, const_lngGotFocus
On Error GoTo 0
RaiseEvent GetFocus
ElseIf Not rHasFocus Then
On Error Resume Next
ButtonParentObj.RaiseBtnEvent Me, const_lngLostFocus
On Error GoTo 0
RaiseEvent LostFocus
End If
Redraw
End Property

Private Sub Class_Initialize()
PressKey = Key_Space
LastState = const_strUp
End Sub

Public Sub FocusChange(FocusButton As ComboPack.Button)
Attribute FocusChange.VB_MemberFlags = "40"
If FocusButton.Name = Name Then Exit Sub
If Not HasFocus Then Exit Sub
HasFocus = False
Redraw
End Sub

Private Sub DrawImage()
Dim PictureWidth As Single
Dim PictureLeft As Single
Dim PictureLeft2 As Single
Dim PictureHeight As Single
Dim PictureTop As Single
Dim PictureTop2 As Single
    If Not Picture Is Nothing Then
        If Not Picture = 0 Then
            If Picture.Width / const_lngImageSize * 15 > Width Then
                PictureWidth = Width
                PictureLeft = Left
                PictureLeft2 = (Picture.Width / const_lngImageSize * 15) - Width
            Else
                PictureWidth = Picture.Width / const_lngImageSize * 15
                PictureLeft = Left + Width / 2 - PictureWidth / 2
                PictureLeft2 = 0
            End If
            If Picture.Height / const_lngImageSize * 15 > Height Then
                PictureHeight = Height
                PictureTop = Top
                PictureTop2 = (Picture.Height / const_lngImageSize * 15) - Height
            Else
                PictureHeight = Picture.Height / const_lngImageSize * 15
                PictureTop = Top + Height / 2 - PictureHeight / 2
                PictureTop2 = 0
            End If
            Parent.PaintPicture Picture, PictureLeft - (CBool(LastState = const_strDn) * 30), PictureTop - (CBool(LastState = const_strDn) * 30), PictureWidth, PictureHeight, PictureLeft2, PictureTop2
        End If
    End If
End Sub
Public Property Get Font() As StdFont
Set Font = rFont
End Property
Public Property Set Font(ByVal vFont As StdFont)
Set rFont = vFont
Redraw
End Property

Public Property Get Enabled() As Boolean
Enabled = rEnabled
End Property

Public Property Let Enabled(ByVal vEnabled As Boolean)
rEnabled = vEnabled
IClicked = False
LastState = ""
Redraw
End Property

Public Property Get State() As String
State = LastState
End Property

Public Property Get Pressed() As Boolean
Pressed = (State = const_strDn)
End Property

Public Sub KeyDown(KeyCode As Integer)
    If Not HasFocus Then Exit Sub
    Select Case KeyCode
        Case PressKey
            RaiseEvent Press
            If State = const_strDn Then Exit Sub
            LastState = const_strDn
            Redraw
        Case vbKeyReturn
            RaiseEvent Click
    End Select
End Sub

Public Sub KeyUp(KeyCode As Integer)
    If Not HasFocus Then Exit Sub
    Select Case KeyCode
        Case PressKey
            If Not State = const_strDn Then Exit Sub
            LastState = const_strUp
            Redraw
            RaiseEvent Click
    End Select
End Sub
