VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsCdPlayer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
'This class was made by Jonas Gauffin at http://surf.to/VbArea
'You may modify/use it in you projects as long as you give me some credit for it.
'Or just visit my website :)
'
'A new example with CDDB support will be availible in the future.
'

'API's that are used to send/retireve commands/info
Private Declare Function mciGetErrorString Lib "winmm.dll" Alias "mciGetErrorStringA" (ByVal dwError As Long, ByVal lpstrBuffer As String, ByVal uLength As Long) As Long
Private Declare Function mciSendString Lib "winmm.dll" Alias "mciSendStringA" (ByVal lpstrCommand As String, ByVal lpstrReturnString As String, ByVal uReturnLength As Long, ByVal hwndCallback As Long) As Long

'volumecontrol
Private Declare Function mixerSetControlDetails Lib "winmm.dll" (ByVal hmxobj As Long, pmxcd As MIXERCONTROLDETAILS, ByVal fdwDetails As Long) As Long
Private Const MIXER_OBJECTF_AUX = &H50000000
Private Type MIXERCONTROLDETAILS
        cbStruct As Long       '  size in Byte of MIXERCONTROLDETAILS
        dwControlID As Long    '  control id to get/set details on
        cChannels As Long      '  number of channels in paDetails array
        item As Long                           ' hwndOwner or cMultipleItems
        cbDetails As Long      '  size of _one_ details_XX struct
        paDetails As Long      '  pointer to array of details_XX structs
End Type


'local variable(s) to hold property value(s)
Private mvarDoorOpen As Boolean 'local copy
Private mvarAudioCD As Boolean
Private mvarcurTimeMM As Long 'local copy
Private mvarcurTimeSS As Long 'local copy
Private mvarhWnd As Long
Private mvarLastError As Long
Private mvarLastErrorStr As String
Private mvarcurTrack As Integer     'Current track
Private mvarTotalTracks As Integer
Private mvarPaused As Boolean
Private tracktime() As String
Private totalTime As String

Private mvarPlaying As Boolean      'True if playing
Private cdLoaded As Boolean     'True if cd in drive
Private numTracks As Integer    'Number of tracks
Private forwarding As Boolean   'Fastforwarding
Private rewinding As Boolean    'Rewinding
Private ffspeed As Integer      'Fasforwardspeed in ms

'To fire this event, use RaiseEvent with the following syntax:
'RaiseEvent Error[(arg1, arg2, ... , argn)]
Public Event Error(Number As Long, Description As String)

Public Function SetVolume(value As Integer) As Long
    mixerSetControlDetails , , MIXER_OBJECTF_AUX
End Function
Public Property Get Playing() As Boolean
    Playing = mvarPlaying
End Property

Public Property Get Paused() As Boolean
    pauses = mvarPaused
End Property
Public Function UseCD() As Long
    If SendMCIString("open cdaudio alias cd wait shareable") = False Then
        mvarAudioCD = False
        UseCD = mvarLastError
        
        'if our source is open close it and open it again
        If UseCD <> 0 Then SendMCIString "close cd"
        SendMCIString ("open cdaudio alias cd wait shareable")
        UseCD = mvarLastError
        If UseCD <> 0 Then Exit Function
    End If
    SendMCIString "set cd time format tmsf wait"

    Update
    ffspeed = 1
End Function
Public Function StopCD() As Long
Dim cmd As String
    If Not mvarPlaying Then Exit Function
    GetCurTime cmd, cmd
    
    SendMCIString "stop cd wait"
    StopCD = mvarLastError
    
    If (mvarLastError = 0) Then mvarPlaying = False
'    Update
End Function

Public Function StopUseCD() As Long
    SendMCIString "close all"
    StopUseCD = mvarLastError
End Function

Public Function PauseCD() As Long
    mvarPaused = True
    If mvarPlaying Then SendMCIString "pause cd"
    PauseCD = mvarLastError
    If (mvarLastError = 0) Then mvarPlaying = False
    Update
End Function

Public Function PlayCD(restart As Boolean, Optional Track As Integer) As Long
Dim cmd As String

    mvarPaused = False
    If restart Then
        GetCurTrack
        If Track > 0 Then cmd = "seek cd to " & Track Else cmd = "seek cd to " & mvarcurTrack
        SendMCIString cmd
    End If
    
    SendMCIString "play cd"
    PlayCD = mvarLastError
    mvarPlaying = (mvarLastError = 0)
End Function

Public Function EjectCD() As Long
    SendMCIString "set cd door open"
    EjectCD = mvarLastError
End Function
Public Function CloseCD() As Long
    SendMCIString "set cd door closed"
    CloseCD = mvarLastError
    Update
    GetCurTrack
End Function
Public Function Rewind(ByVal ms As Long) As Long
Dim s As String * 40

    
    SendMCIString "set cd time format milliseconds"
    mciSendString "status cd position wait", s, Len(s), 0
    If (fmvarPlaying) Then
        cmd = "play cd from " & CStr(CLng(s) - ms) ' * 1000
    Else
        cmd = "seek cd to " & CStr(CLng(s) - ms)  '* 1000
    End If
    mciSendString cmd, 0, 0, 0
    SendMCIString "set cd time format tmsf"
    Rewind = mvarLastError
    Update
    
End Function

Public Function FastForward(ByVal ms As Long) As Long
Dim s As String * 40

    SendMCIString "set cd time format milliseconds"
    mciSendString "status cd position wait", s, Len(s), 0
    If (mvarPlaying) Then
        cmd = "play cd from " & CStr(CLng(s) + ms) ' * 1000
    Else
        cmd = "seek cd to " & CStr(CLng(s) + ms)  '* 1000
    End If
    mciSendString cmd, 0, 0, 0
    SendMCIString "set cd time format tmsf"
    FastForward = mvarLastError
    Update
End Function
Public Function SetPos(ByVal mm As Long, ByVal ss As Long) As Long
    SendMCIString "set cd time format milliseconds"
    If (mvarPlaying) Then
        cmd = "play cd from " & ((mm * 60) + ss) * 1000 ' * 1000
    Else
        cmd = "seek cd to " & ((mm * 60) + ss) * 1000  '* 1000
    End If
    mciSendString cmd, 0, 0, 0
    SendMCIString "set cd time format tmsf"
    SetPos = mvarLastError
    Update
End Function
Public Function PrevTrack() As Long
Dim cmd As String

    GetCurTrack
    If (curTrack <> 1) Then
        cmd = "play cd from " & mvarcurTrack - 1
        SendMCIString cmd
    Else
        cmd = "play cd from " & numTracks
        SendMCIString cmd
    End If
    PrevTrack = mvarLastError
    Update
End Function
Public Function GetCurTime(ByRef mm As String, ByRef ss As String) As Long
Dim s As String * 30
Dim n As String * 30

    If Not mvarPlaying Then
        mm = "00"
        ss = "00"
        Exit Function
    End If
    
    mciSendString "status cd position", s, Len(s), 0
    If s <> n Then
        mvarcurTrack = CInt(Mid$(s, 1, 2))
        mm = Format(CInt(Mid$(s, 4, 2)), "0#")
        ss = Format(CInt(Mid$(s, 7, 2)), "0#")
    Else
        Update
    End If
End Function

Public Function GetCurTimeMM() As String
Dim s As String * 30
Dim n As String * 30

    If Not mvarPlaying Then
        GetCurTimeMM = "00"
        Exit Function
    End If
    mciSendString "status cd position", s, Len(s), 0
    If s <> n Then
        mvarcurTrack = CInt(Mid$(s, 1, 2))
        GetCurTimeMM = Format(CInt(Mid$(s, 4, 2)), "0#")
    Else
        Update
    End If
End Function

Public Function GetCurTimeSS() As String
Dim s As String * 30
Dim n As String * 30

    If Not mvarPlaying Then
        GetCurTimeSS = "00"
        Exit Function
    End If
    
    mciSendString "status cd position", s, Len(s), 0
    If s <> n Then
        mvarcurTrack = CInt(Mid$(s, 1, 2))
        GetCurTimeSS = Format(CInt(Mid$(s, 7, 2)), "0#")
    Else
        Update
    End If
End Function


Public Function NextTrack() As Long
Dim from As String
Dim cmd As String

    GetCurTrack
    If (mvarcurTrack < numTracks) Then
        from = CStr(mvarcurTrack + 1)
    Else
        from = CStr(1)
    End If
    
    cmd = "play cd from " & from
    SendMCIString cmd
    
    NextTrack = mvarLastError
    Update
End Function
Public Function GetLastErrorStr() As String
    GetLastErrorStr = mvarLastErrorStr
End Function
Public Function GetLastError() As Long
    GetLastError = mvarLastError
End Function
'=========================Properties=====================================
Public Property Get DoorOpen() As Boolean
    DoorOpen = mvarDoorOpen
End Property
Public Property Get AudioCD() As Boolean
    AudioCD = mvarAudioCD
End Property
Public Property Get TotalTimeMM() As Long
    TotalTimeMM = Format(Mid(totalTime, 1, 2), "0#")
End Property
Public Property Get TotalTimeSS() As String
    TotalTimeSS = Format(Mid(totalTime, 4, 2), "0#")
End Property
Public Property Get TrackTimeMM() As String
    If mvarcurTrack <> 0 Then TrackTimeMM = Format(Mid(tracktime(curTrack), 1, 2), "0#") Else TrackTimeMM = 0
End Property
Public Property Get TrackTimeSS() As String
    If mvarcurTrack <> 0 Then TrackTimeSS = Format(Mid(tracktime(mvarcurTrack), 4, 2), "0#") Else TrackTimeSS = 0
End Property
Public Property Let hWnd(vdata As Long)
    mvarhWnd = vdata
End Property
Public Property Get curTrack() As String
    curTrack = Format(mvarcurTrack, "0#")
End Property
Public Property Get TotalTracks() As String
    TotalTracks = Format(numTracks, "0#")
End Property
Private Function SendMCIString(cmd As String) As Boolean
Static rc As Long
Static errStr As String * 200

    mvarLastError = 0
    rc = mciSendString(cmd, 0, 0, mvarhWnd)
    Debug.Print cmd
    If rc <> 0 Then
        mvarLastError = rc
        mciGetErrorString rc, errStr, Len(errStr)
        mvarLastErrorStr = errStr
        Debug.Print errStr
    End If
    SendMCIString = (rc = 0)

End Function

Private Sub Update()
Static s As String * 30

    ' Check if CD is in the player
    mciSendString "status cd media present", s, Len(s), 0
    If (CBool(s)) Then
        mvarDoorOpen = False
        mvarAudioCD = True
        ' Enable all the controls, get CD information
        If (fCDLoaded = False) Then
            mciSendString "status cd number of tracks wait", s, Len(s), 0
            numTracks = CInt(Mid$(s, 1, 2))
            
            ' If CD only has 1 track, then it's probably a data CD
            If (numTracks = 1) Then
                mvarAudioCD = False
                Exit Sub
            End If
            
            mciSendString "status cd length wait", s, Len(s), 0
            totalTime = s
            
            ReDim tracktime(1 To numTracks)
            Dim i As Integer
            For i = 1 To numTracks
                cmd = "status cd length track " & i
                mciSendString cmd, s, Len(s), 0
                tracktime(i) = s
            Next
            'SendMCIString "seek cd to 1", True
        End If
    
        ' Check if CD is mvarPlaying
        mciSendString "status cd mode", s, Len(s), 0
        mvarPlaying = (Mid$(s, 1, 7) = "playing")
    Else
        ' Disable all the controls, clear the display
        mvarDoorOpen = True
    End If
End Sub

Private Function GetCurTrack() As Integer
Dim s As String * 30
Dim n As String * 30

    mciSendString "status cd position", s, Len(s), 0
    If s <> n Then
        mvarcurTrack = CInt(Mid$(s, 1, 2))
    End If

End Function
