VERSION 2.00
Begin Form Form3D 
   Caption         =   "3D"
   ClientHeight    =   4500
   ClientLeft      =   2265
   ClientTop       =   1530
   ClientWidth     =   6000
   Height          =   4905
   Left            =   2205
   LinkTopic       =   "Form1"
   ScaleHeight     =   -20
   ScaleLeft       =   -13.33
   ScaleMode       =   0  'User
   ScaleTop        =   10
   ScaleWidth      =   26.67
   Top             =   1185
   Width           =   6120
End
Option Explicit

Dim EyeX As Single
Dim EyeY As Single
Dim EyeZ As Single

Const Xmin = -10
Const Xmax = 10
Const Ymin = -10
Const Ymax = 10
Dim Points(Xmin To Xmax, Ymin To Ymax) As Point3D

Dim Axes(1 To 3) As Point3D

' ********************************************************
' Calculate the transformation matrix.
' ********************************************************
Sub CalculateTransformation (T() As Single)
ReDim T1(1 To 4, 1 To 4) As Single
ReDim T2(1 To 4, 1 To 4) As Single
Dim r1 As Single
Dim r2 As Single
Dim ctheta As Single
Dim stheta As Single
Dim cphi As Single
Dim sphi As Single

    ' Rotate around the Z axis so the
    ' eye lies in the Y-Z plane.
    r1 = Sqr(EyeX * EyeX + EyeY * EyeY)
    stheta = EyeX / r1
    ctheta = EyeY / r1
    MakeIdentity T1()
    T1(1, 1) = ctheta
    T1(1, 2) = stheta
    T1(2, 1) = -stheta
    T1(2, 2) = ctheta

    ' Rotate around the X axis so the
    ' eye lies in the Z axis.
    r2 = Sqr(EyeX * EyeX + EyeY * EyeY + EyeZ * EyeZ)
    sphi = -r1 / r2
    cphi = -EyeZ / r2
    MakeIdentity T2()
    T2(2, 2) = cphi
    T2(2, 3) = sphi
    T2(3, 2) = -sphi
    T2(3, 3) = cphi

    ' Project along the Z axis. (Actually we do nothing
    ' here. We just ignore the Z coordinate when drawing.)

    ' Combine the transformations.
    MatrixMatrixMult T(), T1(), T2()
End Sub

' ********************************************************
' Draw the surface.
' ********************************************************
Sub DrawSurface ()
ReDim T(1 To 4, 1 To 4) As Single
Dim x As Integer
Dim y As Integer

    ' Calculate the transformation matrix.
    CalculateTransformation T()

    ' Apply the transformation matrix to the points.
    For x = Xmin To Xmax
        For y = Ymin To Ymax
            VectorMatrixMult Points(x, y).Trans(), Points(x, y).Coord(), T()
        Next y
    Next x

    ' Draw lines parallel to the X axis.
    ForeColor = RGB(0, 0, 0)
    For x = Xmin To Xmax
        CurrentX = Points(x, Ymin).Trans(1)
        CurrentY = Points(x, Ymin).Trans(2)
        For y = Ymin + 1 To Ymax
            Line -(Points(x, y).Trans(1), Points(x, y).Trans(2))
        Next y
    Next x

    ' Draw lines parallel to the Y axis.
    For y = Ymin To Ymax
        CurrentX = Points(Xmin, y).Trans(1)
        CurrentY = Points(Xmin, y).Trans(2)
        For x = Xmin + 1 To Xmax
            Line -(Points(x, y).Trans(1), Points(x, y).Trans(2))
        Next x
    Next y

    ' Transform and draw the axes.
    ForeColor = RGB(255, 0, 0)
    For x = 1 To 3
        VectorMatrixMult Axes(x).Trans(), Axes(x).Coord(), T()
        Line (0, 0)-(Axes(x).Trans(1), Axes(x).Trans(2))
    Next x
End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
Const PI = 3.14159
Const Dtheta = PI / 16
Const Dphi = PI / 8

Dim theta As Single
Dim phi As Single
Dim r1 As Single
Dim r2 As Single

    If KeyCode < 37 Or KeyCode > 40 Then Exit Sub

    theta = Atan(EyeX, EyeY)
    r1 = Sqr(EyeX * EyeX + EyeY * EyeY)
    r2 = Sqr(EyeX * EyeX + EyeY * EyeY + EyeZ * EyeZ)
    phi = Atan(r1, EyeZ)

    Select Case KeyCode
        Case 37 ' Left arrow.
            theta = theta - Dtheta
        
        Case 38 ' Up arrow.
            phi = phi + Dphi
            If phi > PI / 2 Then phi = PI / 2

        Case 39 ' Right arrow.
            theta = theta + Dtheta

        Case 40 ' Down arrow.
            phi = phi - Dphi
            If phi < -PI / 2 Then phi = -PI / 2
    End Select
    
    EyeX = r1 * Cos(theta)
    EyeY = r1 * Sin(theta)
    EyeZ = r2 * Sin(phi)
    Form3D.Refresh
End Sub

Sub Form_Load ()
Dim x As Integer
Dim y As Integer
Dim r As Single

    ' Initialize the viewing location.
    EyeX = 40
    EyeY = 20
    EyeZ = 20

    ' Initialize the data points.
    For x = Xmin To Xmax
        For y = Ymin To Ymax
            Points(x, y).Coord(1) = x   ' X coordinate.
            Points(x, y).Coord(2) = y   ' Y coordinate.
            Points(x, y).Coord(4) = 1   ' Scale factor.
        
            ' Z coordinate.
            r = Sqr(x * x + y * y)
            Points(x, y).Coord(3) = Cos(r)
        Next y
    Next x

    ' Initialize the axes.
    Axes(1).Coord(1) = 10   ' X axis.
    Axes(1).Coord(4) = 1
    Axes(2).Coord(2) = 10   ' Y axis.
    Axes(2).Coord(4) = 1
    Axes(3).Coord(3) = 10   ' Z axis.
    Axes(3).Coord(4) = 1
End Sub

Sub Form_Paint ()
    DrawSurface
End Sub

