Option Explicit

Type Point3D
    Coord(1 To 4) As Single ' Original coordinates.
    Trans(1 To 4) As Single ' Translated coordinates.
End Type

' ********************************************************
' Return the angle with tangent y / x.
' ********************************************************
Function Atan (x As Single, y As Single)
Const PI = 3.14159

Dim angle As Single

    If x = 0 Then
        angle = 0
    Else
        angle = Atn(y / x)
        If x < 0 Then angle = PI + angle
    End If
    
    Atan = angle
End Function

' ********************************************************
' Make M an identity matrix.
' ********************************************************
Sub MakeIdentity (M() As Single)
Dim i As Integer
Dim j As Integer

    For i = 1 To 4
        For j = 1 To 4
            If i = j Then
                M(i, j) = 1
            Else
                M(i, j) = 0
            End If
        Next j
    Next i
End Sub

' ********************************************************
' Perform matrix-matrix multiplication. Set R = A * B.
' ********************************************************
Sub MatrixMatrixMult (R() As Single, A() As Single, B() As Single)
Dim i As Integer
Dim j As Integer
Dim k As Integer
Dim value As Single

    For i = 1 To 4
        For j = 1 To 4
            value = 0#
            For k = 1 To 4
                value = value + A(i, k) * B(k, j)
            Next k
            R(i, j) = value
        Next j
    Next i
End Sub

Sub ShowMatrix (M() As Single)
Dim i As Integer
Dim j As Integer

    For i = 1 To 4
        For j = 1 To 4
            Debug.Print M(i, j);
        Next j
        Debug.Print
    Next i
End Sub

' ********************************************************
' Perform vector-matrix multiplication. Set Rpt = Ppt * A.
' ********************************************************
Sub VectorMatrixMult (Rpt() As Single, Ppt() As Single, A() As Single)
Dim i As Integer
Dim j As Integer
Dim value As Single

    For i = 1 To 4
        value = 0#
        For j = 1 To 4
            value = value + Ppt(j) * A(j, i)
        Next j
        Rpt(i) = value
    Next i
    
    ' Renormalize the point.
    ' Note that value still holds Rpt(4).
    Rpt(1) = Rpt(1) / value
    Rpt(2) = Rpt(2) / value
    Rpt(3) = Rpt(3) / value
    Rpt(4) = 1#
End Sub

