VERSION 5.00
Begin VB.Form f_principal 
   Caption         =   "PenDrives Habilitados"
   ClientHeight    =   930
   ClientLeft      =   3615
   ClientTop       =   945
   ClientWidth     =   3330
   ControlBox      =   0   'False
   Icon            =   "f_prinicpal.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   930
   ScaleWidth      =   3330
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton Command1 
      Caption         =   "Minimizar"
      Height          =   495
      Left            =   240
      TabIndex        =   1
      Top             =   240
      Width           =   855
   End
   Begin VB.CommandButton cmd_sair 
      Caption         =   "Sair"
      Height          =   495
      Left            =   2280
      TabIndex        =   0
      Top             =   240
      Width           =   855
   End
   Begin VB.Menu mpopup 
      Caption         =   "Arquivo"
      Begin VB.Menu mpopup1 
         Caption         =   "Sair"
      End
   End
End
Attribute VB_Name = "f_principal"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' *************************************************************************************
' Projeto:  HabilitaPendrive 1.0
' Data:     04/03/2008
' Autor:    Paulo Mendes / Robert Quellis
'
' Programa: Enquanto voc ligar o programa, os pendrives da mquina estaro habilita-
' dos, ao desligar o programa, os pendrives so ejetados com segurana e desabilitados
' logo em seguida.
'
' Requerimentos: VB6 SP5, para Win2000 necessrio instalar o reg.exe na mquina
' *************************************************************************************

' *************************************************************************************
'HabilitaPendrive 1.0 is a VB6 Software
'Copyright (C)-2008 PauloMendes (paulo.mendes87@gmail.com)

'This program is free software; you can redistribute it and/or modify
'it under the terms of the GNU General Public License as published by
'the Free Software Foundation; either version 2, or (at your option)
'any later version.

'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'GNU General Public License for more details.

'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
' *************************************************************************************

Option Explicit

Implements iSubclass

Private Declare Function GetLogicalDriveStrings Lib "kernel32" _
Alias "GetLogicalDriveStringsA" ( _
    ByVal nBufferLength As Long, _
    ByVal lpBuffer As String _
) As Long

Private m_clsSubcls As cSubclass


Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" ( _
    ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" ( _
    ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function Shell_NotifyIcon Lib "shell32" Alias "Shell_NotifyIconA" ( _
    ByVal dwMessage As Long, lpData As NOTIFYICONDATA) As Long
Private Declare Function ShellAbout Lib "shell32.dll" Alias "ShellAboutA" ( _
    ByVal hwnd As Long, ByVal szApp As String, ByVal szOtherStuff As String, _
    ByVal hIcon As Long) As Long

Private Type NOTIFYICONDATA
    cbSize As Long
    hwnd As Long
    uID As Long
    uFlags As Long
    uCallbackMessage As Long
    hIcon As Long
    szTip As String * 128
    dwState As Long
    dwStateMask As Long
    szInfo As String * 256
    uTimeout As Integer
    uVersion As Integer
    szInfoTitle As String * 64
    dwInfoFlags As Long
End Type

Private Const WM_MOUSEMOVE = &H200
Private Const GWL_STYLE = (-16)
Private Const WS_HSCROLL = &H100000
Private Const WS_VSCROLL = &H200000

Private Const NIM_ADD = &H0
Private Const NIM_MODIFY = &H1
Private Const NIM_DELETE = &H2
Private Const NIM_SETFOCUS = &H3
Private Const NIM_SETVERSION = &H4

Private Const NIF_MESSAGE = &H1
Private Const NIF_ICON = &H2
Private Const NIF_TIP = &H4
Private Const NIF_STATE = &H8
Private Const NIF_INFO = &H10
Private Const NIF_GUID = &H20

Private Const NIIF_NONE = &H0
Private Const NIIF_INFO = &H1
Private Const NIIF_WARNING = &H2
Private Const NIIF_ERROR = &H3
Public Function f_retornaLetra() As String
' Funo que retorna a letra do pendrive
' Problemas com mltiplos pendrives

Dim strDriveBuffer As String
Dim strDrives() As String
Dim i As Long
Dim udtInfo As DEVICE_INFORMATION
Dim str_letra As String

'Delimita-se um espao para string
strDriveBuffer = Space(240)
'Retorna Informaes Sobre os Dispositivos
strDriveBuffer = Left$(strDriveBuffer, GetLogicalDriveStrings(Len(strDriveBuffer), strDriveBuffer))
'Separa os Dispositivos em uma Matriz Unidimensional
strDrives = Split(strDriveBuffer, Chr$(0))

For i = 0 To UBound(strDrives) - 1
    udtInfo = GetDevInfo(strDrives(i))
    If udtInfo.Valid Then
        'Verificao do tipo de Driver, se for USB e Removivel podemos executar a operao
       ' f_verificaPendrive
        If udtInfo.BusType = BusTypeUsb And udtInfo.Removable = True Then
            'ento retornamos a letra para executar algum tipo de operao
            f_retornaLetra = strDrives(i)
        End If
    End If
Next

End Function

Public Function f_removePendrive() As Boolean
' Funo que Remove o Pendrive

Dim strDriveBuffer As String
Dim strDrives() As String
Dim i As Long
Dim udtInfo As DEVICE_INFORMATION
Dim str_letra As String

'iniciamos a funo com verdadeiro caso
f_removePendrive = True

'Delimita-se um espao para string
strDriveBuffer = Space(240)
'Retorna Informaes Sobre os Dispositivos
strDriveBuffer = Left$(strDriveBuffer, GetLogicalDriveStrings(Len(strDriveBuffer), strDriveBuffer))
'Separa os Dispositivos em uma Matriz Unidimensional
strDrives = Split(strDriveBuffer, Chr$(0))

For i = 0 To UBound(strDrives) - 1
    udtInfo = GetDevInfo(strDrives(i))
    If udtInfo.Valid Then
        'Verificao do tipo de Driver, se for USB e Removivel podemos executar a operao
        If udtInfo.BusType = BusTypeUsb And udtInfo.Removable = True Then
            str_letra = strDrives(i)
            'Esta  a Funo que Ejeta o Pendrive, se retornar falso quer dizer que algum problema houve com
            'A remoo do dispositivo.
            If EjectDevice(str_letra) <> True Then
                MsgBox "O Pen Drive: " + str_letra + " no pode ser ejetado. Existem arquivos abertos", vbCritical, "AVISO"
                f_removePendrive = False
            End If
        End If
    End If
Next

End Function

Private Sub Command1_Click()

Call MinimizeToSystray

End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

If Button = vbLeftButton Then
    PopupMenu mpopup, , , , mpopup1
End If

End Sub

Private Sub Form_Resize()

If WindowState = 1 Then
    MinimizeToSystray
    WindowState = 0
End If

End Sub

Public Sub MinimizeToSystray()

Dim oData As NOTIFYICONDATA
With oData

    .cbSize = Len(oData)
    .hIcon = Me.Icon.Handle
    .hwnd = Me.hwnd
    .szTip = Left(Me.Caption, 64) & Chr(0)
    .uCallbackMessage = WM_MOUSEMOVE
    .uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE

End With
Shell_NotifyIcon NIM_ADD, oData
Hide

End Sub

Private Sub RestoreFromSystray(Optional ShowWindow As Boolean = True)

Dim oData As NOTIFYICONDATA
With oData

    .cbSize = Len(oData)
    .hwnd = Me.hwnd

End With
Shell_NotifyIcon NIM_DELETE, oData

If ShowWindow Then
    Show
End If

End Sub

Public Sub s_habilitaPendrive(switch As Boolean)

Dim bol_verifica As Boolean

'Fazemos a habilitao do driver via regedit, necessrio ter o reg.exe instalado na mquina.
'Primeiro deletamos a chave, e a criamos com outro valor.

'deleta a chave
Shell (Environ("windir") + "\system32\reg delete HKLM\System\CurrentControlSet\Services\USBSTOR /v Start /f")
Select Case switch
    Case True
        
        'Procedimento para Criar a chave, ele tenta criar vrias vezes at ter certeza que a chave
        'Foi criada, isso  um problema do reg.exe que  tratado com um loop simples
        'Esta chave com valor 3 significa o pendrive desabilitado
        bol_verifica = False
        Shell (Environ("windir") + "\system32\reg add HKLM\System\CurrentControlSet\Services\USBSTOR /v Start /t REG_DWORD /d 3 /f")
        Do While bol_verifica = False
            bol_verifica = GetKeyValue(HKEY_LOCAL_MACHINE, "System\CurrentControlSet\Services\USBSTOR", "Start", "")
            If bol_verifica = False Then
                Shell (Environ("windir") + "\system32\reg add HKLM\System\CurrentControlSet\Services\USBSTOR /v Start /t REG_DWORD /d 3 /f")
            Else
                bol_verifica = True
            End If
        Loop
        
        'desmapeia algumas unidades de rede, pode ser omitido
        'Shell (Environ("windir") + "\system32\net use /delete F:")
        'Shell (Environ("windir") + "\system32\net use /delete Y:")
        'Shell (Environ("windir") + "\system32\net use /delete Z:")
        
    Case False
        bol_verifica = False
        
        'Procedimento para Criar a chave, ele tenta criar vrias vezes at ter certeza que a chave
        'Foi criada, isso  um problema do reg.exe que  tratado com um loop simples
        'Esta chave com valor 4 significa o pendrive habilitado
        Shell (Environ("windir") + "\system32\reg add HKLM\System\CurrentControlSet\Services\USBSTOR /v Start /t REG_DWORD /d 4 /f")
        Do While bol_verifica = False
            bol_verifica = GetKeyValue(HKEY_LOCAL_MACHINE, "System\CurrentControlSet\Services\USBSTOR", "Start", "")
            If bol_verifica = False Then
                Shell (Environ("windir") + "\system32\reg add HKLM\System\CurrentControlSet\Services\USBSTOR /v Start /t REG_DWORD /d 4 /f")
            Else
                bol_verifica = True
            End If
        Loop
        
End Select

End Sub

Private Sub cmd_sair_Click()

Dim str_letra As String

str_letra = f_retornaLetra

'Fechamos o arquivo aberto pelo sistema
Call s_Arquivo(str_letra, False)

'Chamamos a funo e verificamos se no d nenhum problema quanto a remoo
If f_removePendrive = True Then
    'Se no houve problemas desabilitamos o pendrive
    Call s_habilitaPendrive(False)
    Shell Environ("windir") + "\system32\loginw32.exe", vbNormalFocus
    Unload Me
End If
 
'If f_verificaPendrive = True Then
'    MsgBox ("Voc no pode fechar o sistema enquanto no retirar o PEN DRIVE."), vbInformation, "AVISO"
'Else
'    Shell (Environ("windir") + "\system32\reg delete HKLM\System\CurrentControlSet\Services\USBSTOR /v Start /f")
'    Shell (Environ("windir") + "\system32\reg.exe add HKLM\System\CurrentControlSet\Services\USBSTOR /v Start /t REG_DWORD /d 4 /f")
'    Shell Environ("windir") + "\system32\loginw32.exe", vbNormalFocus
'    Unload Me
'End If

End Sub

Private Function f_verificaPendrive() As Integer

Dim bol_verifica As Boolean
Dim int_contador As Integer

bol_verifica = True
int_contador = 0

'esta funo verifica se o pendrive est plugado fisicamente na mquina, verificamos isso via registro do
'windows. Caso o valor existe significa que o pendrive est fisicamente na mquina, caso contrrio o pen
'drive est desconectado, funciona excluisvamente para pendrives, e no para qualquer outro tipo de dispo-
'sitivo usb

Do While bol_verifica = True
    bol_verifica = GetKeyValue(HKEY_LOCAL_MACHINE, "System\CurrentControlSet\Services\USBSTOR\Enum", CStr(int_contador), "")
    If bol_verifica = True Then
        int_contador = int_contador + 1
    Else
        bol_verifica = False
    End If
Loop
f_verificaPendrive = int_contador

End Function
Private Sub s_Arquivo(str_device As String, param As Boolean)

Dim int_i As Integer

If param = True Then
    Open str_device + "_x_trava_x_.txt" For Random As #f_verificaPendrive
Else
    For int_i = 1 To f_verificaPendrive
        Close #int_i
    Next
End If

End Sub
Private Sub Form_Load()

'Inicializao do mtodo para escutar nas portas de drives, qualquer mudana, alterao que houver no
'Deck de discos ele chamara o evento iSubclass_WndProc
Set m_clsSubcls = New cSubclass
m_clsSubcls.Subclass Me.hwnd, Me
m_clsSubcls.AddMsg Me.hwnd, WM_DEVICECHANGE

'Chamando a Habilitao de Pendrive
Call s_habilitaPendrive(True)

'Minimizando para a Bandeja do Sistema
Call MinimizeToSystray

End Sub

Private Sub iSubclass_WndProc(ByVal bBefore As Boolean, bHandled As Boolean, lReturn As Long, ByVal lng_hWnd As Long, ByVal uMsg As eMsg, ByVal wParam As Long, ByVal lParam As Long, lParamUser As Long)
'Procedimento para tratar a mudana no Deck de Discos no Meu Computador

Dim str_letra As String

    If uMsg = WM_DEVICECHANGE Then
        'Pegamos a Letra em que o pendrive foi encaixado
        str_letra = f_retornaLetra()
        'Quando f_retornaLetra retornar uma string vazia, significa que o pendrive foi removido
        If str_letra = "" Then Exit Sub
        'Esse procedimento cria o arquivo em instncia aberta para impedir o usurio tirar o pendrive
        'Pelo remover dispositivo. Isso implica dizer que o usurio s poder tirar o pendrive pelo
        'Nosso Sistema
        Call s_Arquivo(str_letra, True)
    End If
    
End Sub

Private Sub mpopup1_Click()

Call cmd_sair_Click

End Sub
