VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "CSHFileOp Class Demo"
   ClientHeight    =   3195
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3195
   ScaleWidth      =   4680
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton Command1 
      Caption         =   "Command1"
      Height          =   495
      Left            =   1320
      TabIndex        =   0
      Top             =   1200
      Width           =   1935
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'SHFileOp - VB program that demonstrates using SHFileOperation
'Copyright (c) 1997 SoftCircuits Programming (R)
'Redistributed by Permission.
'
'Starting with Windows 95, the Windows API provides the SHFileOperation
'function. This function provides many options for copying, moving,
'renaming and deleting files. For lengthy operations, a dialog box is
'displayed that indicates the current operation and progress. This is
'exactly the same progress dialog box displayed by the Windows Explorer
'because the Windows Explorer also calls SHFileOperation.
'
'The CSHFileOp class encapsulates SHFileOperation making it much
'easier to use. Not only does it provide much easier access to the many
'options but performs some special work so that SHFILEOPSTRUCT can be
'fully exploited by VB. Most available options are implemented as class
'properties and methods. For example, set the AllowUndo property to
'True to cause deleted files to be sent to the Recycle Bin. View the
'comments within the source code for information about these options.
'Refer to the Windows API documentation for additional information.
'
'After specifying the source and destination files and setting any
'options you want, call the CopyFiles, MoveFiles, DeleteFiles or
'RenameFiles methods to perform the operation. Each of these methods
'returns True if all operations completely successfully, or False if
'there was an error or the user canceled an operation. (Note: You do
'not normally need to display error information because Windows will
'notify the user of any tasks that could not be completed.)
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
Option Explicit

Private Const TEMPDIR = "_$$Tmp$$"  'Directory name unlikely to exist already
Private Declare Function GetSystemDirectory Lib "kernel32" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long

'Demonstrate CSHFileOp class
Private Sub Command1_Click()
    Dim fileop As New CSHFileOp
    Dim sSysDir As String

    'Tell user what we are doing and give them a chance to back out
    If MsgBox("This program will demonstrate the CSHFileOp class by first " & _
        "copying all the help files from your Windows system directory to " & _
        "a temporary directory, and then deleting that temporary directory " & _
        "and all of its contents." & vbCrLf & vbCrLf & "Do you want to " & _
        "proceed?", vbQuestion Or vbYesNo) <> vbYes Then
        Exit Sub
    End If
    'Make our form the parent window of the
    'SHFileOperation dialog box (optional)
    fileop.ParentWnd = hwnd
    'Get Windows system directory
    sSysDir = String$(512, Chr$(0))
    GetSystemDirectory sSysDir, 512
    sSysDir = Left$(sSysDir, InStr(sSysDir, Chr$(0)) - 1)
    'Ensure trailing backslash
    If Right$(sSysDir, 1) <> "\" Then
        sSysDir = sSysDir & "\"
    End If
    'Copy all the help files in the Windows system directory
    fileop.ClearSourceFiles
    fileop.AddSourceFile sSysDir & "*.hlp"
    'To a temporary subdirectory
    fileop.ClearDestFiles
    fileop.AddDestFile sSysDir & TEMPDIR
    'Copy the files
    If Not fileop.CopyFiles Then
        MsgBox "One or more operations were not successfully completed."
        Exit Sub
    End If
    'Now delete the temporary directory and all contents
    fileop.ClearSourceFiles
    fileop.ClearDestFiles
    fileop.AddSourceFile sSysDir & TEMPDIR
    'Delete the directory
    If Not fileop.DeleteFiles Then
        MsgBox "One or more operations were not successfully completed."
        Exit Sub
    End If
End Sub
