Attribute VB_Name = "modShellDoc"
'Arquivo obtido no Visual Basic Brasil
'http://www.vbbrasil.com
'(c)1996,1997,1998

Option Explicit

'
' API para execuo Shell
'
#If Win16 Then
    Private Declare Function ShellExecute Lib "shell.dll" (ByVal hWnd As Integer, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Integer) As Integer
#Else
    Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
#End If

'
' constantes para ShellExecute
'
Public Const SW_HIDE = 0
Public Const SW_MAXIMIZE = 3
Public Const SW_MINIMIZE = 6
Public Const SW_NORMAL = 1
Public Const SW_SHOWDEFAULT = 10
Public Const SW_SHOWMAXIMIZED = 3
Public Const SW_SHOWMINIMIZED = 2
Public Const SW_SHOWMINNOACTIVE = 7
Public Const SW_SHOWNA = 8
Public Const SW_SHOWNOACTIVATE = 4
Public Const SW_SHOWNORMAL = 1

'
' Mensagens de erro da Shellexecute
'
Public Const ERROR_BAD_FORMAT = 11&
Public Const ERROR_FILE_NOT_FOUND = 2&
Public Const ERROR_PATH_NOT_FOUND = 3&
'
Public Const SE_ERR_ACCESSDENIED = 5
Public Const SE_ERR_ASSOCINCOMPLETE = 27
Public Const SE_ERR_DDEBUSY = 30
Public Const SE_ERR_DDEFAIL = 29
Public Const SE_ERR_DDETIMEOUT = 28
Public Const SE_ERR_FNF = 2
Public Const SE_ERR_NOASSOC = 31
Public Const SE_ERR_OOM = 8
Public Const SE_ERR_PNF = 3
Public Const SE_ERR_SHARE = 26

Public Sub ShellEx(lhWnd As Long, cPath As String, cDoc As String, Optional cAction As Variant, Optional cParms As Variant, Optional nShowCmd As Variant)
    ' =========================================
    ' Funces da API ShellExecute
    '
    ' Entradas requeridas
    '   lhWnd       trbalha com a janela parente
    '   cPath       drive e diretrio do objeto/doc
    '   cDoc        nome completo do objeto (menos diretrio)
    '
    ' Optional Inputs:
    '   cAction     ao para executar
    '                   "open" (default)
    '                   "print"
    '                   "explore" (somente para win95/WinNT4)
    '   cParms      parametrs para cDoc (somente para arquivos EXE)
    '   nShowCmd    controla foco/min-max, etc
    '                   SW_NORMAL  odefault
    '                   veja Const Declares para lista completa
    ' ============================================
    '
    Dim lRtn As Long
    Dim cMsg As String
    '
    ' checa parametros opcionais
    If IsMissing(cAction) Or Trim(cAction) = "" Then
        cAction = "open"
    End If
    '
    If IsMissing(cParms) Then
        cParms = vbNullString
    End If
    '
    If IsMissing(nShowCmd) Then
        nShowCmd = SW_NORMAL
    End If
    '
    ' executa chamada  API
    lRtn = ShellExecute(lhWnd, cAction, cPath & cDoc, cParms, cPath, nShowCmd)
    '
    ' checa valor de retorno
        If lRtn <= 32 Then
        ShellErr (lRtn) ' mostra erro
    End If
    '
End Sub


Public Sub ShellErr(lRtn As Long)
    '
    ' mostra mensagens de erro
    '
    Dim cMsg As String
    '
    Select Case lRtn
        Case 0 ' erro de memria
            cMsg = "Erro de memria"
        Case ERROR_BAD_FORMAT ' 11&
            cMsg = "Formato do executvel ruim"
        Case ERROR_FILE_NOT_FOUND ' 2&
            cMsg = "Arquivo no encontrado"
        Case ERROR_PATH_NOT_FOUND ' 3&
            cMsg = "diretrio no encontrado"
        Case SE_ERR_ACCESSDENIED ' 5
            cMsg = "Acesso negado"
        Case SE_ERR_ASSOCINCOMPLETE ' 27
            cMsg = "Associao incompleta"
        Case SE_ERR_DDEBUSY ' 30
            cMsg = "DDE Busy erro"
        Case SE_ERR_DDEFAIL ' 29
            cMsg = "DDE falhou"
        Case SE_ERR_DDETIMEOUT ' 28
            cMsg = "DEE time out"
        Case SE_ERR_FNF ' 2
            cMsg = "Arquivo no encontrado"
        Case SE_ERR_NOASSOC ' 31
            cMsg = "No existe associao para este arquivo"
        Case SE_ERR_OOM ' 8
            cMsg = "Falta de memria"
        Case SE_ERR_PNF ' 3
            cMsg = "Arquivo no encontrado"
        Case SE_ERR_SHARE ' 26
            cMsg = "Violao de Share"
        Case Else
            cMsg = "Erro desconhecido!"
    End Select
    '
    MsgBox cMsg, vbCritical, "Erro do ShellExecute [" & CStr(lRtn) & "]"
    '
End Sub
