Attribute VB_Name = "Long2Short"
'****************************************************************
'Windows API/Global Declarations for: ShortFileName
'****************************************************************

Private Declare Function OSGetShortPathName Lib "Kernel32" Alias "GetShortPathNameA" (ByVal lpszLongPath As String, ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long

'****************************************************************
' Name: ShortFileName
' Description:Converting a Long File Name to a Short File Name
'
' Inputs: LongName name of file to get short name of
' Returns: Short filename
' Assumes: The file and directory must exist for this to work.
' Side Effects: None
'
'****************************************************************

Public Function ShortFileName(ByVal LongName As String) As String

       Dim pstrBuffer As String
       Dim plngResult As Long
       On Error GoTo ErrorHandler
       ShortFileName = ""

              If LongName = "" Then Exit Sub
                     pstrBuffer = String$(128, 0)
                     plngResult = OSGetShortPathName(LongName, pstrBuffer, Len(pstrBuffer))

                            If plngResult > 0 Then
                                   ShortFileName = Left$(pstrBuffer, plngResult)
                            Else
                                   ShortFileName = ""
                            End If

Exiting:
                     Exit Function
ErrorHandler:
                     Resume Exiting
              End Function
