Attribute VB_Name = "PRCHELP"
Option Explicit

' ***************************************************
' Help File and About API Calls
' ***************************************************
'
' ***************************************************
' * Use this if you are building your project under VB3
' Declare Function WinHelp Lib "User" (ByVal hwnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, ByVal dwData As Any) As Integer
' Private Declare Sub ShellAbout Lib "shell.dll" (ByVal hWindOwner As Integer, ByVal lpszAppName As String, ByVal lpszMoreInfo As String, ByVal hIcon As Integer)
' * end of VB3 version
' ***************************************************

' ***************************************************
' * use this if you are building your project under VB4
#If Win16 Then
    Declare Function WinHelp Lib "User" (ByVal hwnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, ByVal dwData As Any) As Integer
    Declare Sub ShellAbout Lib "shell.dll" (ByVal hWindOwner As Integer, ByVal lpszAppName As String, ByVal lpszMoreInfo As String, ByVal hIcon As Integer)
#Else
    Declare Function WinHelp Lib "user32" Alias "WinHelpA" (ByVal hwnd As Long, ByVal lpHelpFile As String, ByVal wCommand As Long, ByVal dwData As Any) As Long
    Declare Function ShellAbout Lib "shell32.dll" Alias "ShellAboutA" (ByVal hwnd As Long, ByVal szApp As String, ByVal szOtherStuff As String, ByVal hIcon As Long) As Long
#End If
' * end of VB4 version
' ****************************************************

' ****************************************************
' * help routine constants (VB3 and VB4)
Global Const HELP_QUIT = 2
Global Const HELP_INDEX = 3
Global Const HELP_HELPONHELP = 4
Global Const HELP_PARTIALKEY = &H105



Sub HelpFunc(frmForm As Form, nHelpCmd As Integer, cHelpKey As String)
    '
    ' make calls to the Windows Help System
    '
    Dim i As Integer
    Dim nFlag As Integer
    Dim aData As Variant
    '
    ' trap for missing help file
    If Len(LTrim(RTrim(App.HelpFile))) = 0 Then
       MsgBox "No Help File Available"
       GoTo HelpFunc_Exit
    End If
    '
    ' check for valid help command
    Select Case nHelpCmd
       Case Is = HELP_QUIT ' close help child
          nFlag = True
       Case Is = HELP_INDEX ' show contents page
          nFlag = True
       Case Is = HELP_HELPONHELP ' show help on help
          nFlag = True
       Case Is = HELP_PARTIALKEY ' show search dialog
          nFlag = True
       Case Else
          nFlag = False 'invalid command!
    End Select
    '
    If nFlag = True Then
       If nHelpCmd = HELP_PARTIALKEY Then
          i = WinHelp(frmForm.hwnd, App.HelpFile, nHelpCmd, cHelpKey)
       Else
          i = WinHelp(frmForm.hwnd, App.HelpFile, nHelpCmd, 0&)
       End If
    Else
       MsgBox "Invalid Help Command Value"
    End If
    '
HelpFunc_Exit:
    '
End Sub

Public Sub WinAboutPage(frm As Form)
    '
    ' call the default About box for Windows
    '
    Dim cMoreInfo As String
    '
    ' add two custom lines to the about box
    cMoreInfo = "Copyright " & Chr(169) & "1994 MySoftware Ltd."
    cMoreInfo = cMoreInfo & Chr(13) & "Technical Support: 333-555-1212"
    '
    ' show the about box
    Call ShellAbout(frm.hwnd, App.Title, cMoreInfo, frm.Icon)
    '
End Sub

