VERSION 4.00
Begin VB.Form frmFileIO 
   Caption         =   "File IO Tester"
   ClientHeight    =   7050
   ClientLeft      =   1095
   ClientTop       =   1455
   ClientWidth     =   9480
   Height          =   7455
   Icon            =   "FILEIO.frx":0000
   Left            =   1035
   LinkTopic       =   "Form1"
   ScaleHeight     =   7050
   ScaleWidth      =   9480
   Top             =   1110
   Width           =   9600
   Begin VB.CommandButton cmd 
      Caption         =   "&About..."
      Height          =   375
      Index           =   3
      Left            =   8160
      TabIndex        =   7
      Top             =   1800
      Width           =   1215
   End
   Begin VB.CommandButton cmd 
      Caption         =   "&Print File"
      Height          =   375
      Index           =   2
      Left            =   8160
      TabIndex        =   6
      Top             =   1320
      Width           =   1215
   End
   Begin VB.CommandButton cmd 
      Caption         =   "&Build File"
      Height          =   375
      Index           =   1
      Left            =   8160
      TabIndex        =   5
      Top             =   840
      Width           =   1215
   End
   Begin VB.CommandButton cmd 
      Caption         =   "&Open File..."
      Height          =   375
      Index           =   0
      Left            =   8160
      TabIndex        =   4
      Top             =   360
      Width           =   1215
   End
   Begin VB.Frame fraFileInfo 
      Caption         =   "File Information:"
      Height          =   3495
      Left            =   120
      TabIndex        =   2
      Top             =   3480
      Width           =   7935
      Begin VB.PictureBox picFileInfo 
         AutoRedraw      =   -1  'True
         BorderStyle     =   0  'None
         BeginProperty Font 
            name            =   "Courier New"
            charset         =   0
            weight          =   400
            size            =   9.75
            underline       =   0   'False
            italic          =   0   'False
            strikethrough   =   0   'False
         EndProperty
         Height          =   3135
         Left            =   120
         ScaleHeight     =   3135
         ScaleWidth      =   7695
         TabIndex        =   3
         Top             =   240
         Width           =   7695
      End
   End
   Begin VB.TextBox txt 
      Height          =   3015
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   1
      Top             =   360
      Width           =   7935
   End
   Begin VB.Label lblCaption 
      Caption         =   "File Contents:"
      Height          =   195
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1575
   End
   Begin MSComDlg.CommonDialog dlg 
      Left            =   8640
      Top             =   0
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
   End
End
Attribute VB_Name = "frmFileIO"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'**************************************************************************
' FILEIO.FRM - This form is used to test some of the methods and properties
'              in the clsFileDialog and clsFileIO classes.
'**************************************************************************
Option Explicit
'--------------------------------------------------------------------------
' Win32 API constants and declarations.
'--------------------------------------------------------------------------
#If Win32 Then
    Private Declare Function ShellAbout Lib "shell32.dll" Alias "ShellAboutA" _
        (ByVal hWndOwner As Long, ByVal lpszAppName As String, _
        ByVal lpszMoreInfo As String, ByVal hIcon As Long) As Integer
'--------------------------------------------------------------------------
' Win16 API constants and declarations.
'--------------------------------------------------------------------------
#Else
    Private Declare Sub ShellAbout Lib "shell.dll" (ByVal hWndOwner As Integer, _
        ByVal lpszAppName As String, ByVal lpszMoreInfo As String, _
        ByVal hIcon As Integer)
#End If
Private mclsDialog As New clsFileDialog
'**************************************************************************
' Purpose:  Handles the command buttons on the form.
'**************************************************************************
Private Sub cmd_Click(Index As Integer)
    Dim strFilter As String     ' Holds a filter string.
    Select Case Index
        Case 0 ' Open File
            strFilter = "Text Files (*.txt)|*.txt|INI Files (*.ini)|*.*"
            If mclsDialog.OpenFile(vntFilter:=strFilter) Then
                mclsDialog.File.LoadTextBox txt
                LoadFileInfo
            Else
                picFileInfo.Cls
                picFileInfo.Print "File not opened."
                txt = ""
            End If
        Case 1 ' Build File
            BuildFile
        Case 2 ' Print File
            If Len(dlg.FileName) Then
                mclsDialog.File.PrintFile
            Else
                MsgBox "You must open a file with the Open File button first!", _
                                                                vbExclamation
            End If
        Case 3 ' About...
            ShellAbout hWnd, Caption, "Developed by: Ronald R. Martinsen", Icon
    End Select
End Sub
'**************************************************************************
' Purpose:  Centers the form and intializes the .CommonDialogControl
'           property of mclsDialog.
'**************************************************************************
Private Sub Form_Load()
    Set mclsDialog.CommonDialogControl = dlg
    Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
End Sub
'**************************************************************************
' Purpose:  Displays information about the currently open file.
' Assumes:  The Open File button has been pushed.
'**************************************************************************
Private Sub LoadFileInfo()
    With mclsDialog
        picFileInfo.Cls
        picFileInfo.Print "CurrentPosition:", Format(.File.CurrentPosition)
        picFileInfo.Print "Extension:", , LCase(.File.Extension)
        picFileInfo.Print "FileLength:", , Format(.File.FileLength)
        picFileInfo.Print "FileName:", , LCase(.File.FileName)
        picFileInfo.Print "FileOpen:", , .File.FileOpen
        picFileInfo.Print "FilePath:", , LCase(.File.FilePath)
        picFileInfo.Print "FullFilePath:", , LCase(.File.FullFilePath)
        picFileInfo.Print "Attributes:"
        picFileInfo.Print vbTab & "Archive  = " & .File.GetAttribute(vbArchive)
        picFileInfo.Print vbTab & "Hidden   = " & .File.GetAttribute(vbHidden)
        picFileInfo.Print vbTab & "Normal   = " & .File.GetAttribute(vbNormal)
        picFileInfo.Print vbTab & "ReadOnly = " & .File.GetAttribute(vbReadOnly)
        picFileInfo.Print vbTab & "System   = " & .File.GetAttribute(vbSystem)
    End With
End Sub
'**************************************************************************
' Purpose:  A test procedure for several of the clsFileIO properties and
'           methods.
' Assumes:  The Build File button has been pushed.
'**************************************************************************
Private Sub BuildFile()
    Dim clsFile(3) As New clsFileIO ' 3 files opened.
    Dim bytByte As Byte             ' Byte of data to read/write.
    Dim strArray(3) As String       ' Array to write to file.

    If Not clsFile(0).OpenFile("c:\autoexec.bat", True) Then Exit Sub
    If Not clsFile(1).OpenFile("c:\config.sys", True) Then Exit Sub
    If Not clsFile(2).CreateFile("c:\trash.txt") Then Exit Sub
    With clsFile(2)
        .WriteString clsFile(0).Read
        .WriteString clsFile(1).Read
        .FileSeek 125
        .WriteString "Byte 125"
        picFileInfo.Cls
        .MoveBOF
        strArray(0) = clsFile(0).FileName
        strArray(1) = clsFile(1).FileName
        strArray(2) = .FileName
        .WriteArrayToFile strArray
        .MoveEOF
        .FileSeek .CurrentPosition - 4
        .WriteString "EOF"
        bytByte = Asc("Z")
        .PutByte bytData:=bytByte, vntFilePosition:=3
        picFileInfo.Print "config.sys first found at byte " & _
            .Find(strFindWhat:="config.sys", blnCaseSensitive:=False, vntStartPosition:=10)
        bytByte = .GetByte(vntFilePosition:=3)
        picFileInfo.Print Chr(bytByte) & " was found at byte 3"
        picFileInfo.Print .ReplaceAll(strFindWhat:="DOS", strReplaceWith:="<<DOS REPLACED>>", blnCaseSensitive:=False) & _
            " occurences of DOS have been replaced."
        .LoadTextBox txt
        .Clear
        picFileInfo.Print .FileName & " is now " & FileLen(.FullFilePath) & " bytes."
        .Delete
        picFileInfo.Print "File destroyed!"
    End With
End Sub
