VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "clsFileDialog"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
'**************************************************************************
' FILEDLG.CLS - Provides a common dialog interface to clsFileIO's OpenFile'
'               method.
'**************************************************************************
Option Explicit
'--------------------------------------------------------------------------
' Class-specific private constants.
'--------------------------------------------------------------------------
Private Const DEFAULT_EXT = "txt"
Private Const DEFAULT_FILTER = "All Files (*.*)|*.*"
Private Const DEFAULT_FLAGS_OPEN = cdlOFNFileMustExist Or cdlOFNHideReadOnly
'--------------------------------------------------------------------------
' Class-specific private variables.
'--------------------------------------------------------------------------
Private clsFile As New clsFileIO
Private dlg As CommonDialog
'**************************************************************************
' Purpose:  To get a reference to an existing common dialog control.
'**************************************************************************
Public Property Set CommonDialogControl(dlgCommonDialog As CommonDialog)
    Set dlg = dlgCommonDialog
End Property
'**************************************************************************
' Purpose:  To get a external reference to clsFile.
'**************************************************************************
Public Property Get File() As clsFileIO
    Set File = clsFile
End Property
'**************************************************************************
' Purpose:  To free clsFile.
'**************************************************************************
Private Sub Class_Terminate()
    Set clsFile = Nothing
End Sub
'**************************************************************************
' Purpose:  To display a FileOpen dialog box and to intialize clsFile.
' Inputs:   Optional arguments allow the caller to change the visual
'           appearance of the FileOpen dialog.
' Outputs:  Whether or not the file was sucessfully opened.
'**************************************************************************
Public Function OpenFile(Optional vntDefaultExt, Optional vntFlags, _
                                Optional vntFilter, Optional vntFilterIndex)
    Dim intScreenPointer As Integer
    On Error Resume Next
    intScreenPointer = Screen.MousePointer
    With dlg
        .CancelError = True
        .DefaultExt = IIf(IsMissing(vntDefaultExt), DEFAULT_EXT, vntDefaultExt)
        .Flags = IIf(IsMissing(vntFlags), DEFAULT_FLAGS_OPEN, vntFlags)
        .Filter = IIf(IsMissing(vntFilter), DEFAULT_FILTER, vntFilter)
        .FilterIndex = IIf(IsMissing(vntFilterIndex), 1, vntFilterIndex)
        .ShowOpen
        Screen.MousePointer = vbHourglass
        If Not Err Then
            OpenFile = clsFile.OpenFile(.FileName, False)
        Else
            OpenFile = False
        End If
        Screen.MousePointer = intScreenPointer
    End With
End Function
