Attribute VB_Name = "CountLines"
'****************************************************************
' Name: Count_Lines_In_File
'     ' Description: Counts the number of lines in a file
'
' Inputs: strPath--file to read

' Returns: returns number of lines in file strPath or -1 if strPath doesn't exist
' Assumes: None
' Side Effects: None
'
'****************************************************************

Function Count_Lines_In_File(ByVal strFilePath As String) As Integer

       '     'delcare variables
       Dim fileFile As Integer
       Dim intLinesReadCount As Integer
       intLinesReadCount = 0
       '     'open file
       fileFile = FreeFile

              If (File_Exists(strFilePath)) Then
                     Open strFilePath For Input As fileFile
              Else
                           'file doesn't exist
                     MsgBox "File: " & strFilePath & " hasn't been downloaded yet. Preprocessing is being aborted.", MB_OK, "File Does Not Exist"
                     Count_Lines_In_File = -1
                     Exit Function
              End If

             'loop through file
       Dim strBuffer As String

              Do While Not EOF(fileFile)
                           'read line
                     Input #fileFile, strBuffer
                           'update count
                     intLinesReadCount = intLinesReadCount + 1
              Loop

             'close file
       Close fileFile
             'return value
       Count_Lines_In_File = intLinesReadCount
End Function
