Attribute VB_Name = "modFuncoes"
Option Explicit

'---------------------------------------------------------------------------------------
' Procedure  : CriarLog
' Criado em  : 01/08/2005
' Autor      : Vilmar Brazo de Oliveira
' Objetivo   : Cria log em caso de erro, e manda mensagem para a tela, caso necessrio.
'---------------------------------------------------------------------------------------
'
Public Sub CriarLog(ByVal strTexto As String, Optional ByVal blnPromptOnError As Boolean = False)
    On Error GoTo Erro_CriarLog
    
    Dim strCaminho As String
    strCaminho = App.Path
    
    If InStr(Mid(strCaminho, Len(strCaminho), 1), "\") <> 1 Then
        strCaminho = strCaminho & "\"
    End If
    
    Open strCaminho & App.EXEName & ".log" For Append As #1
    Print #1, CStr(Now) & " - " & App.EXEName & ": " & strTexto
    Close #1
    
    If FileLen(strCaminho & App.EXEName & ".log") > 200 * CLng(1024) Then
        FileCopy strCaminho & App.EXEName & ".log", strCaminho & App.EXEName & ".bak"
        Kill strCaminho & App.EXEName & ".log"
    End If

    'Mostra mensagem com erro se este parmetro for = True
    If blnPromptOnError Then
        MsgBox App.EXEName & ": " & strTexto, vbCritical, "Notificao de Erro"
    End If

    Exit Sub
    
Erro_CriarLog:
    On Error GoTo 0
End Sub
