VERSION 5.00
Object = "{5E9E78A0-531B-11CF-91F6-C2863C385E30}#1.0#0"; "Msflxgrd.ocx"
Begin VB.Form frmAlunos 
   Caption         =   "Alunos - Acesso a BD com ADO (Access 2000/XP)"
   ClientHeight    =   3390
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   6840
   Icon            =   "frmAlunos.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3390
   ScaleWidth      =   6840
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdFechar 
      Caption         =   "&Fechar"
      Height          =   300
      Left            =   4440
      TabIndex        =   4
      Top             =   2880
      Width           =   975
   End
   Begin VB.CommandButton cmdDAO 
      Caption         =   "E&xemplo DAO"
      Height          =   300
      Left            =   5520
      TabIndex        =   5
      Top             =   2880
      Width           =   1150
   End
   Begin VB.CommandButton cmdExcluir 
      Caption         =   "&Excluir"
      Height          =   300
      Left            =   3360
      TabIndex        =   3
      Top             =   2880
      Width           =   975
   End
   Begin VB.CommandButton cmdAlterar 
      Caption         =   "&Alterar"
      Height          =   300
      Left            =   2280
      TabIndex        =   2
      Top             =   2880
      Width           =   975
   End
   Begin VB.CommandButton cmdIncluir 
      Caption         =   "&Incluir"
      Height          =   300
      Left            =   1200
      TabIndex        =   1
      Top             =   2880
      Width           =   975
   End
   Begin VB.CommandButton cmdListar 
      Caption         =   "&Listar"
      Height          =   300
      Left            =   120
      TabIndex        =   0
      Top             =   2880
      Width           =   975
   End
   Begin MSFlexGridLib.MSFlexGrid grdAlunos 
      Height          =   2415
      Left            =   240
      TabIndex        =   6
      Top             =   120
      Width           =   5895
      _ExtentX        =   10398
      _ExtentY        =   4260
      _Version        =   393216
      Rows            =   1
      Cols            =   4
      FixedRows       =   0
      FixedCols       =   0
      HighLight       =   2
      AllowUserResizing=   1
   End
End
Attribute VB_Name = "frmAlunos"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdAlterar_Click()
On Error GoTo Handle_Error
    
    'Verifica se foi selecionada alguma clula a ser alterada
    If grdAlunos.RowSel < 1 Then
        MsgBox "Favor escolher uma clula no grid.", vbCritical, "Aviso"
        grdAlunos.SetFocus
        Exit Sub
    Else
        frmAlunosAlteracao.m_lngCodigoSelecionado = Val(grdAlunos.TextMatrix(grdAlunos.RowSel, 0))
        frmAlunosAlteracao.Show
    End If
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / cmdAlterar_Click) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Private Sub cmdDAO_Click()
On Error GoTo Handle_Error
    
    Call frmAlunos.Hide
    Call frmAlunosAccess97.Show
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / cmdDAO_Click) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Private Sub cmdExcluir_Click()
On Error GoTo Handle_Error
    
    'Verifica se foi selecionada alguma clula a ser alterada
    If grdAlunos.RowSel < 1 Then
        MsgBox "Favor escolher uma clula no grid.", vbCritical, "Aviso"
        grdAlunos.SetFocus
        Exit Sub
    Else
        frmAlunosExclusao.m_lngCodigoSelecionado = Val(grdAlunos.TextMatrix(grdAlunos.RowSel, 0))
        frmAlunosExclusao.Show
    End If
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / cmdExcluir_Click) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Private Sub cmdFechar_Click()
On Error GoTo Handle_Error

    End 'Encerra a aplicao
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / cmdFechar_Click) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Private Sub cmdIncluir_Click()
On Error GoTo Handle_Error
    
    Call frmAlunosInclusao.Show

'    Dim objCommand As ADODB.Command ' Objeto Command
'
'    Set objCommand = New ADODB.Command
'    objCommand.ActiveConnection = m_objConexao ' Informa qual conexo usar
'
'    objCommand.CommandText = "INSERT INTO Alunos(Codigo,Nome,RG,DataCadastro) VALUES(1,'Sergio','35645034-3',#" & Now & "#)"
'
'    objCommand.Execute  ' Executa o Comando, que foi definido no objCommand.CommandText
'
'    Call cmdListar_Click 'Lista as alteraes
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / cmdIncluir_Click) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Private Sub cmdListar_Click()
On Error GoTo Handle_Error

    Dim objRS   As ADODB.Recordset
    Dim strSQL  As String
    Dim lngLoop As Long
     
    strSQL = "SELECT * FROM Alunos ORDER BY Codigo"

    Set objRS = New ADODB.Recordset
    objRS.Open strSQL, m_objConexao, adOpenDynamic, adLockReadOnly, adCmdText

    With grdAlunos
        'Limpa ltimos valores listados no grid
        While Not .Rows = 1
            .RemoveItem (1)
        Wend
        
        Do While Not objRS.EOF
            .AddItem Empty
            
            lngLoop = .Rows - 1
            
            .Row = lngLoop 'Define a linha selecionada
            
            'Atribui valores para as clulas do grid
            .Col = 0 'Define a coluna selecionada
            .TextMatrix(lngLoop, 0) = objRS("Codigo")
            .CellAlignment = flexAlignLeftBottom
            
            .Col = 1 'Define a coluna selecionada
            .TextMatrix(lngLoop, 1) = objRS("Nome")
            .CellAlignment = flexAlignLeftBottom
            
            .Col = 2 'Define a coluna selecionada
            .TextMatrix(lngLoop, 2) = objRS("RG")
            .CellAlignment = flexAlignLeftBottom
                        
            .Col = 3 'Define a coluna selecionada
            .TextMatrix(lngLoop, 3) = objRS("DataCadastro")
            .CellAlignment = flexAlignLeftBottom
                        
            objRS.MoveNext 'Move para o prximo registro
        Loop
        
        .Rows = lngLoop + 1 'Retira linhas em branco do final do grid
    End With
    
    objRS.Close
    Set objRS = Nothing

    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / cmdListar_Click) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Private Sub Form_Load()
On Error GoTo Handle_Error

    Call InitializarLayoutFormControles
    Call InitializarLayoutGrid
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / Form_Load) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

' Atribui os valores padres para o formulrio e seus controles
Public Sub InitializarLayoutFormControles()
On Error GoTo Handle_Error
    
    Me.Width = 10000
    Me.Height = 4500
    
    cmdListar.Left = 120
    cmdIncluir.Left = 1200
    cmdAlterar.Left = 2280
    cmdExcluir.Left = 3360
    cmdFechar.Left = 4440
    cmdDAO.Left = 5520
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / InitializarLayoutForm) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

' Atribui os valores padres para o grid
Public Sub InitializarLayoutGrid()
On Error GoTo Handle_Error
    
    Dim intLoop         As Integer
    
    With grdAlunos
        .Clear
        .Rows = 1
        
        'Evita flicker (piscada) do grid
        .Redraw = False
    
        .AllowBigSelection = False
        .AllowUserResizing = flexResizeColumns
        .FillStyle = flexFillRepeat
        
        .BorderStyle = flexBorderNone
        
        .ScrollBars = flexScrollBarVertical
            
        .BackColor = 12632256 'Tom de Cinza
        
'        .Width = Me.Width
'        .Height = Me.Height - 400
        .Left = 0
        .Top = 0
    
        ' Aparncia cabealho
        .Row = 0  'Define a linha selecionada
        .RowHeight(0) = 225
        
        ' Lao para alterar a formatao das 4 primeiras colunas(compras)
        For intLoop = 0 To 3
            .Col = intLoop 'Define a coluna selecionada
                        
            Select Case intLoop
                Case 0
                    .TextMatrix(0, 0) = "Cdigo"
'                    .ColWidth(0) = 2000
                Case 1
                    .TextMatrix(0, 1) = "Nome"
'                    .ColWidth(1) = 3000
                Case 2
                    .TextMatrix(0, 2) = "RG"
'                    .ColWidth(2) = 2500
                Case 3
                    .TextMatrix(0, 3) = "Data Cadastro"
'                    .ColWidth(3) = 2500
            End Select
                        
            .CellAlignment = flexAlignCenterCenter
            .CellFontName = "MS Sans Serif"
            .CellForeColor = vbBlack
            .CellFontSize = 8
            .CellFontBold = True
            .CellFontItalic = False
            .CellBackColor = 4227200 'Tom de verde oliva
        Next
        
        'Habilita a repintura do grid
        .Redraw = True
    End With
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / InitializarLayoutGrid) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Private Sub Form_Resize()
On Error GoTo Handle_Error

    Dim dblLarguraGrid  As Double
    Dim intLoop         As Integer
    
    'Controle de altura e largura mnima do formulrio
    If Me.Width < 3000 Then
        Me.Width = 3000
    End If
    
    If Me.Height < 2000 Then
        Me.Height = 2000
    End If

    With grdAlunos
        .Width = Me.Width - 150
        .Height = Me.Height - 1000
        
        dblLarguraGrid = .Width - LARGURA_SCROLL
         
        ' Atribui largura para cada coluna conforme o formulrio for redimensionado.
        For intLoop = 0 To 3
            .ColWidth(intLoop) = .ColWidth(intLoop) * dblLarguraGrid
            
            'Define a largura das colunas
            Select Case intLoop
                Case 0 'Cdigo 13%
                    .ColWidth(0) = 0.13 * dblLarguraGrid
                Case 1 'Nome 35%
                    .ColWidth(1) = 0.35 * dblLarguraGrid
                Case 2 'RG 30%
                    .ColWidth(2) = 0.3 * dblLarguraGrid
                Case 3 'Data Cadastro 22%
                    .ColWidth(3) = 0.22 * dblLarguraGrid
            End Select
        Next
    End With
    
    cmdListar.Top = grdAlunos.Height + 100
    cmdIncluir.Top = grdAlunos.Height + 100
    cmdAlterar.Top = grdAlunos.Height + 100
    cmdExcluir.Top = grdAlunos.Height + 100
    cmdFechar.Top = grdAlunos.Height + 100
    cmdDAO.Top = grdAlunos.Height + 100
        
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / Form_Resize) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Public Sub Listar()
On Error GoTo Handle_Error

    Call cmdListar_Click 'Lista as alteraes
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / Listar) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

Private Sub Form_Unload(Cancel As Integer)
On Error GoTo Handle_Error

    Call cmdFechar_Click
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / Form_Unload) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub

' Recebe o Cdigo a ser alterado e abre a tela de alterao
Private Sub grdAlunos_DblClick()
On Error GoTo Handle_Error

    If grdAlunos.RowSel < 1 Then
        MsgBox "Favor escolher uma clula no grid.", vbCritical, "Aviso"
        grdAlunos.SetFocus
        Exit Sub
    Else
        frmAlunosAlteracao.m_lngCodigoSelecionado = Val(grdAlunos.TextMatrix(grdAlunos.RowSel, 0))
        frmAlunosAlteracao.Show
    End If
    
    Exit Sub

Handle_Error:
    Call CriarLog("(frmAlunos / Form_Unload) - " & Err.Description & "(" & Err.Number & ")", False)
End Sub
