VERSION 4.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4020
   ClientLeft      =   1140
   ClientTop       =   1515
   ClientWidth     =   8055
   Height          =   4425
   Left            =   1080
   LinkTopic       =   "Form1"
   ScaleHeight     =   4020
   ScaleWidth      =   8055
   Top             =   1170
   Width           =   8175
   Begin VB.PictureBox picScore 
      AutoRedraw      =   -1  'True
      Height          =   3615
      Left            =   4080
      ScaleHeight     =   3555
      ScaleWidth      =   3915
      TabIndex        =   1
      Top             =   0
      Width           =   3975
   End
   Begin VB.PictureBox picAge 
      AutoRedraw      =   -1  'True
      Height          =   3615
      Left            =   0
      ScaleHeight     =   3555
      ScaleWidth      =   3915
      TabIndex        =   0
      Top             =   0
      Width           =   3975
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Test Scores"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Times New Roman"
         Size            =   15.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   1
      Left            =   4080
      TabIndex        =   3
      Top             =   3600
      Width           =   3975
   End
   Begin VB.Label Label1 
      Alignment       =   2  'Center
      Caption         =   "Ages"
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Times New Roman"
         Size            =   15.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Index           =   0
      Left            =   0
      TabIndex        =   2
      Top             =   3600
      Width           =   3975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
Option Explicit

#Const DEBUG_MSGS = 0

Private Const NUM_TESTS = 5

' A record for a student.
Private Type StudentRecord
    LastName As String
    FirstName As String
    Age As Integer
    StudentID As Integer
    Score(1 To NUM_TESTS) As Integer
End Type

Private NumStudents As Integer
Private Students() As StudentRecord
' Graph the age data.
Private Sub GraphAges()
Dim student As Integer
Dim lft As Single
Dim i As Integer
Dim the_age As Integer
Dim txt As String
Dim font_hgt As Single

    ' Make a convenient scale.
    lft = -NumStudents / 10
    picAge.Scale (lft, 21)-(NumStudents + 0.25, -4)
    font_hgt = 1.2 * picAge.TextHeight("X")
    
    ' Draw the axes.
    picAge.Line (0, 20)-(0, 0)
    picAge.Line -(NumStudents, 0)
    For i = 1 To 19
        picAge.Line (-lft / 6, i)-Step(lft / 3, 0)
    Next i

    For student = 1 To NumStudents
        ' Draw the student's histogram.
        the_age = Students(student).Age
        FillColor = QBColor(student Mod 8)
        picAge.Line (student - 1, 0)- _
            (student, the_age), _
            QBColor(student Mod 8), BF

        picAge.Line (student - 1, 0)- _
            (student, the_age), _
            vbBlack, B
        
        ' Draw the student's age.
        txt = Format$(the_age)
        picAge.CurrentX = student - 0.5 - _
            picAge.TextWidth(txt) / 2
        picAge.CurrentY = the_age - font_hgt
        picAge.Print txt
    
        ' Draw the student's name.
        txt = Students(student).FirstName
        picAge.CurrentX = student - 0.5 - _
            picAge.TextWidth(txt) / 2
        picAge.CurrentY = font_hgt * 0.5
        picAge.Print txt
    
        txt = Students(student).LastName
        picAge.CurrentX = student - 0.5 - _
            picAge.TextWidth(txt) / 2
        picAge.CurrentY = font_hgt * 1.5
        picAge.Print txt
    Next student
End Sub
' Graph the test score data.
Private Sub GraphScores()
Dim test As Integer
Dim lft As Single
Dim i As Integer
Dim the_score As Integer
Dim txt As String
Dim font_hgt As Single
Dim student As Integer

    ' Make a convenient scale.
    lft = -NUM_TESTS / 10
    picScore.Scale (1 + lft, 110)-(NUM_TESTS + 0.25, -10)
    font_hgt = picScore.TextHeight("X")

    ' Draw the axes.
    picScore.Line (1, 100)-(1, 0)
    picScore.Line -(NUM_TESTS, 0)
    For i = 10 To 100 Step 10
        picScore.Line (1 - lft / 6, i)-Step(lft / 3, 0)
        txt = Format$(i)
        picScore.CurrentX = 1 + lft / 4 - picScore.TextWidth(txt)
        picScore.CurrentY = i - font_hgt / 2
        picScore.Print txt
    Next i
    font_hgt = font_hgt * 1.2
    picScore.DrawStyle = vbDot
    For test = 1 To NUM_TESTS
        picScore.Line (test, 0)-(test, 100)
        txt = Format$(test)
        picScore.CurrentX = test - picScore.TextWidth(txt) / 2
        picScore.CurrentY = font_hgt / 3
        picScore.Print txt
    Next test
    picScore.DrawStyle = vbSolid
    
    ' Graph the scores.
    For student = 1 To NumStudents
        ' Use a different color.
        picScore.ForeColor = QBColor(student Mod 8)

        the_score = Students(student).Score(1)
        picScore.CurrentX = 1
        picScore.CurrentY = the_score
        For test = 2 To NUM_TESTS
            the_score = Students(student).Score(test)
            picScore.Line -(test, the_score)
        Next test
    Next student
End Sub

' Load the data from the database.
Private Sub LoadData()
Dim ws As Workspace
Dim db As Database
Dim student_rs As Recordset
Dim score_rs As Recordset
Dim query As String

    ' Use the default workspace.
    Set ws = DBEngine.Workspaces(0)

    ' Open the database.
    Set db = ws.OpenDatabase(App.Path & "\graphdb.mdb")

    ' Create a Recordset to read name,
    ' ID, and age information.
    query = _
        "SELECT FirstName, LastName, " & _
        "StudentID, Age FROM Students " & _
        "ORDER BY StudentID"
    Set student_rs = _
        db.OpenRecordset(query, dbOpenSnapshot)

    ' Read the name, ID, and age information.
    With student_rs
        Do While Not .EOF
            NumStudents = NumStudents + 1
            ReDim Preserve Students(1 To NumStudents)
            Students(NumStudents).LastName = !LastName
            Students(NumStudents).FirstName = !FirstName
            Students(NumStudents).Age = !Age
            Students(NumStudents).StudentID = !StudentID
        
            #If DEBUG_MSGS = 1 Then
                Debug.Print _
                    Students(NumStudents).FirstName & " " & _
                    Students(NumStudents).LastName & ", Age: " & _
                    Students(NumStudents).Age & ", ID: " & _
                    Students(NumStudents).StudentID
            #End If
        
            ' Get this student's test scores.
            query = _
                "SELECT TestNumber, Score FROM " & _
                "TestScores WHERE StudentID=" & _
                !StudentID & _
                " ORDER BY TestNumber"
            Set score_rs = _
                db.OpenRecordset(query, dbOpenSnapshot)
            Do While Not score_rs.EOF
                Students(NumStudents).Score( _
                    score_rs!TestNumber) = _
                    score_rs!Score
                    
                #If DEBUG_MSGS = 1 Then
                    Debug.Print _
                        "    Score(" & _
                        Format$(score_rs!TestNumber) & ") = " & _
                        Students(NumStudents).Score( _
                        score_rs!TestNumber)
                #End If
                
                score_rs.MoveNext
            Loop
            score_rs.Close

            ' Go get the next student record.
            .MoveNext
        Loop
    End With
    student_rs.Close
    
    ' Close the workspace.
    ws.Close
End Sub

Private Sub Form_Load()
    ' Load the data.
    LoadData

    ' Graph the age data.
    GraphAges
    
    ' Graph the test score data.
    GraphScores
End Sub
