Attribute VB_Name = "modGeral"
Option Explicit

Public Const REG_NOME_APLICACAO = "TESTEWEBCONTROL"

Public Sub Main()
    On Error GoTo Main_Error

    ' Abre conexo com banco de dados
    Call AbrirConexaoBD
    
    'Abre o formulrio principal
    frmMDIPrincipal.Show

    On Error GoTo 0
    Exit Sub

Main_Error:
    Call CriarLog("ERRO - Main of Module modGeral - " & Err.Number & " - " & Err.Description)
End Sub

Public Sub ReplaceRich(ByVal objrichedit As RichTextBox, ByVal strSubstituir As String, ByVal strPorIsso As String)
    On Error GoTo ReplaceRich_ERRO
    
    Dim posReplace As Long ' Posio a ser modificada
    
    posReplace = InStr(1, objrichedit.Text, strSubstituir)
    objrichedit.SelStart = posReplace - 1
    objrichedit.SelLength = Len(strSubstituir)
    objrichedit.SelText = strPorIsso
    
    Exit Sub
    
ReplaceRich_ERRO:
    Call CriarLog("ERRO ReplaceRich - " & Err.num & " - " & Err.Description)
End Sub

Public Sub Start_tmrOut(ByVal objFormulario As Form, ByVal lngIntervalo As Long, Optional strMensagem As String, Optional blnStart As Boolean = True)
    On Error GoTo Start_tmrOut_Error

    If blnStart Then
        objFormulario.lblSplash.Caption = strMensagem
        objFormulario.lblSplash.Visible = True
        objFormulario.tmrOut.Interval = 60000 'timeout de 1 minuto.
        objFormulario.tmrOut.Enabled = True
        objFormulario.picSplash.Visible = True
    Else
        objFormulario.lblSplash.Visible = False
        objFormulario.tmrOut.Interval = 60000 'timeout de 1 minuto.
        objFormulario.tmrOut.Enabled = False
        objFormulario.picSplash.Visible = False
    End If

    On Error GoTo 0
    Exit Sub

Start_tmrOut_Error:
    Call CriarLog("ERRO - Start_tmrOut of Module modGeral - " & Err.Number & " - " & Err.Description)
End Sub

'Adiciona os itens a tabela HTML que ser exibida no componente WebControl
'Exemplo puxando os dados de componente LABEL
Public Sub AdicionarItensTabelaLabel()
    On Error GoTo AdicionarItensTabelaLabel_Error
    
    Dim strCabecalho As String ' String de auxilio do cabealho
    Dim strCaminho As String   ' Caminho com local da imagem de logo

    With frmWebControlLabel
        'INCIO: Montagem e atribuio do cabealho
        strCaminho = App.Path
        
        If InStr(Mid(strCaminho, Len(strCaminho), 1), "\") <> 1 Then
            strCaminho = strCaminho & "\"
        End If
    
        strCaminho = strCaminho & "logo.bmp"
        
        SavePicture .picLogo.Image, strCaminho
        
        strCabecalho = "<table><tr><td align='center' valign='center'><img src='logo.bmp'></td>"
        strCabecalho = strCabecalho & "<td><table>"
        strCabecalho = strCabecalho & "<tr><td class = 'TextoPadrao'><b>Empresa: </b>" & .lblEmpresa.Caption & "</td></tr>"
        strCabecalho = strCabecalho & "<tr><td class = 'TextoPadrao'><b>Fone:</b> " & .lblFone.Caption & "</td></tr>"
        strCabecalho = strCabecalho & "<tr><td class = 'TextoPadrao'><b>Site:</b> " & .lblSite.Caption & "</td></tr>"
        strCabecalho = strCabecalho & "<tr><td class = 'TextoPadrao'><b>CNPJ:</b> " & .lblCNPJ.Caption & "</td></tr>"
        strCabecalho = strCabecalho & "</table>"                                                                          ' Fecha tabela interna
        strCabecalho = strCabecalho & "</td></tr></table>"                                                                ' Fecha tabela externa
        
        Call ReplaceRich(.rtxHTMLModificado, "#1#", strCabecalho)
        'FIM: Montagem e atribuio do cabealho
    
        'INCIO: Atribuio dos demais dados
        Call ReplaceRich(.rtxHTMLModificado, "#2#", "Cdigo:") 'Campo
        Call ReplaceRich(.rtxHTMLModificado, "#3#", 9999999)  'Valor
        
        Call ReplaceRich(.rtxHTMLModificado, "#4#", "Nome:")
        Call ReplaceRich(.rtxHTMLModificado, "#5#", "Jos da Silva Xavier")
        
        Call ReplaceRich(.rtxHTMLModificado, "#6#", "RG:")
        Call ReplaceRich(.rtxHTMLModificado, "#7#", "29.987.852-2")
        
        Call ReplaceRich(.rtxHTMLModificado, "#8#", "Data Cadastro:")
        Call ReplaceRich(.rtxHTMLModificado, "#9#", "12/05/1998")
        'FIM: Atribuio dos demais dados
        
        Call Start_tmrOut(frmWebControlLabel, 60000, , False)
        
        Call GerarVisualizacaoFormLabel
    End With
            
    On Error GoTo 0
    Exit Sub

AdicionarItensTabelaLabel_Error:
    Call CriarLog("ERRO - AdicionarItensTabelaLabel of Module modGeral - " & Err.Number & " - " & Err.Description)
End Sub

' Aps a pesquisa gera a visualizao do extrato na Tela
Public Sub GerarVisualizacaoFormLabel()
    On Error GoTo GerarVisualizacaoFormLabel_Error

    On Error GoTo GerarVisualizacaoFormLabel_Error

    Dim strArquivoHTML As String
    
    strArquivoHTML = App.Path
    
    If InStr(Mid(strArquivoHTML, Len(strArquivoHTML), 1), "\") <> 1 Then
        strArquivoHTML = strArquivoHTML & "\" & "relatorio_webcontrol.htm"
    Else
        strArquivoHTML = strArquivoHTML & "relatorio_webcontrol.htm"
    End If
    
    Open strArquivoHTML For Output As #1
    Print #1, frmWebControlLabel.rtxHTMLModificado.Text
    Close #1

    frmWebControlLabel.webRelatorio.Navigate2 strArquivoHTML

    On Error GoTo 0
    Exit Sub

GerarVisualizacaoFormLabel_Error:
    Call CriarLog("ERRO - GerarVisualizacaoFormLabel of Module modGeral - " & Err.Number & " - " & Err.Description)
End Sub

' Aps a pesquisa gera a visualizao do extrato na Tela
Public Sub GerarVisualizacaoFormADO()
    On Error GoTo GerarVisualizacaoFormADO_Error

    Dim strArquivoHTML As String
    
    strArquivoHTML = App.Path
    
    If InStr(Mid(strArquivoHTML, Len(strArquivoHTML), 1), "\") <> 1 Then
        strArquivoHTML = strArquivoHTML & "\" & "relatorio_webcontrol.htm"
    Else
        strArquivoHTML = strArquivoHTML & "relatorio_webcontrol.htm"
    End If
    
    Open strArquivoHTML For Output As #1
    Print #1, frmWebControlADO.rtxHTMLModificado.Text
    Close #1

    frmWebControlADO.webRelatorio.Navigate2 strArquivoHTML

    On Error GoTo 0
    Exit Sub

GerarVisualizacaoFormADO_Error:
    Call CriarLog("ERRO - GerarVisualizacaoFormADO of Module modGeral - " & Err.Number & " - " & Err.Description)
End Sub

'Adiciona os itens a tabela HTML que ser exibida no componente WebControl
'Exemplo recebendo os dados usando o componente ADO (Activex Data Object)
Public Sub AdicionarItensTabelaADO()
    On Error GoTo AdicionarItensTabelaADO_Error
    
    Dim objRS   As Object
    Dim strSQL  As String
     
    Dim strCabecalho   As String   ' String de auxilio do cabealho
    Dim strCaminho     As String   ' Caminho com local da imagem de logo
    Dim strTabela As String    ' Tabela HTML com informaes do banco de dados
    
    With frmWebControlADO
        'INCIO: Montagem e atribuio do cabealho
        strCaminho = App.Path
        
        If InStr(Mid(strCaminho, Len(strCaminho), 1), "\") <> 1 Then
            strCaminho = strCaminho & "\"
        End If
    
        strCaminho = strCaminho & "logo.bmp"
        
        SavePicture .picLogo.Image, strCaminho
        
        strCabecalho = "<table><tr><td align='center' valign='center'><img src='logo.bmp'></td>"
        strCabecalho = strCabecalho & "<td><table>"
        strCabecalho = strCabecalho & "<tr><td class = 'TextoPadrao'><b>Empresa: </b>Fbrica de Parafuso Chic Ltda.</td></tr>"
        strCabecalho = strCabecalho & "<tr><td class = 'TextoPadrao'><b>Fone:</b> (11) 7774-8599</td></tr>"
        strCabecalho = strCabecalho & "<tr><td class = 'TextoPadrao'><b>Site:</b> http://www.fpc.ind.br</td></tr>"
        strCabecalho = strCabecalho & "<tr><td class = 'TextoPadrao'><b>CNPJ:</b> 09.555.741.0001/87</td></tr>"
        strCabecalho = strCabecalho & "</table>"                                                                          ' Fecha tabela interna
        strCabecalho = strCabecalho & "</td></tr></table>"                                                                ' Fecha tabela externa
        
        Call ReplaceRich(.rtxHTMLModificado, "#1#", strCabecalho)
        'FIM: Montagem e atribuio do cabealho
    
        'INCIO: Atribuio dos demais dados
        strSQL = "SELECT * FROM Alunos ORDER BY Codigo"
        
        strTabela = "<table>"
        
        Set objRS = New ADODB.Recordset
        objRS.Open strSQL, m_objConexao, adOpenDynamic, , adCmdText
    
        Do While Not objRS.EOF
            strTabela = strTabela & "<tr><td class = 'TextoPadrao'><b>Cdigo: </b>" & objRS!Codigo & "</td>"
            strTabela = strTabela & "<td class = 'TextoPadrao'><b>Nome: </b>" & objRS!Nome & "</td>"
            strTabela = strTabela & "<td class = 'TextoPadrao'><b>RG: </b>" & objRS!RG & "</td>"
            strTabela = strTabela & "<td class = 'TextoPadrao'><b>Data Cadastro: </b>" & objRS!DataCadastro & "</td></tr>"
            objRS.MoveNext
        Loop
        
        strTabela = strTabela & "</table>"
        
        objRS.Close
        Set objRS = Nothing
        
        Call ReplaceRich(.rtxHTMLModificado, "#2#", strTabela)
        'FIM: Atribuio dos demais dados
        
        Call Start_tmrOut(frmWebControlADO, 60000, , False)
        
        Call GerarVisualizacaoFormADO
    End With
     
    On Error GoTo 0
    Exit Sub

AdicionarItensTabelaADO_Error:
    Call CriarLog("ERRO - AdicionarItensTabelaADO of Module modGeral - " & Err.Number & " - " & Err.Description)
End Sub
