Attribute VB_Name = "modTray"
Option Explicit

Public Declare Function Shell_NotifyIcon Lib "shell32" Alias "Shell_NotifyIconA" (ByVal dwMessage As Long, lpData As NOTIFYICONDATA) As Long

Public Type NOTIFYICONDATA
        cbSize As Long
        hwnd As Long
        uID As Long
        uFlags As Long
        uCallbackMessage As Long
        hIcon As Long
        szTip As String * 64
End Type

Global NID As NOTIFYICONDATA

Global Const NIM_ADD = &H0
Global Const NIM_MODIFY = &H1
Global Const NIM_DELETE = &H2
Global Const WM_MOUSEMOVE = &H200

Global Const NIF_MESSAGE = &H1
Global Const NIF_ICON = &H2
Global Const NIF_TIP = &H4

Global Const WM_LBUTTONDBLCLK = &H203
Global Const WM_LBUTTONDOWN = &H201
Global Const WM_LBUTTONUP = &H202


Global Const WM_RBUTTONDBLCLK = &H206
Global Const WM_RBUTTONDOWN = &H204
Global Const WM_RBUTTONUP = &H205

Public Function SendToTray(Optional Icon = "", Optional Caption As String = "", Optional Form As Form, Optional Operation As Integer = 0)
    
    If Operation = 0 Then
        
        NID.cbSize = Len(NID)
        NID.hwnd = Form.hwnd
        NID.uID = vbNull
        NID.uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
        NID.uCallbackMessage = WM_MOUSEMOVE
        NID.hIcon = Icon
        NID.szTip = Caption & vbNullChar
        Shell_NotifyIcon NIM_ADD, NID
        Form.Visible = False
        
    ElseIf Operation = 1 Then
        Shell_NotifyIcon NIM_DELETE, NID
        Form.Visible = True
        
    ElseIf Operation = 2 Then
        Shell_NotifyIcon NIM_DELETE, NID
        
    End If
End Function

Sub ModifyTray(Icon, Caption As String, Form As Form)
         
         NID.cbSize = Len(NID)
         NID.hwnd = Form.hwnd
         NID.uID = vbNull
         NID.uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
         NID.uCallbackMessage = WM_MOUSEMOVE
         NID.hIcon = Icon
         Shell_NotifyIcon NIM_MODIFY, NID
         NID.szTip = Caption & vbNullChar

         Shell_NotifyIcon NIM_MODIFY, NID
End Sub

Function RespondToTray(X As Single, Form As Form) As Integer
            Dim msg As Long
            Dim sFilter As String
          
            RespondToTray = 0
          
            If Form.ScaleMode <> 3 Then
                msg = X / Screen.TwipsPerPixelX
            Else
                msg = X
            End If
            
          Select Case msg
             Case WM_LBUTTONDOWN
                RespondToTray = 0
             Case WM_LBUTTONUP
                RespondToTray = 1
             Case WM_LBUTTONDBLCLK
                RespondToTray = 2
             Case WM_RBUTTONDOWN
                RespondToTray = 3
             Case WM_RBUTTONUP
                RespondToTray = 4
             Case WM_RBUTTONDBLCLK
                RespondToTray = 5
          End Select
End Function
