VERSION 5.00
Begin VB.Form frmMain 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "RASGuard"
   ClientHeight    =   5475
   ClientLeft      =   45
   ClientTop       =   210
   ClientWidth     =   4725
   BeginProperty Font 
      Name            =   "Verdana"
      Size            =   8.25
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5475
   ScaleWidth      =   4725
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame grpMain 
      Height          =   5385
      Left            =   90
      TabIndex        =   0
      Top             =   30
      Width           =   4575
      Begin VB.CheckBox chkNotLocal 
         Caption         =   "Only inform PCs below, not this one."
         Height          =   195
         Left            =   420
         TabIndex        =   18
         Top             =   2610
         Width           =   3555
      End
      Begin VB.Timer tmrPoll 
         Enabled         =   0   'False
         Interval        =   60000
         Left            =   690
         Top             =   4800
      End
      Begin VB.Timer tmrCheck 
         Enabled         =   0   'False
         Interval        =   10000
         Left            =   180
         Top             =   4800
      End
      Begin VB.CommandButton cmdExit 
         Cancel          =   -1  'True
         Caption         =   "Exit"
         Height          =   345
         Left            =   3060
         TabIndex        =   17
         Top             =   4920
         Width           =   1275
      End
      Begin VB.CommandButton cmdStart 
         Caption         =   "Start"
         BeginProperty Font 
            Name            =   "Verdana"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   345
         Left            =   1740
         TabIndex        =   16
         Top             =   4920
         Width           =   1275
      End
      Begin VB.Frame grpDiv1 
         Height          =   135
         Left            =   90
         TabIndex        =   15
         Top             =   4680
         Width           =   4245
      End
      Begin VB.CommandButton cmdAdd 
         Caption         =   "Add PC"
         Height          =   345
         Left            =   390
         TabIndex        =   13
         Top             =   4290
         Width           =   1275
      End
      Begin VB.ListBox lstComputers 
         Height          =   1035
         Left            =   390
         TabIndex        =   12
         Top             =   3210
         Width           =   3945
      End
      Begin VB.TextBox txtMsg 
         Height          =   285
         Left            =   420
         MaxLength       =   40
         TabIndex        =   10
         Text            =   "WARNING: Your cut-off time is almost up!"
         Top             =   2250
         Width           =   3945
      End
      Begin VB.CommandButton cmdDown 
         Caption         =   "6"
         BeginProperty Font 
            Name            =   "Webdings"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   3210
         TabIndex        =   7
         Top             =   1590
         Width           =   255
      End
      Begin VB.CommandButton cmdUp 
         Caption         =   "5"
         BeginProperty Font 
            Name            =   "Webdings"
            Size            =   8.25
            Charset         =   2
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   195
         Left            =   3210
         TabIndex        =   6
         Top             =   1410
         Width           =   255
      End
      Begin VB.TextBox txtCut 
         Height          =   315
         Left            =   1380
         Locked          =   -1  'True
         TabIndex        =   5
         Text            =   "120"
         Top             =   1440
         Width           =   1845
      End
      Begin VB.ComboBox cmbDUN 
         Height          =   315
         Left            =   1380
         Style           =   2  'Dropdown List
         TabIndex        =   2
         Top             =   960
         Width           =   3045
      End
      Begin VB.Label Label3 
         Caption         =   "Windows NT/2000/XP only"
         Height          =   225
         Left            =   1830
         TabIndex        =   14
         Top             =   4350
         Width           =   2475
      End
      Begin VB.Label Label2 
         Caption         =   "Also send messages to these network computers:"
         Height          =   255
         Left            =   120
         TabIndex        =   11
         Top             =   2910
         Width           =   4275
      End
      Begin VB.Label Label1 
         Caption         =   "Time-up Message:"
         Height          =   285
         Left            =   150
         TabIndex        =   9
         Top             =   1950
         Width           =   1755
      End
      Begin VB.Label lblMin 
         Caption         =   "(minutes)"
         Height          =   225
         Left            =   3570
         TabIndex        =   8
         Top             =   1530
         Width           =   855
      End
      Begin VB.Label lblCut 
         Caption         =   "Cut-off Time:"
         Height          =   225
         Left            =   150
         TabIndex        =   4
         Top             =   1500
         Width           =   1185
      End
      Begin VB.Label lblDun 
         Caption         =   "Monitor DUN:"
         Height          =   225
         Left            =   150
         TabIndex        =   3
         Top             =   1020
         Width           =   1155
      End
      Begin VB.Label lblInfo1 
         Caption         =   "RASGuard notifys you a 10 minutes before your dial-up-networking (DUN) connection is automatically disconnected by your ISP."
         Height          =   1005
         Left            =   150
         TabIndex        =   1
         Top             =   240
         Width           =   4275
      End
   End
   Begin VB.Menu mnuPopup 
      Caption         =   "Popup Menu"
      Visible         =   0   'False
      Begin VB.Menu mnuShow 
         Caption         =   "Show RASGuard"
      End
      Begin VB.Menu mnuDiv1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "Exit RASGuard"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Function BytesToString(ByRef bByteArray() As Byte) As String
    Dim iCurrent As Long
    Dim sChar As String
    
    For iCurrent = 0 To UBound(bByteArray)
        sChar = Chr(bByteArray(iCurrent))
        If sChar <> vbNullChar Then
            BytesToString = BytesToString & sChar
        Else
            Exit For
        End If
    Next
End Function

Private Sub cmdAdd_Click()
    Dim sPCName As String
    
    sPCName = InputBox("Type the name or IP address of a computer on the network." & vbCrLf & vbCrLf & "Double click the PC name in the box to delete it.", "Add PC")
    
    If sPCName <> "" Then
        lstComputers.AddItem sPCName
    End If
End Sub

Private Sub cmdDown_Click()
    If txtCut.Text > 20 Then
        txtCut.Text = txtCut.Text - 1
    End If
End Sub

Private Sub cmdStart_Click()
    Static iState As Integer
    
    Call SendToTray(Me.Icon, Me.Caption, Me)
    
    If iState = 0 Then
        iState = 1
        cmdStart.Caption = "Stop"
        tmrCheck.Enabled = True
    
        Call EnDisable(False)
    Else
        iState = 0
        cmdStart.Caption = "Start"
        tmrCheck.Enabled = False
        
        Call EnDisable(True)
    End If
End Sub

Sub EnDisable(bValue As Boolean)
    cmbDUN.Enabled = bValue
    txtCut.Enabled = bValue
    cmdUp.Enabled = bValue
    cmdDown.Enabled = bValue
    txtMsg.Enabled = bValue
    lstComputers.Enabled = bValue
    cmdAdd.Enabled = bValue
End Sub

Private Sub cmdUp_Click()
    If txtCut.Text < 600 Then
        txtCut.Text = txtCut.Text + 1
    End If
End Sub

Private Sub cmdExit_Click()
    Call ExitApp
End Sub
Private Sub Form_Load()
    Call PopulateDUN
    Call LoadSettings
    Me.Show
End Sub

Sub LoadSettings()
    txtCut.Text = GetSetting("RASGuard", "Settings", "txtCut.Text", 120)
    txtMsg.Text = GetSetting("RASGuard", "Settings", "txtMsg.Text", "WARNING: Your cut-off time is almost up!")
    chkNotLocal.Value = GetSetting("RASGuard", "Settings", "chknotlocal.Value", vbUnchecked)
    
    Dim sPCs As String: sPCs = GetSetting("RASGuard", "Settings", "sPCs", "")
    Dim sPCArray() As String: sPCArray = Split(sPCs, vbLf)
    
    Dim sPCName As Variant
    
    For Each sPCName In sPCArray
        lstComputers.AddItem sPCName
    Next
    
End Sub

Sub SaveSettings()
    Call SaveSetting("RASGuard", "Settings", "txtCut.Text", txtCut.Text)
    Call SaveSetting("RASGuard", "Settings", "txtMsg.Text", txtMsg.Text)
    Call SaveSetting("RASGuard", "Settings", "chkNotLocal.Value", chkNotLocal.Value)
    
    Dim iCurrent As Integer
    Dim sPCs As String
    
    For iCurrent = 0 To lstComputers.ListCount - 1
        sPCs = sPCs & lstComputers.List(iCurrent) & IIf(iCurrent = lstComputers.ListCount - 1, "", vbLf)
    Next
    
    Call SaveSetting("RASGuard", "Settings", "sPCs", sPCs)
End Sub

Sub PopulateDUN()
    Dim tInfo(10) As RASCONN
    Dim lSize As Long
    Dim lTotal As Long
    
    tInfo(0).dwSize = Len(tInfo(0))
    lSize = tInfo(0).dwSize * 10
    
    If RasEnumConnections(tInfo(0), lSize, lTotal) <> 0 Then
        Dim sError As String
        
        sError = Space(128)
        
        Call RasGetErrorString(RasEnumConnections(tInfo(0), lSize, lTotal), sError, 128)
        
        MsgBox "Error obtaining DUN connections." & vbCrLf & "You may be using an unsupported operating system?" & vbCrLf & vbCrLf & "Info: " & sError, vbCritical, "RAS API Error:"
        End
    Else
        Dim iCurrent As Long
        
        For iCurrent = 0 To lTotal - 1
            cmbDUN.AddItem BytesToString(tInfo(iCurrent).szEntryName)
            cmbDUN.ItemData(iCurrent) = tInfo(iCurrent).hRasConn
        Next
    End If
    
    If cmbDUN.ListCount = 0 Then
        cmbDUN.AddItem "NONE FOUND!"
        cmbDUN.Enabled = False
        
        cmdStart.Enabled = False
    End If
    
    cmbDUN.ListIndex = 0
    
End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Me.Visible = False Then
        If RespondToTray(X, Me) = 2 Or RespondToTray(X, Me) = 4 Then
            Call PopupMenu(mnuPopup)
            
        ElseIf RespondToTray(X, Me) = 1 Then
            Call SendToTray(, , Me, 1)
        End If
    End If
End Sub


Private Sub Form_Unload(Cancel As Integer)
    Cancel = True
    Call SendToTray(Me.Icon, Me.Caption, Me)
End Sub

Private Sub mnuExit_Click()
    Call ExitApp
End Sub

Sub ExitApp()
    Call SendToTray(, , , 2)
    Call SaveSettings
    End
End Sub

Private Sub mnuShow_Click()
    Me.WindowState = vbNormal
    Call SendToTray(, , Me, 1)
End Sub

Private Sub tmrCheck_Timer()
    Static tStats As RAS_STATS
    
    tStats.dwSize = Len(tStats)
    
    If RasGetConnectionStatistics(cmbDUN.ItemData(cmbDUN.ListIndex), tStats) <> 0 Then
        MsgBox "Error calling RasGetConnectionStatistics(" & cmbDUN.ItemData(cmbDUN.ListIndex) & ", tStats) API", vbCritical, "RAS API Error:"
    Else
        Dim lTime As Long
        lTime = tStats.dwConnectDuration
        lTime = lTime / 1000
        lTime = lTime / 60
        
        If lTime + 10 >= CInt(txtCut.Text) Then
            tmrCheck.Enabled = False
            Call RaiseWarning
            
            tmrPoll.Enabled = True
        End If
    End If
End Sub

Sub RaiseWarning()
    Dim iCurrent As Integer
    
    If frmAlert.Visible = False And chkNotLocal.Value = vbUnchecked Then
        frmAlert.Show
        frmAlert.lblInfo2.Caption = txtMsg.Text
    End If
    
    For iCurrent = 0 To lstComputers.ListCount - 1
        Shell "net send " & lstComputers.List(iCurrent) & " " & txtMsg.Text, vbMinimizedNoFocus
        DoEvents
    Next
    
    
End Sub

Private Sub tmrPoll_Timer()
    Dim tInfo(10) As RASCONN
    Dim lSize As Long
    Dim lTotal As Long
    
    tInfo(0).dwSize = Len(tInfo(0))
    lSize = tInfo(0).dwSize * 10
    
    If RasEnumConnections(tInfo(0), lSize, lTotal) <> 0 Then
        Dim sError As String
        
        sError = Space(128)
        
        Call RasGetErrorString(RasEnumConnections(tInfo(0), lSize, lTotal), sError, 128)
        
        MsgBox "Error obtaining DUN connections while polling." & vbCrLf & "You may be using an unsupported operating system?" & vbCrLf & vbCrLf & "Info: " & sError, vbCritical, "RAS API Error:"
        End
    Else
        Dim iCurrent As Long
        
        For iCurrent = 0 To lTotal - 1
            If BytesToString(tInfo(iCurrent).szEntryName) = cmbDUN.Text And cmbDUN.ItemData(cmbDUN.ListIndex) <> tInfo(iCurrent).hRasConn Then
                cmbDUN.ItemData(cmbDUN.ListIndex) = tInfo(iCurrent).hRasConn
                tmrPoll.Enabled = False
                tmrCheck.Enabled = True
                Exit Sub
            End If
        Next
    End If
End Sub
