Attribute VB_Name = "mdlSystray"
Option Explicit

Private Type NOTIFYICONDATA
   cbSize As Long
   hWnd As Long
   uId As Long
   uFlags As Long
   uCallBackMessage As Long
   hIcon As Long
   szTip As String * 64
End Type


Private Const NIM_ADD = &H0
Private Const NIM_MODIFY = &H1
Private Const NIM_DELETE = &H2

Private Const WM_MOUSEMOVE = &H200

Private Const NIF_MESSAGE = &H1
Private Const NIF_ICON = &H2
Private Const NIF_TIP = &H4

Private Const WM_LBUTTONDBLCLK = &H203
Private Const WM_LBUTTONDOWN = &H201
Private Const WM_LBUTTONUP = &H202

Private Const WM_RBUTTONDBLCLK = &H206
Private Const WM_RBUTTONDOWN = &H204
Private Const WM_RBUTTONUP = &H205

Private Declare Function Shell_NotifyIcon Lib "Shell32" Alias "Shell_NotifyIconA" (ByVal dwMessage As Long, pnid As NOTIFYICONDATA) As Boolean

Private Declare Function RegCreateKey& Lib "advapi32.dll" Alias "RegCreateKeyA" (ByVal hKey As Long, ByVal lpszSubKey As String, lphKey As Long)
Private Declare Function RegSetValue& Lib "advapi32.dll" Alias "RegSetValueA" (ByVal hKey As Long, ByVal lpszSubKey As String, ByVal fdwType As Long, ByVal lpszValue As String, ByVal dwLength As Long)

Private Const HKEY_CLASSES_ROOT = &H80000000
Private Const MAX_PATH = 256&
Private Const REG_SZ = 1

Private Declare Sub SHChangeNotify Lib "shell32.dll" _
           (ByVal wEventId As Long, _
            ByVal uFlags As Long, _
            dwItem1 As Any, _
            dwItem2 As Any)

Const SHCNE_ASSOCCHANGED = &H8000000
Const SHCNF_IDLIST = &H0&

Dim nid As NOTIFYICONDATA
Public Sub AddTrayIcon(Icon As Long, Form As Object, Optional ToolTip As String)

   On Error GoTo AddTrayError
   nid.cbSize = Len(nid)
   nid.hWnd = Form.hWnd
   nid.uId = vbNull
   nid.uFlags = NIF_ICON Or NIF_TIP Or NIF_MESSAGE
   nid.uCallBackMessage = WM_MOUSEMOVE
   nid.hIcon = Icon
   nid.szTip = ToolTip & vbNullChar

   Shell_NotifyIcon NIM_ADD, nid

AddTrayError:
    If Err.Number <> 0 Then Exit Sub

End Sub
Public Sub RemoveTrayIcon()
   
   On Error GoTo TrayRemError
   Shell_NotifyIcon NIM_DELETE, nid

TrayRemError:
    If Err.Number <> 0 Then Exit Sub

End Sub
Public Property Get TrayEvent(mouseX As Single) As String

   On Error GoTo PropError
   Dim Msg As Long
   Dim sFilter As String

   Msg = mouseX / Screen.TwipsPerPixelX
    Select Case Msg
     Case WM_LBUTTONDOWN
      TrayEvent = "LEFTDOWN"
     Case WM_LBUTTONUP
      TrayEvent = "LEFTUP"
     Case WM_LBUTTONDBLCLK
      TrayEvent = "LEFTDOUBLE"
     Case WM_RBUTTONDOWN
      TrayEvent = "RIGHTDOWN"
     Case WM_RBUTTONUP
      TrayEvent = "RIGHTUP"
      Call frmServer.PopupMenu(frmServer.mnuTray, True)
     Case WM_RBUTTONDBLCLK
      TrayEvent = "RIGHTDOUBLE"
    End Select

PropError:
    If Err.Number <> 0 Then Exit Property

End Property
Public Sub TrayToolTip(Message As String)

   On Error GoTo ToolError
   nid.szTip = Message & vbNullChar
   Shell_NotifyIcon NIM_MODIFY, nid

ToolError:
    If Err.Number <> 0 Then Exit Sub

End Sub
Public Sub ChangeTrayIcon(Icon As Long)

   On Error GoTo ChangeError
   nid.hIcon = Icon
   Shell_NotifyIcon NIM_MODIFY, nid

ChangeError:
    If Err.Number <> 0 Then Exit Sub

End Sub
