Attribute VB_Name = "mdlDeclarations"
Option Explicit

Public Const WS_VERSION_REQD = &H101
Public Const WS_VERSION_MAJOR = WS_VERSION_REQD \ &H100 And &HFF&
Public Const WS_VERSION_MINOR = WS_VERSION_REQD And &HFF&
Public Const MIN_SOCKETS_REQD = 1
Public Const SOCKET_ERROR = -1
Public Const WSADescription_Len = 256
Public Const WSASYS_Status_Len = 128

Public Enum ESetWindowPosStyles
    SWP_SHOWWINDOW = &H40
    SWP_HIDEWINDOW = &H80
    SWP_FRAMECHANGED = &H20
    SWP_NOACTIVATE = &H10
    SWP_NOCOPYBITS = &H100
    SWP_NOMOVE = &H2
    SWP_NOOWNERZORDER = &H200
    SWP_NOREDRAW = &H8
    SWP_NOREPOSITION = SWP_NOOWNERZORDER
    SWP_NOSIZE = &H1
    SWP_NOZORDER = &H4
    SWP_DRAWFRAME = SWP_FRAMECHANGED
    HWND_NOTOPMOST = -2
End Enum

Public Const flags = SWP_NOMOVE Or SWP_NOSIZE
Public Const conSwNormal = 1
Public Const HWND_TOPMOST = -1

Public Type HOSTENT
    hName As Long
    hAliases As Long
    hAddrType As Integer
    hLength As Integer
    hAddrList As Long
End Type

Public Type WSADATA
    wversion As Integer
    wHighVersion As Integer
    szDescription(0 To WSADescription_Len) As Byte
    szSystemStatus(0 To WSASYS_Status_Len) As Byte
    iMaxSockets As Integer
    iMaxUdpDg As Integer
    lpszVendorInfo As Long
End Type

Public Declare Function WSAGetLastError Lib "WSOCK32.DLL" () As Long
Public Declare Function WSAStartup Lib "WSOCK32.DLL" (ByVal wVersionRequired&, lpWSAData As WSADATA) As Long
Public Declare Function WSACleanup Lib "WSOCK32.DLL" () As Long
Public Declare Function gethostname Lib "WSOCK32.DLL" (ByVal hostname$, ByVal HostLen As Long) As Long
Public Declare Function gethostbyname Lib "WSOCK32.DLL" (ByVal hostname$) As Long
Public Declare Sub RtlMoveMemory Lib "kernel32" (hpvDest As Any, ByVal hpvSource&, ByVal cbCopy&)
Declare Function SetWindowPos Lib "user32.dll" (ByVal hWnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal Y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Public Function CurrentIP(ReturnExternalIP As Boolean)

    On Error GoTo IPError

    Dim hostname As String * 256
    Dim hostent_addr As Long
    Dim host As HOSTENT
    Dim hostip_addr As Long
    Dim temp_ip_address() As Byte
    Dim i As Integer
    Dim ip_address As String
    Dim IP As String
    Dim TheIP, Internal, External

    If gethostname(hostname, 256) = SOCKET_ERROR Then
     MsgBox "Windows socket error " & Str(WSAGetLastError()), vbInformation, "Message"
     Exit Function
    Else
     hostname = Trim$(hostname)
    End If
    hostent_addr = gethostbyname(hostname)

    If hostent_addr = 0 Then
     MsgBox "Winsock.dll error.", vbInformation, "Message"
     Exit Function
    End If

    RtlMoveMemory host, hostent_addr, LenB(host)
    RtlMoveMemory hostip_addr, host.hAddrList, 4

    Do
     ReDim temp_ip_address(1 To host.hLength)
     RtlMoveMemory temp_ip_address(1), hostip_addr, host.hLength
     For i = 1 To host.hLength
      ip_address = ip_address & temp_ip_address(i) & "."
     Next
     ip_address = Mid$(ip_address, 1, Len(ip_address) - 1)

     Internal = TheIP
     External = ip_address
     TheIP = ip_address

     ip_address = ""
     host.hAddrList = host.hAddrList + LenB(host.hAddrList)
     RtlMoveMemory hostip_addr, host.hAddrList, 4
    Loop While (hostip_addr <> 0)
    
    
    If ReturnExternalIP = True Then
     CurrentIP = External
    Else
     CurrentIP = Internal
    End If

IPError:
    If Err.Number <> 0 Then
     frmServer.lblStatus.Caption = "Status: Error " & Err.Number & " " & Err.Description
     Exit Function
    End If

End Function
Public Function nonTop(frmToTop As Form)
    
    On Error GoTo TopError
    Dim onTop%
    onTop% = SetWindowPos(frmToTop.hWnd, HWND_TOPMOST, 0, 0, 0, 0, flags)

TopError:
    If Err.Number <> 0 Then Exit Function

End Function
Public Function nonBottom(frmToBottom As Form)
    
    On Error GoTo BotError
    Dim onTop%
    onTop% = SetWindowPos(frmToBottom.hWnd, HWND_NOTOPMOST, 0, 0, 0, 0, flags)

BotError:
    If Err.Number <> 0 Then Exit Function

End Function
