Attribute VB_Name = "ModFolder_Information"
Const MAX_PATH = 260
Const INVALID_HANDLE_VALUE = -1
Const FILE_ATTRIBUTE_DIRECTORY = &H10

Type FILETIME
   dwLowDateTime As Long
   dwHighDateTime As Long
End Type

Type FOLDER_INFO
   curSize As Currency
   lngNumFiles As Long
   lngNumSubFolders As Long
End Type

Type WIN32_FIND_DATA
   dwFileAttributes As Long
   ftCreationTime As FILETIME
   ftLastAccessTime As FILETIME
   ftLastWriteTime As FILETIME
   nFileSizeHigh As Long
   nFileSizeLow As Long
   dwReserved0 As Long
   dwReserved1 As Long
   cFileName As String * MAX_PATH
   cAlternate As String * 14
End Type

Declare Function FindFirstFile Lib "kernel32" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Declare Function FindNextFile Lib "kernel32" Alias "FindNextFileA" (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long
Declare Function FindClose Lib "kernel32" (ByVal hFindFile As Long) As Long
Public Type SECURITY_ATTRIBUTES
nLength As Long
lpSecurityDescriptor As Long
bInheritHandle As Long
End Type
Public Declare Function CreateDirectory Lib "kernel32" Alias _
"CreateDirectoryA" (ByVal lpPathName As String, lpSecurityAttributes _
As SECURITY_ATTRIBUTES) As Long



'ooooooooooo
Public Function GetFolderInfo(strFolder As String) As FOLDER_INFO
 If Right$(strFolder, 1) <> "\" Then strFolder = strFolder & "\"
   
   Dim lngFileNum As Long, lngFolderNum As Long
   Dim curSize As Currency, FolderQueue As New Collection
   FolderQueue.Add strFolder
   
   Call EnumFolder(FolderQueue, lngFileNum, curSize)
   FolderQueue.Remove 1
   
   Do While FolderQueue.Count > 0
      lngFolderNum = lngFolderNum + 1
      Call EnumFolder(FolderQueue, lngFileNum, curSize)
      FolderQueue.Remove 1
      DoEvents
   Loop
   GetFolderInfo.curSize = curSize
   GetFolderInfo.lngNumFiles = lngFileNum
   GetFolderInfo.lngNumSubFolders = lngFolderNum
   
End Function

Private Sub EnumFolder(FolderQueue As Collection, lngFileNum, lngSize As Currency)
   Dim strTemp As String, strFolder As String
   Dim lRetVal As Long, FFdata As WIN32_FIND_DATA
   Dim lngSearchHandle As Long
strFolder = FolderQueue.Item(1)
lngSearchHandle = FindFirstFile(strFolder & "*.*", FFdata)
If lngSearchHandle = INVALID_HANDLE_VALUE Then Exit Sub
strTemp = TrimNulls(FFdata.cFileName)
Do While strTemp <> ""
If (FFdata.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY) = FILE_ATTRIBUTE_DIRECTORY Then
If strTemp <> "." And strTemp <> ".." Then
If Right$(strTemp, 1) <> "\" Then strTemp = strTemp & "\"
FolderQueue.Add strFolder & strTemp
End If
Else
lngSize = lngSize + FFdata.nFileSizeLow
lngFileNum = lngFileNum + 1
End If
lRetVal = FindNextFile(lngSearchHandle, FFdata)
strTemp = ""
If lRetVal <> 0 Then strTemp = TrimNulls(FFdata.cFileName)
Loop
lRetVal = FindClose(lngSearchHandle)
   
End Sub

Private Function TrimNulls(strString As String) As String
   
   Dim l As Long
   
   l = InStr(1, strString, Chr(0))
   
   If l = 1 Then
      TrimNulls = ""
   ElseIf l > 0 Then
      TrimNulls = Left$(strString, l - 1)
   Else
      TrimNulls = strString
   End If
   
End Function


