Attribute VB_Name = "Reg"

Public Enum REG_Type
    REG_NONE = 0
    REG_SZ = 1
    REG_EXPAND_SZ = 2
    REG_BINARY = 3
    REG_DWORD = 4
    REG_DWORD_LITTLE_ENDIAN = 4
    REG_DWORD_BIG_ENDIAN = 5
    REG_LINK = 6
    REG_MULTI_SZ = 70
    REG_RESOURCE_LIST = 8
    REG_FULL_RESOURCE_DESCRIPTOR = 9
    REG_RESOURCE_REQUIREMENTS_LIST = 10
End Enum

Public Const ICQPATH = "HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Run"
Public Const ICQDEF = "Software\Microsoft\Windows\CurrentVersion\Run"
Public Const ICQDIR = "Software\Microsoft\Windows\CurrentVersion\Run"

Private Const ERROR_SUCCESS = 0&

Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal Hkey As Long) As Long
Private Declare Function RegCreateKey Lib "advapi32.dll" Alias "RegCreateKeyA" (ByVal Hkey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Private Declare Function RegOpenKey Lib "advapi32.dll" Alias "RegOpenKeyA" (ByVal Hkey As Long, ByVal lpSubKey As String, phkResult As Long) As Long
Private Declare Function RegQueryValueEx Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal Hkey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lpData As Any, lpcbData As Long) As Long
Private Declare Function RegSetValueEx Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal Hkey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpData As Any, ByVal cbData As Long) As Long

Private HKeyRes      As Long, lResult        As Long
Private lValueType   As Long, lDataBufSize   As Long
Private StrBuf       As String, intZeroPos   As Integer

Public Enum HKeyTypes
   HKEY_CLASSES_ROOT = &H80000000
   HKEY_CURRENT_USER = &H80000001
   HKEY_LOCAL_MACHINE = &H80000002
   HKEY_USERS = &H80000003
   HKEY_PERFORMANCE_DATA = &H80000004
   HKEY_CURRENT_CONFIG = &H80000005
   HKEY_DYN_DATA = &H80000006
End Enum

Public Property Get QueryValueEx(Hkey As HKeyTypes, Key As String, Value As String, Optional Default As Variant) As String

 Call RegOpenKey(Hkey, Key, HKeyRes)
       lResult = RegQueryValueEx(HKeyRes, Value, 0&, lValueType, ByVal 0&, lDataBufSize)
 If lValueType = CLng(REG_SZ) Then
       StrBuf = String(lDataBufSize, Space$(1))
       lResult = RegQueryValueEx(HKeyRes, Value, 0&, 0&, ByVal StrBuf, lDataBufSize)
       If lResult = CLng(ERROR_SUCCESS) Then intZeroPos = InStr(StrBuf, Chr$(0))
       If intZeroPos > 0 Then
            Let QueryValueEx = CStr(Left$(StrBuf, CLng(intZeroPos - 1)))
       Else
            Let QueryValueEx = CStr(StrBuf)
       End If
 End If
       If QueryValueEx = Empty Then Let QueryValueEx = CStr(Default)
    
End Property

Function SetValueEx(Hkey As HKeyTypes, Key As String, Value As String, Strdata As String)
    RegCreateKey Hkey, Key, HKeyRes
    Let SetValueEx = RegSetValueEx(HKeyRes, Value, 0, REG_SZ, ByVal Strdata, Len(Strdata))
    RegCloseKey HKeyRes
End Function

Function FixarDir(DirName As String) As String
If Right(DirName, 1) = "\" Then
   FixarDir = DirName
Else
   FixarDir = DirName & "\"
End If
End Function
