VERSION 5.00
Begin VB.Form frmGirarImagem 
   Caption         =   "Exemplo para se girar uma imagem"
   ClientHeight    =   7365
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   8640
   LinkTopic       =   "Form1"
   ScaleHeight     =   7365
   ScaleWidth      =   8640
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdVerticalHorizontal 
      Caption         =   "Girar Imagem V e H"
      Height          =   495
      Left            =   6600
      TabIndex        =   4
      Top             =   6840
      Width           =   1935
   End
   Begin VB.CommandButton cmdGirarImagemHorizontal 
      Caption         =   "Girar Imagem Horizontal"
      Height          =   495
      Left            =   4560
      TabIndex        =   3
      Top             =   6840
      Width           =   1935
   End
   Begin VB.CommandButton cmdGirarImagemVertical 
      Caption         =   "Girar Imagem Vertical"
      Height          =   495
      Left            =   2520
      TabIndex        =   2
      Top             =   6840
      Width           =   1935
   End
   Begin VB.PictureBox picFoto 
      Height          =   495
      Left            =   100
      ScaleHeight     =   435
      ScaleWidth      =   1155
      TabIndex        =   1
      Top             =   100
      Width           =   1215
   End
   Begin VB.CommandButton cmdGirarImagemCompleta 
      Caption         =   "Girar Imagem Completa"
      Height          =   495
      Left            =   480
      TabIndex        =   0
      Top             =   6840
      Width           =   1935
   End
End
Attribute VB_Name = "frmGirarImagem"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Type POINTAPI
    x As Long
    y As Long
End Type

Dim Pt(0 To 2) As POINTAPI

Private Declare Function PlgBlt Lib "gdi32" ( _
ByVal hdcDest As Long, _
lpPoint As POINTAPI, _
ByVal hdcSrc As Long, _
ByVal nXSrc As Long, _
ByVal nYSrc As Long, _
ByVal nWidth As Long, _
ByVal nHeight As Long, _
ByVal hbmMask As Long, _
ByVal xMask As Long, _
ByVal yMask As Long _
) As Long

Private Sub cmdGirarImagemCompleta_Click()
    Call Rotate90(picFoto)
End Sub

Private Sub cmdGirarImagemHorizontal_Click()
    Call FlipHorizontal
End Sub

Private Sub cmdGirarImagemVertical_Click()
    Call FlipVertical
End Sub

Private Sub VerticalHorizontal_Click()
    Call FlipVerticalHorizontal
End Sub

Private Sub Form_Load()
    With picFoto
        .AutoRedraw = True
        .AutoSize = True
        .BorderStyle = 0
        .Appearance = 0
        .ScaleMode = vbPixels
        'Carregue sua figura aqui
        .Picture = LoadPicture(App.Path & "\imagens\3_raios_simultaneos.jpg")
    End With
    
    Me.ScaleMode = vbPixels
End Sub

Private Sub Rotate90(picsrc As PictureBox)
    Dim picWidth As Long
    Dim picHeight As Long
    
    picWidth = picsrc.Width
    picHeight = picsrc.Height
    
    Pt(2).x = 0
    Pt(2).y = 0
    Pt(0).x = picHeight
    Pt(0).y = 0
    Pt(1).x = picHeight
    Pt(1).y = picWidth
    
    If picWidth > picHeight Then
        picsrc.Height = picWidth
    Else
        picsrc.Width = picHeight
    End If
    
    Call PlgBlt(picsrc.hDC, Pt(0), picsrc.hDC, 0, 0, picWidth, picHeight, ByVal 0&, ByVal 0&, ByVal 0&)
    
    picsrc.Width = picHeight
    picsrc.Height = picWidth
    picsrc.Refresh
End Sub

Private Sub FlipVertical()
    Dim H As Long
    Dim W As Long
    
    H = picFoto.Height
    W = picFoto.Width
    
    'flip vertical
    picFoto.PaintPicture picFoto.Picture, 0, H, W, -H
End Sub

Private Sub FlipHorizontal()
    Dim H As Long
    Dim W As Long
    
    H = picFoto.Height
    W = picFoto.Width
    
    'flip horizontal
    picFoto.PaintPicture picFoto.Picture, W, 0, -W
End Sub

Private Sub FlipVerticalHorizontal()
    Dim H As Long
    Dim W As Long
    
    H = picFoto.Height
    W = picFoto.Width
    
    'flip ambos
    picFoto.PaintPicture picFoto.Picture, W, H, -W, -H
End Sub
