Attribute VB_Name = "Funcoes_Conversao"
Public Function HexToRGB(HexColor As String)
'input format = #FFCC00
On Error GoTo erro
Dim r, g, b As Byte
r = CByte("&H" & Mid(HexColor, 2, 2))
g = CByte("&H" & Mid(HexColor, 4, 2))
b = CByte("&H" & Mid(HexColor, 6, 2))
HexToRGB = r & "," & g & "," & b

erro:
If Err Then
    HexToRGB = "!"
    Err.Clear
End If
End Function

Public Function HexToColor(HexColor As String)
Dim v As Variant, Cor As String
Cor = HexToRGB(HexColor)
If Cor = "!" Then
    HexToColor = Cor
    Exit Function
End If
v = Split(Cor, ",")
HexToColor = RGBToColor(CByte(v(0)), CByte(v(1)), CByte(v(2)))
End Function

Public Function ColorToHex(Color As Long)
Dim v As Variant
v = ColorToRGB(Color)
v = Split(v, ",")
ColorToHex = RGBToHex(CByte(v(0)), CByte(v(1)), CByte(v(2)))
End Function

Public Function RGBToHex(r As Byte, g As Byte, b As Byte)

'input format = 255,255,255

'get the r value
If r < 16 Then
hex1 = 0 & Hex(r)
Else
hex1 = Hex(r)
End If


'get the g value
If r < 16 Then
hex2 = 0 & Hex(g)
Else
hex2 = Hex(g)
End If


'get the b value
If b < 16 Then
hex3 = 0 & Hex(b)
Else
hex3 = Hex(b)
End If

RGBToHex = "#" & hex1 & hex2 & hex3
End Function

Public Function RGBToColor(r As Byte, g As Byte, b As Byte) As Long
RGBToColor = CLng(r) + CLng(CLng(g) * 256) + CLng(CLng(b) * 65536)
End Function

Public Function ColorToRGB(Color As Long)
Dim r, g, b As Byte
r = Color And 255
g = (Color \ 256) And 255
b = (Color \ 65536) And 255
ColorToRGB = r & "," & g & "," & b
End Function
