Attribute VB_Name = "modCallBackServerMain"
Option Explicit
Private Declare Function FormatMessage Lib "kernel32" Alias "FormatMessageA" (ByVal dwFlags As Long, lpSource As Long, ByVal dwMessageId As Long, ByVal dwLanguageId As Long, ByVal lpBuffer As String, ByVal nSize As Long, Arguments As Any) As Long

Private colClients As Collection
Private ConnectedToClients  As Integer

Sub Main()
    Set colClients = New Collection
End Sub

Public Function BroadCastString(S As String) As Boolean
    Dim Obj As Object
    Dim I As Integer
    On Error GoTo BroadCastStringError
    
    For I = 1 To colClients.Count
        If Not SendString(colClients(I), S) Then
            BroadCastString = False
            Exit Function
        End If
    Next
    BroadCastString = True
    
BroadCastStringExit:
    Exit Function

BroadCastStringError:
    BroadCastString = False
    Resume BroadCastStringExit
End Function

Public Function SendStringByClientName(Name As String, S As String) As Boolean
    On Error GoTo SendStringByClientName_Error
    
    SendStringByClientName = SendString(colClients(Name), S)
    
SendStringByClientName_Exit:
    Exit Function
    
SendStringByClientName_Error:
    'The client with this name was not found in the collection
    SendStringByClientName = False
    Resume SendStringByClientName_Exit
End Function

Public Function SendString(Obj As Object, S As String) As Boolean
    Dim I As Integer
    Dim NumberOfCollisions As Integer
    Const MAX_COLLISIONS = 5

    On Error GoTo cmdSend_Click_Error
  
    Obj.ReceiveString S
    SendString = True
    
cmdSend_Click_Exit:
    Exit Function

cmdSend_Click_Error:
    'Errors may be caused by collisions (client and server trying to send at the same time. Retry up to MAX_COLLSIONS.
    If Err = -2147418111 Then
        '-2147418111 (80010001 hex):    Call was rejected by callee.
        NumberOfCollisions = NumberOfCollisions + 1
        If NumberOfCollisions >= MAX_COLLISIONS Then
            MsgBox "Unable to send message to client", vbExclamation, "Client Connection Error"
        Else
            If NumberOfCollisions = 1 Then
                Randomize   'Set seed based on system timer
            End If
            For I = 1 To 999 * Rnd() + 1   'Do between 1 and 1000 DoEvent calls
                DoEvents
            Next I
            Resume
        End If
    Else
        'Some other error
       MsgBox Err.Number & " (" & Hex(Err.Number) & ")" & vbCr & MessageText(Err.Number), _
        vbExclamation, "Automation Error"
    End If
    Resume cmdSend_Click_Exit
End Function

Private Function MessageText(lCode As Long) As String
    Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
    Dim sRtrnCode As String
    Dim lRet As Long

    sRtrnCode = Space$(256)
    lRet = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, 0&, lCode, 0&, sRtrnCode, 256&, 0&)
    If lRet > 0 Then
       MessageText = Left(sRtrnCode, lRet)
    Else
       MessageText = "Error not found."
    End If

End Function

Public Function AddClient(Caller As Object, ClientName As String) As Boolean
    On Error GoTo AddClient_Error
  
    If ClientExists(ClientName) Then
        'Can only support one connection for each client name
        AddClient = False
        Exit Function
    End If
    colClients.Add Caller, ClientName
    ConnectedToClients = ConnectedToClients + 1
    frmCallBackServer.lstClients.AddItem ClientName
    AddClient = True
    
AddClient_Exit:
    Exit Function

AddClient_Error:
    AddClient = False
    Resume AddClient_Exit
End Function

Public Function DropClient(ClientName As String) As Boolean
    Dim I As Integer
    Dim Obj As Object
    
    On Error GoTo DropClient_Error

    If Not ClientExists(ClientName) Then
        'Client no registered
        DropClient = False
        Exit Function
    End If

    colClients.Remove ClientName
    ConnectedToClients = ConnectedToClients - 1
    
    'Remove the Client name from the CLient list
    For I = 0 To frmCallBackServer.lstClients.ListCount - 1
        If frmCallBackServer.lstClients.List(I) = ClientName Then
            frmCallBackServer.lstClients.RemoveItem I
            Exit For
        End If
    Next
       
    DropClient = True
    If colClients.Count = 0 Then
        Unload frmCallBackServer        'unload to allow complete derefencing of this object
    End If

  
DropClient_Exit:
    Exit Function

DropClient_Error:
    DropClient = False
    Resume DropClient_Exit
End Function

Private Function ClientExists(ClientName As String)
    'No pre-defined "Exists" function for collections.
    
    Dim Dummy As Object
    
    On Error Resume Next
    
    Set Dummy = colClients(ClientName)
    If Err.Number = 0 Then
        ClientExists = True
    Else
        ClientExists = False
    End If
End Function

