VERSION 5.00
Begin VB.Form frmCallBackClient 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Callback Client"
   ClientHeight    =   1125
   ClientLeft      =   2880
   ClientTop       =   2895
   ClientWidth     =   6375
   ClipControls    =   0   'False
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   1125
   ScaleWidth      =   6375
   Begin VB.CommandButton cmdSend 
      Caption         =   "&Send to Server"
      Height          =   375
      Left            =   4920
      TabIndex        =   3
      Top             =   600
      Width           =   1215
   End
   Begin VB.TextBox txtSndMsg 
      Height          =   285
      Left            =   120
      TabIndex        =   2
      Top             =   600
      Width           =   4575
   End
   Begin VB.TextBox txtRecvdMsg 
      Enabled         =   0   'False
      Height          =   285
      Left            =   3120
      TabIndex        =   1
      Top             =   120
      Width           =   3015
   End
   Begin VB.Label Label1 
      Caption         =   "Last Message received from Server:"
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   2775
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileConnect 
         Caption         =   "&Connect"
      End
      Begin VB.Menu mnuFileDisconnect 
         Caption         =   "&Disconnect"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "&Exit"
      End
   End
End
Attribute VB_Name = "frmCallBackClient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function FormatMessage Lib "kernel32" Alias "FormatMessageA" (ByVal dwFlags As Long, lpSource As Long, ByVal dwMessageId As Long, ByVal dwLanguageId As Long, ByVal lpBuffer As String, ByVal nSize As Long, Arguments As Any) As Long

Private objServerClass As Object
Private ConnectedToServer As Boolean
Private Const MAX_COLLISIONS = 5
Private objMyClass As clsCallBackClient
Private ConnectedToCallBackServer As Boolean
Private MyName As String

Private Sub cmdSend_Click()
    Dim NumberOfCollisions As Integer
    
    Screen.MousePointer = vbHourglass
    'Send is only enabled if there is a connection. No real need to check the objServerClass object
    On Error GoTo cmdSend_Click_Error
    
    If ConnectedToCallBackServer Then
        objServerClass.ReceiveString (Me.txtSndMsg)
    Else
        MsgBox "Not connected to server", vbExclamation, "Send to Server Error"
    End If
    
cmdSend_Click_Exit:
    Screen.MousePointer = vbDefault
    Exit Sub

cmdSend_Click_Error:
    'Errors may be caused by collisions (client and server trying to send at the same time. Retry up to MAX_COLLSIONS.
    If Err = -2147418111 Then
        '-2147418111 (80010001 hex):    Call was rejected by callee.
        NumberOfCollisions = NumberOfCollisions + 1
        If NumberOfCollisions >= MAX_COLLISIONS Then
            MsgBox "Connect request rejected by server. ", vbExclamation, "Remote Server Disconnect Error"
        Else
            WaitRandomTime (NumberOfCollisions = 1)
            Resume
        End If
    Else
        'Some other error
        MsgBox Err.Number & " (" & Hex(Err.Number) & ")" & vbCr & MessageText(Err.Number), vbExclamation, _
            "Automation Error"
    End If
    Resume cmdSend_Click_Exit
End Sub

Private Sub Form_Load()
    SetConnectStatus False
End Sub

Private Sub mnuFileConnect_Click()
    Dim NumberOfCollisions As Integer
    
    On Error GoTo mnuFileConnect_Click_Error
    
    MyName = InputBox("Please enter name of this client", "connect client")
    
    Screen.MousePointer = vbHourglass

    Set objMyClass = New clsCallBackClient
    Set objServerClass = CreateObject("CallBackServer.clsCallBackServer")
    
    If objServerClass.AddClient(objMyClass, MyName) Then
        SetConnectStatus True
    End If
    
mnuFileConnect_Click_Exit:
    Screen.MousePointer = vbDefault
    Exit Sub

mnuFileConnect_Click_Error:
    'Errors may be caused by collisions (client and server trying to send at the same time. Retry up to MAX_COLLSIONS.
    If Err = -2147418111 Then
        '-2147418111 (80010001 hex):    Call was rejected by callee.
        NumberOfCollisions = NumberOfCollisions + 1
        If NumberOfCollisions >= MAX_COLLISIONS Then
            MsgBox "Connect request rejected by server. ", vbExclamation, "Remote Server Disconnect Error"
        Else
            WaitRandomTime (NumberOfCollisions = 1)
            Resume
        End If
    Else
        'Some other error
        MsgBox Err.Number & " (" & Hex(Err.Number) & ")" & vbCr & MessageText(Err.Number), vbExclamation, _
            "Automation Error"
    End If
    Resume mnuFileConnect_Click_Exit
End Sub

Private Sub mnuFileDisconnect_Click()
    Dim NumberOfCollisions As Integer
    
    On Error GoTo mnuFileDisconnect_Click_Error
    Screen.MousePointer = vbHourglass
    
    If objServerClass.DropClient(MyName) Then
        SetConnectStatus (False)
        Set objMyClass = Nothing        'Dereference our local object
        Set objServerClass = Nothing                  'Dereference the server callback object.
    End If
  
mnuFileDisconnect_Click_Exit:
    Screen.MousePointer = vbDefault
    Exit Sub

mnuFileDisconnect_Click_Error:
    'Errors may be caused by collisions (client and server trying to send at the same time. Retry up to MAX_COLLSIONS.
    If Err = -2147418111 Then
        '-2147418111 (80010001 hex):    Call was rejected by callee.
        NumberOfCollisions = NumberOfCollisions + 1
        If NumberOfCollisions >= MAX_COLLISIONS Then
            MsgBox "Release server reference request rejected. ", vbExclamation, "Remote Server Disconnect Error"
        Else
            WaitRandomTime (NumberOfCollisions = 1)
            Resume
        End If
    Else
        'Some other error
        MsgBox Err.Number & " (" & Hex(Err.Number) & ")" & vbCr & MessageText(Err.Number), _
            vbExclamation, "Automation Error"
    End If
    Resume mnuFileDisconnect_Click_Exit
End Sub

Private Sub mnuFileExit_Click()
    Unload Me
End Sub

Private Sub WaitRandomTime(Seed As Boolean)
    Dim I As Integer
    
    If Seed Then
        Randomize   'Set seed based on system timer
    End If
    For I = 1 To 999 * Rnd() + 1   'Do between 1 and 1000 DoEvent calls
        DoEvents
    Next I
End Sub

Private Sub SetConnectStatus(Status As Boolean)
    ConnectedToCallBackServer = Status
    mnuFileDisconnect.Enabled = Status
    mnuFileConnect.Enabled = Not Status
    mnuFileExit.Enabled = Not Status
    If Status Then
        Caption = "Callback Client " & MyName & " [Connected to Server]"
    Else
        Caption = "Callback Client [Not Connected]"
    End If
End Sub


Private Function MessageText(lCode As Long) As String
    Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
    Dim sRtrnCode As String
    Dim lRet As Long

    sRtrnCode = Space$(256)
    lRet = FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM, 0&, lCode, 0&, sRtrnCode, 256&, 0&)
    If lRet > 0 Then
       MessageText = Left(sRtrnCode, lRet)
    Else
       MessageText = "Error not found."
    End If

End Function

