<?



// Datei:       class.Session.inc
// Bentigt:    mind. 4.0.1pl2
/**
*   "Manueller" Session-Fallback mit PHP4
*
*   $Id: class.Session.inc,v 1.6 2001/08/09 18:00:12 maschinist Exp $
*
*   @author     Daniel T. Gorski <daniel.gorski@bluemars.de>
*   @version        1.9.1
*/

class Session {
    var $usesCookies = false;   // Client nimmt Cookies an

### -------------------------------------------------------
/**
*   Konstruktor - nimmt, wenn gewnscht einen neuen Session-Namen entgegen
*/
    function Session($sessionName="dclp", $disableTransSID=true, $debug=false) {
        global $HTTP_POST_VARS, $HTTP_GET_VARS, $HTTP_COOKIE_VARS;

        if ($disableTransSID) ini_set("session.use_trans_sid","0");

        $this->sendNoCacheHeader();

        // Session-Namen setzen, Session initialisieren
        session_name(isset($sessionName) ? $sessionName : session_name());
        @session_start();

        // Prfen ob die Session-ID die Standardlnge von 32 Zeichen hat,
        // ansonsten Session-ID neu setzen
        if (strlen(session_id()) != 32)
            {
                mt_srand ((double)microtime()*1000000);
                session_id(md5(uniqid(mt_rand())));
            }

        // Prfen, ob eine Session-ID bergeben wurde (ber Cookie, POST oder GET)
        $IDpassed = false;
        if (isset($HTTP_COOKIE_VARS[session_name()]) && @strlen($HTTP_COOKIE_VARS[session_name()]) == 32) $IDpassed = true;
        if (isset($HTTP_POST_VARS  [session_name()]) && @strlen($HTTP_POST_VARS  [session_name()]) == 32) $IDpassed = true;
        if (isset($HTTP_GET_VARS   [session_name()]) && @strlen($HTTP_GET_VARS   [session_name()]) == 32) $IDpassed = true;

        if  (!$IDpassed)
            {
                // Es wurde keine (gltige) Session-ID bergeben.
                // Script-Parameter der URL zufgen

                // Debug-Log
                if ($debug)    error_log(date ("[d.m.Y H:i:s]")
                                        ." - '".getenv("SERVER_NAME")
                                                                                .getenv("SCRIPT_NAME")
                                        ."' created a new Session-ID.\n",
                                        3,
                                        "/tmp/session.log");

                $query        =        getenv("QUERY_STRING") != ""
                                                        ? "?".getenv("QUERY_STRING")
                                                        : "";

                header("Status: 302 Found");
                $this->redirectTo(getenv("SCRIPT_NAME").$query); // Script terminiert
            }

        // Wenn die Session-ID bergeben wurde, mu sie
        // nicht unbedingt gltig sein!

        // Fr weiteren Gebrauch merken
        $this->usesCookies = ( isset($HTTP_COOKIE_VARS[session_name()]) && @strlen($HTTP_COOKIE_VARS[session_name()]) == 32);
    }

### -------------------------------------------------------
/**
*   Cacheing unterbinden
*
*   Ergnze/Override "session.cache_limiter = nocache"
*
*   @param  void
*   @return void
*/
    function sendNoCacheHeader()    {
        header("Expires: Sat, 05 Aug 2000 22:27:00 GMT");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: no-cache, must-revalidate");
        header("Pragma: no-cache");
        header("Cache-Control: post-check=0, pre-check=0");
    }

### -------------------------------------------------------
/**
*   HTTP-Redirect ausfhren (header("Location: ...")
*
*   Diese Methode bercksichtigt auch nicht-standard Ports
*   und SSL. Ein GET-Parameter beim  wird bei Bedarf
*   (Session-ID-Fallback) an die URI drangehngt. Nach
*   dem Aufruf dieser Methode wird das aktive Script
*   beendet und die Kontrolle wird an das Ziel-Script
*   bergeben.
*
*   @param  string  Ziel-Datei (z.B. "index.html")
*   @return void
*/
    function redirectTo($pathInfo) {

        // Relativer Pfad?
        if ($pathInfo[0] != "/")
            {   $pathInfo = substr(getenv("SCRIPT_NAME"),
                                   0,
                                   strrpos(getenv("SCRIPT_NAME"),"/")+1
                                   )
                            .$pathInfo;
            }

        // Luft dieses Script auf einem non-standard Port?
        $port    = !preg_match("/^(80|443)$/",getenv("SERVER_PORT"),$portMatch)
                   ? ":".getenv("SERVER_PORT")
                   : "";

        // Redirect
        header("Location: "
               .(($portMatch[1] == 443) ? "https://" : "http://")
               .getenv("SERVER_NAME").$port.$this->url($pathInfo));
        exit;
    }

### -------------------------------------------------------
/**
*   Entfernt mgliche abschlieende "&" und "?"
*
*   @param  string  String
*   @return string  String ohne abschlieende "&" und "?"
*/
    function removeTrail($pathInfo) {
        $dummy = preg_match("/(.*)(?<!&|\?)/",$pathInfo,$match);
        return $match[0];
    }

### -------------------------------------------------------
/**
*   Fallback via GET - wenn Cookies ausgeschaltet sind
*
*   @param  string  Ziel-Datei
*   @return string  Ziel-Datei mit - bei Bedarf - angehngter Session-ID
*/
    function url($pathInfo)  {
        if ($this->usesCookies || ini_get("session.use_trans_sid")) return $pathInfo;

        // Anchor-Fragment extrahieren
        $dummyArray = split("#",$pathInfo);
        $pathInfo = $dummyArray[0];

        // evtl. (kaputte) Session-ID(s) aus dem Querystring entfernen
        $pathInfo = preg_replace("/[?|&]".session_name()."=[^?|&]*/","",$pathInfo);

        // evtl. Query-Delimiter korrigieren
        if (preg_match("/&/",$pathInfo) && !preg_match("/\?/",$pathInfo))
            {
                // 4ter Parameter fr "preg_replace()" erst ab 4.0.1pl2
                $pathInfo = preg_replace("/&/","?",$pathInfo,1);
            }

        // Restmll entsorgen
        $pathInfo = $this->removeTrail($pathInfo);

        // Session-Name und Session-ID frisch hinzufgen
        $pathInfo .= preg_match("/\?/",$pathInfo) ? "&" : "?";
        $pathInfo .= session_name()."=".session_id();

        // Anchor-Fragment wieder anfgen
        $pathInfo .= isset($dummyArray[1]) ? "#".$dummyArray[1] : "";

        return $pathInfo;
    }

### -------------------------------------------------------
/**
*   Fallback via HIDDEN FIELD - wenn Cookies ausgeschaltet sind
*
*   Ohne Cookies erfolgt Fallback via HTML-Hidden-Field
*   (fr Formulare)
*
*   @param  void
*   @return string  HTML-Hidden-Input-Tag mit der Session-ID
*/
    function hidden() {
        if ($this->usesCookies || ini_get("session.use_trans_sid")) return "";
        return '<INPUT type="hidden" name="'.session_name().'" value="'.session_id().'">';
    }

### -------------------------------------------------------
/**
*    Variable korrekt registrieren
*
*    Wenn PHP mit "register_globals=Off" konfiguriert ist,
*    ist das Session-Management ein wenig broken.
*    Diese Methode korrigiert das indem sie eine Referenz
*    zum $HTTP_SESSION_VARS-Hash erzwingt, der dann korrekt
*    gespeichert wird.
*
*    @param    string    Beliebige Anzahl von Variablennamen,
*                        die "registriert" werden sollen
*    @return    void
*/
    function register()    {
        foreach(func_get_args() as $arg)
            session_register($arg);

        if (!ini_get("register_globals") || strtolower(ini_get("register_globals")) == 'off')
            {
                // Keine berraschungen in zukftigen
                // PHP-Versionen erwnscht.
                $oldLevel    =    error_reporting(0);

                foreach(func_get_args() as $arg)
                    $GLOBALS["HTTP_SESSION_VARS"][$arg] = &$GLOBALS[$arg];

                error_reporting($oldLevel);
            }
    }

### -------------------------------------------------------
/**
*    Variable aus den Session-Daten lschen
*
*    Wenn PHP mit "register_globals=Off" konfiguriert ist,
*    ist das Session-Management ein wenig broken.
*    Diese Methode korrigiert das indem sie den entsprechenden
*    Index im $HTTP_SESSION_VARS-Hash lscht.
*
*    @param    string    Beliebige Anzahl von Variablennamen,
*                        die "unregistriert" werden sollen
*    @return    void
*/
    function unregister() {
        foreach(func_get_args() as $arg)
            {
                session_unregister($arg);

                $keyIndex = array_keys(array_keys($GLOBALS["HTTP_SESSION_VARS"]), $arg);
                if (sizeof($keyIndex) == 0) continue;

                array_splice($GLOBALS["HTTP_SESSION_VARS"], $keyIndex[0], 1);
            }
    }
    function destroy() {
            return session_destroy();
   }

} // of class

?>