<?php
class Template
{
	var $classname 		= "Template";
	var $debug     		= false;
	var $file  		= array();
	var $root   		= "";
	var $varkeys 		= array();
	var $varvals 		= array();
	var $unknowns 		= "remove";
	var $halt_on_error  	= "yes";
	var $last_error    	= "";
	function Template($root = ".", $unknowns = "remove")
	{
		$this->set_root($root);
		$this->set_unknowns($unknowns);
	}
	function set_root($root)
	{
		if (!is_dir($root))
		{
			$this->halt("set_root: $root is not a directory.");
			return false;
		}
		$this->root = $root;
		return true;
	}
	function set_unknowns($unknowns = "keep")
	{
		$this->unknowns = $unknowns;
	}
	function set_file($handle, $filename = "")
	{
		if (!is_array($handle))
		{
			if ($filename == "")
			{
				$this->halt("set_file: For handle $handle filename is empty.");
				return false;
			}
			$this->file[$handle] = $this->filename($filename);
		}
		else
		{
			reset($handle);
			while(list($h, $f) = each($handle))
			{
				$this->file[$h] = $this->filename($f);
			}
		}
	}
	function set_block($parent, $handle, $name = "")
	{
		if (!$this->loadfile($parent))
		{
			$this->halt("subst: unable to load $parent.");
			return false;
		}
		if ($name == "")
			$name = $handle;
			$str = $this->get_var($parent);
			$reg = "/<!--\s+BEGIN $handle\s+-->(.*)\n\s*<!--\s+END $handle\s+-->/sm";
			preg_match_all($reg, $str, $m);
			$str = preg_replace($reg, "{" . "$name}", $str);
			$this->set_var($handle, $m[1][0]);
			$this->set_var($parent, $str);
	}
	function set_var($varname, $value = "")
	{
		if (!is_array($varname))
		{
			if (!empty($varname))
			if ($this->debug) print "scalar: set *$varname* to *$value*<br>\n";
			$this->varkeys[$varname] = "/".$this->varname($varname)."/";
			$this->varvals[$varname] = $value;
		}else{
			reset($varname);
			while(list($k, $v) = each($varname))
			{
				if (!empty($k))
				if ($this->debug) print "array: set *$k* to *$v*<br>\n";
				$this->varkeys[$k] = "/".$this->varname($k)."/";
				$this->varvals[$k] = $v;
			}
		}
	}
	function subst($handle)
	{
		if (!$this->loadfile($handle))
		{
			$this->halt("subst: unable to load $handle.");
			return false;
		}
		$str = $this->get_var($handle);
		$str = @preg_replace($this->varkeys, $this->varvals, $str);
		return $str;
	}
	function psubst($handle)
	{
		print $this->subst($handle);
		return false;
	}
	function parse($target, $handle, $append = false)
	{
		if (!is_array($handle))
		{
			$str = $this->subst($handle);
			if ($append)
			{
				$this->set_var($target, $this->get_var($target) . $str);
			}else{
				$this->set_var($target, $str);
			}
		}else{
			reset($handle);
			while(list($i, $h) = each($handle))
			{
				$str = $this->subst($h);
				$this->set_var($target, $str);
			}
		}
		return $str;
	}
	function pparse($target, $handle, $append = false)
	{
		print $this->parse($target, $handle, $append);
		return false;
	}
	function get_vars()
	{
		reset($this->varkeys);
		while(list($k, $v) = each($this->varkeys))
		{
			$result[$k] = $this->varvals[$k];
		}
		return $result;
	}
	function get_var($varname)
	{
		if (!is_array($varname))
		{
			return $this->varvals[$varname];
		}else{
			reset($varname);
			while(list($k, $v) = each($varname))
			{
				$result[$k] = $this->varvals[$k];
			}
			return $result;
		}
	}
	function get_undefined($handle)
	{
		if (!$this->loadfile($handle))
		{
			$this->halt("get_undefined: unable to load $handle.");
			return false;
		}
		preg_match_all("/\{([^}]+)\}/", $this->get_var($handle), $m);
		$m = $m[1];
		if (!is_array($m))
		return false;
		reset($m);
		while(list($k, $v) = each($m))
		{
			if (!isset($this->varkeys[$v]))
				$result[$v] = $v;
		}
		if (count($result))
			return $result;
		else
			return false;
	}
	function finish($str)
	{
		switch ($this->unknowns)
		{
			case "keep":
				break;
			case "remove":
				$str = preg_replace('/{[^ \t\r\n}]+}/', "", $str);
				break;
			case "comment":
				$str = preg_replace('/{([^ \t\r\n}]+)}/', "<!-- Template $handle: Variable \\1 undefined -->", $str);
				break;
		}
		return $str;
	}
	function p($varname)
	{
		print $this->finish($this->get_var($varname));
	}
	function get($varname)
	{
		return $this->finish($this->get_var($varname));
	}
	function filename($filename)
	{
		if (substr($filename, 0, 1) != "/")
		{
			$filename = $this->root."/".$filename;
		}
	if (!file_exists($filename))
		$this->halt("filename: file $filename does not exist.");
		return $filename;
	}
	function varname($varname)
	{
		return preg_quote("{".$varname."}");
	}
	function loadfile($handle)
	{
		if (isset($this->varkeys[$handle]) and !empty($this->varvals[$handle]))
			return true;
			if (!isset($this->file[$handle]))
			{
				$this->halt("loadfile: $handle is not a valid handle.");
				return false;
			}
			$filename = $this->file[$handle];
			$str = implode("", @file($filename));
			if (empty($str))
			{
				$this->halt("loadfile: While loading $handle, $filename does not exist or is empty.");
				return false;
			}
			$this->set_var($handle, $str);
			return true;
	}
	function halt($msg)
	{
		$this->last_error = $msg;
		if ($this->halt_on_error != "no")
			$this->haltmsg($msg);
		if ($this->halt_on_error == "yes")
			die("<b>Halted.</b>");
			return false;
	}
	function haltmsg($msg)
	{
		printf("<b>Template Error:</b> %s<br>\n", $msg);
	}
}

/********************************************************************
check email formate (zend.com)
********************************************************************/
function mailval($Addr, $Level, $Timeout = 15000) { 

//  Valid Top-Level Domains 
    $gTLDs = "com:net:org:edu:gov:mil:int:arpa:info:biz:"; 
    $CCs   = "ad:ae:af:ag:ai:al:am:an:ao:aq:ar:as:at:au:aw:az:ba:bb:bd:be:bf:". 
             "bg:bh:bi:bj:bm:bn:bo:br:bs:bt:bv:bw:by:bz:ca:cc:cf:cd:cg:ch:ci:". 
             "ck:cl:cm:cn:co:cr:cs:cu:cv:cx:cy:cz:de:dj:dk:dm:do:dz:ec:ee:eg:". 
             "eh:er:es:et:fi:fj:fk:fm:fo:fr:fx:ga:gb:gd:ge:gf:gh:gi:gl:gm:gn:". 
             "gp:gq:gr:gs:gt:gu:gw:gy:hk:hm:hn:hr:ht:hu:id:ie:il:in:io:iq:ir:". 
             "is:it:jm:jo:jp:ke:kg:kh:ki:km:kn:kp:kr:kw:ky:kz:la:lb:lc:li:lk:". 
             "lr:ls:lt:lu:lv:ly:ma:mc:md:mg:mh:mk:ml:mm:mn:mo:mp:mq:mr:ms:mt:". 
             "mu:mv:mw:mx:my:mz:na:nc:ne:nf:ng:ni:nl:no:np:nr:nt:nu:nz:om:pa:". 
             "pe:pf:pg:ph:pk:pl:pm:pn:pr:pt:pw:py:qa:re:ro:ru:rw:sa:sb:sc:sd:". 
             "se:sg:sh:si:sj:sk:sl:sm:sn:so:sr:st:su:sv:sy:sz:tc:td:tf:tg:th:". 
             "tj:tk:tm:tn:to:tp:tr:tt:tv:tw:tz:ua:ug:uk:um:us:uy:uz:va:vc:ve:". 
             "vg:vi:vn:vu:wf:ws:ye:yt:yu:za:zm:zr:zw:"; 

//  The countries can have their own 'TLDs', e.g. mydomain.com.au 
    $cTLDs = "com:net:org:edu:gov:mil:co:ne:or:ed:go:mi:"; 

    $fail = 0; 

//  Shift the address to lowercase to simplify checking 
    $Addr = strtolower($Addr); 

//  Split the Address into user and domain parts 
    $UD = explode("@", $Addr); 
    if (sizeof($UD) != 2 || !$UD[0]) $fail = 1; 

//  Split the domain part into its Levels 
    $Levels = explode(".", $UD[1]); $sLevels = sizeof($Levels); 
    if ($sLevels < 2) $fail = 1; 

//  Get the TLD, strip off trailing ] } ) > and check the length 
    $tld = $Levels[$sLevels-1]; 
    $tld = ereg_replace("[>)}]$|]$", "", $tld); 
    if (strlen($tld) < 2 || strlen($tld) > 3 && $tld != "arpa") $fail = 1; 

    $Level--; 

//  If the string after the last dot isn't in the generic TLDs or country codes, it's invalid. 
    if ($Level && !$fail) { 
    $Level--; 
    if (!ereg($tld.":", $gTLDs) && !ereg($tld.":", $CCs)) $fail = 2; 
    } 

//  If it's a country code, check for a country TLD; add on the domain name. 
    if ($Level && !$fail) { 
    $cd = $sLevels - 2; $domain = $Levels[$cd].".".$tld; 
    if (ereg($Levels[$cd].":", $cTLDs)) { $cd--; $domain = $Levels[$cd].".".$domain; } 
    } 

//  See if there's an MX record for the domain 
    if ($Level && !$fail) { 
    $Level--; 
    if (!getmxrr($domain, $mxhosts, $weight)) $fail = 3; 
    } 

//  Attempt to connect to port 25 on an MX host 
    if ($Level && !$fail) { 
    $Level--; 
    while (!$sh && list($nul, $mxhost) = each($mxhosts)) 
      $sh = fsockopen($mxhost, 25); 
    if (!$sh) $fail = 4; 
    } 

//  See if anyone answers 
    if ($Level && !$fail) { 
    $Level--; 
    set_socket_blocking($sh, false); 
    $out = ""; $t = 0; 
    while ($t++ < $Timeout && !$out) 
      $out = fgets($sh, 256); 
    if (!ereg("^220", $out)) $fail = 5; 
    } 

    if(isset($sh)) fclose($sh); 

    return $fail; 
  }
 //MailVal


/*******************************************
MyCheckMail
*******************************************/
function checkmail($email)
{
	$emailcmpstr = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM-.@_1234567890";
	$host = substr($email, strrpos($email, '@') + 1, strlen($email) - strrpos($email, '@')); 
	if($email =="")
	{
		return false;
	}
	if(strspn($email, $emailcmpstr) != strlen($email))
	{
		return false;
	}
	
	if(eregi("^[a-z0-9\._-]+@+[a-z0-9\._-]+\.+[a-z]{2,3}$", $email))
	{
		return true;
	}else{
		return false;
	}
	return true; 
}

/*******************************************
DateSelector
*******************************************/
function DateSelector($range,$format,$formname)
{
	$counter = "0";
	$currentDay = date("d");
	$currentMonth = date("m");
	$currentYear = date("Y");
	$show ="<SELECT NAME=\"$formname\" SIZE=\"1\">\n";
	for($currentDay; $counter <= $range; $currentDay++)
	{
		if(strlen($currentDay)<2) {$currentDay = "0$currentDay";}
		if($currentDay==32)
		{
			$currentMonth = $currentMonth + 1;
			if($currentMonth >12)
			{
				$currentMonth = 1;
				$currentYear = $currentYear + 1;
			}
			$currentDay = 1;
		}
		if(!checkdate($currentMonth,$currentDay,$currentYear))
		{
		}else{
			if(strlen($currentDay)<2) {$currentDay = "0$currentDay";}
			if(strlen($currentMonth)<2) {$currentMonth = "0$currentMonth";}
			if($format =="1")
			{
				$show  .= "<OPTION VALUE=\"$currentYear$currentMonth$currentDay\">$currentDay  -  $currentMonth  -  $currentYear</option>\n";
			}else{
				$show  .= "<OPTION VALUE=\"$currentYear$currentMonth$currentDay\">$currentMonth  -  $currentDay  -  $currentYear</option>\n";
			}
			$counter = $counter + 1;
		}
	}
	$show .="</select>\n";
	return $show;
}

/*******************************************
Remove Specail Char from some text
*******************************************/
function RemoveSpecialChar($text)
{
	$text = stripslashes($text); 			// to remove any slashes caused by magic quotes 
	$text = eregi_replace( "'", "&rsquo;", $text); 	// to remove the ' 
	$text = eregi_replace( '"', "&quot;", $text); // " -> HTML code
	$text = nl2br($text); 			// new line to <BR> tag
	$text = str_replace("<br />","<br>", $text); 		// new line to <BR /> tag
	$text = eregi_replace( "\n", " ", $text); 	// remove nl to form field
	$text = eregi_replace( "\r", " ", $text); 	// remove nl to form field
	return $text;
}

/*******************************************
EmoticonToGraphic
*******************************************/
function EmoticonToGraphic($text)
{
	$text = str_replace( ":-)", "<img src=img/e/smiley.gif>", $text);
	$text = str_replace( ":-(", "<img src=img/e/sad.gif>", $text);
	$text = str_replace( ":-P", "<img src=img/e/tong.gif>", $text);
	$text = str_replace( "8-)", "<img src=img/e/cool.gif>", $text);
	$text = str_replace( "8-P", "<img src=img/e/cooltong.gif>", $text);
	$text = str_replace( "8-O", "<img src=img/e/coolmouth.gif>", $text);
	$text = str_replace( "8-(", "<img src=img/e/coolsad.gif>", $text);
	$text = str_replace( "%-)", "<img src=img/e/dazed.gif>", $text);
	$text = str_replace( "%-O", "<img src=img/e/dazedmouth.gif>", $text);
	$text = str_replace( "%-(", "<img src=img/e/dazedsad.gif>", $text);
	$text = str_replace( "%-P", "<img src=img/e/dazedtong.gif>", $text);
	$text = str_replace( ":-O", "<img src=img/e/mouth.gif>", $text);
	$text = str_replace( ";-)", "<img src=img/e/wink.gif>", $text);
	$text = str_replace( ";-O", "<img src=img/e/winkmouth.gif>", $text);
	$text = str_replace( ";-(", "<img src=img/e/winksad.gif>", $text);
	$text = str_replace( ";-P", "<img src=img/e/winktong.gif>", $text);
	return $text;
}

/*******************************************
FontFaceTestString
*******************************************/
function FontFaceTestString($FontName)
{
	$TagString = "<TR><TD BGCOLOR=\"#FFFFFF\"><FONT FACE=\"$FontName\" SIZE=\"2\">$FontName </FONT></TD><TD BGCOLOR=\"#FFFFFF\"><FONT FACE=\"$FontName\" SIZE=\"2\">$MsgWinSampleString</TD></TR>\n";
	return $TagString;
}

/*******************************************
Recpt Add
*******************************************/
function RecpFormField($range)
{
	$counter = "1";
	$show ="";
	for($counter; $counter <= $range; $counter++)
	{
		$show  .= "<TR>
		<TD><input type=\"text\" name=\"RecpName$counter\" value=\"\" SIZE=\"25\" MAXLENGTH=\"50\"></TD>
		<TD><input type=\"text\" name=\"RecpEmail$counter\" value=\"\" SIZE=\"25\" MAXLENGTH=\"50\"></TD>
		</TR> \n";
	}
	return $show;
}

/*******************************************
Function to mail recipient to pickup card Advance Send
*******************************************/
function SendPickupMailAdvance($RecpEmail,$RecpName,$SenderEmail,$SenderName,$MessageID)
{
	global $Recp_Subject,$Recp_Message,$AdminAddress,$ProgFullURL;
	global $Notification_Subject,$Notification_Message,$AdminAddress;

	$temp_Recp_Subject = str_replace("{recipient_name}", "$recip_name", $Recp_Subject);
	$temp_Recp_Subject = str_replace("{sender_name}", "$SenderName", $temp_Recp_Subject);
	
	$temp_Recp_Message = str_replace("{recipient_name}", "$recip_name", $Recp_Message);
	$temp_Recp_Message = str_replace("{recipient_email}", "$RecpEmail", $temp_Recp_Message);
	$temp_Recp_Message = str_replace("{sender_name}", "$SenderName", $temp_Recp_Message);
	$temp_Recp_Message = str_replace("{sender_email}", "$SenderEmail", $temp_Recp_Message);
	$temp_Recp_Message = str_replace("{pickup_link}", "$ProgFullURL/pickup.php?MessageID=$MessageID", $temp_Recp_Message);

	$headers  = "From: $SenderEmail\n";
	$headers .= "X-Sender: <$SenderEmail>\n"; 
	$headers .= "X-Mailer: PHP/$server_phpversion\n"; 	// mailer
	$headers .= "X-Priority: 3\n"; 				// 1-Urgent message! 2-very 3-normal
	$headers .= "Return-Path: <$RecpEmail>\n";  		// Return path for errors
	$headers .= "Content-Type: text/plain";

	mail("$RecpEmail", "$temp_Recp_Subject","$temp_Recp_Message",$headers);
}

/*******************************************
Function data to advance send
*******************************************/
function SaveAdvancePost($RecpEmail,$RecpName,$SenderName,$SenderEmail,$PostImage,$PostStamp, $PostMessage,$PostSig,$PostHeading,$PostSound,$PostBackGround,$PostColor,$PostTemplate,$PostFontFace,$PostFontColor,$PostFontSize,$randval,$PostBeNotify,$PostToSend,$PostSent)
{
	global $DB_site,$PostStatsTable,$PostImageTable,$PostUserTable;

	$randval = get_message_id();
	$logdate = date("Y-m-d H:m:s");
	$result = $DB_site->query("INSERT
		INTO $PostUserTable ( PostDate, SenderName, SenderEmail, RecpName, RecpEmail, PostImage, PostStamp, PostMessage, PostSig, PostHeading, PostSound, PostBackGround, PostColor, PostTemplate, PostFontFace, PostFontColor, PostFontSize, MessageID, PostBeNotify, PostToSend, PostSent)
		VALUES (CURDATE(),'$SenderName','$SenderEmail','$RecpName','$RecpEmail','$PostImage','$PostStamp', '$PostMessage','$PostSig','$PostHeading','$PostSound','$PostBackGround','$PostColor','$PostTemplate','$PostFontFace','$PostFontColor','$PostFontSize','$randval','$PostBeNotify','$PostToSend','$PostSent')
		 ");
	// query to stat
	$myrow 		= $DB_site->query_first("SELECT * FROM $PostImageTable WHERE CardImgFile='$PostImage' ");
	//$myrow 	= $DB_site->fetch_array($result2);
	$PostImgThm 	= $myrow['CardThmFile'];
	// insert info into card stat database
	$result = $DB_site->query("INSERT
		INTO $PostStatsTable ( date, PostImage, PostImageThm, PostStamp, PostSound, PostBackGround, PostTemplate)
		VALUES ('$logdate','$PostImage','$PostImgThm','$PostStamp', '$PostSound','$PostBackGround','$PostTemplate')");
}

/*******************************************
Function to mail recipient to pickup card
*******************************************/
function SendPickupMail($recip_email,$recip_name,$SenderName,$SenderEmail,$PostImage,$PostStamp, $PostMessage,$PostSig,$PostHeading,$PostSound,$PostBackGround,$PostColor,$PostTemplate,$PostFontFace,$PostFontColor,$PostFontSize,$randval,$PostBeNotify,$PostToSend,$PostSent)
{
	global $Recp_Subject,$Recp_Message,$AdminAddress,$ProgFullURL;
	global $DB_site,$PostUserTable,$PostStatsTable,$PostImageTable;
	
	$post_id = get_message_id();
	$logdate = date("Y-m-d H:m:s");

	$temp_Recp_Subject = str_replace("{recipient_name}", "$recip_name", $Recp_Subject);
	$temp_Recp_Subject = str_replace("{sender_name}", "$SenderName", $temp_Recp_Subject);

	$temp_Recp_Message = str_replace("{recipient_name}", "$recip_name", $Recp_Message);
	
	$temp_Recp_Message = str_replace("{recipient_name}", "$recip_name", $Recp_Message);
	$temp_Recp_Message = str_replace("{recipient_email}", "$recip_email", $temp_Recp_Message);
	$temp_Recp_Message = str_replace("{sender_name}", "$SenderName", $temp_Recp_Message);
	$temp_Recp_Message = str_replace("{sender_email}", "$SenderEmail", $temp_Recp_Message);
	$temp_Recp_Message = str_replace("{pickup_link}", "$ProgFullURL/pickup.php?MessageID=$post_id", $temp_Recp_Message);

	$headers  = "From: $sender_email\n";
	$headers .= "X-Sender: <$sender_email>\n"; 
	$headers .= "X-Mailer: PHP/$server_phpversion\n"; 	// mailer
	$headers .= "X-Priority: 3\n"; 				// 1-Urgent message! 2-very 3-normal
	$headers .= "Return-Path: <$recip_email>\n";  		// Return path for errors
	$headers .= "Content-Type: text/plain";

	mail("$recip_email", "$temp_Recp_Subject","$temp_Recp_Message",$headers);

	$PostSent = "Y";
	// insert info into card user database
	$result = $DB_site->query("INSERT
		INTO $PostUserTable ( PostDate, SenderName, SenderEmail, RecpName, RecpEmail, PostImage, PostStamp, PostMessage, PostSig, PostHeading, PostSound, PostBackGround, PostColor, PostTemplate, PostFontFace, PostFontColor, PostFontSize, MessageID, PostBeNotify, PostToSend, PostSent)
		VALUES (CURDATE(),'$SenderName','$SenderEmail','$recip_name','$recip_email','$PostImage','$PostStamp', '$PostMessage','$PostSig','$PostHeading','$PostSound','$PostBackGround','$PostColor','$PostTemplate','$PostFontFace','$PostFontColor','$PostFontSize','$post_id','$PostBeNotify','$PostToSend','$PostSent')
		 ");
	$myrow = $DB_site->query_first("SELECT * FROM $PostImageTable WHERE CardImgFile='$PostImage' ");
	$PostImgThm 	= $myrow['CardThmFile'];
	// insert info into card stat database
	$result = $DB_site->query("INSERT
		INTO $PostStatsTable ( date, PostImage, PostImageThm, PostStamp, PostSound, PostBackGround, PostTemplate)
		VALUES ('$logdate','$PostImage','$PostImgThm','$PostStamp', '$PostSound','$PostBackGround','$PostTemplate')");
}

/*******************************************
Function to mail sender about notification
*******************************************/
function SendNotifyMail($sender_email,$sender_name,$recip_name,$recip_email,$today_date)
{
	global $Notification_Subject,$Notification_Message,$AdminAddress;
	
	$temp_Notification_Subject = str_replace("{sender_name}","$sender_name", $Notification_Subject);
	$temp_Notification_Subject = str_replace("{recipient_name}","$recip_name", $temp_Notification_Subject);

	$temp_Notification_Message = str_replace("{recipient_name}","$recip_name", $Notification_Message);
	$temp_Notification_Message = str_replace("{sender_name}","$sender_name", $temp_Notification_Message);
	$temp_Notification_Message = str_replace("{today_date}","$today_date", $temp_Notification_Message);

	$headers  = "From: $recip_email\n";
	$headers .= "X-Sender: <$recip_email>\n"; 
	$headers .= "X-Mailer: PHP/$server_phpversion\n"; 	// mailer
	$headers .= "X-Priority: 3\n"; 				// 1-Urgent message! 2-very 3-normal
	$headers .= "Return-Path: <$sender_email>\n";  		// Return path for errors
	$headers .= "Content-Type: text/plain";

	mail("$sender_email","$temp_Notification_Subject","$temp_Notification_Message",$headers);
}

/*******************************************
bgimage =     image to use
ibody   = 0/1 include <BODY> tag
*******************************************/
function TAG_Body($bgimage ="")
{
	global $DefaultBGImage,$PostImageURL,$SiteBGCOLOR,$SiteTEXT,$SiteLINK,$SiteVLINK,$SiteALINK,$SiteMARGINHEIGHT,$SiteMARGINWIDTH;
	$show ="\n";
	if($DefaultBGImage !="" and $bgimage=="")
	{
		$bgimage ="$DefaultBGImage";
	}
	
	if($bgimage == "")
	{
		$show.= "<body bgcolor=\"$SiteBGCOLOR\" text=\"$SiteTEXT\" link=\"$SiteLINK\" vlink=\"$SiteVLINK\" alink=\"$SiteALINK\" topmargin=\"$SiteMARGINHEIGHT\" leftmargin=\"$SiteMARGINWIDTH\" marginwidth=\"$SiteMARGINWIDTH\" marginheight=\"$SiteMARGINHEIGHT\">\n";
	}else{
		$show.= "<body background=\"$PostImageURL/$bgimage\" bgcolor=\"$SiteBGCOLOR\" text=\"$SiteTEXT\" link=\"$SiteLINK\" vlink=\"$SiteVLINK\" alink=\"$SiteALINK\" topmargin=\"$SiteMARGINHEIGHT\" leftmargin=\"$SiteMARGINWIDTH\" marginwidth=\"$SiteMARGINWIDTH\" marginheight=\"$SiteMARGINHEIGHT\">\n";
	}
	return $show;
}

/*******************************************
file =    file
*******************************************/
function TAG_Stamp($file="")
{
	//global $SiteName,$SiteURL,$PostImageURL,$DefaultStampImg;
	global $SiteName,$SiteURL,$PostImageURL,$AllowChooseStamp,$DefaultStampImg; 
	$show ="\n";

	if($AllowChooseStamp =="Y")
	{
		if($file =="")
		{
			$show.="";
		}else{
			$show.="<a href=\"$SiteURL\"><img src=\"$PostImageURL/$file\" border=\"0\" alt=\"$SiteName\" HSPACE=\"6\" VSPACE=\"1\"></a>";
		}
	}else{
		if($DefaultStampImg =="")
		{
			$show.= "";
		}else{
			$show.= "<a href=\"$SiteURL\"><img src=\"$PostImageURL/$DefaultStampImg\" border=\"0\" alt=\"$SiteName\" HSPACE=\"6\" VSPACE=\"1\"></a>";
		}
	}
	return $show;
}

/*******************************************
Version 2
file =    file
*******************************************/
function TAG_Image($file = "",$url)
{
	global $FlashHeight,$FlashWidth,$MsgNoFlash,$MsgClickHereToGet;
	$show ="\n";

	if( eregi(".swf",$file) )
	{
		$show.="
		<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=4,0,2,0\" width=\"$FlashWidth\" height=\"$FlashHeight\">
		<param name=\"movie\" value=\"$url/$file\">
		<param name=\"quality\" value=\"high\">
		<param name=\"LOOP\" value=\"false\">
		<embed src=\"$url/$file\" quality=\"high\" pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" type=\"application/x-shockwave-flash\" width=\"$FlashWidth\" height=\"$FlashHeight\" loop=\"false\">
		<noembed>$MsgNoFlash <a href=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\">$MsgClickHereToGet</a></noembed>
		</embed>
		</object>";
	}else{
		$show.= "<img src=\"$url/$file\" border=\"0\" alt=\"\">";
	}
	return $show;
}

/*******************************************
file =    file
*******************************************/
function TAG_Music($file = "")
{
	global $PostSoundURL;
	$show ="\n";

	if ($file == ""){
		$show.="";
	}else{
		$show.="<br><EMBED SRC=\"$PostSoundURL/$file\" HEIGHT=\"25\" WIDTH=\"150\" AUTOSTART=\"true\" LOOP=\"true\">
		<noembed><BGSOUND SRC=\"$PostSoundURL/$file\" LOOP=\"INFINITE\"></noembed>";
	}
	return $show;
}

/*******************************************
fieldname =  hidden form field name
fieldvalue = hidden form field value
*******************************************/
function TAG_HiddenField($fieldname,$fieldvalue)
{
	echo "<input type=\"hidden\" name=\"$fieldname\" value=\"$fieldvalue\">\n";
}
/*******************************************
fieldname =  hidden form field name
fieldvalue = hidden form field value
*******************************************/
function TAG_ExtraRecpField($i,$name,$email)
{
	if( !mailval($email,2) and !empty($email) and !empty($name) )
	{
		echo "<input type=\"hidden\" name=\"RecpName$i\" value=\"$name\">\n";
		echo "<input type=\"hidden\" name=\"RecpEmail$i\" value=\"$email\">\n";
	}
}


/*******************************************
strg =    field content
erromsg = message error to return
*******************************************/
function CheckEmpty($strg,$errormsg ="")
{
	global $DefaultBGImage,$SiteFontFace,$MsgBackEditButton,$vCardLiteVersion;
	$show ="";
	if($strg=="")
	{
		echo TAG_Body($DefaultBGImage,1);
		include "./include/header.inc.php";
		echo "<BR><P><CENTER><FONT FACE=\"$SiteFontFace\" SIZE=\"3\"><B>";
		echo "$errormsg";
		echo "</B></FONT></P><P><FORM ACTION=\"javascript:history.go(-1)\" METHOD=\"POST\"><INPUT TYPE=\"submit\" VALUE=\"$MsgBackEditButton\" WIDTH=\"200\"></FORM><BR></P><BR></CENTER>";
		echo "\n<!-- COPYRIGHTS -->\n<p><center><font face=arial color=#777777 size=1><A HREF=http://www.belchiorfoundry.com/>Powered by: vCard Lite &copy;</A></FONT></P>\n<!-- /COPYRIGHTS -->\n";
		include "./include/footer.inc.php";
		exit;
	}
}

/*******************************************
FONT TAG Maker
face   = font face
size   = size
bold   = bold text
center = center text
text   = message
*******************************************/
function TagFont($face = "Arial",$size = "0",$bold = "0",$center = "0",$text)
{
	$show ="<font face=\"$face\"";
	if($size !="0")
	{
		$show.=" size=\"$size\"";
	}
	$show.=">";
	if($center =="1")
	{
		$show.="<center>";
	}
	if($bold =="1")
	{
	 	$show.="<b>";
	}
	$show.="$text";
	if($bold =="1")
	{
	 	$show.="</b>";
	}
	if($center =="1")
	{
		$show.="</center>";
	}
	$show.="</font>\n";
	return $show;
}

/*******************************************
Copyright
*******************************************/
function MyCopyright()
{
	global $vCardLiteVersion;
	$show ="<!-- COPYRIGHTS -->\n<p align=\"center\"><FONT FACE=\"Arial\" color=\"#777777\" size=\"1\"><A HREF=\"http://www.belchiorfoundry.com/\" TARGET=\"_blank\" STYLE=\"text-decoration:none; color: #777777; font-family: Arial;\">Powered by: vCard Lite $vCardLiteVersion</A><br>&copy;2001, Belchior Foundry.</FONT></P>\n<!-- /COPYRIGHTS -->\n";
	return $show;
}

/*******************************************
Back BAR
*******************************************/
function TagBackBar($qto ="1",$msg =" ")
{
	$show ="<P><BR>
	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\" align=\"center\" bgcolor=\"#000000\"><tr><td>
	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" bgcolor=\"#C0C0C0\">
	<tr>
		<td align=\"center\"><font face=\"Verdana\" size=\"3\"><b><a href=\"javascript:history.go(-$qto)\"  STYLE=\"text-decoration:none; color: #000000; font-family: Verdana;\">$msg</a>&nbsp;</b></font></td>
	</tr>
	</table>
	</td></tr></table>";
	return $show;
}

function dohtmlbackbutton($backn="-1")
{
	global $MsgBackButton;
	print "<br><CENTER><P align=\"center\"><FORM ACTION=\"javascript:history.go($backn)\" METHOD=\"POST\"><INPUT TYPE=\"submit\" VALUE=\"$MsgBackButton\" WIDTH=\"200\"></FORM></P><BR></CENTER>\n";
}

/*******************************************
Custom Tags
*******************************************/
// Tags of WIN.php
$FontTag2 = "<FONT FACE=\"$SiteFontFace\" SIZE=\"2\">";
$FontTag3 = "<FONT FACE=\"$SiteFontFace\" SIZE=\"3\">";
$FontTag4 = "<FONT FACE=\"$SiteFontFace\" SIZE=\"4\">";

// Admin pages
function dohtmladminheader()
{
	global $MsgAdminPage,$SiteFontFace;
	print "
<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\" align=\"center\" bgcolor=\"#000000\"><tr><td>
<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" align=\"center\" bgcolor=\"#C0C0C0\">
<tr>
	<td align=\"left\">&nbsp;<font face=\"Verdana\" size=\"5\" color=\"#000000\"><b>vCard Lite</font> <font face=\"$SiteFontFace\" size=\"5\" color=\"#000000\">$MsgAdminPage</b></font></td>
	<td align=\"right\"><font face=\"Verdana\" size=\"4\"><b><a href=\"http://www.belchiorfoundry.com/\"  STYLE=\"text-decoration:none; color: #000000; font-family: Verdana;\" target=\"_blank\">Belchior Foundry</a>&nbsp;</b></font></td>
</tr>
</table>
</td></tr></table>";
}

$TagStartText ="<blockquote><font face=\"$SiteFontFace\"size=\"2\"><B>";
$TagEndText ="</B></font></blockquote>";

function checkrefer()
{
	global $ProgFullURL,$HTTP_REFERER;
	
	if(!eregi($ProgFullURL,$HTTP_REFERER))
	{
		echo "forbidden access";
		exit;
	}
}

/********************************************************************
check var expression
********************************************************************/
function cexpr($expression,$return_true,$return_false)
{
	if($expression==0)
	{
		return $return_false;
	}else{
		return $return_true;
	}
}

/********************************************************************
get file extension
********************************************************************/
function getextension($filename)
{
	$filename 	= strtolower($filename);
	$extension 	= split("[/\\.]", $filename);
	$n 		= count($extension)-1;
	$extension 	= $extension[$n];
	return $extension;
}

/********************************************************************
Create a uid to message
********************************************************************/
function get_message_id()
{
	$pool  = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"; 
	$pool .= "abcdefghijklmnopqrstuvwxyz"; 
	$pool .= "0123456789"; 
	mt_srand ((double) microtime() * 1000000);
	$unique_id = "";
	for ($index = 0; $index < 14; $index++)
	{
		$unique_id .= substr($pool, (mt_rand()%(strlen($pool))), 1);
	}// end for
	$unique_id = date("ymd").$unique_id;
	return $unique_id;
}// end get_message_id 

?>