<?php
/***************************************************************************
 *   script               : vCard LITE
 *   copyright            : (C) 2001-2003 Belchior Foundry
 *   website              : www.belchiorfoundry.com
 *
 *   This program is freeware software; you cant redistribute it under
 *   any circumstance without explicit authorization from Belchior Foundry.
 *   http://www.belchiorfoundry.com/
 *
 ***************************************************************************/
class Template
{
	var $classname = "Template";
	var $debug = false;
	var $file = array();
	var $root = "";
	var $varkeys = array();
	var $varvals = array();
	var $unknowns = "remove";
	var $halt_on_error = "yes";
	var $last_error = "";
	function Template($root='./templates', $unknowns='remove')
	{
		$this->set_root($root);
		$this->set_unknowns($unknowns);
	}
	function set_root($root)
	{
		if (!is_dir($root))
		{
			$this->halt("set_root: $root is not a directory.");
			return false;
		}
		$this->root = $root;
		return true;
	}
	function set_unknowns($unknowns = "keep")
	{
		$this->unknowns = $unknowns;
	}
	function set_file($handle, $filename = "")
	{
		if (!is_array($handle))
		{
			if ($filename == "")
			{
				$this->halt("set_file: For handle $handle filename is empty.");
				return false;
			}
			$this->file[$handle] = $this->filename($filename);
		}
		else
		{
			reset($handle);
			while(list($h, $f) = each($handle))
			{
				$this->file[$h] = $this->filename($f);
			}
		}
	}
	function set_block($parent, $handle, $name = "")
	{
		if (!$this->loadfile($parent))
		{
			$this->halt("subst: unable to load $parent.");
			return false;
		}
		if ($name == "")
			$name = $handle;
			$str = $this->get_var($parent);
			$reg = "/<!--\s+BEGIN $handle\s+-->(.*)\n\s*<!--\s+END $handle\s+-->/sm";
			preg_match_all($reg, $str, $m);
			$str = preg_replace($reg, "{" . "$name}", $str);
			$this->set_var($handle, $m[1][0]);
			$this->set_var($parent, $str);
	}
	function set_var($varname, $value = "")
	{
		if (!is_array($varname))
		{
			if (!empty($varname))
			if ($this->debug) print "scalar: set *$varname* to *$value*<br>\n";
			$this->varkeys[$varname] = "/".$this->varname($varname)."/";
			$this->varvals[$varname] = $value;
		}else{
			reset($varname);
			while(list($k, $v) = each($varname))
			{
				if (!empty($k))
				if ($this->debug) print "array: set *$k* to *$v*<br>\n";
				$this->varkeys[$k] = "/".$this->varname($k)."/";
				$this->varvals[$k] = $v;
			}
		}
	}
	function subst($handle)
	{
		if (!$this->loadfile($handle))
		{
			$this->halt("subst: unable to load $handle.");
			return false;
		}
		$str = $this->get_var($handle);
		$str = @preg_replace($this->varkeys, $this->varvals, $str);
		return $str;
	}
	function psubst($handle)
	{
		print $this->subst($handle);
		return false;
	}
	function parse($target, $handle, $append = false)
	{
		if (!is_array($handle))
		{
			$str = $this->subst($handle);
			if ($append)
			{
				$this->set_var($target, $this->get_var($target) . $str);
			}else{
				$this->set_var($target, $str);
			}
		}else{
			reset($handle);
			while(list($i, $h) = each($handle))
			{
				$str = $this->subst($h);
				$this->set_var($target, $str);
			}
		}
		return $str;
	}
	function pparse($target, $handle, $append = false)
	{
		print $this->parse($target, $handle, $append);
		return false;
	}
	function get_vars()
	{
		reset($this->varkeys);
		while(list($k, $v) = each($this->varkeys))
		{
			$result[$k] = $this->varvals[$k];
		}
		return $result;
	}
	function get_var($varname)
	{
		if (!is_array($varname))
		{
			return $this->varvals[$varname];
		}else{
			reset($varname);
			while(list($k, $v) = each($varname))
			{
				$result[$k] = $this->varvals[$k];
			}
			return $result;
		}
	}
	function get_undefined($handle)
	{
		if (!$this->loadfile($handle))
		{
			$this->halt("get_undefined: unable to load $handle.");
			return false;
		}
		preg_match_all("/\{([^}]+)\}/", $this->get_var($handle), $m);
		$m = $m[1];
		if (!is_array($m))
		return false;
		reset($m);
		while(list($k, $v) = each($m))
		{
			if (!isset($this->varkeys[$v]))
				$result[$v] = $v;
		}
		if (count($result))
			return $result;
		else
			return false;
	}
	function finish($str)
	{
		switch ($this->unknowns)
		{
			case "keep":
				break;
			case "remove":
				$str = preg_replace('/{[^ \t\r\n}]+}/', "", $str);
				break;
			case "comment":
				$str = preg_replace('/{([^ \t\r\n}]+)}/', "<!-- Template $handle: Variable \\1 undefined -->", $str);
				break;
		}
		return $str;
	}
	function p($varname)
	{
		print $this->finish($this->get_var($varname));
	}
	function get($varname)
	{
		return $this->finish($this->get_var($varname));
	}
	function filename($filename)
	{
		if (substr($filename, 0, 1) != "/")
		{
			$filename = $this->root."/".$filename;
		}
	if (!file_exists($filename))
		$this->halt("filename: file $filename does not exist.");
		return $filename;
	}
	function varname($varname)
	{
		return preg_quote("{".$varname."}");
	}
	function loadfile($handle)
	{
		if (isset($this->varkeys[$handle]) and !empty($this->varvals[$handle]))
			return true;
			if (!isset($this->file[$handle]))
			{
				$this->halt("loadfile: $handle is not a valid handle.");
				return false;
			}
			$filename = $this->file[$handle];
			$str = implode("", @file($filename));
			if (empty($str))
			{
				$this->halt("loadfile: While loading $handle, $filename does not exist or is empty.");
				return false;
			}
			$this->set_var($handle, $str);
			return true;
	}
	function halt($msg)
	{
		$this->last_error = $msg;
		if ($this->halt_on_error != "no")
			$this->haltmsg($msg);
		if ($this->halt_on_error == "yes")
			die("<b>Halted.</b>");
			return false;
	}
	function haltmsg($msg)
	{
		printf("<b>Template Error:</b> %s<br>\n", $msg);
	}
}

/********************************************************************
check email formate (zend.com)
********************************************************************/
function mailval($Addr, $Level, $Timeout = 15000) { 

//  Valid Top-Level Domains 
    $gTLDs = "com:net:org:edu:gov:mil:int:arpa:info:biz:name:pro:eu:coop:museum:"; 
    $CCs   = "ac:ad:ae:af:ag:ai:al:am:an:ao:aq:ar:as:at:au:aw:az:ba:bb:bd:be:bf:". 
             "bg:bh:bi:bj:bm:bn:bo:br:bs:bt:bv:bw:by:bz:ca:cc:cf:cd:cg:ch:ci:". 
             "ck:cl:cm:cn:co:cr:cs:cu:cv:cx:cy:cz:de:dj:dk:dm:do:dz:ec:ee:eg:". 
             "eh:er:es:et:fi:fj:fk:fm:fo:fr:fx:ga:gb:gd:ge:gf:gh:gi:gl:gm:gn:". 
             "gp:gq:gr:gs:gt:gu:gw:gy:hk:hm:hn:hr:ht:hu:id:ie:il:in:io:iq:ir:". 
             "is:it:jm:jo:jp:ke:kg:kh:ki:km:kn:kp:kr:kw:ky:kz:la:lb:lc:li:lk:". 
             "lr:ls:lt:lu:lv:ly:ma:mc:md:mg:mh:mk:ml:mm:mn:mo:mp:mq:mr:ms:mt:". 
             "mu:mv:mw:mx:my:mz:na:nc:ne:nf:ng:ni:nl:no:np:nr:nt:nu:nz:om:pa:". 
             "pe:pf:pg:ph:pk:pl:pm:pn:pr:pt:pw:py:qa:re:ro:ru:rw:sa:sb:sc:sd:". 
             "se:sg:sh:si:sj:sk:sl:sm:sn:so:sr:st:su:sv:sy:sz:tc:td:tf:tg:th:". 
             "tj:tk:tm:tn:to:tp:tr:tt:tv:tw:tz:ua:ug:uk:um:us:uy:uz:va:vc:ve:". 
             "vg:vi:vn:vu:wf:ws:ye:yt:yu:za:zm:zr:zw:"; 

//  The countries can have their own 'TLDs', e.g. mydomain.com.au 
    $cTLDs = "com:net:org:edu:gov:mil:co:ne:or:ed:go:mi:"; 

    $fail = 0; 

//  Shift the address to lowercase to simplify checking 
    $Addr = strtolower($Addr); 

//  Split the Address into user and domain parts 
    $UD = explode("@", $Addr); 
    if (sizeof($UD) != 2 || !$UD[0]) $fail = 1; 

//  Split the domain part into its Levels 
    $Levels = explode(".", $UD[1]); $sLevels = sizeof($Levels); 
    if ($sLevels < 2) $fail = 1; 

//  Get the TLD, strip off trailing ] } ) > and check the length 
    $tld = $Levels[$sLevels-1]; 
    $tld = ereg_replace("[>)}]$|]$", "", $tld); 
    if (strlen($tld) < 2 || strlen($tld) > 6 && $tld != "arpa") $fail = 1; 

    $Level--; 

//  If the string after the last dot isn't in the generic TLDs or country codes, it's invalid. 
    if ($Level && !$fail) { 
    $Level--; 
    if (!ereg($tld.":", $gTLDs) && !ereg($tld.":", $CCs)) $fail = 2; 
    } 

//  If it's a country code, check for a country TLD; add on the domain name. 
    if ($Level && !$fail) { 
    $cd = $sLevels - 2; $domain = $Levels[$cd].".".$tld; 
    if (ereg($Levels[$cd].":", $cTLDs)) { $cd--; $domain = $Levels[$cd].".".$domain; } 
    } 

//  See if there's an MX record for the domain 
    if ($Level && !$fail) { 
    $Level--; 
    if (!getmxrr($domain, $mxhosts, $weight)) $fail = 3; 
    } 

//  Attempt to connect to port 25 on an MX host 
    if ($Level && !$fail) { 
    $Level--; 
    while (!$sh && list($nul, $mxhost) = each($mxhosts)) 
      $sh = fsockopen($mxhost, 25); 
    if (!$sh) $fail = 4; 
    } 

//  See if anyone answers 
    if ($Level && !$fail) { 
    $Level--; 
    set_socket_blocking($sh, false); 
    $out = ""; $t = 0; 
    while ($t++ < $Timeout && !$out) 
      $out = fgets($sh, 256); 
    if (!ereg("^220", $out)) $fail = 5; 
    } 

    if(isset($sh)) fclose($sh); 

    return $fail; 
  }
 //MailVal


/*******************************************
MyCheckMail
*******************************************/
function checkmail($email)
{
	$emailcmpstr = "qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM-.@_1234567890";
	$host = substr($email, strrpos($email, '@') + 1, strlen($email) - strrpos($email, '@')); 
	if($email =="")
	{
		return false;
	}
	if(strspn($email, $emailcmpstr) != strlen($email))
	{
		return false;
	}
	
	if(eregi("^[a-z0-9\._-]+@+[a-z0-9\._-]+\.+[a-z]{2,3}$", $email))
	{
		return true;
	}else{
		return false;
	}
	return true; 
}

/*******************************************
DateSelector
*******************************************/
function DateSelector($range,$format,$formname,$selected)
{
	global $cfg;
	$d=getdate($cfg['timestamp']);
	$yr=$d['year'];
	$mo=$d['mon'];
	$da=$d['mday'];
	$hr=$d['hours'];
	$mi=$d['minutes'];
	$se=$d['seconds'];

	$i = 0;
	$currentDay = $da;
	$currentMonth = $mo;
	$currentYear = $yr;
	$show ="<select name='$formname' size'1'>\n";
	for($currentDay; $i <= $range; $currentDay++)
	{
		if(strlen($currentDay)<2) {$currentDay = "0$currentDay";}
		if($currentDay==32)
		{
			$currentMonth = $currentMonth + 1;
			if($currentMonth >12)
			{
				$currentMonth = 1;
				$currentYear = $currentYear + 1;
			}
			$currentDay = 1;
		}
		if(checkdate($currentMonth,$currentDay,$currentYear))
		{
			if(strlen($currentDay)<2) {$currentDay = "0$currentDay";}
			if(strlen($currentMonth)<2) {$currentMonth = "0$currentMonth";}
			
			$option_date = "$currentYear-$currentMonth-$currentDay";
			$show .= "<option value='$option_date' ";
			$show .= ($selected == $option_date)? ' selected> ':' >';
			$show .= ($format ==1)? "$currentDay  -  $currentMonth  -  $currentYear": "$currentMonth  -  $currentDay  -  $currentYear";
			$show .= '</option>';
			$i++;
		}
	}
	$show .='</select>';
	return $show;
}

/*******************************************
Remove Specail Char from some text
*******************************************/
function RemoveSpecialChar($text)
{
	$text = stripslashes($text); 			// to remove any slashes caused by magic quotes 
	$text = eregi_replace( "'", "&rsquo;", $text); 	// to remove the ' 
	$text = eregi_replace( '"', "&quot;", $text); // " -> HTML code
	$text = nl2br($text); // new line to <BR> tag
	$text = str_replace('<br />','<br>', $text); 		// new line to <BR /> tag (no xhtml)
	$text = eregi_replace( "\n",' ', $text); 	// remove nl to form field
	$text = eregi_replace( "\r",' ', $text); 	// remove nl to form field
	return $text;
}

/*******************************************
EmoticonToGraphic
*******************************************/
function EmoticonToGraphic($text)
{
	$text = str_replace( ":-)", "<img src=img/e/smiley.gif>", $text);
	$text = str_replace( ":-(", "<img src=img/e/sad.gif>", $text);
	$text = str_replace( ":-P", "<img src=img/e/tong.gif>", $text);
	$text = str_replace( "8-)", "<img src=img/e/cool.gif>", $text);
	$text = str_replace( "8-P", "<img src=img/e/cooltong.gif>", $text);
	$text = str_replace( "8-O", "<img src=img/e/coolmouth.gif>", $text);
	$text = str_replace( "8-(", "<img src=img/e/coolsad.gif>", $text);
	$text = str_replace( "%-)", "<img src=img/e/dazed.gif>", $text);
	$text = str_replace( "%-O", "<img src=img/e/dazedmouth.gif>", $text);
	$text = str_replace( "%-(", "<img src=img/e/dazedsad.gif>", $text);
	$text = str_replace( "%-P", "<img src=img/e/dazedtong.gif>", $text);
	$text = str_replace( ":-O", "<img src=img/e/mouth.gif>", $text);
	$text = str_replace( ";-)", "<img src=img/e/wink.gif>", $text);
	$text = str_replace( ";-O", "<img src=img/e/winkmouth.gif>", $text);
	$text = str_replace( ";-(", "<img src=img/e/winksad.gif>", $text);
	$text = str_replace( ";-P", "<img src=img/e/winktong.gif>", $text);
	return $text;
}

/*******************************************
FontFaceTestString
*******************************************/
function FontFaceTestString($FontName)
{
	$TagString = "<tr><td bgcolor=\"#FFFFFF\"><font face=\"$FontName\" size=\"2\">$FontName </font></td><td bgcolor=\"#FFFFFF\"><font face=\"$FontName\" size=\"2\">$MsgWinSampleString</td></tr>\n";
	return $TagString;
}

/*******************************************
Recpt Add
*******************************************/
function RecpFormField($range)
{
	$counter = "1";
	$show ="";
	for($counter; $counter <= $range; $counter++)
	{
		$show  .= "<tr>
		<td><input type='text' name='ecard_rname$counter' value='' size='25' maxlength='50'></td>
		<td><input type='text' name='ecard_remail$counter' value='' size='25' maxlength='50'></td>
		</tr> \n";
	}
	return $show;
}

/*******************************************
Function to mail recipient to pickup card Advance Send
*******************************************/
function SendPickupMailAdvance($ecard_remail,$ecard_rname,$ecard_semail,$ecard_sname,$ecard_id)
{
	global $Recp_Subject,$Recp_Message,$AdminAddress,$ProgFullURL,$charset;
	global $Notification_Subject,$Notification_Message,$AdminAddress;

	$ecard_rname = str_replace( "&rsquo;",'', $ecard_rname);
	$ecard_rname = str_replace( "&quot;",'', $ecard_rname);
	$ecard_sname = str_replace( "&rsquo;",'', $ecard_sname);
	$ecard_sname = str_replace( "&quot;",'', $ecard_sname);
	
	$ecard_rname1 = str_replace( "&rsquo;", "", $ecard_rname);
	$ecard_rname1 = str_replace( "&quot;", '"', $ecard_rname1);
	$ecard_sname1 = str_replace( "&rsquo;", "", $ecard_sname);
	$ecard_sname1 = str_replace( "&quot;",'"' , $ecard_sname1);
	
	$subject = str_replace("{recipient_name}", "$ecard_rname1", $Recp_Subject);
	$subject = str_replace("{sender_name}", "$ecard_sname1", $subject);
	
	$message = str_replace("{recipient_name}", "$ecard_rname1", $Recp_Message);
	$message = str_replace("{recipient_email}", "$ecard_remail", $message);
	$message = str_replace("{sender_name}", "$ecard_sname1", $message);
	$message = str_replace("{sender_email}", "$ecard_semail", $message);
	$message = str_replace("{pickup_link}", "$ProgFullURL/pickup.php?ecard_id=$ecard_id", $message);

	$headers  = "From: $ecard_semail\r\n";
	$headers .= "X-Sender: <$ecard_semail>\r\n"; 
	$headers .= "X-Mailer: PHP/$server_phpversion\r\n"; 	// mailer
	$headers .= "X-Priority: 1\r\n"; 				// 1-Urgent message! 2-very 3-normal
	$headers .= "Return-Path: <$ecard_semail>\r\n";  		// Return path for errors
	$headers .= "Content-Type: text/plain; charset=$charset\r\n";

	mail($ecard_remail, $subject,$message,$headers);
	//echo " mail($ecard_remail, $temp_Recp_Subject,$temp_Recp_Message,$headers) ";
}

/*******************************************
Function data to advance send
*******************************************/
function SaveAdvancePost($ecard_remail,$ecard_rname,$ecard_sname,$ecard_semail,$card_image,$stamp_file, $ecard_message,$ecard_sig,$ecard_heading,$sound_file,$pattern_file,$ecard_color,$card_template,$ecard_fontface,$ecard_fontcolor,$ecard_fontsize,$ecard_notify,$ecard_tosend,$ecard_sent)
{
	global $DB_site,$dbtbl_stats,$dbtbl_card,$dbtbl_user;
	global $client_ip;

	$ecard_sent = 0;
	$ecard_id = get_message_id();
	$logdate = date("Y-m-d H:m:s");
	$result = $DB_site->query("INSERT
		INTO $dbtbl_user ( ecard_date, ecard_sname, ecard_semail, ecard_sip, ecard_rname, ecard_remail, card_image, stamp_file, ecard_message, ecard_sig, ecard_heading, sound_file, pattern_file, ecard_color, card_template, ecard_fontface, ecard_fontcolor, ecard_fontsize, ecard_id, ecard_notify, ecard_tosend, ecard_sent)
		VALUES (CURDATE(),'$ecard_sname','$ecard_semail','$client_ip','$ecard_rname','$ecard_remail','$card_image','$stamp_file', '$ecard_message','$ecard_sig','$ecard_heading','$sound_file','$pattern_file','$ecard_color','$card_template','$ecard_fontface','$ecard_fontcolor','$ecard_fontsize','$ecard_id','$ecard_notify','$ecard_tosend','$ecard_sent')
		 ");
	// query to stat
	service_log($ecard_remail,$ecard_rname,$ecard_sname,$ecard_semail,$ecard_id);
	$myrow = $DB_site->query_first("SELECT * FROM $dbtbl_card WHERE card_image='$card_image' ");
	$PostImgThm = $myrow['card_thm'];
	$result = $DB_site->query("INSERT
		INTO $dbtbl_stats ( date, card_image, card_thm, stamp_file, sound_file, pattern_file, card_template)
		VALUES ('$logdate','$card_image','$PostImgThm','$stamp_file', '$sound_file','$pattern_file','$card_template')");
	spam_inserdata();
}

/*******************************************
Function to mail recipient to pickup card
*******************************************/
function SendPickupMail($recip_email,$recip_name,$ecard_sname,$ecard_semail,$card_image,$stamp_file, $ecard_message,$ecard_sig,$ecard_heading,$sound_file,$pattern_file,$ecard_color,$card_template,$ecard_fontface,$ecard_fontcolor,$ecard_fontsize,$ecard_notify,$ecard_tosend,$ecard_sent)
{
	global $Recp_Subject,$Recp_Message,$AdminAddress,$ProgFullURL,$charset;
	global $DB_site,$dbtbl_user,$dbtbl_stats,$dbtbl_card;
	global $client_ip;
	
	$post_id = get_message_id();
	$logdate = date("Y-m-d H:m:s");
	$ecard_sent = 1;
	
	$recip_name1 = str_replace( "&rsquo;", "", $recip_name);
	$recip_name1 = str_replace( "&quot;", '"', $recip_name1);
	$ecard_sname1 = str_replace( "&rsquo;", "", $ecard_sname);
	$ecard_sname1 = str_replace( "&quot;",'"' , $ecard_sname1);

	
	$subject = str_replace("{recipient_name}",$recip_name1, $Recp_Subject);
	$subject = str_replace("{sender_name}", $ecard_sname1, $subject);

	$message = str_replace("{recipient_name}", $recip_name1, $Recp_Message);
	$message = str_replace("{recipient_email}", $recip_email, $message);
	$message = str_replace("{sender_name}", $ecard_sname1, $message);
	$message = str_replace("{sender_email}", $ecard_semail, $message);
	$message = str_replace("{pickup_link}", "$ProgFullURL/pickup.php?ecard_id=$post_id", $message);

	$headers  = "From: $ecard_semail\r\n";
	$headers .= "X-Sender: <$ecard_semail>\r\n"; 
	$headers .= "X-Mailer: PHP\r\n"; 	// mailer
	$headers .= "X-Priority: 1\r\n"; 				// 1-Urgent message! 2-very 3-normal
	$headers .= "Return-Path: <$ecard_semail>\r\n";  		// Return path for errors
	$headers .= "Content-Type: text/plain; charset=$charset\r\n";

	service_log($recip_email,$recip_name,$ecard_sname,$ecard_semail,$post_id);
	mail($recip_email,$subject,$message,$headers);
	
	// insert info into card user database
	$result = $DB_site->query("INSERT
		INTO $dbtbl_user ( ecard_date, ecard_sname,  ecard_semail, ecard_sip, ecard_rname, ecard_remail, card_image, stamp_file, ecard_message, ecard_sig, ecard_heading, sound_file, pattern_file, ecard_color, card_template, ecard_fontface, ecard_fontcolor, ecard_fontsize, ecard_id, ecard_notify, ecard_tosend, ecard_sent)
		VALUES ( CURDATE(),'$ecard_sname','$ecard_semail','$client_ip','$recip_name','$recip_email','$card_image','$stamp_file', '$ecard_message','$ecard_sig','$ecard_heading','$sound_file','$pattern_file','$ecard_color','$card_template','$ecard_fontface','$ecard_fontcolor','$ecard_fontsize','$post_id','$ecard_notify','$ecard_tosend','$ecard_sent')
		 ");
	$myrow = $DB_site->query_first("SELECT * FROM $dbtbl_card WHERE card_image='$card_image' ");
	$PostImgThm 	= $myrow['card_thm'];
	// insert info into card stat database
	$result = $DB_site->query("INSERT
		INTO $dbtbl_stats ( date, card_image, card_thm, stamp_file, sound_file, pattern_file, card_template)
		VALUES ('$logdate','$card_image','$PostImgThm','$stamp_file', '$sound_file','$pattern_file','$card_template')");
	spam_inserdata();
}

/*******************************************
Function to mail sender about notification
*******************************************/
function SendNotifyMail($sender_email,$sender_name,$recip_name,$recip_email,$today_date)
{
	global $Notification_Subject,$Notification_Message,$AdminAddress,$charset;

	$sender_name = str_replace( "&rsquo;", "", $sender_name);
	$sender_name = str_replace( "&quot;", '"', $sender_name);
	
	$recip_name = str_replace( "&rsquo;", "", $recip_name);
	$recip_name = str_replace( "&quot;",'"' , $recip_name);
	
	$temp_Notification_Subject = str_replace("{sender_name}",$sender_name, $Notification_Subject);
	$temp_Notification_Subject = str_replace("{recipient_name}",$recip_name, $temp_Notification_Subject);

	$temp_Notification_Message = str_replace("{recipient_name}",$recip_name, $Notification_Message);
	$temp_Notification_Message = str_replace("{sender_name}",$sender_name, $temp_Notification_Message);
	$temp_Notification_Message = str_replace("{today_date}",$today_date, $temp_Notification_Message);

	$headers  = "From: $recip_email\r\n";
	$headers .= "X-Sender: <$recip_email>\r\n"; 
	$headers .= "X-Mailer: PHP\r\n"; 	// mailer
	$headers .= "X-Priority: 1\r\n"; 				// 1-Urgent message! 2-very 3-normal
	$headers .= "Return-Path: <$recip_email>\r\n";  		// Return path for errors
	$headers .= "Content-Type: text/plain; charset=$charset\r\n";

	mail($sender_email,$temp_Notification_Subject,$temp_Notification_Message,$headers);
}

function spam_inserdata() {
	global $DB_site,$enduser_ip,$dbtbl_spam;
	
	$DB_site->query("INSERT INTO $dbtbl_spam VALUES (NULL,'$enduser_ip','".time()."') ");
}

/*******************************************
bgimage =     image to use
ibody   = 0/1 include <BODY> tag
*******************************************/
function TAG_Body($bgimage ="")
{
	global $DefaultBGImage,$card_imageURL,$SiteBGCOLOR,$SiteTEXT,$SiteLINK,$SiteVLINK,$SiteALINK,$SiteMARGINHEIGHT,$SiteMARGINWIDTH;
	$show ="\n";
	if($DefaultBGImage !="" and $bgimage=="")
	{
		$bgimage ="$DefaultBGImage";
	}
	
	if($bgimage == "")
	{
		$show.= "<body bgcolor='$SiteBGCOLOR' text='$SiteTEXT' link='$SiteLINK' vlink='$SiteVLINK' alink='$SiteALINK' topmargin='$SiteMARGINHEIGHT' leftmargin='$SiteMARGINWIDTH' marginwidth='$SiteMARGINWIDTH' marginheight='$SiteMARGINHEIGHT'>\n";
	}else{
		$show.= "<body background='$card_imageURL/$bgimage' bgcolor='$SiteBGCOLOR' text='$SiteTEXT' link='$SiteLINK' vlink='$SiteVLINK' alink='$SiteALINK' topmargin='$SiteMARGINHEIGHT' leftmargin='$SiteMARGINWIDTH' marginwidth='$SiteMARGINWIDTH' marginheight='$SiteMARGINHEIGHT'>\n";
	}
	return $show;
}

/*******************************************
file =    file
*******************************************/
function TAG_Stamp($file='')
{
	global $SiteName,$SiteURL,$card_imageURL,$AllowChooseStamp,$DefaultStampImg; 
	if($AllowChooseStamp =="Y")
	{
		$file = $file;
	}else{
		if (!empty($DefaultStampImg))
		{
			$file = $DefaultStampImg;
		}else{
			$file = '';
		}
	}
	if( eregi('http://',$file) )
	{
		$file_url = $file;
	}else{
		$file_url = $card_imageURL.'/'.$file;
	}
	if(!empty($file))
	{
		$show = "<a href='$SiteURL'><img src='$file_url' border='0' alt='$SiteName' hspace='6' vspace='1'></a>";
	}else{
		$show = '';
	}
	return $show;
}

function TAG_Image($file = "",$url)
{
	global $FlashHeight,$FlashWidth,$MsgNoFlash,$MsgClickHereToGet;
	global $card_imagePath;

	if( eregi('http://',$file) )
	{
		$file_url = $file;
	}else{
		$file_url = $url.'/'.$file;
	}
	$file_ext = getextension($file);
	if( $file_ext == 'swf' )
	{
		$show ="
		<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=4,0,2,0\" width=\"$FlashWidth\" height=\"$FlashHeight\">
		<param name=\"movie\" value=\"$file_url\">
		<param name=\"quality\" value=\"high\">
		<param name=\"LOOP\" value=\"false\">
		<embed src=\"$file_url\" quality=\"high\" pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" type=\"application/x-shockwave-flash\" width=\"$FlashWidth\" height=\"$FlashHeight\" loop=\"false\">
		<noembed>$MsgNoFlash <a href=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\">$MsgClickHereToGet</a></noembed>
		</embed>
		</object>";
	}elseif( $file_ext=='jav' || $file_ext=='txt'){
		$file_path = $card_imagePath.'/'.str_replace('./','',str_replace('../','',$file));
		$filesize = @filesize($file_path);
		$filenum = @fopen($file_path,"r");
		$filestuff = @fread($filenum,$filesize);
		$show = $filestuff;
	}else{
		$show = "<img src='$file_url' border='0' alt=''>";
	}
	return $show;
}

/*******************************************
file =    file
*******************************************/
function TAG_Music($file = "")
{
	global $sound_fileURL;
	$show ="\n";
	
	if (eregi('http://',$file) )
	{
		$file_url = $file;
	}else{
		$file_url = "$sound_fileURL/$file";
	}
	if ($file == ""){
		$show.="";
	}else{
		$show.="<br><embed src='$file_url' height='25' width='150' autostart='true' loop='true'><noembed><bgsound src='$file_url' loop='infinite'></noembed>";
	}
	return $show;
}

/*******************************************
fieldname =  hidden form field name
fieldvalue = hidden form field value
*******************************************/
function TAG_HiddenField($name,$value='')
{
	if(is_array($name))
	{
		foreach($name as $key=>$val)
		{
			echo "<input type='hidden' name='$key' value='$val'>\n";
		}
	}else{
		echo "<input type='hidden' name='$name' value='$value'>\n";
	}
}
/*******************************************
fieldname =  hidden form field name
fieldvalue = hidden form field value
*******************************************/
function TAG_ExtraRecpField($i,$name,$email)
{
	if( !mailval($email,2) and !empty($email) and !empty($name) )
	{
		echo "<input type='hidden' name='ecard_rname$i' value='$name'>\n";
		echo "<input type='hidden' name='ecard_remail$i' value='$email'>\n";
	}
}


/*******************************************
strg =    field content
erromsg = message error to return
*******************************************/
function CheckEmpty($strg,$errormsg ="")
{
	global $DefaultBGImage,$SiteFontFace,$MsgBackEditButton,$vCardLiteVersion;
	$show ='';
	if(empty($strg))
	{
		echo TAG_Body($DefaultBGImage,1);
		include "./include/header.inc.php";
		echo "<br><p><center><font face='$SiteFontFace' size='3'><b>";
		echo "$errormsg";
		echo "</b></font></p><p><form action='javascript:history.go(-1)' method='POST'><input type='submit' value='$MsgBackEditButton' width='200'></form><br></p><br></center>";
		echo "\n<!-- COPYRIGHTS -->\n<p><center><font face='arial' color='#777777' size='1'><a href='http://www.belchiorfoundry.com/'>Powered by: vCard Lite &copy;</a></font></p>\n<!-- /COPYRIGHTS -->\n";
		include "./include/footer.inc.php";
		exit;
	}
}
function get_hidden_vars() 
{ 
	global $HTTP_POST_VARS;
	
    foreach($HTTP_POST_VARS as $input_name => $input_value)
	{
		if($input_name != 'action')
		{
			$hidden_inputs .= "<input name='$input_name' type='hidden' value='$input_value'>\n"; 
		}
	}
        return $hidden_inputs; 
}
function do_checkempty($strg,$errormsg ="")
{
	global $DefaultBGImage,$SiteFontFace,$MsgBackEditButton,$vCardLiteVersion;
	$show ="";
	if($strg=="")
	{
		dovcardliteheader();
		//echo TAG_Body($DefaultBGImage,1);
		//include "./include/header.inc.php";
		echo "<br><p><center><font face='$SiteFontFace' size='3'><b>";
		echo "$errormsg";
		echo "</b></font></p><p><form action='create.php' method='post'>";
		echo get_hidden_vars();
		echo "<input type='submit' value='$MsgBackEditButton' width='200'></form><br></p><br></center>";
		echo "\n<!-- COPYRIGHTS -->\n<p><center><font face='arial' color='#777777' size='1'><a href='http://www.belchiorfoundry.com/'>Powered by: vCard Lite &copy;</a></font></p>\n<!-- /COPYRIGHTS -->\n";
		//include "./include/footer.inc.php";
		dovcardlitefooter();
		exit;
	}
}

/*******************************************
FONT TAG Maker
face   = font face
size   = size
bold   = bold text
center = center text
text   = message
*******************************************/
function TagFont($face = "Arial",$size = "0",$bold = "0",$center = "0",$text)
{
	$show ="<font face='$face' ";
	if($size !=0)
	{
		$show.=" size='$size' ";
	}
	$show.='>';
	if($center ==1)
	{
		$show.='<center>';
	}
	if($bold ==1)
	{
	 	$show.='<b>';
	}
	$show.= $text;
	if($bold ==1)
	{
	 	$show.='</b>';
	}
	if($center ==1)
	{
		$show.='</center>';
	}
	$show.='</font>';
	return $show;
}

/*******************************************
Copyright
*******************************************/
function MyCopyright()
{
	global $vCardLiteVersion;
	$show ="<!-- COPYRIGHTS -->\n<p align='center'><font face='Arial' color='#777777' size='1'><a href='http://www.belchiorfoundry.com/' target='_blank' style='text-decoration:none; color: #777777; font-family: Arial;'>Powered by: vCard Lite $vCardLiteVersion</a><br>&copy;2001-2003, Belchior Foundry.</font></p>\n<!-- /COPYRIGHTS -->\n";
	return $show;
}

/*******************************************
Back BAR
*******************************************/
function TagBackBar($qto ="1",$msg =" ")
{
	$show ="<p><br>
	<table width='100%' border='0' cellspacing='0' cellpadding='1' align='center' bgcolor='#000000'><tr><td>
	<table width='100%' border='0' cellspacing='0' cellpadding='0' align='center' bgcolor='#C0C0C0'>
	<tr>
		<td align='center'><font face='Verdana' size='3'><b><a href='javascript:history.go(-$qto)'  style='text-decoration:none; color: #000000; font-family: Verdana;'>$msg</a>&nbsp;</b></font></td>
	</tr>
	</table>
	</td></tr></table>";
	return $show;
}

function dohtmlbackbutton($backn="-1")
{
	global $MsgBackButton;
	print "<br><center><p align='center'><form action='javascript:history.go($backn)' method='POST'><input type='submit' value='$MsgBackButton' width='200'></form></p><br></center>\n";
}

/*******************************************
Custom Tags
*******************************************/
// Tags of WIN.php
$FontTag2 = "<font face='$SiteFontFace' size='2'>";
$FontTag3 = "<font face='$SiteFontFace' size='3'>";
$FontTag4 = "<font face='$SiteFontFace' size='4'>";

// Admin pages
function dohtmladminheader()
{
	global $MsgAdminPage,$SiteFontFace;
	print "<table width='100%' border='0' cellspacing='0' cellpadding='1' align='center' bgcolor='#000000'><tr><td>
<table width='100%' border='0' cellspacing='0' cellpadding='0' align='center' bgcolor='#C0C0C0'>
<tr>
	<td align='left'>&nbsp;<font face='Verdana' size='5' color='#000000'><b>vCard Lite</font> <font face='$SiteFontFace' size='5' color='#000000'>$MsgAdminPage</b></font></td>
	<td align='right'><font face='Verdana' size='4'><b><a href='http://www.belchiorfoundry.com/'  style='text-decoration:none; color: #000000; font-family: Verdana;' target='_blank'>Belchior Foundry</a>&nbsp;</b></font></td>
</tr>
</table>
</td></tr></table>";
}

$TagStartText ="<blockquote><font face='$SiteFontFace' size='2'><b>";
$TagEndText ="</b></font></blockquote>";

function checkrefer()
{
	global $si,$ses,$ProgFullURL,$local_referer,$noadminrefer;
	if ($si!=$ses)
	{
		echo 'Forbidden Access';
		exit;
	}
	/*
	$ProgFullURL = str_replace('http://www.','', $ProgFullURL);
	$ProgFullURL = str_replace('http://','', $ProgFullURL);
	if($noadminrefer ==1)
	{
	}else{
		if(!eregi($ProgFullURL,$local_referer))
		{
			echo "forbidden access - $ProgFullURL,$local_referer";
			exit;
		}
	}
	*/
}

/********************************************************************
check var expression
********************************************************************/
function cexpr($expression,$return_true,$return_false)
{
	if($expression==0)
	{
		return $return_false;
	}else{
		return $return_true;
	}
}

/********************************************************************
get file extension
********************************************************************/
function getextension($filename)
{
	$filename 	= strtolower($filename);
	$extension 	= split("[/\\.]", $filename);
	$n 		= count($extension)-1;
	$extension 	= $extension[$n];
	return $extension;
}

/********************************************************************
Create a uid to message
********************************************************************/
function get_message_id()
{
	$pool  = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'; 
	$pool .= 'abcdefghijklmnopqrstuvwxyz'; 
	$pool .= '0123456789'; 
	mt_srand ((double) microtime() * 1000000);
	$unique_id = "";
	for ($index = 0; $index < 12; $index++)
	{
		$unique_id .= substr($pool, (mt_rand()%(strlen($pool))), 1);
	}// end for
	$unique_id = date("ymdHms").$unique_id;
	return $unique_id;
}// end get_message_id 

function get_day_after($card_date) {

	list ($year, $month, $day) = split ('[/.-]', $card_date);
	$sec_pass = mktime() - mktime(0,0,0, $month, $day, $year);
	$day_pass = floor( $sec_pass / 86400); // % div modulo
	return $day_pass;
}

/* new icon */
function gethml_newbutton($card_date) {
	global $site_new_days;
	
	$days = get_day_after($card_date);
	//echo "$site_new_days >= $days <br>";
	if($site_new_days >= $days)
	{
		return "<img src='img/icon_new.gif' border='0' alt=''>";
	}
}

function spammer_killer() {
	global $DB_site,$dbtbl_spam,$enduser_ip,$antispam_policy,$antispam_allow_entries,$SiteFontFace;
	
	$time = time()-3600;
	//echo $time;
	$DB_site->query("DELETE FROM $dbtbl_spam WHERE date < $time");
	$spam_detected = $DB_site->query("SELECT * FROM $dbtbl_spam WHERE ip='$enduser_ip' AND date > $time");
	$num_rows = $DB_site->num_rows();
	if($num_rows >= $antispam_allow_entries)
	{
		dovcardliteheader();
		echo TagFont($SiteFontFace,3,1,1,$antispam_policy);
		dovcardlitefooter();
		exit;
	}
}

function service_log($recip_email,$recip_name,$ecard_sname,$ecard_semail,$ecard_id) {
	global $client_ip,$DB_site,$dbtbl_slog;
	
	$sql = " INSERT INTO $dbtbl_slog (logid,date,sentdate,sname,semail,sip,rname,remail,ecard_id)
	         VALUES (NULL, NOW(),NOW(), '".addslashes($ecard_sname)."', '".addslashes($ecard_semail)."', '$client_ip', '".addslashes($recip_name)."', '".addslashes($recip_email)."', '".addslashes($ecard_id)."') "; 
	$add = $DB_site->query($sql);
}

function timestamp_to_human($ts) {

	$d=getdate($ts);
	$yr=$d["year"];
	$mo=$d["mon"];
	$da=$d["mday"];
	$hr=$d["hours"];
	$mi=$d["minutes"];
	$se=$d["seconds"];
	
	return sprintf("%02d/%02d/%04d %02d:%02d",$da,$mo,$yr,$hr,$mi);
}

?>