<?php 
/***************************************************/
/* Calendar-Class v1.0.0.                          */
/* Author: tgc_md                                  */
/* Date: 04.03.2003                                */
/* E-Mail: tgc_md@tool-garage.de                   */
/* Website: http://www.tool-garage.de              */
/***************************************************/
?>

<style type="text/css">
<!--

table {   border: 1px solid Black;  background-color: White;   }
th { background-color: #EFEFEF;  color: Black;  font-family: Arial, Helvetica, sans-serif;  font-size: 11px;  font-weight: bold;           }
td { background-color: #EFEFEF;  color: #696969;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;       }
a { color: #434343;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;  text-decoration: none;    }

a:hover {
	color: #F37710;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;
}
a:visited, a:link {
	color: #434343;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;
}

td.empty { background-color: #EFEFEF;  color: #696969;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;       }
td.sunday { background-color: #EFEFEF;  color: #F94500;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;       }
td.today { background-color: #EFEFEF;  color: Green;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;       }
td.headdays { background-color: #EFEFEF;  color: Black;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;       }
td.ago { background-color: #EFEFEF;  color: #C9C9C9;  font-family: Arial, Helvetica, sans-serif;  font-size: 10px;       }

-->
</style>

<?php 

    class Calendar
    {
        var $day = 0;
        var $month = 0;
        var $year = 0;
        var $lang = ""; // possible are "ge" or "en"
        var $days_str = Array(); // array for the days names (Mon-Tue-Wed-...)
        var $months_str = Array(); // array for the months names (Jan-Feb-Mar-...)
        
        var $show_arrows = TRUE; // determines whether the display arrows in the calendar-headline
        var $next_month = NULL; // value for the href-param in the <a> Tag :: next-arrow
        var $prev_month = NULL; // value for the href-param in the <a> Tag :: prev-arrow
            

//---------------------------------------------------------------------------
// Constructor
//---------------------------------------------------------------------------
        function Calendar ( $d=0, $m=0, $y=0, $lang="ge" )
        {
            $this->day = ( $d==0 ) ? $this->day = (int) date ( "d" ) : $this->day = $d;
            $this->month = ( $m==0 ) ? $this->month = (int) date ( "m" ) : $this->month = $m;
            $this->year = ( $y==0 ) ? $this->year = (int) date ( "Y" ) : $this->year = $y; 
            $this->lang = $lang; 
            
            if ( $this->lang == "ge" )
            {
                $this->days_str = Array (   "Sonntag", "Montag", "Dienstag", "Mittwoch",
                                            "Donnerstag", "Freitag", "Samstag" );
                $this->months_str = Array ( "Januar", "Februar", "M&auml;rz", "April", "Mai", "Juni", "Juli",
                                            "August", "September", "Oktober", "November", "Dezember" );
            }
            elseif ( $this->lang == "en" )
            {
                $this->days_str = Array(    "Sunday", "Monday", "Tuesday", "Wednesday",
                                            "Thursday", "Friday", "Saturday" );
                $this->months_str = Array(  "January", "February", "March", "April", "May", "June", "July",
                                            "August", "September", "October", "November", "December" ); 
            }
        }
//---------------------------------------------------------------------------
        

//---------------------------------------------------------------------------
// set the Date
//---------------------------------------------------------------------------
        function set_date ( $d, $m, $y )
        {
            $this->day = $d;
            $this->month = $m;
            $this->year = $y; 
        }
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// get Date as Array
//---------------------------------------------------------------------------
        function get_date ( )
        {
            return Array ( $this->day, $this->month, $this->year );
        }
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// set next-Link
//---------------------------------------------------------------------------
        function set_next ( $val )
        {
            $this->next_month = $val;
        }
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// set prev-Link
//---------------------------------------------------------------------------
        function set_prev ( $val )
        {
            $this->prev_month = $val;
        }
//---------------------------------------------------------------------------

        
//---------------------------------------------------------------------------
// Returns a value from Monday - Sunday in the selected language
//---------------------------------------------------------------------------
        function get_weekday_as_string ( $d=0, $m=0, $y=0 )
        {
            if ( $d!=0 )   $this->day = $d;
            if ( $m!=0 )   $this->month = $m;
            if ( $y!=0 )   $this->year = $y;
                        
            $tmp = (int) date ( "w", mktime ( 0,0,0,$this->month,$this->day,$this->year ) );
            return $this->days_str[$tmp];
        }
//---------------------------------------------------------------------------
        
        
//---------------------------------------------------------------------------
// Returns a value from 0 - 6
//---------------------------------------------------------------------------
        function get_weekday_as_num ( $d=0, $m=0, $y=0 )
        {
            if ( $d!=0 )   $this->day = $d;
            if ( $m!=0 )   $this->month = $m;
            if ( $y!=0 )   $this->year = $y;
                        
            $tmp = (int) date ( "w", mktime ( 0,0,0,$this->month,$this->day,$this->year ) );
            if ( $tmp == 0 )   return 7;
            else   return $tmp;
        }
//---------------------------------------------------------------------------
        

//---------------------------------------------------------------------------
// Returns a value from January - December in the selected language
//---------------------------------------------------------------------------
        function get_month_as_string ( $m=0, $y=0 )
        {
            if ( $m!=0 )   $this->month = $m;
            if ( $y!=0 )   $this->year = $y;
                        
            $tmp = (int) date ( "n", mktime ( 0,0,0,$this->month,1,$this->year ) );
            return $this->months_str[$tmp-1];
        }
//---------------------------------------------------------------------------

        
//---------------------------------------------------------------------------
// Determines whether a day is a Saturday or Sunday
// Return:  true  - if date is a Saturday or Sunday
//          false - any other case  
//---------------------------------------------------------------------------
        function is_day_of_weekend ( $d=0, $m=0, $y=0 )
        {
            if ( $d!=0 )   $this->day = $d;
            if ( $m!=0 )   $this->month = $m;
            if ( $y!=0 )   $this->year = $y;
                        
            $tmp = (int) date ( "w", mktime ( 0,0,0,$this->month,$this->day,$this->year ) );
            if ( $tmp == 0 || $tmp == 6 )   return true;
            else   return false;
        }
//---------------------------------------------------------------------------
        
    
//---------------------------------------------------------------------------
// Determines whether a day is a Sunday
// Return:  true  - if date is a Sunday
//          false - any other case  
//---------------------------------------------------------------------------
        function is_sunday ( $d=0, $m=0, $y=0 )
        {
            if ( $d!=0 )   $this->day = $d;
            if ( $m!=0 )   $this->month = $m;
            if ( $y!=0 )   $this->year = $y;
                        
            $tmp = (int) date ( "w", mktime ( 0,0,0,$this->month,$this->day,$this->year ) );
            if ( $tmp == 0 )   return true;
            else   return false;
        }
//---------------------------------------------------------------------------    
    
        
//---------------------------------------------------------------------------
// returns the last day of the month as integer
//---------------------------------------------------------------------------
        function get_last_day_of_month ( $m=0, $y=0 )
        {
            if ( $m!=0 )   $this->month = $m;
            if ( $y!=0 )   $this->year = $y;
            
            return (int) date ( "t", mktime ( 0,0,0,$this->month,1,$this->year ) );
        }
//---------------------------------------------------------------------------


//---------------------------------------------------------------------------
// bool :: determines if a date is todays date :: for internal use
//---------------------------------------------------------------------------
        function is_today ( )
        {
            $d_today = (int) date ( "d" );
            $m_today = (int) date ( "m" );
            $y_today = (int) date ( "Y" );
            
            if ( $d_today==$this->day && $m_today==$this->month && $y_today==$this->year )
                return TRUE;
            else return FALSE;            
        }
//---------------------------------------------------------------------------
  
  
//---------------------------------------------------------------------------
// sets the arrow-nav-variables to std-values :: for internal use
//---------------------------------------------------------------------------
        function mk_nav ( )
        {
            if ( $this->prev_month == NULL )
            {
                if ( $this->month == 1 )
                {
                    $_m = 12;
                    $_y = $this->year - 1;
                    $_l = $this->lang;
                }  
                else
                {
                    $_m = $this->month - 1;
                    $_y = $this->year;
                    $_l = $this->lang;
                }   
                $this->prev_month = "$PHP_SELF?d=1&m=$_m&y=$_y&l=$_l";
            }
            
            if ( $this->next_month == NULL )
            {
                if ( $this->month == 12 )
                {
                    $_m = 1;
                    $_y = $this->year + 1;
                    $_l = $this->lang;
                }  
                else
                {
                    $_m = $this->month + 1;
                    $_y = $this->year;
                    $_l = $this->lang;
                }   
                $this->next_month = "$PHP_SELF?d=1&m=$_m&y=$_y&l=$_l";
            }
        }  
//---------------------------------------------------------------------------        
  
  
//---------------------------------------------------------------------------
// displays a calendar
//---------------------------------------------------------------------------
        function mk_calendar ( $m=0, $y=0 )
        {
            // write instance values to tmp-var
            $d_tmp = $this->day;
            $m_tmp = $this->month;
            $y_tmp = $this->year;
            
            if ( $m!=0 )   $this->month = $m;
            if ( $y!=0 )   $this->year = $y; 

            $this->mk_nav ( );
            
            // Table-Head
            $head_month = "<table border='0' cellpadding='2' cellspacing='0'>\n";
            $head_month .= "<tr>\n";
            if ( $this->show_arrows == FALSE )
                $head_month .= "<th>&nbsp;</th>\n";
            else
                $head_month .= "<th> <a href='". $this->prev_month ."'>&lt;&lt;</a> </th>\n";
            $head_month .=  "<th colspan='5'>";
            $head_month .= $this->get_month_as_string ( $this->month, $this->year ); 
            $head_month .= " " . $this->year;
            $head_month .=  "</th>\n";
            if ( $this->show_arrows == FALSE )
                $head_month .= "<th>&nbsp;</th>\n";
            else
                $head_month .= "<th> <a href='". $this->next_month ."'>&gt;&gt;</a> </th>\n";
            $head_month .= "</tr>\n";
            
            // Table-Subhead --> Weekdays
            $head_weekdays = "<tr>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Mo" : "Mon";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Di" : "Tue";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Mi" : "Wed";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Do" : "Thu";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Fr" : "Fri";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Sa" : "Sat";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "So" : "Sun";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "</tr>\n";     
            
            // Table-Body --> Numbers
            $start_col = $this->get_weekday_as_num ( 1,$this->month,$this->year );
            
            $last_day = $this->get_last_day_of_month ( $this->month,$this->year );
            $end_col = $this->get_weekday_as_num ( $last_day,$this->month,$this->year );

            $body = "<tr>\n";

            // empty cells before day 1
            for ( $i=1; $i<$start_col; $i++ )
                $body .= "<td class='empty'>&nbsp;</td>\n";
            
            // day 1 till last day of month
            $this->day = 1;
            while ( $this->day <= $last_day )
            {
                $col = $this->get_weekday_as_num ();
                if ( $col == 1 )   $body .= "<tr>\n";
                    
                if ( $col == 7 )   
                {
                    if ( $this->is_today() == TRUE ) $class = "class='today'";
                    else $class = "class='sunday'";
                        
                    $body .= "<td align='right' $class >". $this->day ."</td>\n";
                    $body .= "</tr>\n";
                } 
                else 
                {
                    if ( $this->is_today() == TRUE ) $class = "class='today'";
                    else $class = "";
                    
                    $body .= "<td align='right' $class >". $this->day ."</td>\n";
                }
                
                $this->day++;
            }
            
            // empty cells after last day
            for ( $i=$end_col; $i<7; $i++ )
                $body .= "<td class='empty'>&nbsp;</td>\n";  
                
            $body .= "</tr>\n";          
            
            $foot = "</table>\n";
            
            // write tmp-values into instance again
            $this->day = $d_tmp;
            $this->month = $m_tmp;
            $this->year = $y_tmp;            
            
            return $head_month . $head_weekdays . $body . $foot;
        }
//---------------------------------------------------------------------------
        

//---------------------------------------------------------------------------
// displays a calendar
//---------------------------------------------------------------------------
        function mk_calendar_from_offset ( $d=0, $m=0, $y=0 )
        {
            // write instance values to tmp-var
            $d_tmp = $this->day;
            $m_tmp = $this->month;
            $y_tmp = $this->year;
            
            if ( $d!=0 )   $this->day = $d;
            if ( $m!=0 )   $this->month = $m;
            if ( $y!=0 )   $this->year = $y; 

            $this->mk_nav ( );
            
            $offset = $this->day;  

            // Table-Head
            $head_month = "<table border='0' cellpadding='2' cellspacing='0'>\n";
            $head_month .= "<tr>\n";
            if ( $this->show_arrows == FALSE )
                $head_month .= "<th>&nbsp;</th>\n";
            else
                $head_month .= "<th> <a href='". $this->prev_month ."'>&lt;&lt;</a> </th>\n";
            $head_month .=  "<th colspan='5'>";
            $head_month .= $this->get_month_as_string ( $this->month, $this->year ); 
            $head_month .= " " . $this->year;
            $head_month .=  "</th>\n";
            if ( $this->show_arrows == FALSE )
                $head_month .= "<th>&nbsp;</th>\n";
            else
                $head_month .= "<th> <a href='". $this->next_month ."'>&gt;&gt;</a> </th>\n";
            $head_month .= "</tr>\n";
            
            // Table-Subhead --> Weekdays
            $head_weekdays = "<tr>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Mo" : "Mon";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Di" : "Tue";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Mi" : "Wed";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Do" : "Thu";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Fr" : "Fri";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "Sa" : "Sat";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "<td class='headdays'>";
            $head_weekdays .= ( $this->lang == "ge" ) ? "So" : "Sun";
            $head_weekdays .= "</td>\n";
            $head_weekdays .= "</tr>\n";    
            
            // Table-Body --> Numbers
            $tmp_start_col = $this->get_weekday_as_num ( 1,$this->month,$this->year );
            $start_col = $this->get_weekday_as_num ( $this->day,$this->month,$this->year );
            
            $last_day = $this->get_last_day_of_month ( $this->month,$this->year );
            $end_col = $this->get_weekday_as_num ( $last_day,$this->month,$this->year );

            $body = "<tr>\n";

            // empty cells before day 1
            for ( $i=1; $i<$tmp_start_col; $i++ )
                $body .= "<td>&nbsp;</td>\n";

            // days that are already over
            $i = 1;
            $this->day = 1;
            while ( $i < $offset )
            {
                $col = $this->get_weekday_as_num ();
                if ( $col == 1 )   $body .= "<tr>\n";
                    
                if ( $col == 7 )   
                {
                    $body .= "<td align='right' class='ago'>". $this->day ."</td>\n";
                    $body .= "</tr>\n";
                } 
                else   $body .= "<td align='right' class='ago'>". $this->day ."</td>\n";
                
                $this->day++;
                $i++;
            }
            
            // days to go incl. $offset - day
            $this->day = $offset;
            while ( $this->day <= $last_day )
            {
                $col = $this->get_weekday_as_num ();
                if ( $col == 1 )   $body .= "<tr>\n";
                    
                if ( $col == 7 )   
                {
                    if ( $this->is_today() == TRUE ) $class = "class='today'";
                    else $class = "class='sunday'";
                        
                    $body .= "<td align='right' $class><b>". $this->day ."</b></td>\n";
                    $body .= "</tr>\n";
                } 
                else
                {
                    if ( $this->is_today() == TRUE ) $class = "class='today'";
                    else $class = "";
                    
                    $body .= "<td align='right' $class>". $this->day ."</td>\n";
                }
                
                $this->day++;
            }
            
            for ( $i=$end_col; $i<7; $i++ )
                $body .= "<td class='empty'>&nbsp;</td>\n";  
                
            $body .= "</tr>\n";          
            
            $foot = "</table>\n";
            
            // write tmp-values into instance again
            $this->day = $d_tmp;
            $this->month = $m_tmp;
            $this->year = $y_tmp;   
            
            return $head_month . $head_weekdays . $body . $foot;
        }
//---------------------------------------------------------------------------

        
//---------------------------------------------------------------------------
// displays the class-variables
//---------------------------------------------------------------------------
        function show ( )
        {
            echo "<p>\n";
            echo "\$day: " . $this->day . "<br>\n";
            echo "\$month: " . $this->month . "<br>\n";
            echo "\$year: " . $this->year . "<br>\n";
            
            echo "\$lang: " . $this->lang . "<br>\n";

            echo "\$show_arrows: " . $this->show_arrows . "<br>\n";
            echo "\$next_month: ";
             echo ( $this->next_month == NULL ) ? "NULL" : $this->next_month; 
             echo "<br>\n";
            echo "\$prev_month: ";
             echo ( $this->prev_month == NULL ) ? "NULL" : $this->prev_month; 
             echo "<br>\n";
            echo "</p>\n";
        }
//---------------------------------------------------------------------------
    } 
?>