<?PHP

// File: $Id: config.php,v 1.2 2002/02/06 17:58:39 windowsix Exp $ $Name:  $
// ----------------------------------------------------------------------
// TextAds Text Ads Management System
// Copyright (C) 2001 by Window Six
// http://www.windowsix.com/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Original Author of this file: William Rini
// Purpose of this file: Configuration file for TextAds
// ----------------------------------------------------------------------





if (eregi("config.php",$PHP_SELF)) {
    Header("Location: /");
    die();
}


/*      DB CONFIG OPTIONS  */

$ads_dbhost                 = "localhost";
$ads_dbuname                = "[ENTER THE DB USER NAME]";
$ads_dbpass                 = "[ENTER THE DB USER PASSWORD]";
$ads_dbname                 = "textads_";


/*   GENERAL CONFIG OPTIONS   */

$signup 		= "/textads/index.php";			/* location of signup form */
$reports		= "/textads/reports.php";		/* location of report form */
$radmin			= "/textads/radmin.php";		/* location of admin form  */
$addir			= "/textads/";				/* Directory of the ads program */
$minads			= "2500";				/* Minimun ads that can be ordered */
$costper		= ".004";  				/* Cost per ad! */
$defurl			= "[ENTER http://yoursite]";	  	/* Main URL for the website  */
$shash			= "[ENTER RANDOM VALUES]"; 	  	/* Hash value for user reports   */
$ashash                 = "[ENTER RANDOM VALUES]";  		/* Hash value for admin reports  */
$adminpass		= "[ENTER ADMIN PASS]";			/* Encrypted Admin password */
$adminemail		= "[ENTER ADMIN EMAIL]";		/* Admin email address */
$page_title		= "TextAds";				/* Title used on all pages */
$ta_sitename		= "[YOUR SITE NAME]";			/* Name of your website  */
$dumpfile 		= "[ENTER PATH]/$GLOBALS[dbname]_"; 	/*  Location where you want your ad database backed up to each evening  */

$cms_nuke               = 0;                                    /* Are you using a Nuke based CMS?  PHPNuke, PostNuke, phpWebSite, etc. */

$default_ad_url		= $GLOBALS[defurl];
$default_ad_shorttext	= $GLOBALS[ta_sitename];
$default_ad_text	= "[ENTER DEFAULT AD TEXT]";

$update_subject		= "Your Ad Is Approved";		/* Subject line for approval emails */
$update_sender		= "[ENTER EMAIL ADDRESS]";		/* Address approval emails come from */
$password_sender	= "[ENTER EMAIL ADDRESS]";	  	/* Address new passwords come from */


$email_on_purchase      = 1;                                    /* 1 if you want to receive purchases notices 0 if not */
$purchase_email         = "[ENTER EMAIL ADDRESS]";  	        /* Email address to send purchase notices */
$purchase_subject       = "$GLOBALS[ta_sitename] PURCHASE";     /* Subject of purchase notification */


/*
//      Some webservers/programs require that the server use GMT as the default timezone.
//      If this is the case, set $gmoffset to the number of seconds ahead of or behind
//      GMT of your timezone.  For instance, Pacific Standard Time is -8 hours.  So
//      the $gmtoffset = 28800 which equals 60 seconds * 60 minutes * 8 hours.  If you
//      want to use GMT, set $gmtoffset to 0.
*/

$gmtoffset              = "28800";


/*
//
//      Configure the site colors
//
*/

$ttcolor                = "#FFCC66";    /* Color for title row in reports  */
$tlcolor                = "#CCCC99";    /* Color for the spacer lines  */
$tbcolor                = "#FFFFFF";    /* Color for table backgrounds */


/*
//      
//      PAYPAL CONFIG OPTIONS   
//
*/

$pp_email               = "[ENTER YOUR PAYPAL ID]"; 					/* Address registered with PayPal */
$pp_quantity            = "1"; 								/* Quantity being ordered (always 1) */
$pp_itemname            = "Advertising"; 						/* Name of item being purchased */
$pp_itemnum             = "1000547"; 							/* Fake SKU for tracking purchases */
$pp_ref                 = "https://www.paypal.com/";			  		/* PayPal affiliates URL */
$pp_login               = "https://www.paypal.com/cgi-bin/webscr?cmd=_login-run"; 	/* PayPal login page */
$pp_pay_url             = "https://www.paypal.com/cgi-bin/webscr?cmd=_xclick"; 		/* PayPal to redirect ad buyers to  */



$status_0		= "Pending Approval";			/* Name assigned to accounts not yet approved */
$status_1 		= "Active";				/* Name assigned to active accounts */
$status_2		= "Inactive";				/* Name assigned to inactive accounts */
$status_3		= "Delete";				/* Name assigned to accounts deleted */


/*  MINIMUM NUMBER OF CHARACTERS  */

$min_url_length         = "11";	/*  Minimum # of characters in a url  */
$min_url_desc_length    = "3";	/*  Minimum # of characters in url description  */
$min_adtext_length      = "5";	/*  Minimum # of characters in the ad text  */
$min_uname_length       = "5";	/*  Minimum # of characters in the user name  */
$min_email_length       = "5";	/*  Minimum # of characters in the email address  */
$min_pass_length        = "4";	/*  Minimum # of characters in the password  */

/*  MAXIMUM NUMBER OF CHARACTERS  */

$max_url_length		= "100";/*  Max # of characters (database max is 200)  */
$max_url_desc_length	= "35";	/*  Max # of characters (database max is 50)  */
$max_adtext_length	= "75";	/*  Max # of characters (database max is 100)  */
$max_uname_length	= "50";	/*  Max # of characters (database max is 50)  */
$max_email_length	= "50";	/*  Max # of characters (database max is 50)  */
$max_pass_length	= "10";	/*  Max # of characters (database max is 50 - 10 recommended)  */


/* FOOTER TAGLINE  */

$footer_tagline = "<center><a href=\"http://www.windowsix.com\"><img src=\"$GLOBALS[addir]logo_sm.gif\" border=\"0\"></a>
			<br>TextAds are powered by WindowSix Technologies </center>";


/*
//
//	Configure the email messages that are sent to you and your users
//
*/


/* Body of message sent to users when their ads have been approved */

$update_message		= 
"Your ad has been reviewed and has been placed into rotation.  You can check on the status of your ad campaign by visiting our reporting area at

$GLOBALS[defurl]$GLOBALS[reports]

To view your reports, you will need to use the email address and password you selected when you placed your order.

Thank you for placing an order with us and we hope this proves to be a successful ad campaign for you.

Thank you,

$GLOBALS[ta_sitename] Admin

";


/*  
//
//	This is the body of the message that you will recieve when someone places an order  
//
*/

$purchase_message = 
"The following purchase has been made.  You will need to approve this purchase before ads will be placed into rotation.  You can approve this purchase by visiting

$GLOBALS[defurl]$GLOBALS[radmin]

When you accept payment via PayPal please confirm that the dollar amount listed 
below is the same as the dollar amount shown by PayPal.  Users can change the 
dollar amount after being sent to PayPal to complete their purchase.  Any changes 
that they make will not be reflected in this system.  

";


/* 
//
//	This text is inserted on the text ad sign up page  
//
*/

$purchase_text = 
"
To begin the process of purchasing a text ad please fill in the information below.  When you are finished, 
you can preview your ad before making your purchase via PayPal.  If you have any questions about TextAds 
or how to make a purchase, please review our list of <a href=\"javascript:Help('$PHP_SELF?op=faq')\">frequently asked questions</a>.  
If you have questions about writing effective ads, check out our ad writing <a href=\"javascript:Help('$PHP_SELF?op=adTips')\">tips and suggestions</a>.  
<p>
If you are interested in running TextAds on your website, please contact us using 
our <a href=\"javascript:Help('$PHP_SELF?op=sendMail')\">contact page</a>. 
";



$adtips = 
"
<b>Tips For Writing Effective Ads</b>
<p>
This is an advertisement for your product/service/website, you should do everything you can to draw people's attention to your message.
Ads that have a call to action have a far better response rate than ads that simply advertise a site or service.
Your objective, obviously, is to get as many people to take action (click on the link) as possible.
<p>
Be sure to include keywords that make people want to click thru to your website.  For instance, \"We specialize in web development\" doesn't say much
to most people.  Instead, \"Get better results -- and more paying customers -- from your website\" invites people to click thru and learn more.
You should use keywords and emotinal triggers to grab the user's attention.  Also, make it clear why they should click thru
to your website.  The purpose of a text ad is not to portray your company or service in the best possible light, rather it is to get people to
click on a link where you can portray your company any way you like.
<p>
Look at other text and banner ads for inspiration.  It should come as no surprise that ads that have stuck in your mind will also
strike a similar feeling with potential customers.  Copy what works (within the limits of copyright law, of course) instead of trying to
re-invent the wheel.
<p>
Create multiple ads and see which one(s) works the best for you.  Sometimes even a minor re-wording of an ad can make the difference
between a sucesssful ad campaign and one that fails.  Even the most savvy advertising pros experiment with different ads to find what
works and what doesn't.
<p>
Keep your ads focused.  If you sell sporting goods, it is better to create multiple ads for specific items.  Users are more driven to click on
an ad that promotes a special price or item than they are to click on an ad for sporting goods in general.
";


?>
