

CREATE TABLE adinfo (
	ad_id 			int(11) NOT NULL auto_increment,
	user_id                 int(11) NOT NULL,
	ad_approved 		int(1) NOT NULL,
	ad_url 			varchar(200) NOT NULL,
	ad_shorttext 		varchar(50) NOT NULL,
	ad_text 		varchar(100) NOT NULL,
	ad_ordered 		int(10) NOT NULL,
	ad_ts 			datetime NOT NULL,
	ad_views 		int(10) NOT NULL,
	ad_clicks 		int(10) NOT NULL,
	PRIMARY KEY 		(ad_id)
);

CREATE TABLE adtrack (
	track_id 		int(11) NOT NULL auto_increment,
	ad_id 			int(11) NOT NULL,
	track_ts 		datetime NOT NULL,
	track_host_ip 		varchar(50) NULL,
	track_served 		int(10) NOT NULL,
        track_click 		int(10) NOT NULL,
	PRIMARY KEY 		(track_id)
);

CREATE TABLE summary (
        summary_id 		int(11) NOT NULL auto_increment,
        ad_id 			int(11) NOT NULL,
        summary_ts 		datetime NOT NULL,
        summary_served 		int(10) NOT NULL,
        summary_clicked 	int(10) NOT NULL,
        PRIMARY KEY 		(summary_id)
);

CREATE TABLE userinfo (
        user_id                 int(11) NOT NULL auto_increment,
        user_name               varchar(50) NOT NULL,
        user_email              varchar(50) NOT NULL,
        user_pwd                varchar(50) NOT NULL,
        PRIMARY KEY 		(user_id)
);

CREATE TABLE temp (
        temp_id                 int(11) NOT NULL auto_increment,
        ad_id                   int(11) NOT NULL,
        temp_ad_id              int(11) NOT NULL,
        temp_ts                 datetime NOT NULL,
        PRIMARY KEY             (temp_id)
);

CREATE TABLE adsessions (
        session_id      char(32) not null,
        session_data text not null,
        session_expiration int(11) unsigned not null,
        primary key (session_id)
);

