<?php

/**
 *  retorna o numero de vezes que $char esta contido em $linha
 *  desde que $char no esteja entre aspas (") ou (').
 *  $linha deve ser uma linha de comando PHP ou HTML.
 */
function contaCaracter( $linha, $char )
{
  $ret    = 0;
  $flag_C = true;
  $flag_B = true;

  $len = strlen( $linha );

  for( $ix = 0; $ix < $len; $ix++ )
  {
    if( $linha[$ix] == '\\' && $linha[$ix+1] == '"')
      $ix = $ix +2;
    if ($linha[$ix] == '"' && $flag_B)
      $flag_C = !$flag_C;
    if ($linha[$ix] == "'" && $flag_C)
      $flag_B = !$flag_B;

    if( $flag_C &&
        $flag_B &&
        $linha[$ix] == $char
       )
    {
      $ret ++;
    }// End if()
  }// End for()
  return $ret;
}// End function()


/**
 *  Renomeia o projeto
 */
function renProjeto( $nDir, $nProjeto, $novoNome )
{
  $path = $_SERVER['DOCUMENT_ROOT'] . '/Studio/desenv/projetos/';
  $flag = true;
  $ret = 'ok:::';
  define( 'NEWLINE', "\n" );
  
  // 1 passo: renomeia o Diretorio
  if ( $nDir <> $novoNome )
  {
    if ( @file_exists( $path . $novoNome ) )
    {
      $ret  = 'erro: Projeto ja Existe.';
      $flag = false;
    }else
    {
      $ret = 'ok';
      $flag = @rename( $path . $nDir, $path . $novoNome );
    }// End if()
  }// End if()

  if( $flag )
  {
    // 2 passo: renomeia arquivos do diretorio principal
    $arr = array(
      $nDir.'/'.$nProjeto.'.main.php'     => $nDir.'/'.$novoNome.'.main.php',
      $nDir.'/'.$nProjeto.'.main.inc.php' => $nDir.'/'.$novoNome.'.main.inc.php',
      $nDir.'/'.$nProjeto.'.main.prj'     => $nDir.'/'.$novoNome.'.main.prj'
    );

    foreach( $arr as $nome1 => $nome2 )
    {
      $flag = @rename( $path . $nome1, $path . $nome2 );
    }// End foreach()

    if( $flag )
    {
      // 3 passo: renomeia arquivos do diretorio config
      $nome1 = $nDir.'/config/'.$nProjeto.'.main.define.php';
      $nome2 = $nDir.'/config/'.$novoNome.'.main.define.php';
      @rename( $path . $nome1, $path . $nome2 );
      
      // 4 passo: renomeia arquivos do diretorio lang
      $nome1 = $nDir.'/lang/pt_br/'.$nProjeto.'.def.php';
      $nome2 = $nDir.'/lang/pt_br/'.$novoNome.'.def.php';
      @rename( $path . $nome1, $path . $nome2 );
      
      // 5 passo: altera o arquivo .main.php
      $linhas = @file( $path . $nDir.'/'.$novoNome.'.main.php' );
      
      $_fp_ = @fopen($path . $nDir.'/'.$novoNome.'.main.php', 'wb' );
      foreach( $linhas as $ix => $_linha_ )
      {
        if( strpos( $_linha_, "'projeto_nome' =>" ) === false )
        {
          @fwrite( $_fp_, $_linha_ );
        }else
        {
          $tmp = "    'projeto_nome' => '".$novoNome."',";
          @fwrite( $_fp_, $tmp . NEWLINE );
        }
      }

    }else
    { $ret = 'erro';
    }
    
    // 4 passo: renomeia arquivos do diretorio lang
  }else
  {
    $ret = 'Error ...';
  }// End if()

return $ret;
}// End function()

/**
 *  criar a arvore de diretorio para um novo projeto
 */
function newProjeto( $nProj )
{
  $nDir = $_SERVER['DOCUMENT_ROOT'] . "/Studio/desenv/projetos/";
  $ret = "";
  $arrDir = array(
    'core',
    'config',
    'css',
    'imagens',
    'include',
    'lang',
    'lang/pt_br',
    'lib_JS',
    'lib_PHP',
    'uses' );

  if ( makeDir( $nDir . $nProj ) )
  {
    foreach( $arrDir as $ix => $nDir_ )
    {
      if ( makeDir( $nDir . $nProj .'/'. $nDir_ ) )
      {
        $ret .= $nDir_ . ':';
      }else
      {
        $ret .= 'erro:'.$ix.' ';
      }
    }
  }else
  {
    $ret = 'Erro1:';
  }

  return $ret;
}// End function

/**
 *
 */
function nextProjeto()
{
  $nDir = $_SERVER['DOCUMENT_ROOT'] . "/Studio/desenv/projetos/";
  $nFile = "projeto";
  
  if ( file_exists( $nDir ) &&
       is_dir( $nDir )
     )
  {
    if ( $handle = opendir( $nDir ) )
    {
      $max = 0;
      while (false !== ($file = readdir($handle)))
      {
        if ( is_dir( $nDir . $file ) &&
             $file != "."            &&
             $file != ".."
            )
        {
          if ( substr( $file, 0, 7 ) == "projeto" )
          {
            $nr = substr( $file, 7 );
            if ( $nr > $max )
              $max = $nr;
          }// End if()
        }// End if()
      }// End while()
      closedir($handle);
      $nFile .= ++ $max;
    }else
    {
      $nFile .= 'Erro..';
    }// End if()
  }else
  {
    $nFile = "not exist.";
  }// End if ( file_exists($nDir) && is_dir($nDir) )
  
  return( $nFile );
}// End function()


/**
 *  retorna o nome do proximo Objeto do Componente
 */
function nextObjeto( $nObj, $prj, $path )
{
  $nFile = $prj . ".main.prj";
  $ret = "";

  if ( file_exists( $path . $nFile) )
  {
    $linhas = file( $path . $nFile);
    asort($linhas);
    reset($linhas);

    foreach( $linhas as $i_ => $linha )
    {
      $arr = explode( ":", $linha );
      if ( $arr[0] == $nObj)
        $nome = $arr[1];
    }// End foreach( $linhas as $i_ => $linha )
      
    if ( isset($nome) )
    {
      $ret = str_replace( $nObj, "", $nome );
      $ret = $nObj.++$ret;
    }else
    {
      $ret = $nObj . "1";
    }
  }else
  {
    $ret = $nObj . "1";
  }// End if ( file_exists($nFile) )
    
  return( $ret );
}// end function nextObj( $nObj )


/**
 *  deletar um Objeto da Page
 */
function delObj( $nObj, $prj, $path )
{
  $nFile    = $path . $prj . ".main.prj";
  $baseName = $_SERVER['DOCUMENT_ROOT'] . '/Studio/';
  
  /**
   *  1 Passo  ---------------------------------------------------------  //
   *
   *  deletar a linha no arquivo de projeto da page
   */
  if ( file_exists( $nFile ) )
  {
    if ( is_writable( $nFile ) )
    {
      $linhas = @file( $nFile );
      
      if ( count( $linhas ) > 0 )
      {
        $fp  = @fopen( $nFile, 'wb' );
        foreach( $linhas as $ind => $linha )
        {
          $linha = trim( $linha );
          $arr = explode( ":", $linha );
          
          if( $arr[1] != $nObj )
          {
            @fwrite($fp, $linha . "\n" );
          }// End if()
        }// End if()
        @fclose( $fp );
      }// End if()
      return "$nFile";
    }// End if()
  }// End if()

  /**
   *  2 Passo  ---------------------------------------------------------  //
   *
   *  deletar o arquivo config.def.php
   */

  /**
   *  3 Passo  ---------------------------------------------------------  //
   *
   *  deletar o arquivo config.ini
   */

  /**
   *  4 Passo  ---------------------------------------------------------  //
   *
   *  deletar o arquivo ServerSide
   */

  /**
   *  5 Passo  ---------------------------------------------------------  //
   *
   *  deletar o arquivo config.php
   */

  /**
   *  6 Passo  ---------------------------------------------------------  //
   *
   *  deletar o arquivo css.php
   */

  /**
   *  7 Passo  ---------------------------------------------------------  //
   *
   *  deletar o arquivo tpl.php
   */

  /**
   *  8 Passo  ---------------------------------------------------------  //
   *
   *  deletar o arquivo obj.php
   */

  /**
   *  9 Passo  ---------------------------------------------------------  //
   *
   *  deletar o icone
   */
  return 'del: ' . $nObj;
}// End function()


/**
 *  addObj()
 *  ------------------------------------------------------------------------  //
 *
 *  Adiciona um Objeto na Page Principal
 *
 */
function addObj( $nObj, $nPaleta, $container, $prj, $path )
{
  $nl       = "\n";
  $sep      = ":";
  $final    = ";";
  $nFile    = $path . $prj . ".main.prj";
  $baseName = $_SERVER['DOCUMENT_ROOT'] . '/Studio/';
  $paleta   = $baseName . 'core/paletas/' . $nPaleta;
    
  $nextObj = nextObjeto( $nObj, $prj, $path );

  include( "../config/phPage.esquema.php" );
    
//return $nextObj;
    if ( $container == 'page1' )
    {
      $nContainer = $container;
    }else
    {
      // verifica se o objeto destino  do tipo container

      $temp_ = substr( $container, 0, strlen( $container ) -1 );
      $len_  = strlen( $temp_ ) -1;
      if( is_numeric( substr( $temp_, 0, $len_ ) ) )
      {
        $temp_ = substr( $temp, $len_ );
      }// End if( is_numeric( substr( $temp_, 0, $len_ ) ) )
      $nContainer = 'page1';
      if( file_exists( 'component.ini' ) )
      {
        $nContainer = 'page1';

        $arrINI = readINIfile( 'component.ini' );
        foreach( $arrINI as $_ii_ => $_vv_ )
        {
          if( $_ii_ == $temp_ && $_vv_[ 'container' ] )
            $nContainer = $container;
        }// End foreach( $arrINI as $_ii_ => $_vv_ )
      }else
      {
        $nContainer = 'page1';
      }// End if( file_exists( 'component.ini' ) )
    }// End if ( $container == 'page1' )
//return $temp_;
//return $nContainer;

    // pega os dados do componente
    $_nConf = $paleta . '/' . $nObj . '.ini';

    if ( @file_exists( $_nConf ) )
    {
//return"conf: ".$_nConf;
      $arrConf     = readINIfile ( $_nConf, ';' );
      $isContainer = $arrConf['component']['container'];
      $isVisual    = $arrConf['component']['visual'];
      $nIcone      = $arrConf['component']['icone'];
      if( isset($arrConf['component']['image']) )
      {
        $nImage      = $arrConf['component']['image'];
      }else
      {
        $nImage = false;
      }// End
//return "ok".$nImage;
    }else
    {
//return "erro Config: ".$_nConf;
      $isContainer = false;
      $isVisual    = false;
      $nIcone      = false;
      $nImage      = false;
    }// End if()
//return $nIcone;
//return $nContainer;
    $linha = $nObj        . $sep  .
             $nextObj     . $sep  .
             $nextObj     . $sep  .
             $nContainer  . $sep  .
             $isContainer . $sep  .
             $isVisual    . $final.
             $nl; 

/**
 *  1 Passo  ---------------------------------------------------------  //
 *
 *  adiciona uma linha no arquivo de projeto da page
 */
     
    if ( file_exists( $nFile ) )
    {
      if ( is_writable( $nFile ) )
      {
        if ( !$handle = fopen($nFile, 'ab') )
        {
          $ret = "Erro abrindo arquivo ($nFile)";
        }
        if ( !fwrite($handle, $linha) )
        {
          $ret = "Erro escrevendo no arquivo ($nFile)";
        }
        $ret = "Sucesso: escrito ($linha) no arquivo ($nFile)";
        fclose($handle);
      }else
      {
        echo "o arquivo $filename no pode ser atualizado";
        exit;
      }// End if()
    }else
    {
      $fp = @fopen($nFile, 'wb');
      @fwrite( $fp, $linha );
      @fclose( $fp );
      $ret = "criado arquivo de projeto com sucesso...";
    }// End if()
//return $ret;
    
    if ( file_exists( $baseName . "core/" . $nObj . ".comp.ini" ) )
    {
      $flagIni = true;
      $arrConfig = readINIfile( $baseName . "core/" . $nObj . ".comp.ini", ';');
      //return "ok1";
    }else
    {
      $flagIni = false;
      /*  inclui o arquivo de composio do componente   */
      /*  este arquivo .comp.php esta em desuso, e esta  */
      /*  linha  apenas para manter a compatibilidade   */
      /*  com verses mais antigas                       */
      include( $baseName . "core/" . $nObj . ".comp.php" );
      //return "ok2";
    }
//return 'passo 1';

/**
 *  2 Passo  ---------------------------------------------------------  //
 *
 *  gerar o arquivo config.def.php
 */
    $fileName = "config/" . $nextObj . ".config.def.php";
//return $path . $fileName;

    $nl = "\n";

    $fp  = @fopen( $path . $fileName, 'wb' );
    @fwrite($fp, '<?php '."\n" );
    @fwrite($fp, '  $' . $nextObj . '_Conf = array( ' . $nl );

    if( $flagIni )
    {
      //
      // a origme  o .comp.ini
      //
      //fwrite($fp, 'file.ini'."\n" );
      $arrConf_ = $arrConfig[ strtolower($nObj) . '_config'];
      $idx = 0;
      $len = count( $arrConf_ );
      foreach( $arrConf_ as $i_ => $v_ )
      {
        $idx ++;
        $nl_ = ( $idx < $len ) ? "', \n" : "' \n";

        /**
         *  Modifica as propriedades
         *  name    : todos os Objetos
         *  caption : do Objeto Button
         *  texto   : do Objeto Label
         */
        if( $i_ == 'name'                             ||
            ( $i_ == 'caption' && $nObj == 'button' ) ||
            ( $i_ == 'texto'   && $nObj == 'label'  )
          )
        {
          $linha = "    '" . $i_ . "' =>'" . $nextObj . $nl_;
        }else
        {
          $linha = "    '" . $i_ . "' =>'" . $v_ . $nl_;
        }// End
        @fwrite($fp, $linha);
      }
    }else
    {
      //fwrite($fp, 'config.ini'."\n" );
      $ptr = $nObj . "_Config";
      $tmp = $$ptr;
      $len = count($tmp);
      $idx = 0;

      foreach( $tmp as $i_ => $v_ )
      {
        $tmp = $nObj . "_" . $v_;
        $val = ${$tmp};
      
        if ( is_array($val) )
          $valor = $val[0];
        else
          $valor = $val;
      
        $idx ++;
        $nl_ = ( $idx < $len ) ? "', \n" : "' \n";
        
        if( $v_ == 'name' )
        {
          $linha = "    '" . $v_ . "' =>'" . $nextObj . $nl_;
        }else
        {
          $linha = "    '" . $v_ . "' =>'" . $valor . $nl_;
        }// End
        
        @fwrite($fp, $linha);
      }// End
    }// End if()
    
    @fwrite($fp, '  ); ' . $nl );
    @fwrite($fp, '?> ' . $nl );

    @fclose($fp);

//return 'passo 2';

    /**
     *  3 Passo  ---------------------------------------------------------  //
     *
     *  gerar o arquivo config.ini
     */
    if ( isset( $arrConfig[ strtolower($nObj) . '_config']['config'] ) &&
                $arrConfig[ strtolower($nObj) . '_config']['config'] != ''
       )
    {
      $configFile = $arrConfig[ strtolower($nObj) . '_config']['config'];
      $fileName   = "config/" . $nextObj . ".config." . $configFile . ".ini";
      $nl = "\n";

      $fp  = @fopen( $path . $fileName, 'wb' );
      @fwrite($fp, '[' . $arrConfig[ strtolower($nObj) . '_config']['chave'] . ']' . $nl );

        $arrConf_1 = $arrConfig[ strtolower($nObj) . '_config'];
        $arrConf_2 = $arrConfig[ strtolower($nObj) . '_conf'];
        foreach( $arrConf_2 as $i_ => $v_ )
        {
          if ( !isset( $arrConf_1[$i_] ) )
          {
            $val_ = $arrConfig[ strtolower($nObj) . '_' . $i_ ];
            $linha = "    " . $i_ . " = " . $val_['valor'] . $nl;
            fwrite($fp, $linha);
          }
        }

      fwrite($fp, ' ' . $nl );

      @fclose($fp);
    }// End if()
//return 'passo 3';

    /**
     *  4 Passo  ---------------------------------------------------------  //
     *
     *  copiar o arquivo ServerSide
     */
    $fileName = $baseName . "core/paletas/" . $nPaleta . "/" .$nObj . ".rpcServer.php";
    $newFile  = $baseName . "core/" . $nObj . ".rpcServer.php";




    /**
     *  5 Passo  ---------------------------------------------------------  //
     *
     *  copiar o arquivo config.php
     */
    $fileName = $baseName . "core/paletas/" . $nPaleta . "/" .$nObj . ".config.php";
    $newFile  = "config/" . $nextObj . ".config.php";

//return $fileName;

    $linhas = @file( $fileName );
//return $linhas;

    //echo"<br><pre>"; 
//return('passo 5: '.$fileName);
//return('passo 5: '.$linhas);
//return 'passo 5: '.$path . $newFile;

    $fp = @fopen( $path . $newFile, 'wb' );
    foreach( $linhas as $ix_ => $linha )
    {
      $str = str_replace( $nObj."X", $nextObj, $linha );
      fwrite($fp, $str);
    }// End 
    @fclose($fp);

//return 'passo 5: '.$ret;

    /**
     *  6 Passo  ---------------------------------------------------------  //
     *
     *  copiar o arquivo css.php
     */
    $fileName = $baseName . "core/paletas/" . $nPaleta . "/" .$nObj . ".css.php";
    $newFile  = "css/" . $nextObj . ".css.php";
    
    $linhas = @file( $fileName );
    $fp = @fopen( $path . $newFile, 'wb' );
    foreach( $linhas as $ix_ => $linha )
    {
      $str = str_replace( $nObj."X", $nextObj, $linha );
      fwrite($fp, $str);
    }// End 
    @fclose($fp);
    
//return "passo 6: ".$ret;

    /**
     *  7 Passo  ---------------------------------------------------------  //
     *
     *  copiar o arquivo tpl.php
     */
    $fileName = $baseName . "core/paletas/" . $nPaleta . "/" .$nObj . ".tpl.php";
    $newFile  = "include/" . $nextObj . ".tpl.php";
    
    $linhas = file( $fileName );
    $fp = @fopen( $path . $newFile, 'wb' );
    foreach( $linhas as $ix_ => $linha )
    {
      $str = str_replace( $nObj."X", $nextObj, $linha );
      fwrite($fp, $str);
    }// End 
    @fclose($fp);

    /**
     *  8 Passo  ---------------------------------------------------------  //
     *
     *  copiar o arquivo obj.php
     */
    $fileName = $baseName . "core/paletas/" . $nPaleta . "/" .$nObj . ".obj.php";
    $newFile  = "uses/page1." . $nObj . ".obj.php";
//return "passo 8";
    $linhas = @file( $fileName );
    $fp = @fopen( $path . $newFile, 'wb' );
    foreach( $linhas as $ix_ => $linha )
    {
      $str = str_replace( $nObj."X", $nextObj, $linha );
      fwrite($fp, $str);
    }// End
    @fclose($fp);

    /**
     *  9 Passo  ---------------------------------------------------------  //
     *
     *  copiar os arquivos Icone & image
     */
    if( $nIcone )
    {
      if ( file_exists( $baseName . 'imagens/' . $nIcone ) )
      {
        @copy( $baseName . 'imagens/' . $nIcone, $path . 'imagens/' . $nIcone );
      }// End if ( file_exists( $baseName . 'imagens/' . $nIcone ) )
    }// End if( $nIcone )
    if( $nImage )
    {
      $modelo = getModelo( $prj, $path );

      if ( file_exists( $baseName . 'imagens/' . $modelo . "/". $nImage ) )
      {
        @copy( $baseName . 'imagens/' .$modelo . "/" . $nImage, $path . 'imagens/' . $nImage );
      }// end if ( file_exists( $baseName . 'imagens/' . $modelo . "/". $nImage ) )

      //return 'passo 9: '.$baseName . 'imagens/' .$modelo . "/" . $nImage;
    }// End if( $nImage )
    
return $ret;
}// End function addObj( $nObj, $container, $prj )
  
  
/**
 *  Deletar todos os Arquivos do diretorio especificado 
 */
function deleteFile( $origem )
{
  $ret     = true;
  $arrFile = array();
  $msg     = "";
  $fp      = @fopen( 'buffer.err', 'wb');

  if ( file_exists( $origem ) && is_dir( $origem ) )
  {
      if ($handle = opendir( $origem ))
      {
        while (false !== ($file = readdir($handle)))
        {
          if ( is_dir( $origem . $file ) )
          {
            if( $file != "." && $file != "..")
            {
              deleteFile( $origem . $file . "/" );
              $msg .= "dir: ".$origem . $file."\n";
            }
          }else
          {
            $msg .= "dele: ".$origem . $file."\n";
            unlink( $origem . $file );
          }// End if
        }// End while
        closedir($handle);
      }// End if()
  }else
  {
    $ret = false;
    $msg = "erro Copy... \n";
  }// End if ( file_exists( $origem ) && is_dir( $origem ) )

  @fwrite($fp, $msg, strLen($msg));
  @fclose($fp);

  return( $ret );
}


/**
 *  Copiar todos os Arquivos e sub-diretorios do
 *  diretorio especificado para o diretorio destino
 */
function copyFile( $origem, $destino )
{
  $ret     = true;
  $arrFile = array();
  $msg     = "";
  
  if ( file_exists( $origem ) && is_dir( $origem ) )
  {
      if ($handle = opendir( $origem ))
      {
        while (false !== ($file = readdir($handle)))
        {
          if ( is_dir( $origem . $file ) )
          {
            if( $file != "." && $file != "..")
            {
              copyFile( $origem . $file . "/", $destino . $file . "/" );
            }
          }else
          {
            copy( $origem . $file, $destino . $file );
          }// End if
        }// End while
        closedir($handle);
      }// End if()
  }else
  {
    $ret = false;
    $msg = "erro Copy... \n";
    
    $fp = @fopen( 'buffer.err', 'wb');
    @fwrite($fp, $msg, strLen($msg));
    @fclose($fp);

  }// End if ( file_exists( $origem ) && is_dir( $origem ) )
  
  return( $ret );
}

/**
 *  Criar um Diretrio
 */
function makeDir( $nDir )
{
  $ret = true;
  if ( file_exists( $nDir ) && is_dir( $nDir ) )
  {
  }else
  {
    if ( mkdir( $nDir ) == false )
    {
      $ret = false;
    }else
    {
    }// End if
  }// End if()
  return( $ret );
}// End function


/**
 *  Apaga todos os arquivos do Diretorio
 */
function deleteAll( $nDir, $flag = true )
{
  $ret = true;
  if ( file_exists( $nDir ) && is_dir( $nDir ) )
  {
    if ( $handle = opendir( $nDir ) )
    {
      while ( false !== ( $file = readdir( $handle ) ) )
      {
        if ( is_dir( $nDir . $file ) )
        {
          if( $file != "." && $file != ".." )
          {
            deleteAll( $nDir . $file . "/" );
          }
        }else
        {
          unlink( $nDir . $file );
        }// End if
      }// End while
        closedir($handle);
    }// End if()
  }else
  {
    $ret = false;
    $msg = "erro na Deleo... \n";
    $msg .= "$nDir \n";

    $fp = @fopen( 'buffer.err', 'wb');
    @fwrite($fp, $msg, strLen($msg));
    @fclose($fp);

  }// End if ( file_exists( $origem ) && is_dir( $origem ) )

  return( $ret );
}


/**
 *  write_config_def()
 */
function write_config_def( $log_, $comp, $arrItem )
{
  define( "NEWLINE", "\n" );

  $n_path = $_SERVER['DOCUMENT_ROOT'] . '/Studio/desenv/usuarios/' . $log_ . '/config/';
  $n_file = $comp . ".config.def.php";

  $fp = @fopen( $n_path . $n_file, "wb" );

  @fwrite($fp, '<?php ' . NEWLINE );
//  @fwrite($fp, '// mudou ' . NEWLINE );
  @fwrite($fp, '   $' . $comp . '_Conf =array( ' . NEWLINE );

  $nl = count( $arrItem );
  $ix = 1;
  foreach( $arrItem as $key_ => $val_ )
  {
    $fim = ( $ix < $nl ) ? ',': '';
    @fwrite($fp, "   '" . $key_ . "' => '". $val_ . "'" . $fim . NEWLINE );
    $ix ++;
  }// End foreach()

  @fwrite($fp, '   );' . NEWLINE );
  @fwrite($fp, '?> '    . NEWLINE );
  @fclose($fp);

}// End function write_config_def( $log_, $comp, $arrItem )


/**
 *  Retira comentrios de linha nica
 * e espaos em branco desnecessrios
 */
function strip_line( $linha )
{
  $obs = strpos( $linha, '//' );
  
  if ( $obs === false )
  {
    $ret = $linha;
  }else
  {
    $ret = substr( $linha, 0, $obs );
  }// End if()
  
  return ereg_replace ("  *", " ", $ret );
}// End function


/**
 *  incorpora um arquivo no script que esta sendo gerado
 */
function includeFile( $_fp_, $linha, $log_, $prj_ )
{
  $_rad_ = "/Studio/";
  $_desenv_ = $_rad_ . 'desenv/usuarios/' . $log_ . '/';
//return;

  $tmp_ = substr( $linha, 8, strlen( $linha ) - 10 );
  $nProj = '$projeto[' . "'" . 'projeto_nome'. "']";
  
  //$fileName = substr( $linha, 8, $end_ );

  $fileName = ereg_replace( '$_rad_', $_rad_, $tmp_ );
  $fileName = ereg_replace( '$_desenv_', $_desenv_, $tmp_ );
  
  /**
   *  retira a funo getRegistro() de gerar o arquivo ".main.inc.php"
   *  e coloca o nome do arquivo gerado
   */
  if( !(strpos( $fileName, 'getRegistro' ) === false) )
  {
    $ix = strpos( $fileName, 'getRegistro' );
    $fileName = substr( $fileName,0, $ix) . '"' . $prj_. '.main.inc.php"' ;
  }// End if( !(strpos( $fileName, 'getRegistro' ) === false) )


  /**
   *  substitui o nome do projeto
   */
  if( !(strpos( $fileName, $nProj ) === false) )
  {
    $ix = strpos( $fileName, $nProj );
    $fileName = substr( $fileName,0, $ix) . '"' . $prj_. '"' . substr( $fileName, $ix + 24);
  }// End if()


  /**
   *  Define o Idioma
   */
  if( !(strpos( $fileName, 'LANGUAGE' ) === false) )
  {
    $ix = strpos( $fileName, 'LANGUAGE' );
    $fileName = substr( $fileName,0, $ix) . '"pt_br"' . substr( $fileName, $ix + 8 );
  }// End if()
  
  @eval( "\$fileName = " . $fileName . ";" );
  
  //@fwrite( $_fp_, $tmp_ . NEWLINE );
  //@fwrite( $_fp_, '### '.$fileName . NEWLINE );
  //@fwrite( $_fp_, $nProj . NEWLINE );
  //return;
  
  if ( file_exists( $fileName ) )
  {
    //$linhas = @file( $fileName );
    $handle = @fopen( $fileName, 'rb' );

    $nLinha = '';
    $flag_W = false;
    $flag_C = 0;
    $flag_B = 0;
    $iniOBS = 0;
    $endOBS = 0;
    
    //@fgets($handle);  // descarta a primeira linha '<?php'
    while( !feof( $handle ) )
    {
      $lin_ = trim( @fgets($handle, 4096) );
//@fwrite( $_fp_, '### ['.$flag_C.']['.$flag_B.']'.$lin_ . NEWLINE );

      // elimina linhas invlidas
      if( strlen( $lin_ ) > 0           &&
          substr( $lin_, 0, 2 ) != '<?' &&
          substr( $lin_, 0, 2 ) != '?>'
         )
      {
        $flag_C += contaCaracter( $lin_, '{' );
        $flag_B += contaCaracter( $lin_, '(' );

        $flag_C -= contaCaracter( $lin_, '}' );
        $flag_B -= contaCaracter( $lin_, ')' );

        /* eliminar comentrios multi-linha */
        if ( strpos( $lin_, '/*' ) === false )
        {
          if ( !$flag_W )
          {
            $nLinha .= strip_line( $lin_ );
          }// End if()
        }else
        {
          $iniOBS = strpos( $lin_, '/*' );
          $flag_W = true;
          $tmp_   = substr( $lin_, 0, $iniOBS );

          if( strlen( $tmp_ ) > 0 )
          {
            $nLinha .= strip_line( $tmp_ );
          }// End if()
        }// End if()

        if( !(strpos( $lin_, '*/' ) === false) )
        {
          $endOBS  = strpos( $lin_, '*/' );
          $nLinha .= strip_line( substr( $lin_, $endOBS + 2 ) );
          $flag_W  = false;
        }// End if()

        /* Escreve a linha no novo arquivo */
        if ( (!$flag_W) &&
             $flag_C == 0 &&
             $flag_B == 0 )
        {
          if ( strlen( $nLinha ) > 0 )
          {
            if( strpos( $nLinha, 'include' ) === false )
            {
              /**
               *  retira a declarao que esta no STUDIO
               */
              if( strpos( $nLinha, 'STUDIO' ) === false )
              {
                @fwrite( $_fp_, $nLinha . NEWLINE );
              }// End
            }else
            {
              //includeFile( $_fp_, $nLinha );
              @fwrite( $_fp_, $nLinha . NEWLINE );
            }
          }// End if()
          $nLinha = '';
        }// End if()
      }// End if()
    }// End while( !feof( $handle ) )
    
    @fclose( $handle );
  }else
  {
    @fwrite( $_fp_, 'arquivo nao encontrado: '.$fileName . NEWLINE );
  }// Endif
  
  //@fwrite( $_fp_, $fileName . NEWLINE );
  //@fwrite( $_fp_, $linha . NEWLINE );
}// End function includeFile( $_fp_, $linha, $log_, $prj_ )


/**
 *
 */
function getModelo( $prj, $path )
{
  $fileName = $path . $prj . ".main.php";
  $flag = false;
  $ret  = "erro";
  
  if ( @file_exists( $fileName ) )
  {
    $linhas = @file( $fileName );
    foreach( $linhas as $nl_ => $linha )
    {
      $lin = trim( $linha );
      if ( $lin == '$projeto = array(' )
      {
        $flag = true;
      }// end if ( alltrim(linhas) == "$projeto = array(" )

      $pos = strpos($lin, 'modelo');
      if( $pos !== false && $flag)
      {
        $i = strpos( $lin, "=>" ) + 2;
        $ret = trim(substr( $lin, $i ));
        $ret = str_replace( "'","", $ret );
        $ret = str_replace( ",","", $ret );
      }// End
    }// End foreach( $linhas as $nl_ => $linha )
  }else
  {
    $ret = "file not found";
  }// End
  
  return $ret;
}// End function getModelo( $prj )

/*
 *  Gerar o Script Executvel do Projeto que esta sendo Editado.
 */
    function gerar_script_exec( $prj_, $path_, $log_ )
    {
      $ret = 'Ok';
      $arrComp = '';
      define( 'NEWLINE', "\n" );

      $file_ = $prj_ . '.main.php';
      $nFile = $prj_ . '.php';

      if( @file_exists( $path_ . $file_ ) )
      {
//return "ok[".$path_ . $file_;
        $linhas = @file( $path_ . $file_ );
        $_fp_  = @fopen( $path_ . $nFile, 'wb' );

        $nLinha  = '';
        $flag_W  = false;
        $flagRAD = true;
        $flag_C  = 0;
        $flag_B  = 0;
        $iniOBS  = 0;
        $endOBS  = 0;

        foreach( $linhas as $ind_ => $linha )
        {
          $_linha_ = trim( $linha );
//return "l:".$_linha_;

          /* eliminar linhas em branco */
          if( strlen( $_linha_ ) > 0 )
          {
            /* blocos */
            $flag_C += contaCaracter( $_linha_, '{' );
            $flag_B += contaCaracter( $_linha_, '(' );

            $flag_C -= contaCaracter( $_linha_, '}' );
            $flag_B -= contaCaracter( $_linha_, ')' );

//@fwrite( $_fp_, '#### B['.$flag_B.']'.$_linha_ . NEWLINE );

//$t =($flag_W)?'0':'1';
//@fwrite( $_fp_, 'W: '.$t.' C: '.$flag_C .' B: '.$flag_B. ' :  '.$nLinha. NEWLINE );

            /* eliminar comentrios multi-linha */
            if ( strpos( $_linha_, '/*' ) === false )
            {
              if ( !$flag_W )
              {
                $nLinha .= strip_line( $_linha_ );
              }// End if()
            }else
            {
              // inicio de comentrio
              $iniOBS = strpos( $_linha_, '/*' );
              $flag_W = true;
              $temp   = substr( $_linha_, 0, $iniOBS );

              if( strlen( $temp ) > 0 || true )
              {
                $nLinha .= strip_line( $temp );
                //@fwrite( $_fp_, '::'.$_linha_ . NEWLINE );
              }// End if()
            }// End if()
            if( !(strpos( $_linha_, '*/' ) === false) )
            {
              // fim de comentrio
              $endOBS  = strpos( $_linha_, '*/' );
              $nLinha .= strip_line( substr( $_linha_, $endOBS + 2 ) );
              $flag_W  = false;
            }// End if()

            /* Escreve a linha no novo arquivo */
            if ( (!$flag_W)   &&
                 $flag_C == 0 &&
                 $flag_B == 0 )
            {
              if ( strlen( $nLinha ) > 0 )
              {
                /**
                 *  testa se  um include
                 */
                if( strpos( $nLinha, 'include' ) === false )
                {
                  /**
                   *  esta linha no  um Include
                   *  ======================================================= //
                   */
                  if( $flagRAD )
                  {
                    //@fwrite( $_fp_, '++B['.$flag_B.']'.$nLinha . NEWLINE );
                    if( substr( $nLinha,0,9 ) == '$_desenv_' )
                    {
                      @fwrite( $_fp_, '$_desenv_ = $_rad_ . "desenv/usuarios/' . $log_ . '/";' . NEWLINE );
                    }else
                    {
                      @fwrite( $_fp_, $nLinha . NEWLINE );
                    }// End if( substr( $nLinha,0,9 ) == '$_desenv_' )
                  }// End if( $flagRAD )

                  if( !(strpos( $nLinha, 'session_start' ) === false) )
                  {
                    $flagRAD = false;
                    @fwrite( $_fp_, '$modo_RAD = false; $_rad_ = "/Studio/";' . NEWLINE );
                  }// if( !(strpos( $nLinha, 'session_start' ) === false) )
                  
                  if( !(strpos( $nLinha, '$_rad_' ) === false) )
                  {
                    $flagRAD = true;
                  }// End if( !(strpos( $nLinha, '$_rad_' ) === false) )
                }else
                {
                  /**
                   *  esta linha  um Include
                   *  ======================================================= //
                   */
                  includeFile( $_fp_, $nLinha, $log_, $prj_ );
                }// End if( strpos( $nLinha, 'include' ) === false )
              }// End if ( strlen( $nLinha ) > 0 )
              $nLinha = '';
            }else
            {
              //@fwrite( $_fp_, '....['.$flag_W.']['.$flag_C.']['.$flag_B.']: '.$nLinha . NEWLINE );
            }
          }// Endif ()

        }// End foreach()
        @fclose( $_fp_ );
//return "foreach";
      }else
      {
        $ret = 'Erro 1 : file not found.';
      }// End if()

      return $ret;
    }

?>
