//******************************************************************************
//* jsrsCore.js - javascript remote scripting Lib 
//* 
//* Here's where you start:
//*   1) Place the files in a dir that is reachable by the server
//*      e.g. http://www.foo.ch/jsrs/.
//*   2) Include to lib to your web page by adding this *one* line into the 
//*      <HEAD> section.
//*         <script type="text/javascript" src="/jsrs/jsrsCore.js"></script>
//*      Note that all other js-scripts needed are loaded automatically
//*   3) The only function to call is 
//*           jsrsCall(remoteTarget, jsCallback, remoteFunction, params);
//*      E.g. callId = jsrsCall("/jsrs/myServer.php",showCity,"getCitys",'USA');
//*      
//*      Make sure to have a jsCallback function with 2 parameters 
//*      E.g. function showCity(param, callId) {alert(callId+" "+param);}  
//*   
//*
//* Parameters of jsrsCall():
//*   remoteTarget  : The href target of the jsrs-server-script. It must be able
//*                    to read out the passed data and respond correctly
//*   jsCallback,   : This is your javascript function that is called on return
//*                    of the remote call.
//*   remoteFunction: Is the remote function you intend to call. It's either a 
//*                   simple function name or an method call. Method calls have
//*                   the structure
//*                   <class name>.<method name> E.g. 'Interface.getData'
//*   params        : This can be any js data (string, number, array, object) 
//*                   even  cascaded types (e.g. array of objects) as long as
//*                   there no *loop* references!!
//*   <return>      : Is the call-ID. This is returned when calling the callback
//*                   function and may be important when calling multiple
//*                   functions, as the return is asynchron.
//*
//* Parameters to use for the callback function
//*  <1st param> :Is the return value that can be string, number, array, object.
//*  <2ed param> :Is the call-ID (See 'return' above)
//*   
//*   
//* Advanced Use:  Passing Objects (see also Bugs below).
//*   To identify an object it must have the field
//*   wddxSerializationType=[class Name].
//*   
//*   
//* BUGS:  
//*   Only happens when server is written in PHP: 
//*    - Date problem:
//*         If you pass a date object ( new Date() ) it will be ignored by a
//*         PHP server.
//*      Reason: The data exchange is done uning the WDDX formate. PHP built in 
//*         WDDX converter seams to ignor the WDDX tag <dateTime>.
//*      Workaround: Don't pass a Date object; convert it to a string.        
//*    - Object problem:
//*         Unfortunately PHP has it's own way to convert Objects to and from
//*         WDDX.
//*         The standard way in WDDX is to make a <struc type='className'>.
//*         But PHP ignors this feature. So object passing is not realy suported.
//*      Workaround: Passing Objects frome Client -> Server.
//*         Instead pass an Object with a field name 'php_class_name'
//*         E.g. var myObject = new Object();
//*                  myObject['php_class_name'] = 'aPhpClassName';
//*                  myObject['foo'] =  new Array(1,2,3);
//*                      :
//*         
//*         Passing Objects frome Server->Client. IS not currently suported 
//* ---------------------------------------------------------------------------
//* @Requires NS6.2 and up / IE5.5 and up / Don't know about Opera
//* ---------------------------------------------------------------------------
//* @Version: 3.0 (10-April-2002)
//* ---------------------------------------------------------------------------
//* @Author:  Sam   Blum   [jsrs@4matics.ch] Collected all the ideas, merged
//*           and rewrote them and added doc.
//**

//------------------------------------------------------------------------------
// Dynamic code unit loading routines 
// Idea taken from D. Kadrioski (See http://www.domapi.com/)
//------------------------------------------------------------------------------

// ============================================================================ 
//  -- Core Functions -- 
// ============================================================================ 

// Start by identifying the path to this javascript file (javascript files are
// also called unit)
var jsrsLibs = new Object();
jsrsLibs.path = _jsrsGetUnitPath('jsrsCore'); // obviously this unit is loaded
                                              // if this code executes ;)


//------------------------------------------------------------------------------
function jsrsLoadUnit(name, useCompression){
  if(jsrsLibs[name]) return false; // unit was already loaded, nothing to do
 
  jsrsLibs[name] = true;
  
  // if we are using compression, add the "_c"
  name+=(useCompression ? "_c" : "")+".js";
  
  // load the script
  // 4debug  alert(jsrsLibs.path+name);  
  var out = '<script type="text\/javascript" src="'+jsrsLibs.path+name+'"><\/script>';
  document.writeln(out);
};

//------------------------------------------------------------------------------
function _jsrsGetUnitPath(name){ // returns false or the path to the unit
  var r=false;
  var i;
  var re=new RegExp("\/?"+name+"[\._]");
  var tags=document.getElementsByTagName("SCRIPT");
  for(var a=0;a<tags.length;a++){
    i=tags[a].src.search(re);
    if(i>=0) r= (i==0) ? '' : tags[a].src.substr(0,i) +'/';
  }
  return r;
};
//------------------------------------------------------------------------------


// Then load the units dynamically
jsrsLoadUnit('wddx', false);       // <- The WDDX serializer
jsrsLoadUnit('wddxDes', false);    // <- The WDDX deserializer
jsrsLoadUnit('jsrsClient', false); // <- The client gateway


